/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.ElementAlias;
import ch.interlis.ili2c.metamodel.ErrorListener;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Model;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class Element
implements BeanContextChild,
ElementAlias {
    static final ResourceBundle rsrc;
    protected BeanContextChildSupport bccs;
    private Element nextElement;
    private String alias;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.interlis.ili2c.metamodel.ErrorMessages");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        rsrc = ResourceBundle.getBundle(clazz.getName(), Locale.getDefault());
    }

    static final String formatMessage(String msg, Object[] args) {
        try {
            MessageFormat mess = new MessageFormat(rsrc.getString(msg));
            return mess.format(args);
        }
        catch (Exception ex) {
            return "Internal compiler error [" + ex.getLocalizedMessage() + "]";
        }
    }

    static final String formatMessage(String msg) {
        return Element.formatMessage(msg, "");
    }

    static final String formatMessage(String msg, String arg) {
        return Element.formatMessage(msg, new Object[]{arg});
    }

    static final String formatMessage(String msg, String arg1, String arg2) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2});
    }

    static final String formatMessage(String msg, String arg1, String arg2, String arg3) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2, arg3});
    }

    static final String formatMessage(String msg, String arg1, String arg2, String arg3, String arg4) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2, arg3, arg4});
    }

    static final String formatMessage(String msg, String arg1, String arg2, String arg3, String arg4, String arg5) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    static final String formatMessage(String msg, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6});
    }

    public boolean isDependentOn(Element other) {
        return false;
    }

    public final void setBeanContext(BeanContext bc) throws PropertyVetoException {
        this.bccs.setBeanContext(bc);
    }

    public final BeanContext getBeanContext() {
        return this.bccs.getBeanContext();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.bccs.addPropertyChangeListener(null, listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.bccs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.bccs.removePropertyChangeListener(propertyName, listener);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.bccs.addVetoableChangeListener(propertyName, listener);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.bccs.removeVetoableChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.bccs.firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.bccs.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.bccs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
        this.bccs.fireVetoableChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.bccs.fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected static final Object[] retrieveAllInstancesOf(Iterator it, Class clazz) {
        LinkedList l = new LinkedList();
        while (it.hasNext()) {
            Object o = it.next();
            if (!clazz.isInstance(o)) continue;
            l.add(o);
        }
        return l.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public final Container getContainer(Class klass) {
        BeanContext bc = this.getBeanContext();
        while (bc != null) {
            if (klass.isInstance(bc)) {
                return (Container)bc;
            }
            bc = bc.getBeanContext();
        }
        return null;
    }

    public final Container getContainer() {
        BeanContext bc = this.getBeanContext();
        if (bc instanceof Container) {
            return (Container)bc;
        }
        return null;
    }

    public String getName() {
        return null;
    }

    public String getScopedName(Container scope) {
        return this.getName();
    }

    protected static final void checkNameSanity(String s, boolean emptyStringIsOK) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int len = s.length();
        if (!emptyStringIsOK && len == 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < len) {
            char curChar = s.charAt(i);
            if (curChar == ' ') {
                throw new IllegalArgumentException(Element.formatMessage("err_name_withSpaces", s));
            }
            ++i;
        }
    }

    protected void checkNameUniqueness(String proposedName, Class klass, Element acceptable, String errorKey) {
        Container container;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Container");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((container = this.getContainer(clazz)) == null) {
            return;
        }
        Element conflicting = container.getRealElement(klass, proposedName);
        if (conflicting == null || conflicting == this || conflicting == acceptable) {
            return;
        }
        throw new IllegalArgumentException(Element.formatMessage(errorKey, proposedName, container.toString(), conflicting.toString()));
    }

    public static final String makeErrorName(Element elt) {
        if (elt == null) {
            return rsrc.getString("err_dumpErrorName");
        }
        return elt.toString();
    }

    public void checkIntegrity() throws IllegalStateException {
    }

    public Container getCommonContainer(Element elt) {
        if (elt == null) {
            return null;
        }
        Container myCtr = this.getContainer();
        while (myCtr != null) {
            Container eltCtr = elt.getContainer();
            while (eltCtr != null) {
                if (eltCtr == myCtr) {
                    return myCtr;
                }
                eltCtr = eltCtr.getContainer();
            }
            myCtr = myCtr.getContainer();
        }
        return null;
    }

    public boolean isDeclaredBefore(Element elt) {
        Container commonContainer = this.getCommonContainer(elt);
        if (commonContainer == null) {
            return false;
        }
        Iterator iter = commonContainer.iterator();
        while (iter.hasNext()) {
            Element curElt = (Element)iter.next();
            if (curElt == this || curElt instanceof Container && ((Container)curElt).containsIndirectly(this)) {
                return true;
            }
            if (curElt != elt && (!(curElt instanceof Container) || !((Container)curElt).containsIndirectly(elt))) continue;
            return false;
        }
        throw new IllegalStateException("Internal error; check ch.interlis.Element.isDeclaredBefore");
    }

    public boolean canAccess(Element other) {
        Model otherModel;
        Model myModel;
        if (other == null) {
            throw new IllegalArgumentException();
        }
        if (this == other) {
            return true;
        }
        if (!other.isDeclaredBefore(this)) {
            return false;
        }
        if (this instanceof Model) {
            myModel = (Model)this;
        } else {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("ch.interlis.ili2c.metamodel.Model");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            myModel = (Model)this.getContainer(clazz);
        }
        if (other instanceof Model) {
            otherModel = (Model)other;
        } else {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("ch.interlis.ili2c.metamodel.Model");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            otherModel = (Model)other.getContainer(clazz);
        }
        if (myModel == null || otherModel == null) {
            return false;
        }
        return myModel == otherModel || myModel.isImporting(otherModel);
    }

    public Set getAccessiblePolymorphicEquivalents(Extendable forExtendable) {
        if (forExtendable == null) {
            return new HashSet();
        }
        Set result = forExtendable.getExtensions();
        result.add(forExtendable);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            Element elt = (Element)iter.next();
            if (this.canAccess(elt)) continue;
            iter.remove();
        }
        return result;
    }

    public boolean checkStructuralEquivalence(Element with, ErrorListener listener) {
        if (this.isAlias()) {
            return this.getReal().checkStructuralEquivalence(with, listener);
        }
        if (with == null) {
            return false;
        }
        if (this.getClass() != with.getClass()) {
            listener.error(new ErrorListener.ErrorEvent(Element.formatMessage("err_diff_mismatchInClass", this.toString(), with.toString()), this, 5));
            return false;
        }
        return true;
    }

    protected boolean checkStructuralEquivalenceOfArrays(Element with, Element[] myArray, Element[] withArray, ErrorListener listener, String numElementMismatchMessageKey) {
        if (myArray == null || withArray == null || with == null) {
            return false;
        }
        if (myArray.length != withArray.length) {
            listener.error(new ErrorListener.ErrorEvent(Element.formatMessage(numElementMismatchMessageKey, this.toString(), with.toString()), this, 5));
            return false;
        }
        boolean fine = true;
        int i = 0;
        while (i < myArray.length) {
            if (myArray[i] == null != (withArray[i] == null)) {
                fine = false;
            }
            if (myArray[i] != null && !myArray[i].checkStructuralEquivalence(withArray[i], listener)) {
                fine = false;
            }
            ++i;
        }
        return fine;
    }

    public Element getNext() {
        return this.nextElement;
    }

    protected void setNext(Element nextElement) {
        this.nextElement = nextElement;
    }

    public Element getReal() {
        Element real = this;
        while (real.getNext() != null) {
            real = real.getNext();
        }
        return real;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isAlias() {
        return this.alias != null;
    }

    public ElementAlias createAlias(String alias) {
        return null;
    }
}

