/*!

\page gdcm2vtk Convert a file supported by VTK into DICOM. 

\section synopsis SYNOPSIS

\verbatim
gdcm2vtk [options] file-in file-out
\endverbatim

\section description DESCRIPTION

The \b gdcm2vtk 

\section parameters PARAMETERS

\verbatim
file-in   input filename (DICOM or VTK supported)

file-out  DICOM output filename
\endverbatim

\section options OPTIONS

\subsection options options
\verbatim
     --force-rescale    force rescale.
     --force-spacing    force spacing.
     --palette-color    when supported generate a PALETTE COLOR file.
     --argb             when supported generate a ARGB file.
\endverbatim

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

  -v   --version
         print version information and exit

  -V   --verbose
         verbose mode (warning+error).

  -W   --warning
         warning mode, print warning information

  -E   --error
         error mode, print error information

  -D   --debug
         debug mode, print debug information
\endverbatim

\section description DESCRIPTION
Convert a file supported by VTK into DICOM.

Typical usage is:

\verbatim
$ gdcm2vtk inputfile output.dcm
\endverbatim

It uses the internal factory mechanism of VTK to recognize a file (CanRead function). See VTK supported file here:

    * What image file formats can VTK read and write? http://www.vtk.org/Wiki/VTK_FAQ#What_image_file_formats_can_VTK_read_and_write.3F

If your input file has 4 components, the 4th comp (alpha) will be removed from the output file as DICOM does not support alpha component anymore (see --argb option).

Special care was taken for the following file format:

\verbatim
   1. DICOM: Direction Cosines and vtkMedicalImageInformation are passed to the output
   2. BMP: The file can be saved with a Lookup Table (see --palette-color)
   3. GE Signa: vtkMedicalImageProperties is passed to the output
   4. MINC: Direction Cosines is passed to the output
   5. TIFF: vtkTIFFReader is currently in bad shape in VTK (different behavior in VTK 5.2 and CVS). Only use it, if you know what you are doing. 
\endverbatim

\section dicom DICOM

\verbatim
$ gdcm2vtk input.dcm output.dcm
\endverbatim

vtkGDCMImageReader will be used to read in a DICOM file, not the default vtkDICOMImageReader.

IMPORTANT NOTE: The internal VTK structured will be filled from the input DICOM, and then pass to the output DICOM writer. Some information might be lost during the conversion DICOM to VTK to DICOM. This option is mostly used to test the vtkGDCMImageReader/vtkGDCMImageWriter combination.

IMPORTANT NOTE: When converting from a lossy format such as JPEG, the information of lossiness is important. The output DICOM will contains the required Lossy Image Compression attribute that indicates that image was lossy-compressed somewhere along the pipeline. See also gdcmimg (better handling of JPEG in general).

\section see_also SEE ALSO

<b>gdcmdump</b>(1), <b>gdcmviewer</b>(1), <b>gdcmimg</b>(1)

\section copyright COPYRIGHT

Copyright (c) 2006-2009 Mathieu Malaterre

*/
