from DisplayContainer import DisplayContainer
from main import UNSET_COORD

import gtk


#
# Container class for displays that are pluggable into other applications.
#
class Plug(gtk.Plug, DisplayContainer):

    def __init__(self, display):

        self.__display = display

        # window size for detecting resizing
        self.__window_size = (0, 0)

        self.__shape = None


        gtk.Plug.__init__(self, 0)
        DisplayContainer.__init__(self, display)
        
        self.set_size_request(-1, -1)
        self.set_default_size(10, 10)
        self.add(display)
        display.set_container(self)

        # set up event handlers
        #self.connect("button-press-event", self.__on_button, 0)
        #self.connect("button-release-event", self.__on_button, 1)
        self.add_events(gtk.gdk.BUTTON_PRESS_MASK |
                        gtk.gdk.BUTTON_RELEASE_MASK)


    #
    # Returns the XEMBED ID for embedding this plug into other applications.
    #
    def get_xembed_id(self):

        return self.get_id()


    def close(self):

        self.destroy()


    def set_position(self, x, y):

        # we happily ignore this
        pass


    def set_size(self, width, height):

        self.resize(width, height)
        

    def set_window_flags(self, value):

        # we happily ignore this
        pass


    def set_shape(self, mask):

        if (self.__window_pos == (UNSET_COORD, UNSET_COORD)):
            self.__shape = mask
        else:
            self.shape_combine_mask(mask, 0, 0)
