from DisplayTarget import DisplayTarget
from utils.datatypes import *

import gtk
import bonobo
import bonobo.ui


#
# Class for a target that embeds Bonobo controls.
#
class TargetBonoboControl(DisplayTarget):

    def __init__(self, parent, display):

        # the control; you can load a control only once
        self.__control = None


        DisplayTarget.__init__(self, parent, display)

        self._set_property_type("oafiid", TYPE_STRING)



    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "oafiid"):
            try:
                container = bonobo.ui.Container()
                control = bonobo.ui.Widget(str(value),
                                           container.corba_objref())
                pbag = control.get_control_frame().get_control_property_bag()
                slots = pbag.getKeys("")
                print "Property Bag:\n", slots
                
                control.show()

                if self.__control:  # we have to remove the previous control
                    self.remove( self.__control )

                self.add(control)
                self.__control = control
                
            except StandardError, e:
                print e

        else:
            DisplayTarget.set_config(self, key, value)
