from ContainerTarget import ContainerTarget
from utils.datatypes import *

import gtk



#
# The gauge is a decorator that can turn anything into a gauge.
#
class TargetGauge(ContainerTarget):

    __HORIZONTAL = "horizontal"
    __VERTICAL = "vertical"
    

    def __init__(self, parent, display):

        self.__orientation = self.__HORIZONTAL
        self.__fill_level = 100


        ContainerTarget.__init__(self, parent, display)

        self.__layout = gtk.Fixed()
        self.__layout.show()
        self.add(self.__layout)

        self._set_property_type("fill", TYPE_FLOAT)
        self._set_property_type("orientation", TYPE_STRING)

        

    def add_children(self, childrendata):

        ContainerTarget.add_children(self, childrendata)
        child = self._get_child()
        self.__layout.put(child, 0, 0)
        self.__layout.set_size_request(1, 1)
        child.add_observer(self.__on_observe_child)
        self._init_children()
            


    def __on_observe_child(self, src, cmd, *data):

        if (cmd == src.OBS_GEOMETRY):
            x, y, w, h = src.get_geometry()
            self.__set_gauge(self.__fill_level)



    def __set_gauge(self, fill):

        x, y, width, height = self._get_child().get_geometry()
        if (self.__orientation == self.__HORIZONTAL):
            width = int(width * (fill / 100.0))
        else:
            height = int(height * (fill / 100.0))

        self.set_size_request(width, height)
        self.__fill_level = fill
        if (self.window): self.window.process_updates(gtk.FALSE)

        

    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "orientation"):
            self.__orientation = value

        elif (key == "fill"):
            self.__set_gauge(int(value))

        else:
            ContainerTarget.set_config(self, key, value)
