from DisplayTarget import DisplayTarget
from utils.datatypes import *
from utils import vfs

import gtk


#
# Class for image targets.
#
class TargetImage(DisplayTarget):

    def __init__(self, parent, display):

        # the pixbuf of the original image and its URI
        self.__original_image = None
        self.__uri = ""

        # the saturation of the image
        self.__saturation = 1.0

        # the size values
        self.__width = 0
        self.__height = 0
        self.__original_width = 0
        self.__original_height = 0
        self.__current_width = 0
        self.__current_height = 0
        self.__scale = 1.0
                

        DisplayTarget.__init__(self, parent, display)

        self.__widget = gtk.Image()
        self.__widget.show()

        self.add(self.__widget)

        self._set_property_type("uri", TYPE_STRING)
        self._set_property_type("saturation", TYPE_FLOAT)
        self._set_property_type("scale", TYPE_FLOAT)
        self._set_property_type("image-width", TYPE_INT)
        self._set_property_type("image-height", TYPE_INT)



    #
    # Sets the configuration values.
    #
    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "uri"):
            try:
                self.__load_image(value)
            except StandardError, e:
                import traceback; traceback.print_exc()
                print e
                
        elif (key == "scale" and abs(value - self.__scale) > 0.01):
            self.__scale_image(value)

        elif (key == "image-width" and value != self.__width):
            self.__width = value
            self.__render_image(self.__width, self.__height)
            
        elif (key == "image-height" and value != self.__height):
            self.__height = value
            self.__render_image(self.__width, self.__height)

        elif (key == "saturation" and abs(value - self.__saturation) > 0.01 ):
            self.__saturation = value
            self.__render_image()

        else:
            DisplayTarget.set_config(self, key, value)



    #
    # Loads the image from the given URI.
    #
    def __load_image(self, uri):

        uri = vfs.join(self.get_path(), uri)
        if (uri != self.__uri):
            try:
                fd = vfs.open(uri, "r")
            except IOError:
                print "Could not open image %s." % (uri)
                return
            data = vfs.read_all(fd)
            fd.close()
            loader = gtk.gdk.PixbufLoader()
            loader.write(data, len(data))
            loader.close()
            self.__original_image = loader.get_pixbuf()
            self.__widget.set_from_pixbuf(self.__original_image)
            self.__uri = uri
        #end if

        if (self.__original_image):
            self.__original_width = self.__original_image.get_width()
            self.__original_height = self.__original_image.get_height()
            self.__scale_image(self.__scale)
        #end if



    #
    # Scales the image by the given factor.
    #
    def __scale_image(self, scale):

        width = int((self.__width or self.__original_width) * scale)
        height = int((self.__height or self.__original_height) * scale)
        self.__render_image(width, height)
            
        self.__scale = scale



    #
    # Renders the image at the given size. Whithout size arguments,
    # the current size is used.
    #
    def __render_image(self, width = 0, height = 0):

        if (not self.__original_image): return

        w = width or self.__current_width
        h = height or self.__current_height
        
        img = self.__original_image.scale_simple(w, h, 3)

        if (abs(self.__saturation - 1.0) > 0.00001):
            simg = img.copy()
            img.saturate_and_pixelate(simg, self.__saturation, gtk.FALSE)
        else:
            simg = img

        self.__widget.set_from_pixbuf(simg)
        self.__current_width = w
        self.__current_height = h
        self.set_size(w, h)
