from DisplayTarget import DisplayTarget
from utils.datatypes import *
import desktop

import gtk, pango



class TargetLabel(DisplayTarget):

    def __init__(self, parent, display):

        self.__old_value = ""
        self.__font_description = None
        self.__wrap_at = -1

        DisplayTarget.__init__(self, parent, display)

        self.__widget = gtk.Label("")
        self.__widget.set_line_wrap(gtk.FALSE)
        self.__font_description = \
             self.__widget.get_layout().get_context().get_font_description()
        self.__widget.show()

        self.add(self.__widget)

        self._set_property_type("value", TYPE_STRING)
        self._set_property_type("color", TYPE_STRING)
        self._set_property_type("font", TYPE_STRING)
        self._set_property_type("wrap-at", TYPE_INT)


    def __set_value(self, value):

        value = str(value)
        # make sure we have clean UTF-8 text
        if (type(value) != unicode):
            try:
                value = value.decode("utf8")
            except UnicodeDecodeError:
                try:
                    value = unicode(str(value), CHARMAP, "ignore")
                except LookupError:
                    value = unicode(str(value), "UTF-8", "replace")
        #end if

        layout = self.__widget.get_layout()
        layout.set_markup(str(value))
        layout.set_font_description(self.__font_description)
        layout.set_width(self.__wrap_at * pango.SCALE)
        width, height = layout.get_pixel_size()
        
        self.__widget.set_size_request(width, height)
        self.__widget.set_markup(str(value))
        self.set_size(width, height)
        self.__old_value = value
        if (self.window): self.window.process_updates(gtk.FALSE)


    def __set_font(self, font):

        self.__font_description = pango.FontDescription(font)
        size = self.__font_description.get_size()
        size = int(desktop.pixels2points(size))
        self.__font_description.set_size(size)
        self.__widget.modify_font(self.__font_description)
        self.__set_value(self.__old_value)


    def __set_color(self, color):

        self.__widget.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse(color))
        self.__set_value(self.__old_value)


    def __set_wrap(self, value):

        if (value == 0):
            self.__widget.set_line_wrap(gtk.FALSE)
            self.__wrap_at = -1
        else:
            self.__widget.set_line_wrap(gtk.TRUE)
            self.__wrap_at = value

        self.__set_value(self.__old_value)


    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "value" and value != self.__old_value):
            self.__set_value(value)
        elif (key == "font"):
            self.__set_font(value)
        elif (key == "color"):
            self.__set_color(value)
        elif (key == "wrap-at"):
            self.__set_wrap(value)
        else:
            DisplayTarget.set_config(self, key, value)


# determine the locale
import commands
fail, CHARMAP = commands.getstatusoutput("locale charmap")
if (fail or not CHARMAP):
    print "Could not detect character encoding."
    CHARMAP = "ASCII"
