from desktop.GlassWindow import GlassWindow
from ContainerTarget import ContainerTarget
from TargetGroup import TargetGroup
from utils.datatypes import *

import gtk



#
# Class for popup windows.
#
class TargetPopup(ContainerTarget):

    def __init__(self, display):

        self.__window = GlassWindow(gtk.WINDOW_POPUP)
        ContainerTarget.__init__(self, display)

        # create the root TargetGroup
        self.__group = TargetGroup(display)
        self.__window.add(self.__group)
        self.__group.add_observer(self.__on_observe_group)

        self._set_property_type("visible", TYPE_INT)


    #
    # Observer for the root group.
    #
    def __on_observe_group(self, src, cmd, *args):

        if (cmd == src.OBS_MOVE):
            x, y, w, h = args
            self.__window.move(x, y)
            if (w > 0 and h > 0):
                self.__window.resize(w, h)



    def __popup_window(self):

        toplevel = self.get_toplevel()
        win = toplevel.window
        if (win):
            rx, ry = win.get_position()
            x, y, w, h = self.get_allocation()

            x = x + rx
            y = y + ry

            self.__window.move(x, y)
            self.__window.show()



    def add_children(self, childrendata):

        self.__group.add_children(childrendata)




    def _get_children(self): return self.__group._get_children()




    def set_config(self, key, value):

        value = self._convert_type(key, value)
        
        if (key == "visible"):
            v = int(value)
            if (v): self.__popup_window()
            else: self.__window.hide()

        elif (key in ["watch", "x", "y"]):
            self._set_common_config(key, value)

        else:
            self.__group.set_config(key, value)
