import glibtop
import polling


class Disk:

    def __init__(self):

        self.get_partitions = self.__poll_partitions
        self.get_size       = self.__poll_size
        self.get_fs         = self.__poll_fs
        self.get_fsusage    = self.__poll_fsusage



    #
    #:function get_partitions | | Returns all available partitions.
    #:  param | |
    #:  return List containing the device and the mount point.
    #:/function
    #
    def __poll_partitions(self):

        data = glibtop.get_mountlist(0)
        partitions = []
        for size, device, mpoint, fstype in data:
            if (fstype in ("ext2", "ext3", "msdos", "vfat", "ntfs", "hpfs"
                           "jfs", "reiserfs", "xfs", "qnx4", "adfs", "ffs",
                           "hfs", "befs", "bfs", "efs", "iso9660", "minix",
                           "sysv", "coda", "nfs", "udf", "ufs", "xiafs")):
                partitions.append((device, mpoint))

        return partitions
            


    #
    #:function get_size | partition | Returns size, used size and free size
    #                                 of the given partition.
    #:  param partition | string | Partition whose size should be examined.
    #:  return Three int values: Total size, used size and free size for
    #          given the partition.
    #:/function
    #
    def __poll_size(self, partition):

        blocks, bfree, bavail, files, ffree = glibtop.get_fsusage(partition)
        free = float(bfree * 512)
        total = float(blocks * 512)
        used = total - free

        return (total, used)#, free)



    #
    #:function get_fs | partition | Returns the filesystem for the given
    #                               partition.
    #:  param partition | string | Partition whose filesystem should be
    #                              returned.
    #:  return One string: Filesystem for the partition.
    #:/function
    #
    def __poll_fs(self, partition):

        data = glibtop.get_mountlist(0)
        partitions = []
        for size, device, mpoint, fstype in data:
            if (mpoint == partition):
                return fstype


    #
    #:function get_fs_usage | mounted_partition |
    #          Returns filesystem usage of a mounted partition.
    #:  param mounted_partition | string | The mounted partition whose
    #                                      usage should be examined.
    #:  return Four int values. #TODO#
    #:/function
    #
    def __poll_fsusage(self, mounted_partition):

        return (glibtop.get_fsuage(mounted_partition))
