import getopt
import admin
from utils import dialog
from utils import vfs
from config import settings
from main import _
from main import print_about

import sys


#
# Class for parsing command line arguments.
#
class CmdLineParser:

    __DUMMY = []
    __OPTIONS = ["no-config", "orig-coords", "profile=", "version",
                 "sm-client-id=", "sm-config-prefix=", "sm-disable",
                 "tray-icon"]


    def __init__(self):

        pass


    #
    # Parses the given list of command line arguments. This is usually
    # sys.argv[1:].
    #
    def parse(self, args):

        try:
            opts, rest = getopt.getopt(args, "nop:v", self.__OPTIONS)

        except getopt.GetoptError:
            self.__usage()
            sys.exit(0)
        for o, a in opts:
            if (o == "--no-config"):
                print "Ignoring configuration."
                settings.no_config = 1
            elif (o == "--orig-coords"):
                settings.orig_coords = 1
            elif (o == "--profile"):
                admin.set_profile(a)
            elif (o == "--version"):
                print_about()
            elif (o in ("--sm-client-id", "--sm-config-prefix",
                        "--sm-disable")):
                pass
            elif (o == "--tray-icon"):
                settings.tray_icon = 1
            else:
                self.__usage()
        #end for

        # load displays
        if (rest):
            for display in rest:
                display = vfs.join(vfs.getcwd(), display)

                if (not vfs.exists(display)):
                    dialog.error(_("Could not add display"),
                                 _("The display could not be added because "
                                   "the file does not exist."))
                else:
                    admin.add_display(display)
            #end for

            if (not settings.no_config): sys.exit(0)
        #end if

        settings.profile = admin.get_profile()


    def __usage(self):

        print _("Usage: gdesklets <OPTION> <my.display>\n")
        print _("Options:\n")
        print _("\t--no-config\t\tignore the configuration stored in the " \
                "database (GConf)")
        print _("\t--orig-coords\t\tset the coordinates for every " \
                "display to the upper left corner")
        print _("\t--profile=myprofile\tuse \"myprofile\" as profile.")
        print _("\t--version\t\toutput version information and exit")
