from Sensor import Sensor
from utils.datatypes import *
from main import UNSET_COORD

import os


#
# The DefaultSensor is always present in a Display and handles things like
# the initial positioning of the Display window.
#
class DefaultSensor(Sensor):

    def __init__(self):

        self.__x_coord = None
        self.__y_coord = None
        self.__dont_init = 0

        Sensor.__init__(self)

        self._set_config_type("x", TYPE_INT, UNSET_COORD)
        self._set_config_type("y", TYPE_INT, UNSET_COORD)
        self._set_config_type("real-x", TYPE_INT, UNSET_COORD)
        self._set_config_type("real-y", TYPE_INT, UNSET_COORD)
        self._set_config_type("width", TYPE_INT, 0)
        self._set_config_type("height", TYPE_INT, 0)

        self.add_timer(0, self.__init_display)



    #
    # Initializes the Display.
    #
    def __init_display(self):

        if (self.__dont_init): return

        x = self.get_config("x")
        y = self.get_config("y")

        # only set position if it was set in the config
        if (x != UNSET_COORD and y != UNSET_COORD):
            settings = self.new_output()
            settings.set("x", x)
            settings.set("y", y)
            self.send_output(settings)
        self.watch_config(self.__on_watch_config)


    #
    # Reacts on window movements in the config.
    #
    def __on_watch_config(self, key, value):

        changed = 0
        if (key in ["x", "y"]):
            # break cycles
            if (key == "x"):
                if (int(value) == self.__x_coord): return
                self.__x_coord = value
                changed = 1
            elif (key == "y"):
                if (int(value) == self.__y_coord): return
                self.__y_coord = value
                changed = 1

            if (changed):
                settings = self.new_output()
                settings.set(key, value)
                self.send_output(settings)



    def call_action(self, call, path, args):

        # show display menu
        if (call == "menu"):
            menu = []
            self.open_menu(menu)

        # save new coordinates after moving
        elif (call == "move"):
            self.__dont_init = 1
            x, y, real_x, real_y = args
            if (x == UNSET_COORD or y == UNSET_COORD): return
            self.__x_coord = x
            self.__y_coord = y
            self.set_config("x", x)
            self.set_config("y", y)
            self.set_config("real-x", real_x)
            self.set_config("real-y", real_y)

        elif (call == "size"):
            w, h = args
            self.set_config("width", w)
            self.set_config("height", h)

        # open URLs
        elif (call == "open"):
            uri = args[-1]
            try:
                import gnome
                gnome.url_show(uri)
            except:
                print "could not open", uri

        # execute commands
        elif (call == "exec"):
            commands = args[-1]
            os.system(commands + " &")
