#
# Hash table for two-dimensional integer coordinates as keys.
#
class Hash2D:

    # size of the areas; low values are more efficient for retrieving values
    # but less efficient for setting or deleting values
    __AREA_SIZE = 10


    def __init__(self):

        self.__areas = {}
        self.__is_in = {}



    def __hash(x, y):        
        return (x - x % Hash2D.__AREA_SIZE, y - y % Hash2D.__AREA_SIZE)

    __hash = staticmethod(__hash)
    


    def set(self, x1, y1, x2, y2, value):

        self.delete(value)

        x1, x2 = min(x1, x2), max(x1, x2)
        y1, y2 = min(y1, y2), max(y1, y2)

        for x in xrange(x1, x2 + 1, Hash2D.__AREA_SIZE):
            for y in xrange(y1, y2 + 1, Hash2D.__AREA_SIZE):
                key = Hash2D.__hash(x, y)
                self.__areas.setdefault(key, []).append((value, x1, y1, x2, y2))
                self.__is_in.setdefault(value, []).append((key, x1, y1, x2, y2))
            #end for
        #end for




    def get(self, x, y):

        key = Hash2D.__hash(x, y)
        entries = self.__areas.get(key, [])

        return [ value for value, x1, y1, x2, y2 in entries
                if x1 <= x <= x2 and y1 <= y <= y2 ]





    def delete(self, value):

        # i love python 2.3 {}.pop !
        keys = self.__is_in.get(value, [])
        self.__is_in[value] = []
        for k, x1, y1, x2, y2 in keys:
            self.__areas[k].remove((value, x1, y1, x2, y2))
