import vfs
import gtk


#
# Image widget that supports tiling.
#
class TilingImage(gtk.Image):

    def __init__(self):

        self.__pixbuf = None
        self.__size = (1, 1)
        self.__is_invalidated = 1

        gtk.Image.__init__(self)
        #self.connect("expose-event", self.__on_expose)



    def __on_expose(self, src, event):

        w, h = self.size_request()
        if ((w, h) != self.__size):
            self.tile(w, h)
            self.__size = (w, h)
        


    #
    # Sets the image from a color string.
    #
    def set_from_color(self, color):

        if (color[0] == "#" and len(color) == 9):
            alpha = int(color[-2:], 16)
            color = color[:-2]
        else:
            alpha = 255

        self.__pixbuf = gtk.gdk.Pixbuf(0, 1, 8, 32, 32)
        c = gtk.gdk.color_parse(color)
        fillr = (c.red / 256) << 24
        fillg = (c.green / 256) << 16
        fillb = (c.blue / 256) << 8
        fillcolor = fillr | fillg | fillb | alpha
        self.__pixbuf.fill(fillcolor)

        self.__is_invalidated = 1
        w, h = self.__size
        self.tile(w, h)



    #
    # Sets the image from a file.
    #
    def set_from_file(self, uri):

        if (vfs.exists(uri)):
            fd = vfs.open(uri, "r")
            data = vfs.read_all(fd)
            fd.close()
            loader = gtk.gdk.PixbufLoader()
            try:
                loader.write(data, len(data))
                loader.close()
            except:
                print "Invalid file format"
                loader.close()
            self.__pixbuf = loader.get_pixbuf()
            w, h = self.__size
            self.__is_invalidated = 1
            self.tile(w, h)
            


    #
    # Tiles the background image over the visible area.
    #
    def tile(self, width, height):

        if (not self.__is_invalidated and (width, height) == self.__size):
            return

        self.__is_invalidated = 0
        self.__size = (width, height)
        
        if (not self.__pixbuf): return
        w = self.__pixbuf.get_width()
        h = self.__pixbuf.get_height()
        width = max(width, 1)
        height = max(height, 1)

        bg = gtk.gdk.Pixbuf(0, 1, 8, width, height)
        for x in xrange(0, width, w):
            for y in xrange(0, height, h):
                pw = min(w, width - x)
                ph = min(h, height - y)
                self.__pixbuf.copy_area(0, 0, pw, ph, bg, x, y)
            #end for
        #end for

        self.set_from_pixbuf(bg)

        cache_width = int(width / w) * w
        cache_height = int(height / h) * h
        if (cache_width > 0 and cache_height > 0):
            cache = gtk.gdk.Pixbuf(0, 1, 8, cache_width, cache_height)
            bg.copy_area(0, 0, cache_width, cache_height, cache, 0, 0)
            self.__pixbuf = cache
