%module systray %{
  #include <gdk/gdk.h>
  #include <pygtk/pygtk.h>
  #include "eggstatusicon.h"
%}


%typemap(python,in) PyObject *PyFunc {
  if (!PyCallable_Check($source)) {
      PyErr_SetString(PyExc_TypeError, "Need a callable object!");
      return NULL;
  }
  $target = $source;
}


%typemap(in) GdkWindow* { $1 = GDK_WINDOW(((PyGObject*) $input)->obj); }

extern EggStatusIcon* systray_icon_new ();
extern void systray_icon_set_icon (EggStatusIcon*, char*);
extern void systray_icon_set_activate_cb (EggStatusIcon*, PyObject *PyFunc);



%pythoncode %{

class SysTrayIcon:

    def __init__(self):

        self.__obj = systray_icon_new()

    def set_icon(self, icon_name):

        systray_icon_set_icon(self.__obj, icon_name)

    def set_activate_cb(self, cb):

	systray_icon_set_activate_cb(self.__obj, cb)

%}
