from DisplayTarget import DisplayTarget
from utils.datatypes import *
from utils import Unit

import gobject
import gtk
import pango
import re


# determine the locale
import commands

fail, CHARMAP = commands.getstatusoutput("locale charmap")

if (fail or not CHARMAP):
    log("Could not detect character encoding.")
    CHARMAP = "ASCII"


class TargetLabel(DisplayTarget):

    # regular expression for parsing font description strings
    __RE_FONT = re.compile("(?P<name>.+?)"
                           "(?P<size>[0-9\.]+)"
                           "(?P<unit>[a-z%]+)?$")


    def utf8_to_utf8(value):

        if (isinstance(value, unicode)):
            try:
                value = value.encode("UTF-8", "replace")
            except ValueError:
                log("Unicode -> UTF-8 convertion failed !!!")
                raise

        elif (not isinstance(value, str)):
            # int, float, long, list, tuple, instance
            value = str(value)

        return value


    def charmap_to_utf8(value):

        if (isinstance(value, str)):
            try:
                value = unicode(value, CHARMAP, "ignore")
            except LookupError:
                # may be it's already UTF-8 ?
                value = unicode(value, "UTF-8", "replace")

        if (isinstance(value, unicode)):
            try:
                value = value.encode("UTF-8", "replace")
            except ValueError:
                log("Unicode -> UTF-8 convertion failed !!!")
                raise

        else:
            # int, float, long, list, tuple, instance
            value = str(value)

        return value


    #
    # Converts the given string to UTF-8 format.
    #
    if (CHARMAP == 'UTF-8'):
        __utf8ify = staticmethod(utf8_to_utf8)
    else:
        __utf8ify = staticmethod(charmap_to_utf8)



    def __init__(self, name, parent):

        self.__old_value = ""
        self.__font_description = None
        self.__wrap_at = -1

        DisplayTarget.__init__(self, name, parent)

        self.__widget = gtk.Label("")
        self.__widget.set_line_wrap(False)
        self.__font_description = \
             self.__widget.get_layout().get_context().get_font_description()
        self.__widget.show()

        # i guess a label has to accept everything printable for its value
        # these days
        self._register_property("value", TYPE_ANY,
                                self._setp_value, self._getp)
        self._register_property("color", TYPE_STRING,
                                self._setp_color, self._getp)
        self._register_property("font", TYPE_STRING,
                                self._setp_font, self._getp)
        self._register_property("wrap-at", TYPE_UNIT,
                                self._setp_wrap_at, self._getp)

        self._setp("value", "")
        self._setp("color", "black")
        self._setp("font", "Sans 8")
        self._setp("wrap-at", Unit.Unit(0, Unit.UNIT_PX))

        # watch the parent for geometry changes; we need this for percentual
        # font sizes
        parent.add_observer(self.__on_observe_parent)


    def get_widget(self): return self.__widget


    def __on_observe_parent(self, src, cmd, *args):

        if (cmd == src.OBS_GEOMETRY):
            self.__set_wrap(self.get_prop("wrap-at"))
            self.__set_font(self.get_prop("font"))
            self.__set_value(self.get_prop("value"))


    def __set_value(self, value):

        value = self.__utf8ify(value)

        layout = self.__widget.get_layout()
        layout.set_markup(value)
        layout.set_font_description(self.__font_description)
        layout.set_width(self.__wrap_at * pango.SCALE)
        width, height = layout.get_pixel_size()

        self.__widget.set_size_request(width, height)
        self.__widget.set_markup(value)
        gobject.timeout_add(0, self.set_size,
                            Unit.Unit(width, Unit.UNIT_PX),
                            Unit.Unit(height, Unit.UNIT_PX))
        self.__old_value = value


    def __set_font(self, font):

        m = TargetLabel.__RE_FONT.match(font)
        if (m):
            name = m.group("name")
            unit = m.group("unit") or Unit.UNIT_PT  # pt is default for fonts
            size = m.group("size")
            if (size):
                size = float(size)
                if (unit == Unit.UNIT_PERCENT):
                    height = self._get_parent().get_geometry()[3]
                    # don't allow 0 pixels height
                    size = max(1, height.as_pt() * (size / 100.0))
                    unit = Unit.UNIT_PT
                u = Unit.Unit(size, unit)
                size = u.as_pt()
                font = "%s %f" % (name, size)

        self.__font_description = pango.FontDescription(font)
        self.__widget.modify_font(self.__font_description)
        self.__widget.set_size_request(-1, -1)


    def __set_color(self, color):

        # chop off alpha channel
        if (color.startswith("#") and len(color) == 9): color = color[:7]
        self.__widget.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse(color))


    def __set_wrap(self, value):

        width = self._get_parent().get_geometry()[2]
        if (width > Unit.ZERO): value.set_100_percent(width.as_px())
        size = value.as_px()

        if (size == 0):
            self.__widget.set_line_wrap(False)
            self.__wrap_at = -1
        else:
            self.__widget.set_line_wrap(True)
            self.__wrap_at = size


    #
    # "value" property.
    #
    def _setp_value(self, key, value):

        if (value != self.__old_value):
            self.__set_value(value)
            self._setp(key, value)


    #
    # "font" property.
    #
    def _setp_font(self, key, value):

        if (value != self.get_prop("font")):
            self.__set_font(value)
            self._setp(key, value)
            self.__set_value(self.get_prop("value"))


    #
    # "color" property.
    #
    def _setp_color(self, key, value):

        self.__set_color(value)
        self._setp(key, value)


    #
    # "wrap-at" property.
    #
    def _setp_wrap_at(self, key, value):

        self.__set_wrap(value)
        self._setp(key, value)
	self.__set_value(self.get_prop("value"))
        self.set_prop("value", self.get_prop("value"))

