/* gdeklets-display-thumbnailer.c

   Complete rewrite of the previous version from Sebastien Bacher

   Copyright (C) 2004 Free Software Foundation

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Authors: Christian Kellner <gicmo@gnome-de.org>
            Christian Meyer <chrisime@gnome-de.org>
*/

#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

int main (int argc, char *argv[])
{
    char *file_content, *preview_url, *end;
    int   file_size;
    GnomeVFSURI    *uri, *image, *target;
    GnomeVFSResult result;

    if (argc != 3) {
        g_print("Syntax: %s [display_file to parse] [output]\n", argv[0]);
        return -1;
    }

    if (!gnome_vfs_init ())
        g_error("Couldn't initialize GnomeVFS!\n");

    result = gnome_vfs_read_entire_file (argv[1], &file_size, &file_content);

    if (result != GNOME_VFS_OK)
        g_error("Could not open URI: %s\n", argv[1]);

    preview_url = g_strstr_len (file_content, file_size, "preview");

    if (preview_url == NULL)
        return -1;

    /* skip preview=" */
    preview_url += 9;
    end = g_strrstr (preview_url, "\"");
    if (end == NULL)
        return -1;
    *end = '\0';

    uri = gnome_vfs_uri_new (argv[1]);
    image = gnome_vfs_uri_resolve_relative (uri, preview_url);
    gnome_vfs_uri_unref (uri);

    target = gnome_vfs_uri_new (argv[2]);

    result = gnome_vfs_xfer_uri (image, target,
                        GNOME_VFS_XFER_DEFAULT, GNOME_VFS_XFER_ERROR_MODE_ABORT,
                        GNOME_VFS_XFER_OVERWRITE_MODE_REPLACE, NULL, NULL);

    gnome_vfs_uri_unref (target);
    gnome_vfs_uri_unref (image);

    return result;
}
