import gtk


#
# Restricts the given coordinates to visible values.
#
def _crop_coords(x, y, width, height):

    scrwidth = gtk.gdk.screen_width()
    scrheight = gtk.gdk.screen_height()

    x = min(x, scrwidth - 1)
    y = min(y, scrheight - 1)

    width = min(scrwidth - x, width)
    height = min(scrheight - y, height)

    return (x, y, width, height)



#
# Captures the wallpaper image by accessing the background pixmap.
#
def get_wallpaper(widget, x, y, width, height):

    if (HAVE_WIN32): return

    x, y, width, height = _crop_coords(x, y, width, height)
    # get wallpaper
    try:
        pmap_id = get_wallpaper_id()
        import tiling
        tiling.tile_transparency(widget, pmap_id, x, y, width, height)
    except:
        raise NotImplementedError



#
# Returns the ID of the background pixmap.
#
def get_wallpaper_id():

    try:
        root = gtk.gdk.get_default_root_window()
        ident = root.property_get("_XROOTPMAP_ID", "PIXMAP")[2][0]
        return long(ident)

    except:
        raise NotImplementedError

