/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include "widgets.h"
#include "commands.h"
#include "populate_scope_treeview.h"
#include "select_first_scope.h"
#include "set_num_ranges.h"
#include "populate_ranges.h"
#include "populate_scope_settings.h"
#include "populate_leases.h"

extern char DHCPD_CONF_BUF[1024];


void add_conf_button_clicked(struct gdhcpd_widgets *widgets)
{
    gtk_widget_destroy(widgets->add_conf_window);

    add_missing_values(DHCPD_CONF_BUF);

    /* Populate the scope treeview */
    populate_scope_treeview(widgets);
    select_first_scope(widgets);

    /* Populate ranges */
    set_num_ranges(global_nic, global_subnet, global_netmask);
    populate_ranges(widgets, global_nic, global_subnet, global_netmask);
    
    /* Populate the settings */
    populate_scope_settings(widgets);

    /* Populate leases */
    populate_leases(widgets);

    gtk_widget_show_all(widgets->main_window);

    /* Dont ReRead here */
}
