/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "get_ranges_from_current_scope.h"
#include "delete_scope.h"
#include "populate_scope_treeview.h"
#include "select_first_scope.h"
#include "set_num_ranges.h"
#include "populate_ranges.h"
#include "populate_scope_settings.h"
#include "reread_conf.h"
extern char DHCPD_CONF_BUF[1024];



void apply_scope_settings(struct gdhcpd_widgets *widgets)
{
    FILE *fp;
    gchar *new_scope_begin, *new_scope_end;
    G_CONST_RETURN gchar *change_nic, *change_subnet, *change_netmask;
    gchar *setting=NULL, *info;
    char *ranges;
    int new_scope_def = 0;

    change_nic = gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[0]));
    change_subnet = gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[1]));
    change_netmask = gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[2]));

    if( strlen(change_nic) < 2 )
    {
        info = g_strdup_printf(_("The name of the network card is too short, the scope was not changed.\n"));
        show_info(info);
        g_free(info);
	return;
    }
    if( strlen(change_subnet) < 7 )
    {
        info = g_strdup_printf(_("The network address is too short, the scope was not changed.\n"));
        show_info(info);
        g_free(info);
	return;
    }
    if( strlen(change_netmask) < 7 )
    {
        info = g_strdup_printf(_("The subnet mask is too short, the scope was not changed.\n"));
        show_info(info);
        g_free(info);
	return;
    }

    /* Only update the scope treeview if the scope defs differs */
    if( strcmp(change_nic, global_nic) || strcmp(change_subnet, global_subnet) 
     || strcmp(change_netmask, global_netmask) )
      new_scope_def=1;

    ranges = get_ranges_from_current_scope();

    new_scope_begin = g_strdup_printf("subnet %s netmask %s {\n    interface %s;\n", 
								      change_subnet,
							              change_netmask,
								      change_nic);
    /* Added last */							
    new_scope_end = g_strdup_printf("}\n");

    /* Delete the current scope */
    delete_scope(widgets);
    

    if((fp=fopen(DHCPD_CONF_BUF, "a"))==NULL)
    {
        printf("Could not open dhcpd.conf here: %s\n", DHCPD_CONF_BUF);
	g_free(new_scope_begin);
	g_free(new_scope_end);
        return;
    }
    
    fputs(new_scope_begin, fp);


    if( strlen(ranges) > 0 )
      fputs(ranges, fp);

    /* Default lease time */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[3])))>0 )
    {
        setting = g_strdup_printf("    default-lease-time %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[3])));
	fputs(setting, fp);
    }

    /* Max lease time */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[4])))>0 )
    {
        setting = g_strdup_printf("    max-lease-time %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[4])));
	fputs(setting, fp);
    }

    /* Domain name */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[5])))>0 )
    {
        setting = g_strdup_printf("    option domain-name \"%s\";\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[5])));
	fputs(setting, fp);
    }

    /* Subnet mask */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[6])))>0 )
    {
        setting = g_strdup_printf("    option subnet-mask %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[6])));
	fputs(setting, fp);
    }

    /* Broadcast address */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[7])))>0 )
    {
        setting = g_strdup_printf("    option broadcast-address %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[7])));
	fputs(setting, fp);
    }

    /* Broadcast address */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[8])))>0 )
    {
        setting = g_strdup_printf("    option routers %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[8])));
	fputs(setting, fp);
    }

    /* Domain name servers */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[9])))>0 )
    {
        setting = g_strdup_printf("    option domain-name-servers %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[9])));
	fputs(setting, fp);
    }

    /* NIS domain */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[10])))>0 )
    {
        setting = g_strdup_printf("    option nis-domain \"%s\";\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[10])));
	fputs(setting, fp);
    }

    /* Time offset */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[11])))>0 )
    {
        setting = g_strdup_printf("    option time-offset %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[11])));
	fputs(setting, fp);
    }

    /* NTP servers */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[12])))>0 )
    {
        setting = g_strdup_printf("    option ntp-servers %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[12])));
	fputs(setting, fp);
    }

    /* Netbios name servers */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[13])))>0 )
    {
        setting = g_strdup_printf("    option netbios-name-servers %s;\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[13])));
	fputs(setting, fp);
    }

    /* Option T150 */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[14])))>0 )
    {
        setting = g_strdup_printf("    option T150 \"%s\";\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[14])));
	fputs(setting, fp);
    }

    /* Option filename */
    if( strlen(gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[15])))>0 )
    {
        setting = g_strdup_printf("    filename \"%s\";\n", 
	gtk_entry_get_text(GTK_ENTRY(widgets->scope_set_entry[15])));
	fputs(setting, fp);
    }

    fputs(new_scope_end, fp);
    fclose(fp);

    free(ranges); /* Allocated in get_ranges.. */

    if( setting!=NULL )
      g_free(setting);

    g_free(new_scope_begin);
    g_free(new_scope_end);

    /* Change the globals to new nic sub netmask if any */
    sprintf(global_nic, "%s", change_nic);
    sprintf(global_subnet, "%s", change_subnet);
    sprintf(global_netmask, "%s", change_netmask);

    /* Only update the scope settings if the scope defs differs */
    if( new_scope_def )
    {
	populate_scope_treeview(widgets);
	select_first_scope(widgets);

	set_num_ranges(global_nic, global_subnet, global_netmask);
	populate_ranges(widgets, global_nic, global_subnet, global_netmask);

	populate_scope_settings(widgets);
    }

    reread_conf();
}
