/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"

/* Wether or not to let the scope section expand */
#define EXPAND_SCOPE_SECTION FALSE

/* Wether or not to let the range section expand */
#define EXPAND_RANGE_SECTION FALSE

#include "scope_treeview_row_clicked.h"
#include "add_scope.h"
#include "delete_scope_from_btn.h"



void create_scope_tab(struct gdhcpd_widgets *widgets)
{
    GtkCellRenderer *scope_cell_renderer;
    GtkWidget *treeview_hbox;
    GtkWidget *scrolled_window;

    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();

    /* Create the scopes treeview in a scrolled window */
    treeview_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), treeview_hbox, EXPAND_SCOPE_SECTION, TRUE, 0);

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(treeview_hbox), scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(scrolled_window, -1, 75);

    widgets->scope_store = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    widgets->scope_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->scope_treeview), GTK_TREE_MODEL(widgets->scope_store));

    gtk_container_add (GTK_CONTAINER (scrolled_window), widgets->scope_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW (widgets->scope_treeview), TRUE);

    /* Set the column labels in the treeview */
    scope_cell_renderer = gtk_cell_renderer_text_new ();

    GtkTreeViewColumn *eth_col = gtk_tree_view_column_new_with_attributes(_("Network card"), scope_cell_renderer, "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->scope_treeview), GTK_TREE_VIEW_COLUMN(eth_col));

    GtkTreeViewColumn *subnet_col = gtk_tree_view_column_new_with_attributes(_("Network address"), scope_cell_renderer, "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->scope_treeview), GTK_TREE_VIEW_COLUMN(subnet_col));

    GtkTreeViewColumn *netmask_col = gtk_tree_view_column_new_with_attributes(_("Subnet mask"), scope_cell_renderer, "text", 2, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->scope_treeview), GTK_TREE_VIEW_COLUMN(netmask_col));

    g_signal_connect((gpointer)widgets->scope_treeview, "button_press_event",  
		      G_CALLBACK(scope_treeview_row_clicked), widgets);

    g_signal_connect(GTK_WINDOW(widgets->main_window), "delete_event", 
		     G_CALLBACK (gtk_main_quit), NULL);

    /* The add scope entries and add and delete buttons */
    GtkWidget *scope_add_hbox1 = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), scope_add_hbox1, FALSE, FALSE, 0);

    GtkWidget *scope_add_hbox2 = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), scope_add_hbox2, FALSE, FALSE, 0);

    GtkWidget *scope_del_hbox = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), scope_del_hbox, FALSE, FALSE, 0);

    widgets->scope_add_nic_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(scope_add_hbox2), widgets->scope_add_nic_entry, TRUE, TRUE, 0);
    gtk_widget_set_size_request(widgets->scope_add_nic_entry, 85, -1);
    gtk_tooltips_set_tip(tooltips, widgets->scope_add_nic_entry, "eth0", NULL);

    widgets->scope_add_subnet_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(scope_add_hbox2), widgets->scope_add_subnet_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(tooltips, widgets->scope_add_subnet_entry, "192.168.0.0", NULL);

    widgets->scope_add_netmask_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(scope_add_hbox2), widgets->scope_add_netmask_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(tooltips, widgets->scope_add_netmask_entry, "255.255.255.0", NULL);


    /* A hbutton box for the add and delete scope buttons */
    GtkWidget *scope_add_hbuttonbox = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(scope_add_hbox2), scope_add_hbuttonbox, FALSE, TRUE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(scope_add_hbuttonbox), GTK_BUTTONBOX_SPREAD);

    /* The add scope button */
    GtkWidget *scope_add_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    g_signal_connect_swapped(G_OBJECT(scope_add_button), "clicked", 
                             G_CALLBACK(add_scope), widgets);
    gtk_tooltips_set_tip(tooltips, scope_add_button, _("Add a new scope"), NULL);
    gtk_container_add(GTK_CONTAINER(scope_add_hbuttonbox), scope_add_button);

    /* The delete scope button */
    GtkWidget *scope_del_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    g_signal_connect_swapped(G_OBJECT(scope_del_button), "clicked", 
                             G_CALLBACK(delete_scope_from_btn), widgets);
    gtk_tooltips_set_tip(tooltips, scope_del_button, _("Delete the selected scope"), NULL);
    gtk_container_add(GTK_CONTAINER(scope_add_hbuttonbox), scope_del_button);

    /* A spacer at the end */
    GtkWidget *scope_spacer_label_del2 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(scope_add_hbox2), scope_spacer_label_del2, FALSE, FALSE, 9);


    /* Range settings */
    widgets->range_vbox = gtk_vbox_new(TRUE, 0);

    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), 
			       widgets->range_vbox, 
			       EXPAND_RANGE_SECTION, TRUE, 0);

    GtkWidget *scrolled_range_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(widgets->range_vbox), scrolled_range_window, TRUE, TRUE, 0);

    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_range_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(scrolled_range_window, -1, 80);

    widgets->range_viewport = gtk_viewport_new(NULL, NULL);
    gtk_container_add (GTK_CONTAINER (scrolled_range_window), widgets->range_viewport);

    /* So it can be destroyed initially */
    widgets->range_scrolled_vbox = gtk_vbox_new(TRUE, 0);



    /* Scope and client settings */
    widgets->scope_set_vbox = gtk_vbox_new(TRUE, 0);

    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1),
			       widgets->scope_set_vbox, 
			       TRUE, TRUE, 0);

    GtkWidget *scope_set_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(widgets->scope_set_vbox), scope_set_scrolled_window, TRUE, TRUE, 0);

    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scope_set_scrolled_window), 
								GTK_POLICY_AUTOMATIC, 
								GTK_POLICY_ALWAYS);

    widgets->scope_set_viewport = gtk_viewport_new(NULL, NULL);
    gtk_container_add (GTK_CONTAINER (scope_set_scrolled_window), widgets->scope_set_viewport);

    /* So it can be destroyed initially */
    widgets->scope_set_scrolled_vbox = gtk_vbox_new(TRUE, 0);
}
