/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "clear_ptr_array.h"
#include "populate_ranges.h"
#include "populate_scope_settings.h"
#include "show_info.h"
#include "set_num_ranges.h"
#include "reread_conf.h"

extern char DHCPD_CONF_BUF[1024];
extern int MAX_CONF_LINE;
extern int del_row_num;



void delete_range(struct gdhcpd_widgets *widgets)
{
    FILE *fp;
    long conf_size=0;
    int found_scope=0, range_deleted=0;
    char *line;
    char *new_conf;
    char *line_from;
    char *line_to;
    gchar *info;

    line_from = allocate(MAX_CONF_LINE+1);
    line_to = allocate(MAX_CONF_LINE+1);

    /* 3 different styles ...\n{ or ...{ or ... { */
    gchar *scope_line1 = g_strdup_printf("subnet %s netmask %s\n", global_subnet, global_netmask);
    gchar *scope_line2 = g_strdup_printf("subnet %s netmask %s{\n", global_subnet, global_netmask);
    gchar *scope_line3 = g_strdup_printf("subnet %s netmask %s {\n", global_subnet, global_netmask);
    gchar *nic_line = g_strdup_printf("interface %s;\n", global_nic);

    gpointer range_from_arr = g_ptr_array_index(widgets->ranges_from_entry_array, 
									  del_row_num);
    gpointer range_to_arr = g_ptr_array_index(widgets->ranges_to_entry_array, 
									  del_row_num);

    if( range_from_arr==NULL || range_to_arr==NULL )
    {
       printf("Pointer arrays are NULL in delete_range\n");
       info = g_strdup_printf(_("Pointer array value is NULL, range not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }
    
    G_CONST_RETURN gchar *range_from = gtk_entry_get_text(GTK_ENTRY((gpointer)range_from_arr));
    G_CONST_RETURN gchar *range_to   = gtk_entry_get_text(GTK_ENTRY((gpointer)range_to_arr));

    if( range_from==NULL || range_to==NULL )
    {
	printf("delete_range: range_from or range_to is NULL\n");
        info = g_strdup_printf(_("Range from or range to is NULL, range not deleted\n"));
        show_info(info);
        g_free(info);
	return;
    }

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    new_conf = allocate(conf_size+1);
    line = allocate(conf_size+1);

    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( ( strstr(line, scope_line1) || strstr(line, scope_line2) 
	|| strstr(line, scope_line3) ) && ! strstr(line, "#") )
	{
	    strcat(new_conf, line);    
	
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		strcat(new_conf, line);

		if( strstr(line, nic_line) && ! strstr(line, "#") )
		{
		    found_scope = 1;
		    break;
		}
	    }
	}
	else
	  strcat(new_conf, line);
	
	if( found_scope )
	  break;
    }

    if( found_scope )
    {
	while(fgets(line, conf_size, fp)!=NULL)
	{
	    if( strstr(line, "range") && ! strstr(line, "#") )
	    {
	        if( ! range_deleted )
		{
		    sscanf(line, "%*s %s %s", line_from, line_to);
		    line_to[strlen(line_to)-1]='\0';

		    if( ! strcmp(line_from, range_from) && ! strcmp(line_to, range_to) )
		      range_deleted=1;
		    else
		      strcat(new_conf, line);
		}
		else
	          strcat(new_conf, line);
	    }
	    else
	      strcat(new_conf, line);
	}
    }

    fclose(fp);

    if((fp=fopen(DHCPD_CONF_BUF, "w+"))==NULL)
    {
	printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
    	return;
    }
    else
      {
         fputs(new_conf, fp);
         fclose(fp);
      }

    free(new_conf);
    free(line);
    free(line_from);
    free(line_to);

    g_free(scope_line1);
    g_free(scope_line2);
    g_free(scope_line3);
    
    if( range_deleted )
    {
	clear_ptr_array(widgets);
	set_num_ranges(global_nic, global_subnet, global_netmask);
	populate_ranges(widgets, global_nic, global_subnet, global_netmask);
	populate_scope_settings(widgets);

	reread_conf();
    }
}
