/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "set_num_ranges.h"
#include "populate_ranges.h"
#include "populate_scope_settings.h"


void scope_treeview_row_clicked(GtkTreeView *treeview, GdkEventButton *event,
								gpointer data)
{
    gchar *nic, *subnet, *netmask;
    GtkTreeIter iter;
    GtkTreePath *path;
    GtkTreeModel *list_store;
    GtkTreeSelection *selection;

    /* The left button is pressed */
    if( ! event->type == GDK_BUTTON_PRESS || ! event->button == 1 )
      return;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));

    if( gtk_tree_selection_count_selected_rows(selection) <= 1 )
    {
	/* Get the treepath for the row that was clicked */
         if( gtk_tree_view_get_path_at_pos(GTK_TREE_VIEW(treeview), event->x, event->y,
				                                &path, NULL, NULL, NULL))
         {
            gtk_tree_selection_unselect_all(selection);
    	    gtk_tree_selection_select_path(selection, path);

	    list_store = gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));
	    gtk_tree_model_get_iter(list_store, &iter, path);
	    gtk_tree_model_get(list_store, &iter, 0, &nic, -1);
	    gtk_tree_model_get(list_store, &iter, 1, &subnet, -1);
	    gtk_tree_model_get(list_store, &iter, 2, &netmask, -1);

	    sprintf(global_subnet, "%s", subnet);
	    sprintf(global_netmask, "%s", netmask);
	    sprintf(global_nic, "%s", nic);

	    set_num_ranges(nic, subnet, netmask);
	    populate_ranges(data, nic, subnet, netmask);
	    populate_scope_settings(data);

	    g_free(nic);
	    g_free(subnet);
	    g_free(netmask);
            gtk_tree_path_free(path);
    	 }
    }
}
