/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>

/* Number of widgets used in the settings window */
#define NUM_SETTINGS_ENTRIES 2
#define NUM_SETTINGS_COMBOS  5

/* Number of entries used in the scope and host settings */
#define NUM_SCOPE_SETTINGS 16
#define NUM_HOST_SETTINGS  16


typedef struct gdhcpd_widgets
{
  GtkWidget *main_window;
  GtkWidget *main_vbox;
  GtkWidget *notebook_vbox1;
  GtkWidget *notebook_vbox2;
  GtkWidget *notebook_vbox3;
  GtkWidget *onoff_label;
  GtkWidget *dhcpd_version_label;
  GtkWidget *scope_treeview;
  GtkTreePath *scope_treepath;
  GtkListStore *scope_store;

  /* Add scope entries */
  GtkWidget *scope_add_nic_entry;
  GtkWidget *scope_add_subnet_entry;
  GtkWidget *scope_add_netmask_entry;

  /* Scope settings */
  GtkWidget *scope_set_vbox;
  GtkWidget *scope_set_viewport;
  GtkWidget *scope_set_scrolled_vbox;
  GtkWidget *scope_set_entry[NUM_SCOPE_SETTINGS];
  
  /* Scope ranges */
  GtkWidget *range_vbox;
  GtkWidget *range_viewport;
  GtkWidget *range_scrolled_vbox;
  GtkWidget *range_from;
  GtkWidget *range_to;
  GPtrArray *ranges_hbox_array;
  GPtrArray *ranges_from_entry_array;
  GPtrArray *ranges_to_entry_array;
  GPtrArray *ranges_del_button_array;
  GtkWidget *ranges_add_vbox;
  GtkWidget *ranges_add_button;
  GtkWidget *ranges_add_from_entry;
  GtkWidget *ranges_add_to_entry; 

  /* Add host entries */
  GtkWidget *host_add_hostname_entry;
  GtkWidget *host_add_ipaddr_entry;
  GtkWidget *host_add_hwaddr_entry;

  /* Host settings */
  GtkWidget *host_set_vbox;
  GtkWidget *host_set_viewport;
  GtkWidget *host_set_scrolled_vbox;
  GtkListStore *host_store;
  GtkWidget *host_treeview;
  GtkWidget *host_set_entry[NUM_HOST_SETTINGS];

  /* Settings window */
  GtkWidget *add_conf_window;
  GtkWidget *settings_window;
  GtkWidget *settings_entry[NUM_SETTINGS_ENTRIES];
  GtkWidget *settings_combo[NUM_SETTINGS_COMBOS];

  /* Leases tab */
  GtkWidget *leases_textview;  

  GtkWidget *credits_window;

}wid;
