/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"

extern char global_hwaddr[1024];
extern char global_ipaddr[1024];
extern char global_hostname[1024];
extern char DHCPD_CONF_BUF[1024];

#include "functions.h"
#include "apply_host_settings.h"
#include "create_host_set_entries.h"



void populate_host_settings(struct w *widgets)
{
    FILE *fp;
    gchar *utf8=NULL;
    char *line, *buffy;
    long conf_size=0;
    int found_host=0, y=0;

    gchar *host_line1 = g_strdup_printf("host %s\n", global_hostname);
    gchar *host_line2 = g_strdup_printf("host %s{\n", global_hostname);
    gchar *host_line3 = g_strdup_printf("host %s {\n", global_hostname);

    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();

    gtk_widget_destroy(widgets->host_set_scrolled_vbox);
    widgets->host_set_scrolled_vbox = gtk_vbox_new(FALSE, 0);

    gtk_container_add (GTK_CONTAINER (widgets->host_set_viewport), widgets->host_set_scrolled_vbox);


    /* Host settings label */
    GtkWidget *host_set_spacer_hbox1 = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->host_set_scrolled_vbox), host_set_spacer_hbox1, FALSE, FALSE, 0);
    GtkWidget *host_set_spacer_label1 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(host_set_spacer_hbox1), host_set_spacer_label1, TRUE, TRUE, 0);

    /* Apply button */
    GtkWidget *host_set_apply_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->host_set_scrolled_vbox), host_set_apply_hbox, TRUE, TRUE, 0);

    GtkWidget *host_set_spacer_label2 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(host_set_apply_hbox), host_set_spacer_label2, FALSE, FALSE, 2);

    GtkWidget *host_settings_apply_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(host_set_apply_hbox), host_settings_apply_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(host_settings_apply_button), "clicked", 
                             G_CALLBACK(apply_host_settings), widgets);

    GtkWidget *host_set_spacer_label3 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(host_set_apply_hbox), host_set_spacer_label3, FALSE, FALSE, 5);



    /* Create the settings entries and labels in the host table */
    create_host_set_entries(widgets);



    /* Populate hostname,ipaddr and hwaddr entries from the global values */
    utf8 = g_locale_to_utf8((char *)global_hostname, strlen(global_hostname), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[0]), utf8);

    utf8 = g_locale_to_utf8((char *)global_ipaddr, strlen(global_ipaddr), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[1]), utf8);

    utf8 = g_locale_to_utf8((char *)global_hwaddr, strlen(global_hwaddr), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[2]), utf8);


    /* Insert the values from the host */
    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
	if( utf8!=NULL )
          g_free(utf8);

        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( ( !strcmp(line, host_line1) || !strcmp(line, host_line2) 
	|| !strcmp(line, host_line3) ) && ! strstr(line, "#") )
	{
	    found_host=1;
	    break;
	}
    }


    buffy = allocate(1024);

    if( found_host && conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {

	/* Break at host end */
	if( strstr(line, "}") && ! strstr(line, "#") )
	  break;

	if( strlen(line)>1000 )
	  continue;

	remove_semicolon(line);

	if( strstr(line, "default-lease-time") && ! strstr(line, "#") )
	{
    	    sscanf(line, "%*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[3]), utf8);
	}

	if( strstr(line, "max-lease-time") && ! strstr(line, "#") )
	{
	    sscanf(line, "%*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[4]), utf8);
	}

	if( strstr(line, "option domain-name") && ! strstr(line, "#")
	&& ! strstr(line, "option domain-name-servers")  )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }
	      
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[5]), utf8);
	}

	if( strstr(line, "option subnet-mask") && ! strstr(line, "#") )
	{
	    sscanf(line, "%*s %*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[6]), utf8);
	}

	if( strstr(line, "option broadcast-address") && ! strstr(line, "#") )
	{
	    sscanf(line, "%*s %*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[7]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option routers") && ! strstr(line, "#") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[8]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option domain-name-servers") && ! strstr(line, "#") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[9]), utf8);
	}

	if( strstr(line, "option nis-domain") && ! strstr(line, "#") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[10]), utf8);
	}

	if( strstr(line, "option time-offset") && ! strstr(line, "#") )
	{
	    sscanf(line, "%*s %*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[11]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option ntp-servers") && ! strstr(line, "#") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[12]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option netbios-name-servers") && ! strstr(line, "#") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[13]), utf8);
	}

	if( strstr(line, "option T150") && ! strstr(line, "#") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[14]), utf8);
	}

	if( strstr(line, "filename") && ! strstr(line, "#") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[15]), utf8);
	}
    }

    if( ! found_host )
    {
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[0]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[1]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[2]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[3]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[4]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[5]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[6]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[7]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[8]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[9]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[10]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[11]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[12]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[13]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[14]), "");
	gtk_entry_set_text(GTK_ENTRY(widgets->host_set_entry[15]), "");
    }

    fclose(fp);
    free(line);
    free(buffy);

    if( utf8!=NULL )
      g_free(utf8);

    gtk_widget_show_all(widgets->main_window);
}
