/**********************************************************************/
/*                                                                    */
/*                           Objective Caml                           */
/*                                                                    */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt        */
/*                                                                    */
/*  Copyright 1996 Institut National de Recherche en Informatique et  */
/*  en Automatique.  All rights reserved.  This file is distributed   */
/*  under the terms of the GNU Library General Public License, with   */
/*  the special exception on linking described in file                */
/*  ../../LICENSE-INRIA.                                              */
/*                                                                    */
/**********************************************************************/

/* Buffered input/output */

#ifndef __IO_H__
#define __IO_H__

#ifndef IO_BUFFER_SIZE
#define IO_BUFFER_SIZE 4096
#endif

typedef long file_offset;

struct channel {
  int fd;                       /* Unix file descriptor */
  file_offset offset;           /* Absolute position of fd in the file */
  char * end;                   /* Physical end of the buffer */
  char * curr;                  /* Current position in the buffer */
  char * max;                   /* Logical end of the buffer (for input) */
  void * mutex;                 /* Placeholder for mutex (for systhreads) */
  struct channel * next;        /* Linear chaining of channels (flush_all) */
  int revealed;                 /* For Cash only */
  int old_revealed;             /* For Cash only */
  int refcount;                 /* For flush_all and for Cash */
  char buff[IO_BUFFER_SIZE];    /* The buffer itself */
};

/* For an output channel:
     [offset] is the absolute position of the beginning of the buffer [buff].
   For an input channel:
     [offset] is the absolute position of the logical end of the buffer, [max].
*/

/* Functions and macros that can be called from C.  Take arguments of
   type struct channel *.  No locking is performed. */

/* Extract a struct channel * from the heap object representing it */

#define Channel(v) (*((struct channel **) (Data_custom_val(v))))

#endif /* __IO_H__ */

