/* Copyright 2011-2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

/**
 * A generic IMAP message or mailbox flag.
 *
 * In IMAP, message and mailbox flags have similar syntax, which is encapsulated here.
 *
 * @see MessageFlag
 * @see MailboxAttribute
 */

public abstract class Geary.Imap.Flag : BaseObject, Gee.Hashable<Geary.Imap.Flag> {
    public string value { get; private set; }
    
    public Flag(string value) {
        this.value = value;
    }
    
    public bool is_system() {
        return value[0] == '\\';
    }
    
    public bool equals_string(string value) {
        return Ascii.stri_equal(this.value, value);
    }
    
    public bool equal_to(Geary.Imap.Flag flag) {
        return (flag == this) ? true : flag.equals_string(value);
    }
    
    /**
     * Returns the {@link Flag} as an appropriate {@link Parameter}.
     */
    public Parameter to_parameter() {
        return StringParameter.get_best_for(value);
    }
    
    public uint hash() {
        return Ascii.stri_hash(value);
    }
    
    public string to_string() {
        return value;
    }
}



