#line 25 "../noweb/a_pan.nw"
/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/a_pan.nw"
/* DO NOT read or edit this file ! Use ../noweb/a_pan.nw instead */

#line 48 "../noweb/a_pan.nw"
#include <config.h>

#include <stdio.h>
#include <math.h>

#include <libgeda/libgeda.h>

#include "../include/x_states.h"
#include "../include/prototype.h"

#line 62 "../noweb/a_pan.nw"
/* Kazu on July 8, 1999 - added these macros to simplify the code */
/* keep these macros local to this file! KISS! */
#define GET_PAGE_WIDTH(w)					\
	((w)->page_current->right  - (w)->page_current->left)
#define GET_PAGE_HEIGHT(w)					\
	((w)->page_current->bottom - (w)->page_current->top )

#define GET_PAGE_CENTER_X(w)					\
	((w)->page_current->left + GET_PAGE_WIDTH(w)  / 2);
#define GET_PAGE_CENTER_Y(w)					\
	((w)->page_current->top  + GET_PAGE_HEIGHT(w) / 2);

#line 78 "../noweb/a_pan.nw"
int current_center_x = 0;
int current_center_y = 0;

#line 90 "../noweb/a_pan.nw"
/* experimental */
/* Kazu Hirata <kazu@seul.org> on July 25, 1999 - all zoom- and
 * pan-related functions should eventually get to this function. It
 * takes the desired center coordinate and the desired zoom
 * factor. Necessary adjustments may be done depending on situations.
 * */
/* this code is not longer experimental an is use by several funktions
like every zooming-function and the x_event_configure (Werner Hoch,(hw))*/
void a_pan_general(TOPLEVEL * w_current, double world_cx, double world_cy,
		   double relativ_zoom_factor, int flags)
{
  /* see libgeda/include/defines.h for flags */

  int fix = 0;

  /*if the borders should be ignored always rm outcomment or changes
     the flags in the function-calls */
  /*    flags |= A_PAN_IGNORE_BORDERS;
   */
  /* think it's better that the zoomfactor is defined as pix/mills
     this will be the same as w_current->page_current->to_screen_x/y_constant */
  int zoom_max = 5;
  double zx, zy, zoom_old, zoom_new, zoom_min;
#if DEBUG
  printf("--------------a_pan_general: \nworld_cx: %f, world_cy: %f \n ",
	 world_cx, world_cy);
#endif
  /* calc minimum zoomfactors and choose the smaller one, they are equal
     if the aspectratio of the world is the same as the worlds */
  zx = (double) w_current->width / (w_current->init_right -
				    w_current->init_left);
  zy = (double) w_current->height / (w_current->init_bottom -
				     w_current->init_top);
  zoom_min = zx < zy ? zx : zy;

#if DEBUG
  printf("zx_min: %f, zy_min: %f , flags: %d\n ", zx, zy, flags);
#endif

  /*to_screen_x_constant and to_screen_y_constant are nearly equal */
  /*    zx = w_current->page_current->to_screen_x_constant;
     zy = w_current->page_current->to_screen_y_constant;
     zoom_old = zx < zy ? zx : zy;
   */
  zoom_old = w_current->page_current->to_screen_y_constant;

  /*calc new zooming factor */
  zoom_new = zoom_old * relativ_zoom_factor;
  zoom_new = zoom_new > zoom_max ? zoom_max : zoom_new;
  if (!(flags & A_PAN_IGNORE_BORDERS)) {
    zoom_new = zoom_new < zoom_min ? zoom_min : zoom_new;
  }

  /*check if theres a zoom_full (rel is -1) */
  if (relativ_zoom_factor < 0) {
    zoom_new = zoom_min;
  }
  /*calculate the new visible area; adding 0.5 to round */
  w_current->page_current->left = world_cx - (double) w_current->width
      / 2 / zoom_new + 0.5;
  w_current->page_current->right = world_cx + (double) w_current->width
      / 2 / zoom_new + 0.5;
  w_current->page_current->top = world_cy - (double) w_current->height
      / 2 / zoom_new + 0.5;
  w_current->page_current->bottom = world_cy + (double) w_current->height
      / 2 / zoom_new + 0.5;

  /*and put it back to the borders */
  if (!(flags & A_PAN_IGNORE_BORDERS)) {
    /* check right border */
    if (w_current->page_current->right > w_current->init_right) {
      w_current->page_current->left +=
	  w_current->init_right - w_current->page_current->right;
      w_current->page_current->right = w_current->init_right;
    }
    /* check left border; this have to be done after the right border */
    if (w_current->page_current->left < w_current->init_left) {
      w_current->page_current->right +=
	  w_current->init_left - w_current->page_current->left;
      w_current->page_current->left = w_current->init_left;
    }
    /* check bottom border */
    if (w_current->page_current->bottom > w_current->init_bottom) {
      w_current->page_current->top +=
	  w_current->init_bottom - w_current->page_current->bottom;
      w_current->page_current->bottom = w_current->init_bottom;
    }
    /* check top border this have to be done after the bottom border */
    if (w_current->page_current->top < w_current->init_top) {
      w_current->page_current->bottom +=
	  w_current->init_top - w_current->page_current->top;
      w_current->page_current->top = w_current->init_top;
    }
  }
#if DEBUG
  printf("zoom_old: %f, zoom_new: %f \n ", zoom_old, zoom_new);
  printf("left: %d, right: %d, top: %d, bottom: %d\n",
	 w_current->page_current->left, w_current->page_current->right,
	 w_current->page_current->top, w_current->page_current->bottom);
  printf("aspect: %f\n",
	 (float) fabs(w_current->page_current->right -
		      w_current->page_current->left) /
	 (float) fabs(w_current->page_current->bottom -
		      w_current->page_current->top));
#endif

  /* not used any longer because there are no rounding errors to fix */
  /* correct aspect ratio */
  if (fix != 0) {
    correct_aspect(w_current);
  }

  /* set_window */
  set_window(w_current,
	     w_current->page_current->left,
	     w_current->page_current->right,
	     w_current->page_current->top,
	     w_current->page_current->bottom);

  /* redraw */
  if (!(flags & A_PAN_DONT_REDRAW)) {
    w_current->DONT_RECALC = 1;
    w_current->DONT_RESIZE = 1;
    w_current->DONT_REDRAW = 1;
    x_hscrollbar_update(w_current);
    x_vscrollbar_update(w_current);
    o_redraw_all_fast(w_current);
    w_current->DONT_REDRAW = 0;
    w_current->DONT_RECALC = 0;
    w_current->DONT_RESIZE = 0;
  }
}


#line 236 "../noweb/a_pan.nw"
void a_pan_calc(TOPLEVEL * w_current, int x, int y)
{
  int pan_x, pan_y;
  int ix, iy, center_x, center_y;

  pan_x = mil_x(w_current, x);
  pan_y = mil_y(w_current, y);

  center_x = GET_PAGE_CENTER_X(w_current);
  center_y = GET_PAGE_CENTER_Y(w_current);

  ix = center_x - pan_x;
  if (w_current->page_current->right - ix > w_current->init_right) {
    /* the right wall was hit */

    w_current->page_current->left =
	w_current->init_right - GET_PAGE_WIDTH(w_current);

    w_current->page_current->right = w_current->init_right;
  } else if (w_current->page_current->left - ix < w_current->init_left) {
    /* the left wall was hit */
    w_current->page_current->right =
	w_current->init_left + GET_PAGE_WIDTH(w_current);

    w_current->page_current->left = w_current->init_left;
  } else {
    /* normal case */
    w_current->page_current->left -= ix;
    w_current->page_current->right -= ix;
  }

  iy = center_y - pan_y;
  if (w_current->page_current->bottom - iy > w_current->init_bottom) {
    /* the bottom wall was hit */
    w_current->page_current->top =
	w_current->init_bottom - GET_PAGE_HEIGHT(w_current);

    w_current->page_current->bottom = w_current->init_bottom;
  } else if (w_current->page_current->top - iy < w_current->init_top) {
    /* the top wall was hit */
    w_current->page_current->bottom =
	w_current->init_top + GET_PAGE_HEIGHT(w_current);

    w_current->page_current->top = w_current->init_top;
  } else {
    /* normal case */
    w_current->page_current->top -= iy;
    w_current->page_current->bottom -= iy;
  }

#if DEBUG
  printf("left: %d, right: %d, top: %d, bottom: %d\n",
	 w_current->page_current->left, w_current->page_current->right,
	 w_current->page_current->top, w_current->page_current->bottom);
  printf("aspect: %f\n",
	 (float) fabs(w_current->page_current->right -
		      w_current->page_current->left) /
	 (float) fabs(w_current->page_current->bottom -
		      w_current->page_current->top));
  printf("zoomfactor: %d\n", w_current->page_current->zoom_factor);
#endif

  current_center_x = GET_PAGE_CENTER_X(w_current);
  current_center_y = GET_PAGE_CENTER_Y(w_current);

#if DEBUG
  printf("%d %d\n", current_center_x, current_center_y);
#endif
}


#line 314 "../noweb/a_pan.nw"
/* Kazu on July 8, 1999 - TODO: distill common part from a_pan() and
 * a_pan_mouse() because they are doing basically the same thing */
void a_pan(TOPLEVEL * w_current, int x, int y)
{
  int sx, sy, lx, ly;

  /* check to see if we are inside an action draw net, etc.  If
   * yes, convert screen coords to world coords */
  if (w_current->inside_action) {
    SCREENtoWORLD(w_current,
		  w_current->start_x, w_current->start_y, &sx, &sy);
    SCREENtoWORLD(w_current,
		  w_current->last_x, w_current->last_y, &lx, &ly);

#if 0
    printf("BEGIN: start x %d -> %d \n", w_current->start_x, sx);
    printf("BEGIN: start y %d -> %d \n", w_current->start_y, sy);
    printf("BEGIN: last  x %d -> %d \n", w_current->last_x, lx);
    printf("BEGIN: last  y %d -> %d \n", w_current->last_y, ly);
#endif
    w_current->start_x = sx;
    w_current->start_y = sy;
    w_current->last_x = lx;
    w_current->last_y = ly;
  }

  /* do the actual work */
  a_pan_calc(w_current, x, y);

  w_current->DONT_RECALC = 1;
  w_current->DONT_RESIZE = 1;
  w_current->DONT_REDRAW = 1;
  x_hscrollbar_update(w_current);
  x_vscrollbar_update(w_current);
  w_current->DONT_REDRAW = 0;
  w_current->DONT_RECALC = 0;
  w_current->DONT_RESIZE = 0;

  o_redraw_all_fast(w_current);

  /* convert coords back to screen coords */
  if (w_current->inside_action) {
    WORLDtoSCREEN(w_current,
		  w_current->start_x, w_current->start_y, &sx, &sy);
    WORLDtoSCREEN(w_current,
		  w_current->last_x, w_current->last_y, &lx, &ly);
#if 0
    printf("END:   start x %d <- %d \n", sx, w_current->start_x);
    printf("END:   start y %d <- %d \n", sy, w_current->start_y);
    printf("END:   last  x %d <- %d \n", lx, w_current->last_x);
    printf("END:   last  y %d <- %d \n", ly, w_current->last_y);
#endif
    w_current->start_x = sx;
    w_current->start_y = sy;
    w_current->last_x = lx;
    w_current->last_y = ly;
  }
  /* not needed */
  /* o_undo_savestate(w_current, UNDO_VIEWPORT_ONLY); */
}


#line 394 "../noweb/a_pan.nw"
void a_pan_mouse(TOPLEVEL * w_current, int diff_x, int diff_y)
{
  int pan_x, pan_y;
  int fix = 0;

  pan_x = WORLDabs(w_current, diff_x);
  pan_y = WORLDabs(w_current, diff_y);

#if 0
  printf("inside pan: %d %d\n", pan_x, pan_y);
  printf("before: %d %d %d %d\n",
	 w_current->page_current->left,
	 w_current->page_current->top,
	 w_current->page_current->right, w_current->page_current->bottom);
#endif

#if 0
  w_current->page_current->right -= pan_x;
  w_current->page_current->left -= pan_x;
  w_current->page_current->top -= pan_y;
  w_current->page_current->bottom -= pan_y;
#endif

  if (w_current->page_current->left - pan_x <= w_current->init_left) {
    w_current->page_current->left = w_current->init_left;
    /* the left wall was hit */
#if DEBUG
    printf("LEFT\n");
#endif
    fix++;
  } else {
    /* normal case */
    w_current->page_current->right -= pan_x;
#if DEBUG
    printf("left normal\n");
#endif
  }

  if (w_current->page_current->right - pan_x >= w_current->init_right) {
    /* the right wall was hit */
    w_current->page_current->right = w_current->init_right;
#if DEBUG
    printf("RIGHT\n");
#endif
    fix++;
  } else {
    /* normal case */
    w_current->page_current->left -= pan_x;
#if DEBUG
    printf("right normal\n");
#endif
  }

  if (w_current->page_current->top + pan_y <= w_current->init_top) {
    /* the top wall was hit */
    w_current->page_current->top = w_current->init_top;
#if DEBUG
    printf("TOP\n");
#endif
    fix++;
  } else {
    /* normal case */
    w_current->page_current->bottom += pan_y;
#if DEBUG
    printf("top normal\n");
#endif
  }

  if (w_current->page_current->bottom + pan_y >= w_current->init_bottom) {
    /* the bottom wall was hit */
    w_current->page_current->bottom = w_current->init_bottom;
#if DEBUG
    printf("BOTTOM\n");
#endif
    fix++;
  } else {
    /* normal */
    w_current->page_current->top += pan_y;
#if DEBUG
    printf("bottom normal\n");
#endif
  }

  /* really bound the left */
  if (w_current->page_current->left < 0) {
    w_current->page_current->left = 0;
    fix++;
  }

  /* really bound the top */
  if (w_current->page_current->top < 0) {
    w_current->page_current->top = 0;
    fix++;
  }

  if (fix != 0) {
    correct_aspect(w_current);
  }

  set_window(w_current,
	     w_current->page_current->left,
	     w_current->page_current->right,
	     w_current->page_current->top,
	     w_current->page_current->bottom);

#if 0
  printf("after: %d %d %d %d\n",
	 w_current->page_current->left,
	 w_current->page_current->top,
	 w_current->page_current->right, w_current->page_current->bottom);
#endif

  w_current->DONT_RECALC = 1;
  w_current->DONT_RESIZE = 1;
  w_current->DONT_REDRAW = 1;
  x_hscrollbar_update(w_current);
  x_vscrollbar_update(w_current);
  w_current->DONT_REDRAW = 0;
  w_current->DONT_RECALC = 0;
  w_current->DONT_RESIZE = 0;

  o_redraw_all_fast(w_current);

#if DEBUG
  printf("left: %d, right: %d, top: %d, bottom: %d\n",
	 w_current->page_current->left, w_current->page_current->right,
	 w_current->page_current->top, w_current->page_current->bottom);
  printf("aspect: %f\n",
	 (float) fabs(w_current->page_current->right -
		      w_current->page_current->left) /
	 (float) fabs(w_current->page_current->bottom -
		      w_current->page_current->top));
  printf("zoomfactor: %d\n", w_current->page_current->zoom_factor);
#endif
}
