#line 43 "../noweb/o_arc.nw"
/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/o_arc.nw"
/* DO NOT read or edit this file ! Use ../noweb/o_arc.nw instead */

#line 65 "../noweb/o_arc.nw"
#include <config.h>
#include <stdio.h>
#include <math.h>

#include <libgeda/libgeda.h>

#include "../include/globals.h"
#include "../include/prototype.h"

#line 77 "../noweb/o_arc.nw"
/* Kazu on July 8, 1999 - added these macros to simplify the code */
#define GET_BOX_WIDTH(w)			\
	abs((w)->last_x - (w)->start_x)
#define GET_BOX_HEIGHT(w)			\
	abs((w)->last_y - (w)->start_y)
/* pb20011011 - added this macro to compute distance */
#define GET_DISTANCE(w)             \
    sqrt(pow((w)->last_x-(w)->start_x,2)+pow((w)->last_y-(w)->start_y,2))


#line 98 "../noweb/o_arc.nw"
void o_arc_draw(TOPLEVEL * w_current, OBJECT * o_current)
{
  int wleft, wright, wtop, wbottom;
  int x, y, radius, start_angle, end_angle;
  int arc_width;
  GdkCapStyle arc_end;
  GdkColor *color;
  void (*draw_func) () = NULL;
  int length, space;

  if (o_current->arc == NULL) {
    return;
  }
#line 119 "../noweb/o_arc.nw"
  o_arc_recalc(w_current, o_current);

  world_get_arc_bounds(w_current, o_current,
		       &wleft, &wtop, &wright, &wbottom);

  if (!visible(w_current, wleft, wtop, wright, wbottom)) {
    return;
  }
#line 139 "../noweb/o_arc.nw"
  x = o_current->arc->screen_x;
  y = o_current->arc->screen_y;
  radius = o_current->arc->screen_width / 2;
  start_angle = o_current->arc->start_angle;
  end_angle = o_current->arc->end_angle;

#if DEBUG
  printf("drawing arc x: %d y: %d sa: %d ea: %d width: %d height: %d\n",
	 o_current->arc->screen_x,
	 o_current->arc->screen_y,
	 o_current->arc->start_angle,
	 o_current->arc->end_angle,
	 o_current->arc->screen_width, o_current->arc->screen_height);
#endif

  if (w_current->override_color != -1)
    color = x_get_color(w_current->override_color);
  else
    color = x_get_color(o_current->color);

  if (o_current->screen_line_width > 0) {
    arc_width = o_current->screen_line_width;
  } else {
    arc_width = 1;
  }

  switch (o_current->line_end) {
  case END_NONE:
    arc_end = GDK_CAP_BUTT;
    break;
  case END_SQUARE:
    arc_end = GDK_CAP_PROJECTING;
    break;
  case END_ROUND:
    arc_end = GDK_CAP_ROUND;
    break;
  default:
    fprintf(stderr, _("Unknown end for arc (%d)\n"), o_current->line_end);
    arc_end = GDK_CAP_BUTT;
    break;
  }

  length = o_current->screen_line_length;
  space = o_current->screen_line_space;

  switch (o_current->line_type) {
  case TYPE_SOLID:
    length = -1;
    space = -1;
    draw_func = (void *) o_arc_draw_solid;
    break;

  case TYPE_DOTTED:
    length = -1;		/* AVH changed o_arc_draw_dotted to use */
    /* space parameter only */
    draw_func = (void *) o_arc_draw_dotted;
    break;

  case TYPE_DASHED:
    draw_func = (void *) o_arc_draw_dashed;
    break;

  case TYPE_CENTER:
    draw_func = (void *) o_arc_draw_center;
    break;

  case TYPE_PHANTOM:
    draw_func = (void *) o_arc_draw_phantom;
    break;

  case TYPE_ERASE:
    break;

  default:
    length = -1;
    space = -1;
    arc_width = 0;		/* just to be careful */
    draw_func = (void *) o_arc_draw_solid;
    fprintf(stderr, _("Unknown type for arc !\n"));
    break;
  }

  if ((length == 0) || (space == 0))
    draw_func = (void *) o_arc_draw_solid;

  (*draw_func) (w_current->window, w_current->gc, color,
		arc_end,
		x, y, radius, start_angle, end_angle,
		arc_width, length, space);
  (*draw_func) (w_current->backingstore, w_current->gc, color,
		arc_end,
		x, y, radius, start_angle, end_angle,
		arc_width, length, space);


#line 238 "../noweb/o_arc.nw"
  if (o_current->draw_grips && w_current->draw_grips == TRUE) {

    /* pb29911903 - modified to use the new o_arc_[draw|erase]_grips() */
    if (!o_current->selected) {
      /* object is no more selected, erase the grips */
      o_current->draw_grips = FALSE;
      o_arc_erase_grips(w_current, o_current);
    } else {
      /* object is selected, draw the grips on the arc */
      o_arc_draw_grips(w_current, o_current);
    }

  }

#line 229 "../noweb/o_arc.nw"
#if DEBUG
  printf("drawing arc\n");
#endif
}

#line 270 "../noweb/o_arc.nw"
void
o_arc_draw_solid(GdkWindow * w, GdkGC * gc, GdkColor * color,
		 GdkCapStyle cap, gint x, gint y, gint radius, gint angle1,
		 gint angle2, gint arc_width, gint length, gint space)
{
  gdk_gc_set_foreground(gc, color);
  /* Set the width, end type and join style of the line */
  gdk_gc_set_line_attributes(gc, arc_width,
			     GDK_LINE_SOLID, cap, GDK_JOIN_MITER);

  /* Draw the arc */
  gdk_draw_arc(w, gc, FALSE,
	       x - radius, y - radius, 2 * radius, 2 * radius,
	       angle1 * 64, angle2 * 64);

}

#line 304 "../noweb/o_arc.nw"
/* length parameter is not used here */
void
o_arc_draw_dotted(GdkWindow * w, GdkGC * gc, GdkColor * color,
		  GdkCapStyle cap, gint x, gint y, gint radius,
		  gint angle1, gint angle2, gint arc_width, gint length,
		  gint space)
{
  double xa, ya;
  int da, d;

  gdk_gc_set_foreground(gc, color);

#line 321 "../noweb/o_arc.nw"
  /* PB inverting angle2 if < 0 and changing angle1 accordingly */
  /* the loop test assume that da > 0 */
  if (angle2 < 0) {
    angle1 = angle1 + angle2;
    angle2 = -angle2;
  }
  da = (int) ((((double) space) * 180) / (M_PI * ((double) radius)));

  /* If da or db too small for arc to be displayed as dotted,
     draw a solid arc */
  if (da <= 0) {
    gdk_draw_arc(w, gc, FALSE,
		 x + radius, y + radius, 2 * radius, 2 * radius,
		 angle1 * 64, angle2 * 64);
    return;
  }
#line 343 "../noweb/o_arc.nw"
  d = angle1;
  while (d < (angle2 + angle1)) {
    xa = ((double) x) + ((double) radius) * cos(d * M_PI / 180);
    ya = ((double) y) - ((double) radius) * sin(d * M_PI / 180);


#line 360 "../noweb/o_arc.nw"
    if (arc_width == 1) {
      gdk_draw_point(w, gc, (int) xa, (int) ya);
    } else {
      gdk_draw_arc(w, gc, TRUE,
		   ((int) xa) - arc_width / 2,
		   ((int) ya) - arc_width / 2,
		   arc_width, arc_width, 0, FULL_CIRCLE);
    }


#line 350 "../noweb/o_arc.nw"
    d = d + da;
  }

}

#line 386 "../noweb/o_arc.nw"
void
o_arc_draw_dashed(GdkWindow * w, GdkGC * gc, GdkColor * color,
		  GdkCapStyle cap, gint x, gint y, gint radius,
		  gint angle1, gint angle2, gint arc_width, gint length,
		  gint space)
{
  int da, db, a1, a2, d;

  gdk_gc_set_foreground(gc, color);
  gdk_gc_set_line_attributes(gc, arc_width, GDK_LINE_SOLID, cap,
			     GDK_JOIN_MITER);

#line 406 "../noweb/o_arc.nw"
  /* PB inverting angle2 if < 0 and changing angle1 accordingly */
  /* the loop test assume that da > 0 */
  if (angle2 < 0) {
    angle1 = angle1 + angle2;
    angle2 = -angle2;
  }
  da = (int) ((length * 180) / (M_PI * ((double) radius)));
  db = (int) ((space * 180) / (M_PI * ((double) radius)));

  /* If da or db too small for arc to be displayed as dotted,
     draw a solid arc */
  if ((da <= 0) || (db <= 0)) {
    gdk_draw_arc(w, gc, FALSE,
		 x - radius, y - radius, 2 * radius, 2 * radius,
		 angle1 * 64, angle2 * 64);
    return;
  }
#line 431 "../noweb/o_arc.nw"
  d = angle1;
  while ((d + da + db) < (angle1 + angle2)) {
    a1 = d;
    d = d + da;
    gdk_draw_arc(w, gc, FALSE,
		 x - radius, y - radius, 2 * radius, 2 * radius,
		 a1 * 64, da * 64);

    d = d + db;

  }

#line 448 "../noweb/o_arc.nw"
  if ((d + da) < (angle1 + angle2)) {
    a1 = d;
    a2 = da;
  } else {
    a1 = d;
    a2 = (angle1 + angle2) - d;
  }
  gdk_draw_arc(w, gc, FALSE,
	       x - radius, y - radius, 2 * radius, 2 * radius,
	       a1 * 64, a2 * 64);

}

#line 477 "../noweb/o_arc.nw"
void
o_arc_draw_center(GdkWindow * w, GdkGC * gc, GdkColor * color,
		  GdkCapStyle cap, gint x, gint y, gint radius,
		  gint angle1, gint angle2, gint arc_width, gint length,
		  gint space)
{
  double xa, ya;		/* coordinate of center */
  int da, db, a1, a2, d;

  gdk_gc_set_foreground(gc, color);
  gdk_gc_set_line_attributes(gc, arc_width,
			     GDK_LINE_SOLID, cap, GDK_JOIN_MITER);

#line 497 "../noweb/o_arc.nw"
  /* PB inverting angle2 if < 0 and changing angle1 accordingly */
  /* the loop test assume that da > 0 */
  if (angle2 < 0) {
    angle1 = angle1 + angle2;
    angle2 = -angle2;
  }
  da = (int) ((length * 180) / (M_PI * ((double) radius)));
  db = (int) ((space * 180) / (M_PI * ((double) radius)));

  /* If da or db too small to be displayed, draw an arc */
  if ((da <= 0) || (db <= 0)) {
    gdk_draw_arc(w, gc, FALSE,
		 x - radius, y - radius, 2 * radius, 2 * radius,
		 angle1 * 64, angle2 * 64);
    return;
  }
#line 521 "../noweb/o_arc.nw"
  d = angle1;
  while ((d + da + 2 * db) < (angle1 + angle2)) {
    a1 = d;
    d = d + da;
    gdk_draw_arc(w, gc, FALSE,
		 x - radius, y - radius, 2 * radius, 2 * radius,
		 a1 * 64, da * 64);

    d = d + db;
    xa = ((double) x) + ((double) radius) * cos(d * M_PI / 180);
    ya = ((double) y) - ((double) radius) * sin(d * M_PI / 180);


#line 578 "../noweb/o_arc.nw"
    if (arc_width == 1) {
      gdk_draw_point(w, gc, (int) xa, (int) ya);
    } else {
      gdk_draw_arc(w, gc, TRUE,
		   ((int) xa) - arc_width / 2,
		   ((int) ya) - arc_width / 2,
		   arc_width, arc_width, 0, FULL_CIRCLE);
    }


#line 535 "../noweb/o_arc.nw"
    d = d + db;
  }

#line 549 "../noweb/o_arc.nw"
  if ((d + da) < (angle1 + angle2)) {
    a1 = d;
    a2 = da;

    d = d + da;
  } else {
    a1 = d;
    a2 = (angle1 + angle2) - d;

    d = d + da;
  }
  gdk_draw_arc(w, gc, FALSE,
	       x - radius, y - radius, 2 * radius, 2 * radius,
	       a1 * 64, da * 64);

  if ((d + db) < (angle1 + angle2)) {
    xa = ((double) x) + ((double) radius) * cos(d * M_PI / 180);
    ya = ((double) y) - ((double) radius) * sin(d * M_PI / 180);


#line 578 "../noweb/o_arc.nw"
    if (arc_width == 1) {
      gdk_draw_point(w, gc, (int) xa, (int) ya);
    } else {
      gdk_draw_arc(w, gc, TRUE,
		   ((int) xa) - arc_width / 2,
		   ((int) ya) - arc_width / 2,
		   arc_width, arc_width, 0, FULL_CIRCLE);
    }

#line 569 "../noweb/o_arc.nw"
  }

}

#line 603 "../noweb/o_arc.nw"
void
o_arc_draw_phantom(GdkWindow * w, GdkGC * gc, GdkColor * color,
		   GdkCapStyle cap, gint x, gint y, gint radius,
		   gint angle1, gint angle2, gint arc_width, gint length,
		   gint space)
{
  double xa, ya;
  int da, db, a1, a2, d;

  gdk_gc_set_foreground(gc, color);
  gdk_gc_set_line_attributes(gc, arc_width,
			     GDK_LINE_SOLID, cap, GDK_JOIN_MITER);

#line 623 "../noweb/o_arc.nw"
  /* PB inverting angle2 if < 0 and changing angle1 accordingly */
  /* the loop test assume that da > 0 */
  if (angle2 < 0) {
    angle1 = angle1 + angle2;
    angle2 = -angle2;
  }
  da = (int) ((length * 180) / (M_PI * ((double) radius)));
  db = (int) ((space * 180) / (M_PI * ((double) radius)));

  /* If da or db too small for arc to be displayed as dotted,
     draw a solid arc */
  if ((da <= 0) || (db <= 0)) {
    gdk_draw_arc(w, gc, FALSE,
		 x - radius, y - radius, 2 * radius, 2 * radius,
		 angle1 * 64, angle2 * 64);
    return;
  }
#line 648 "../noweb/o_arc.nw"
  d = angle1;
  while ((d + da + 3 * db) < (angle1 + angle2)) {
    a1 = d;
    d = d + da;
    gdk_draw_arc(w, gc, FALSE,
		 x - radius, y - radius, 2 * radius, 2 * radius,
		 a1 * 64, da * 64);

    d = d + db;
    xa = ((double) x) + ((double) radius) * cos(d * M_PI / 180);
    ya = ((double) y) - ((double) radius) * sin(d * M_PI / 180);


#line 736 "../noweb/o_arc.nw"
    if (arc_width == 1) {
      gdk_draw_point(w, gc, (int) xa, (int) ya);
    } else {
      gdk_draw_arc(w, gc, TRUE,
		   ((int) xa) - arc_width / 2,
		   ((int) ya) - arc_width / 2,
		   arc_width, arc_width, 0, FULL_CIRCLE);
    }


#line 662 "../noweb/o_arc.nw"
    d = d + db;
    xa = ((double) x) + ((double) radius) * cos(d * M_PI / 180);
    ya = ((double) y) - ((double) radius) * sin(d * M_PI / 180);


#line 736 "../noweb/o_arc.nw"
    if (arc_width == 1) {
      gdk_draw_point(w, gc, (int) xa, (int) ya);
    } else {
      gdk_draw_arc(w, gc, TRUE,
		   ((int) xa) - arc_width / 2,
		   ((int) ya) - arc_width / 2,
		   arc_width, arc_width, 0, FULL_CIRCLE);
    }


#line 668 "../noweb/o_arc.nw"
    d = d + db;
  }

#line 684 "../noweb/o_arc.nw"
  if ((d + da) < (angle1 + angle2)) {
    a1 = d;
    a2 = da;
    d = d + da;
  } else {
    a1 = d;
    a2 = (angle1 + angle2) - d;
    d = d + da;
  }
  gdk_draw_arc(w, gc, FALSE,
	       x - radius, y - radius, 2 * radius, 2 * radius,
	       a1 * 64, a2 * 64);

  if ((d + db) < (angle1 + angle2)) {
    d = d + db;

    xa = ((double) x) + ((double) radius) * cos(d * M_PI / 180);
    ya = ((double) y) - ((double) radius) * sin(d * M_PI / 180);

    if (arc_width == 1) {
      gdk_draw_point(w, gc, (int) xa, (int) ya);
    } else {
      gdk_draw_arc(w, gc, TRUE,
		   ((int) xa) - arc_width / 2,
		   ((int) ya) - arc_width / 2,
		   arc_width, arc_width, 0, FULL_CIRCLE);
    }
  }

  if ((d + db) < (angle1 + angle2)) {
    d = d + db;

    xa = ((double) x) + ((double) radius) * cos(d * M_PI / 180);
    ya = ((double) y) - ((double) radius) * sin(d * M_PI / 180);

    if (arc_width == 1) {
      gdk_draw_point(w, gc, (int) xa, (int) ya);
    } else {
      gdk_draw_arc(w, gc, TRUE,
		   ((int) xa) - arc_width / 2,
		   ((int) ya) - arc_width / 2,
		   arc_width, arc_width, 0, FULL_CIRCLE);
    }
  }

}


#line 757 "../noweb/o_arc.nw"
void o_arc_erase(TOPLEVEL * w_current, OBJECT * o_current)
{
  w_current->override_color = w_current->background_color;
  o_arc_draw(w_current, o_current);
  w_current->override_color = -1;
}


#line 775 "../noweb/o_arc.nw"
void o_arc_eraserubber(TOPLEVEL * w_current)
{
  o_arc_rubberarc_xor(w_current);
}



#line 795 "../noweb/o_arc.nw"
void
o_arc_draw_xor(TOPLEVEL * w_current, int dx, int dy, OBJECT * o_current)
{
  int x, y, width, height, start_angle, end_angle;
  int color;

  if (o_current->arc == NULL) {
    return;
  }

#line 815 "../noweb/o_arc.nw"
/* diameter */
  width = o_current->arc->screen_width;
/* height MUST be equal to width, just another name for diameter */
  height = o_current->arc->screen_height;
/* center */
  x = o_current->arc->screen_x - (width / 2);
  y = o_current->arc->screen_y - (height / 2);
/* start and end angles */
  start_angle = o_current->arc->start_angle;
  end_angle = o_current->arc->end_angle;

/* check the size of the displayed arc */
/* do not allow null diameter = arc always displayed */
  if (height < 1) {
    height = 1;
  }
  if (width < 1) {
    width = 1;
  }

  if (o_current->saved_color != -1) {
    color = o_current->saved_color;
  } else {
    color = o_current->color;
  }


#line 807 "../noweb/o_arc.nw"

#line 845 "../noweb/o_arc.nw"
  gdk_gc_set_foreground(w_current->outline_xor_gc, x_get_darkcolor(color));
/* better to set the line attributes here ? */
  gdk_draw_arc(w_current->window, w_current->outline_xor_gc, FALSE,
	       x + dx, y + dy, width, height,
	       start_angle * 64, end_angle * 64);

/* backing store? not appropriate here  */

#line 808 "../noweb/o_arc.nw"

}


#line 867 "../noweb/o_arc.nw"
void o_arc_start(TOPLEVEL * w_current, int x, int y)
{
  /* set the center of the arc */
  w_current->last_x = w_current->start_x = fix_x(w_current, x);
  w_current->last_y = w_current->start_y = fix_y(w_current, y);

  /* set the radius */
  w_current->distance = 0;

  /* set the start and end angles */
  w_current->loc_x = w_current->loc_y = 0;

  /* start the rubberbanding process of the radius */
  o_arc_rubberarc_xor(w_current);

}

#line 900 "../noweb/o_arc.nw"
void o_arc_end1(TOPLEVEL * w_current, int x, int y)
{
  int diff_x, diff_y;

  if (w_current->inside_action == 0) {
    o_redraw(w_current, w_current->page_current->object_head);
    return;
  }

  /* erases the previous temporary radius segment */
  o_arc_rubberarc_xor(w_current);

  w_current->last_x = fix_x(w_current, x);
  w_current->last_y = fix_y(w_current, y);
  /* compute the radius */
  diff_x = GET_BOX_WIDTH(w_current);
  diff_y = GET_BOX_HEIGHT(w_current);
  if (diff_x >= diff_y) {
    w_current->distance = diff_x;
  } else {
    w_current->distance = diff_y;
  }

  /* ack! zero length radius */
  if (w_current->distance == 0) {
    return;
  }
#if DEBUG
  printf("DIST: %d\n", w_current->distance);
#endif

  /* open a dialog to input the start and end angle */
  arc_angle_dialog(w_current);

}

#line 952 "../noweb/o_arc.nw"
void o_arc_end2(TOPLEVEL * w_current, int x, int y)
{
  double dx, dy, d, cos_a_, sin_a_, a;

  /* erase the previous temporary arc */
  o_arc_rubberarc_xor(w_current);


#line 971 "../noweb/o_arc.nw"
/* compute the start angle */
  dx = ((double) x) - ((double) w_current->start_x);
  dy = -((double) y) + ((double) w_current->start_y);
  d = sqrt((dx * dx) + (dy * dy));

  sin_a_ = dy / ((double) d);
  cos_a_ = dx / ((double) d);
  a = asin(sin_a_) * 180 / M_PI;
  if (a < 0)
    a *= -1;

/* find the right quadrant */
  if (sin_a_ >= 0) {
    if (cos_a_ >= 0)
      a = a;
    else
      a = 180 - a;
  } else {
    if (cos_a_ >= 0)
      a = 360 - a;
    else
      a = 180 + a;
  }

/* start angle in degree is in a */
  w_current->loc_x = (int) a;


#line 962 "../noweb/o_arc.nw"
  /* draw the new temporary arc */
  o_arc_rubberarc_xor(w_current);

}

#line 1007 "../noweb/o_arc.nw"
void o_arc_end3(TOPLEVEL * w_current, int x, int y)
{
  double d, dx, dy, cos_a_, sin_a_, a;

  /* erase the previous temporary arc */
  o_arc_rubberarc_xor(w_current);


#line 1037 "../noweb/o_arc.nw"
/* compute the end angle */
  dx = ((double) x) - ((double) w_current->start_x);
  dy = -((double) y) + ((double) w_current->start_y);
  d = sqrt((dx * dx) + (dy * dy));

  sin_a_ = dy / ((double) d);
  cos_a_ = dx / ((double) d);
  a = asin(sin_a_) * 180 / M_PI;
  if (a < 0)
    a *= -1;

/* find the right quadrant */
  if (sin_a_ >= 0) {
    if (cos_a_ >= 0)
      a = a;
    else
      a = 180 - a;
  } else {
    if (cos_a_ >= 0)
      a = 360 - a;
    else
      a = 180 + a;
  }

/* end angle in degree is in a */
  w_current->loc_y = (int) a;


#line 1017 "../noweb/o_arc.nw"

#line 1063 "../noweb/o_arc.nw"
/* create, initialize and link the new arc object */
  w_current->page_current->object_tail =
      o_arc_add(w_current, w_current->page_current->object_tail,
		OBJ_ARC, w_current->graphic_color,
		w_current->start_x, w_current->start_y,
		w_current->distance, w_current->loc_x, w_current->loc_y);

/* draw the new object */
  o_redraw_single(w_current, w_current->page_current->object_tail);


#line 1019 "../noweb/o_arc.nw"
  w_current->start_x = (-1);
  w_current->start_y = (-1);
  w_current->last_x = (-1);
  w_current->last_y = (-1);
  w_current->loc_x = -1;
  w_current->loc_y = -1;
  w_current->distance = -1;

  w_current->page_current->CHANGED = 1;

  o_undo_savestate(w_current, UNDO_ALL);

}

#line 1084 "../noweb/o_arc.nw"
void o_arc_end4(TOPLEVEL * w_current, int start_angle, int end_angle)
{
  int x1, y1;
  int radius;

  /* get the center in world coords */
  SCREENtoWORLD(w_current,
		w_current->start_x, w_current->start_y, &x1, &y1);

  /* get the radius in world coords */
  radius = snap_grid(w_current, WORLDabs(w_current, w_current->distance));

  /* create, initialize and link the new arc object */
  w_current->page_current->object_tail =
      o_arc_add(w_current, w_current->page_current->object_tail,
		OBJ_ARC, w_current->graphic_color,
		x1, y1, radius, start_angle, end_angle);

  /* draw the new object */
  o_redraw_single(w_current, w_current->page_current->object_tail);

  w_current->start_x = (-1);
  w_current->start_y = (-1);
  w_current->last_x = (-1);
  w_current->last_y = (-1);
  w_current->loc_x = -1;
  w_current->loc_y = -1;
  w_current->distance = -1;

  w_current->page_current->CHANGED = 1;

  o_undo_savestate(w_current, UNDO_ALL);

}


#line 1143 "../noweb/o_arc.nw"
/* for the arc */
void o_arc_rubberarc(TOPLEVEL * w_current, int x, int y, int whichone)
{
  double d, dx, dy, sin_a_, cos_a_, a;
  int diff_x, diff_y;

  /* erase the previous temporary arc */
  o_arc_rubberarc_xor(w_current);

  if (whichone == ARC_RADIUS) {

#line 1175 "../noweb/o_arc.nw"
/* update the radius */
    w_current->last_x = fix_x(w_current, x);
    w_current->last_y = fix_y(w_current, y);

    diff_x = GET_BOX_WIDTH(w_current);
    diff_y = GET_BOX_HEIGHT(w_current);
    if (diff_x >= diff_y) {
      w_current->distance = diff_x;
    } else {
      w_current->distance = diff_y;
    }

#line 1155 "../noweb/o_arc.nw"

  } else if ((whichone == ARC_START_ANGLE) || (whichone == ARC_END_ANGLE)) {

#line 1191 "../noweb/o_arc.nw"
/* compute the angle */
    dx = ((double) x) - ((double) w_current->start_x);
    dy = -((double) y) + ((double) w_current->start_y);
    d = sqrt((dx * dx) + (dy * dy));

    sin_a_ = dy / ((double) d);
    cos_a_ = dx / ((double) d);
    a = asin(sin_a_) * 180 / M_PI;
    if (a < 0)
      a *= -1;

/* find the right quadrant */
    if (sin_a_ >= 0) {
      if (cos_a_ >= 0)
	a = a;
      else
	a = 180 - a;
    } else {
      if (cos_a_ >= 0)
	a = 360 - a;
      else
	a = 180 + a;
    }

#line 1159 "../noweb/o_arc.nw"


#line 1214 "../noweb/o_arc.nw"
/* set the start or end angle with this angle */
    switch (whichone) {
    case ARC_START_ANGLE:
      w_current->loc_x = (int) a;
      break;

    case ARC_END_ANGLE:
      w_current->loc_y = (int) a;
      break;

    default:
      return;
    }

#line 1161 "../noweb/o_arc.nw"

  }

  /* draw the new temporary arc */
  o_arc_rubberarc_xor(w_current);

}

#line 1241 "../noweb/o_arc.nw"
void o_arc_rubberarc_xor(TOPLEVEL * w_current)
{
  double tmp;
  int x1, y1;

  gdk_gc_set_foreground(w_current->xor_gc,
			x_get_darkcolor(w_current->select_color));
  gdk_gc_set_line_attributes(w_current->xor_gc, 0,
			     GDK_LINE_SOLID, GDK_CAP_NOT_LAST,
			     GDK_JOIN_MITER);
  /* draw the arc from the w_current variables */
  gdk_draw_arc(w_current->window, w_current->xor_gc, FALSE,
	       w_current->start_x - w_current->distance,
	       w_current->start_y - w_current->distance,
	       w_current->distance * 2,
	       w_current->distance * 2,
	       w_current->loc_x * 64, w_current->loc_y * 64);
  /* draw the radius segment from the w_current variables */
  tmp = ((double) w_current->loc_x) * M_PI / 180;
  x1 = w_current->start_x + w_current->distance * cos(tmp);
  y1 = w_current->start_y - w_current->distance * sin(tmp);
  gdk_draw_line(w_current->window, w_current->xor_gc,
		w_current->start_x, w_current->start_y, x1, y1);

}


#line 1280 "../noweb/o_arc.nw"
void o_arc_draw_grips(TOPLEVEL * w_current, OBJECT * o_current)
{
  int radius, x, y, start_angle, end_angle;
  int x1, y1, x2, y2;

  if (w_current->draw_grips == FALSE)
    return;


#line 1309 "../noweb/o_arc.nw"
  x = o_current->arc->screen_x;
  y = o_current->arc->screen_y;
  radius = o_current->arc->screen_width / 2;
  start_angle = o_current->arc->start_angle;
  end_angle = o_current->arc->end_angle;

  x1 = x + radius * cos(((double) start_angle) * M_PI / 180);
  y1 = y - radius * sin(((double) start_angle) * M_PI / 180);
  x2 = x + radius * cos(((double) (start_angle + end_angle)) * M_PI / 180);
  y2 = y - radius * sin(((double) (start_angle + end_angle)) * M_PI / 180);


#line 1291 "../noweb/o_arc.nw"

#line 1324 "../noweb/o_arc.nw"
/* draw the grip at the center */
  o_grips_draw(w_current, x, y);

/* draw the grip at the start_angle end of the arc */
  o_grips_draw(w_current, x1, y1);

/* draw the grip at the end_angle end of the arc */
  o_grips_draw(w_current, x2, y2);


#line 1293 "../noweb/o_arc.nw"
}

#line 1344 "../noweb/o_arc.nw"
void o_arc_erase_grips(TOPLEVEL * w_current, OBJECT * o_current)
{
  int radius, x, y, start_angle, end_angle;
  int x1, y1, x2, y2;

  if (w_current->draw_grips == FALSE)
    return;


#line 1365 "../noweb/o_arc.nw"
  x = o_current->arc->screen_x;
  y = o_current->arc->screen_y;
  radius = o_current->arc->screen_width / 2;
  start_angle = o_current->arc->start_angle;
  end_angle = o_current->arc->end_angle;

  x1 = x + radius * cos(((double) start_angle) * M_PI / 180);
  y1 = y - radius * sin(((double) start_angle) * M_PI / 180);
  x2 = x + radius * cos(((double) start_angle + end_angle) * M_PI / 180);
  y2 = y - radius * sin(((double) start_angle + end_angle) * M_PI / 180);


#line 1355 "../noweb/o_arc.nw"

#line 1380 "../noweb/o_arc.nw"
/* erase the grip at the center */
  o_grips_erase(w_current, x, y);

/* erase the grip at the start_angle end of the arc */
  o_grips_erase(w_current, x1, y1);

/* erase the grip at the end_angle end of the arc */
  o_grips_erase(w_current, x2, y2);


#line 1357 "../noweb/o_arc.nw"
}
