#line 172 "../noweb/x_dialog.nw"
/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/x_dialog.nw"
/* DO NOT read or edit this file ! Use ../noweb/x_dialog.nw instead */

/* STILL NEED to clean up line lengths in aa and tr */

#line 195 "../noweb/x_dialog.nw"
#include <config.h>

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/i_vars.h"
#include "../include/globals.h"
#include "../include/prototype.h"

#line 290 "../noweb/x_dialog.nw"
void destroy_window(GtkWidget * widget, GtkWidget ** window)
{
  *window = NULL;
}



#line 18 "../noweb/x_dialog.nw"
/***************** Start of Text Input dialog box *********************/
#line 306 "../noweb/x_dialog.nw"
int
text_input_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			   TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    text_input_dialog_close(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 325 "../noweb/x_dialog.nw"
void text_input_dialog_apply(GtkWidget * w, TOPLEVEL * w_current)
{
  int len;
  char *string = NULL;
  GtkWidget *tientry;
#ifdef HAS_GTK22
  GtkTextBuffer *textbuffer;
  GtkTextIter start, end;
#endif

  tientry =
      gtk_object_get_data(GTK_OBJECT(w_current->tiwindow), "tientry");

#ifdef HAS_GTK22
  textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(tientry));
  gtk_text_buffer_get_bounds(textbuffer, &start, &end);
  string = gtk_text_iter_get_text(&start, &end);
#else
  string = gtk_entry_get_text(GTK_ENTRY(tientry));
#endif

  if (string[0] != '\0') {
    len = strlen(string);
#if DEBUG
    printf("text was: _%s_ %d\n", string, len);
#endif
    switch (w_current->text_caps) {
    case (LOWER):
      string_tolower(string, string);
      break;

    case (UPPER):
      string_toupper(string, string);
      break;

    case (BOTH):
    default:
      /* do nothing */
      break;
    }

    o_attrib_set_string(w_current, string);
    w_current->page_current->CHANGED = 1;
#ifdef HAS_GTK22
    gtk_text_buffer_set_text(textbuffer, w_current->current_attribute, -1);
    select_all_text_in_textview(GTK_TEXT_VIEW(tientry));
#else
    gtk_entry_set_text(GTK_ENTRY(tientry), w_current->current_attribute);
    gtk_entry_select_region(GTK_ENTRY(tientry), 0, len);
#endif
    gtk_widget_grab_focus(tientry);

    w_current->event_state = DRAWTEXT;
    w_current->inside_action = 1;
  }
#if 0
  gtk_grab_remove(w_current->tiwindow);
  gtk_widget_destroy(w_current->tiwindow);
  w_current->tiwindow = NULL;
#endif
}


#line 400 "../noweb/x_dialog.nw"
void text_input_dialog_close(GtkWidget * w, TOPLEVEL * w_current)
{
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);
#if 0
  gtk_grab_remove(w_current->tiwindow);
#endif
  gtk_widget_destroy(w_current->tiwindow);
  w_current->tiwindow = NULL;
}


#line 422 "../noweb/x_dialog.nw"
void text_input_dialog(TOPLEVEL * w_current)
{
  GtkWidget *label = NULL;
  GtkWidget *tientry = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttoncancel = NULL;
  GtkWidget *vbox, *action_area;
#ifdef HAS_GTK22
  GtkWidget *viewport1 = NULL;
  GtkWidget *scrolled_window = NULL;
  PangoTabArray *tab_array;
  int real_tab_width;
#endif

  if (!w_current->tiwindow) {
    w_current->tiwindow = x_create_dialog_box(&vbox, &action_area);

#if 0
    gtk_window_position(GTK_WINDOW(w_current->tiwindow),
			GTK_WIN_POS_MOUSE);
#endif

    /*gtk_widget_set_usize(w_current->tiwindow, 400,130); no longer fixed size */

    gtk_window_position(GTK_WINDOW(w_current->tiwindow), GTK_WIN_POS_NONE);

    gtk_signal_connect(GTK_OBJECT(w_current->tiwindow),
		       "destroy", GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tiwindow);

    gtk_signal_connect(GTK_OBJECT(w_current->tiwindow),
		       "key_press_event",
		       (GtkSignalFunc) text_input_dialog_keypress,
		       w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->tiwindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tiwindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->tiwindow),
			 _("Text Entry..."));
    gtk_container_border_width(GTK_CONTAINER(w_current->tiwindow), 5);

    label =
	gtk_label_new(_
		      ("Enter text, click apply,\nmove cursor into window, click to place text.\nMiddle button to rotate while placing."));
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, TRUE, 5);
    gtk_widget_show(label);

#ifdef HAS_GTK22
    viewport1 = gtk_viewport_new(NULL, NULL);
    gtk_widget_show(viewport1);

    scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);
    gtk_container_add(GTK_CONTAINER(viewport1), scrolled_window);
    gtk_box_pack_start(GTK_BOX(vbox), viewport1, TRUE, TRUE, 10);
    gtk_widget_show(scrolled_window);

    tientry = gtk_text_view_new();
    gtk_text_view_set_editable(GTK_TEXT_VIEW(tientry), TRUE);
    select_all_text_in_textview(GTK_TEXT_VIEW(tientry));

    /* Set the tab width, using pango tab array */
    /* FIXME: This doesn't work. Why? */
    tab_array = pango_tab_array_new(1, TRUE);
    real_tab_width =
	text_view_calculate_real_tab_width(GTK_TEXT_VIEW(tientry),
					   tab_in_chars);
    if (real_tab_width >= 0) {
      pango_tab_array_set_tab(tab_array, 0, PANGO_TAB_LEFT,
			      real_tab_width);
      /* printf("Real tab width: %i\n", real_tab_width); */
      gtk_text_view_set_tabs(GTK_TEXT_VIEW(tientry), tab_array);
    } else {
      g_warning("text_input_dialog: Impossible to set tab width.\n");
    }
    pango_tab_array_free(tab_array);
    gtk_container_add(GTK_CONTAINER(scrolled_window), tientry);
#else
    tientry = gtk_entry_new_with_max_length(79);
    gtk_editable_select_region(GTK_EDITABLE(tientry), 0, -1);
    gtk_signal_connect(GTK_OBJECT(tientry), "activate",
		       GTK_SIGNAL_FUNC(text_input_dialog_apply),
		       w_current);
    gtk_box_pack_start(GTK_BOX(vbox), tientry, TRUE, TRUE, 10);
#endif

    gtk_widget_show(tientry);
    gtk_widget_grab_focus(tientry);
    gtk_object_set_data(GTK_OBJECT(w_current->tiwindow),
			"tientry", tientry);

    buttonok = gtk_button_new_with_label(_("Apply"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(text_input_dialog_apply),
		       w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);

    buttoncancel = gtk_button_new_with_label(_("Close"));
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttoncancel, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(text_input_dialog_close),
		       w_current);
    gtk_widget_show(buttoncancel);
  }

  if (!GTK_WIDGET_VISIBLE(w_current->tiwindow)) {
    gtk_widget_show(w_current->tiwindow);
#if 0
    gtk_grab_add(w_current->tiwindow);
#endif
  } else {
    gdk_window_raise(w_current->tiwindow->window);
  }
}


#line 23 "../noweb/x_dialog.nw"
/***************** End of Text Input dialog box ***********************/

/***************** Start of Text Edit dialog box **********************/
#line 563 "../noweb/x_dialog.nw"
gint change_alignment(GtkWidget * w, TOPLEVEL * w_current)
{
  char *alignment;
  alignment = gtk_object_get_data(GTK_OBJECT(w), "alignment");
  w_current->text_alignment = atoi(alignment);

  /*w_current->page_current->CHANGED=1; I don't think this belongs */
  /* o_undo_savestate(w_current, UNDO_ALL); I don't think this belongs */

  return (0);
}


#line 586 "../noweb/x_dialog.nw"
static GtkWidget *create_menu_alignment(TOPLEVEL * w_current)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GSList *group;
  char *buf;

  menu = gtk_menu_new();
  group = NULL;

  buf = g_strdup_printf(_("Lower Left"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "alignment", "0");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_alignment, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Middle Left"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "alignment", "1");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_alignment, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Upper Left"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "alignment", "2");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_alignment, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Lower Middle"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "alignment", "3");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_alignment, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Middle Middle"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "alignment", "4");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_alignment, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Upper Middle"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "alignment", "5");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_alignment, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Lower Right"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "alignment", "6");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_alignment, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Middle Right"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "alignment", "7");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_alignment, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Upper Right"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "alignment", "8");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_alignment, w_current);
  gtk_widget_show(menuitem);

  return (menu);
}


#line 709 "../noweb/x_dialog.nw"
int
text_edit_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			  TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    text_edit_dialog_cancel(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 729 "../noweb/x_dialog.nw"
void text_edit_dialog_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  int len = 0;
  int text_size = 8;
  char *text_string = NULL;
  char *text_size_string = NULL;
  int new_text_alignment;
  int num_selected;
#ifdef HAS_GTK22
  GtkTextBuffer *textbuffer;
  GtkTextIter start, end;
#endif

  num_selected =
      o_selection_return_num(w_current->page_current->selection2_head);

  /* text string entry will only show up if one object is selected */
  if (num_selected == 1) {
#ifdef HAS_GTK22
    textbuffer =
	gtk_text_view_get_buffer(GTK_TEXT_VIEW(w_current->teentry));
    gtk_text_buffer_get_bounds(textbuffer, &start, &end);
    text_string = gtk_text_iter_get_text(&start, &end);
#else
    text_string =
	(char *) gtk_entry_get_text(GTK_ENTRY(w_current->teentry));
#endif
  }
  /* else the string will be null which is okay */
  text_size_string =
      (char *) gtk_entry_get_text(GTK_ENTRY(w_current->tsentry));

  if (text_string) {
    len = strlen(text_string);
  }

  if (text_size_string) {
    text_size = atoi(text_size_string);
  }

  if (text_size == 0) {
    text_size = default_text_size;
  }

  new_text_alignment = w_current->text_alignment;

  o_text_edit_end(w_current, text_string, len, text_size,
		  new_text_alignment);

  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);

  gtk_grab_remove(w_current->tewindow);
  gtk_widget_destroy(w_current->tewindow);
  w_current->tewindow = NULL;
}


#line 792 "../noweb/x_dialog.nw"
void text_edit_dialog_cancel(GtkWidget * w, TOPLEVEL * w_current)
{
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);
  gtk_grab_remove(w_current->tewindow);
  gtk_widget_destroy(w_current->tewindow);
  w_current->tewindow = NULL;
}


#line 812 "../noweb/x_dialog.nw"
void
text_edit_dialog(TOPLEVEL * w_current, char *string, int text_size,
		 int text_alignment)
{
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttoncancel = NULL;
  GtkWidget *vbox, *action_area;
  GtkWidget *optionmenu = NULL;
  GtkWidget *align_menu = NULL;
#ifdef HAS_GTK22
  GtkWidget *viewport1 = NULL;
  GtkWidget *scrolled_window = NULL;
  GtkTextBuffer *textbuffer;
#endif
  char *text_size_string;
  int len;
  int num_selected;

  num_selected =
      o_selection_return_num(w_current->page_current->selection2_head);

  if (!w_current->tewindow) {
    w_current->tewindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_set_default_size(GTK_WINDOW(w_current->tewindow), 250, 300);

    gtk_window_position(GTK_WINDOW(w_current->tewindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->tewindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tewindow);

    gtk_signal_connect(GTK_OBJECT(w_current->tewindow),
		       "key_press_event",
		       (GtkSignalFunc) text_edit_dialog_keypress,
		       w_current);


#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->tewindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(gtk_widget_destroyed),
		       &w_current->tewindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->tewindow), _("Edit Text"));
    gtk_container_border_width(GTK_CONTAINER(w_current->tewindow), 10);

    if (num_selected == 1) {
      label = gtk_label_new(_("Edit Text"));
      gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, TRUE, 3);
      gtk_widget_show(label);

#ifdef HAS_GTK22
      viewport1 = gtk_viewport_new(NULL, NULL);
      gtk_widget_show(viewport1);

      scrolled_window = gtk_scrolled_window_new(NULL, NULL);
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
				     GTK_POLICY_AUTOMATIC,
				     GTK_POLICY_AUTOMATIC);
      gtk_container_add(GTK_CONTAINER(viewport1), scrolled_window);
      gtk_box_pack_start(GTK_BOX(vbox), viewport1, TRUE, TRUE, 10);
      gtk_widget_show(scrolled_window);

      w_current->teentry = gtk_text_view_new();
      gtk_text_view_set_editable(GTK_TEXT_VIEW(w_current->teentry), TRUE);
      select_all_text_in_textview(GTK_TEXT_VIEW(w_current->teentry));

      /* FIXME: Set tab's width in the textview widget. */
      /* See first the code in text_input_dialog and get it working before adding it here. */

      gtk_container_add(GTK_CONTAINER(scrolled_window),
			w_current->teentry);
#else
      w_current->teentry = gtk_entry_new();
      gtk_editable_select_region(GTK_EDITABLE(w_current->teentry), 0, -1);
      gtk_signal_connect(GTK_OBJECT(w_current->teentry), "activate",
			 GTK_SIGNAL_FUNC(text_edit_dialog_ok), w_current);
      gtk_box_pack_start(GTK_BOX(vbox), w_current->teentry, TRUE, TRUE,
			 10);
#endif

      gtk_widget_show(w_current->teentry);
      gtk_widget_grab_focus(w_current->teentry);
    }

    label = gtk_label_new(_("Edit Text Size"));
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, TRUE, 0);
    gtk_widget_show(label);

    w_current->tsentry = gtk_entry_new_with_max_length(10);
    gtk_editable_select_region(GTK_EDITABLE(w_current->tsentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->tsentry, FALSE, FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->tsentry), "activate",
		       GTK_SIGNAL_FUNC(text_edit_dialog_ok), w_current);
    gtk_widget_show(w_current->tsentry);


    label = gtk_label_new(_("Edit Text Alignment"));
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, TRUE, 5);
    gtk_widget_show(label);

    optionmenu = gtk_option_menu_new();
    align_menu = create_menu_alignment(w_current);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), align_menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu),
				text_alignment);
    w_current->text_alignment = text_alignment;
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
				   (gtk_menu_get_active
				    (GTK_MENU(align_menu))), TRUE);

    gtk_box_pack_start(GTK_BOX(vbox), optionmenu, FALSE, TRUE, 0);
    gtk_widget_show(optionmenu);


    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 5);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(text_edit_dialog_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);

    buttoncancel = gtk_button_new_with_label(_("Cancel"));
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttoncancel, TRUE, TRUE, 5);
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(text_edit_dialog_cancel),
		       w_current);
    gtk_widget_show(buttoncancel);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->tewindow)) {
    gtk_widget_show(w_current->tewindow);
    if (string != NULL) {
      len = strlen(string);
      if (num_selected == 1) {	/* only if one thing is selected */
#ifdef HAS_GTK22
	textbuffer =
	    gtk_text_view_get_buffer(GTK_TEXT_VIEW(w_current->teentry));
	gtk_text_buffer_set_text(GTK_TEXT_BUFFER(textbuffer), string, -1);
	select_all_text_in_textview(GTK_TEXT_VIEW(w_current->teentry));
#else
	gtk_entry_set_text(GTK_ENTRY(w_current->teentry), string);
	gtk_entry_select_region(GTK_ENTRY(w_current->teentry), 0, len);
#endif
      }
    }

    text_size_string = g_strdup_printf("%d", text_size);
    gtk_entry_set_text(GTK_ENTRY(w_current->tsentry), text_size_string);
    free(text_size_string);

    gtk_grab_add(w_current->tewindow);
  }
}


#line 32 "../noweb/x_dialog.nw"
/***************** End of Text Edit dialog box ************************/

/***************** Start of Line Type/width dialog box ****************/
#line 995 "../noweb/x_dialog.nw"
gint change_linetype(GtkWidget * w, TOPLEVEL * w_current)
{
  char *linetype;
  linetype = gtk_object_get_data(GTK_OBJECT(w), "linetype");
  w_current->line_type = (int) linetype;

  return (0);
}


#line 1015 "../noweb/x_dialog.nw"
static GtkWidget *create_menu_linetype(TOPLEVEL * w_current)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GSList *group;
  char *buf;

  menu = gtk_menu_new();
  group = NULL;

  buf = g_strdup_printf(_("Solid"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "linetype",
		      (gpointer) TYPE_SOLID);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_linetype, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Dotted"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "linetype",
		      (gpointer) TYPE_DOTTED);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_linetype, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Dashed"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "linetype",
		      (gpointer) TYPE_DASHED);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_linetype, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Center"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "linetype",
		      (gpointer) TYPE_CENTER);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_linetype, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Phantom"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "linetype",
		      (gpointer) TYPE_PHANTOM);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_linetype, w_current);
  gtk_widget_show(menuitem);

  return (menu);
}


#line 1094 "../noweb/x_dialog.nw"
int
line_type_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			  TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    line_type_dialog_cancel(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 1114 "../noweb/x_dialog.nw"
void line_type_dialog_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  int width = -1, length = -1, space = -1;
  OBJECT *object;
  GtkWidget *length_entry, *space_entry, *width_entry;
  char *line_width_string = NULL;
  char *line_length_string = NULL;
  char *line_space_string = NULL;

  object = gtk_object_get_data(GTK_OBJECT(w_current->ltwindow), "object");

  width_entry = gtk_object_get_data(GTK_OBJECT(w_current->ltwindow),
				    "width_entry");
  length_entry = gtk_object_get_data(GTK_OBJECT(w_current->ltwindow),
				     "length_entry");
  space_entry = gtk_object_get_data(GTK_OBJECT(w_current->ltwindow),
				    "space_entry");

  line_width_string = (char *) gtk_entry_get_text(GTK_ENTRY(width_entry));
  line_length_string =
      (char *) gtk_entry_get_text(GTK_ENTRY(length_entry));
  line_space_string = (char *) gtk_entry_get_text(GTK_ENTRY(space_entry));

  if ((line_width_string[0] != '\0')) {
    width = atoi(line_width_string);
  }

  if ((line_width_string[0] != '\0')) {
    length = atoi(line_length_string);
  }

  if ((line_width_string[0] != '\0')) {
    space = atoi(line_space_string);
  }

  /* do some error checking / correcting */
  switch (w_current->line_type) {

  case (TYPE_SOLID):
    length = -1;
    space = -1;
    break;

  case (TYPE_DOTTED):
    length = -1;

    if (space < 1) {
      space = 100;
      s_log_message(_("Invalid space specified, setting to 100\n"));
    }
    break;

  case (TYPE_DASHED):
  case (TYPE_CENTER):
  case (TYPE_PHANTOM):
    if (length < 1) {
      length = 100;
      s_log_message(_("Invalid length specified, setting to 100\n"));
    }

    if (space < 1) {
      space = 100;
      s_log_message(_("Invalid space specified, setting to 100\n"));
    }
    break;

  }

  o_erase_single(w_current, object);

  o_set_line_options(w_current, object, object->line_end,
		     w_current->line_type, width, length, space);

  o_object_recalc(w_current, object);

  o_redraw_single(w_current, object);


  w_current->page_current->CHANGED = 1;
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);

  gtk_grab_remove(w_current->ltwindow);
  gtk_widget_destroy(w_current->ltwindow);
  w_current->ltwindow = NULL;
}


#line 1211 "../noweb/x_dialog.nw"
void line_type_dialog_cancel(GtkWidget * w, TOPLEVEL * w_current)
{
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);
  gtk_grab_remove(w_current->ltwindow);
  gtk_widget_destroy(w_current->ltwindow);
  w_current->ltwindow = NULL;
}


#line 1231 "../noweb/x_dialog.nw"
void line_type_dialog(TOPLEVEL * w_current, OBJECT * object)
{
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttoncancel = NULL;
  GtkWidget *vbox, *action_area;
  GtkWidget *optionmenu = NULL;
  GtkWidget *line_type_menu = NULL;
  GtkWidget *length_entry = NULL;
  GtkWidget *space_entry = NULL;
  GtkWidget *width_entry = NULL;
  char *string;
  int len;

  if (!w_current->ltwindow) {
    w_current->ltwindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->ltwindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->ltwindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->ltwindow);

    gtk_signal_connect(GTK_OBJECT(w_current->ltwindow),
		       "key_press_event",
		       (GtkSignalFunc) line_type_dialog_keypress,
		       w_current);

    gtk_window_set_title(GTK_WINDOW(w_current->ltwindow),
			 _("Edit Line Width & Type"));
    gtk_container_border_width(GTK_CONTAINER(w_current->ltwindow), 10);

    gtk_object_set_data(GTK_OBJECT(w_current->ltwindow), "object",
			(gpointer) object);

    label = gtk_label_new(_("Line Width"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    width_entry = gtk_entry_new();
    /*    gtk_editable_select_region(
       GTK_EDITABLE(width_entry), 0, -1); */
    gtk_box_pack_start(GTK_BOX(vbox), width_entry, TRUE, TRUE, 10);

    gtk_signal_connect(GTK_OBJECT(width_entry), "activate",
		       GTK_SIGNAL_FUNC(line_type_dialog_ok), w_current);
    gtk_widget_show(width_entry);
    gtk_widget_grab_focus(width_entry);
    gtk_object_set_data(GTK_OBJECT(w_current->ltwindow),
			"width_entry", (gpointer) width_entry);

    label = gtk_label_new(_("Line Type"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);
    gtk_widget_show(label);

    optionmenu = gtk_option_menu_new();
    line_type_menu = create_menu_linetype(w_current);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), line_type_menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu),
				object->line_type);
    w_current->line_type = object->line_type;
    gtk_box_pack_start(GTK_BOX(vbox), optionmenu, TRUE, TRUE, 0);
    gtk_widget_show(optionmenu);

    label = gtk_label_new(_("Line Dash Length"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);
    gtk_widget_show(label);
    length_entry = gtk_entry_new();
    gtk_editable_select_region(GTK_EDITABLE(length_entry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), length_entry, TRUE, TRUE, 10);
    gtk_widget_show(length_entry);
    gtk_widget_grab_focus(length_entry);
    gtk_object_set_data(GTK_OBJECT(w_current->ltwindow),
			"length_entry", (gpointer) length_entry);

    label = gtk_label_new(_("Line Dash Space"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);
    gtk_widget_show(label);
    space_entry = gtk_entry_new();
    gtk_editable_select_region(GTK_EDITABLE(space_entry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), space_entry, TRUE, TRUE, 10);
    gtk_widget_show(space_entry);
    gtk_widget_grab_focus(space_entry);
    gtk_object_set_data(GTK_OBJECT(w_current->ltwindow),
			"space_entry", (gpointer) space_entry);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(line_type_dialog_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);

    buttoncancel = gtk_button_new_with_label(_("Cancel"));
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttoncancel, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(line_type_dialog_cancel),
		       w_current);
    gtk_widget_show(buttoncancel);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->ltwindow)) {
    gtk_widget_show(w_current->ltwindow);

    string = g_strdup_printf("%d", object->line_width);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(width_entry), string);
    gtk_entry_select_region(GTK_ENTRY(width_entry), 0, len);
    free(string);

    string = g_strdup_printf("%d", object->line_space);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(space_entry), string);
    free(string);

    string = g_strdup_printf("%d", object->line_length);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(length_entry), string);
    free(string);

    gtk_widget_grab_focus(width_entry);
    gtk_grab_add(w_current->ltwindow);
  }
}


#line 41 "../noweb/x_dialog.nw"
/***************** End of Line Type / Width dialog box ****************/

/***************** Start of Fill Type dialog box **********************/
#line 1401 "../noweb/x_dialog.nw"
gint change_filltype(GtkWidget * w, TOPLEVEL * w_current)
{
  char *filltype;
  filltype = gtk_object_get_data(GTK_OBJECT(w), "filltype");
  w_current->fill_type = (int) filltype;

  return (0);
}


#line 1421 "../noweb/x_dialog.nw"
static GtkWidget *create_menu_filltype(TOPLEVEL * w_current)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GSList *group;
  char *buf;

  menu = gtk_menu_new();
  group = NULL;

  buf = g_strdup_printf(_("Hollow"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "filltype",
		      (gpointer) FILLING_HOLLOW);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_filltype, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Filled"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "filltype",
		      (gpointer) FILLING_FILL);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_filltype, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Mesh"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "filltype",
		      (gpointer) FILLING_MESH);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_filltype, w_current);
  gtk_widget_show(menuitem);

  buf = g_strdup_printf(_("Hatch"));
  menuitem = gtk_radio_menu_item_new_with_label(group, buf);
  free(buf);
  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_object_set_data(GTK_OBJECT(menuitem), "filltype",
		      (gpointer) FILLING_HATCH);
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
		     (GtkSignalFunc) change_filltype, w_current);
  gtk_widget_show(menuitem);

  return (menu);
}


#line 1489 "../noweb/x_dialog.nw"
int
fill_type_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			  TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    fill_type_dialog_cancel(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 1509 "../noweb/x_dialog.nw"
void fill_type_dialog_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  int width = -1, angle1 = -1, pitch1 = -1, angle2 = -1, pitch2 = -1;
  OBJECT *object;
  GtkWidget *width_entry, *angle1_entry, *pitch1_entry, *angle2_entry,
      *pitch2_entry;
  char *fill_width_string = NULL;
  char *fill_angle1_string = NULL;
  char *fill_pitch1_string = NULL;
  char *fill_angle2_string = NULL;
  char *fill_pitch2_string = NULL;

  object = gtk_object_get_data(GTK_OBJECT(w_current->ftwindow), "object");

  width_entry = gtk_object_get_data(GTK_OBJECT(w_current->ftwindow),
				    "width_entry");
  angle1_entry = gtk_object_get_data(GTK_OBJECT(w_current->ftwindow),
				     "angle1_entry");
  pitch1_entry = gtk_object_get_data(GTK_OBJECT(w_current->ftwindow),
				     "pitch1_entry");
  angle2_entry = gtk_object_get_data(GTK_OBJECT(w_current->ftwindow),
				     "angle2_entry");
  pitch2_entry = gtk_object_get_data(GTK_OBJECT(w_current->ftwindow),
				     "pitch2_entry");

  fill_width_string = (char *) gtk_entry_get_text(GTK_ENTRY(width_entry));
  fill_angle1_string =
      (char *) gtk_entry_get_text(GTK_ENTRY(angle1_entry));
  fill_pitch1_string =
      (char *) gtk_entry_get_text(GTK_ENTRY(pitch1_entry));
  fill_angle2_string =
      (char *) gtk_entry_get_text(GTK_ENTRY(angle2_entry));
  fill_pitch2_string =
      (char *) gtk_entry_get_text(GTK_ENTRY(pitch2_entry));

  if ((fill_width_string[0] != '\0')) {
    width = atoi(fill_width_string);
  }

  if ((fill_angle1_string[0] != '\0')) {
    angle1 = atoi(fill_angle1_string);
  }

  if ((fill_pitch1_string[0] != '\0')) {
    pitch1 = atoi(fill_pitch1_string);
  }

  if ((fill_angle2_string[0] != '\0')) {
    angle2 = atoi(fill_angle2_string);
  }

  if ((fill_pitch2_string[0] != '\0')) {
    pitch2 = atoi(fill_pitch2_string);
  }

  /* do some error checking / correcting */
  switch (w_current->fill_type) {

  case (FILLING_HOLLOW):
  case (FILLING_FILL):
    angle1 = -1;
    pitch1 = 1;
    angle2 = -1;
    pitch2 = 1;
    width = -1;
    break;

  case (FILLING_HATCH):
    angle2 = -1;
    pitch2 = 1;
    break;

  case (FILLING_MESH):
    break;

  }

  o_erase_single(w_current, object);

#if DEBUG
  printf("fill_type_dialog_ok() : type: %d, width: %d\n",
	 w_current->fill_type, width);
  printf("\tpitch1: %d, angle1: %d\n", pitch1, angle1);
  printf("\tpitch2: %d, angle2: %d\n", pitch2, angle2);
#endif

  o_set_fill_options(w_current, object,
		     w_current->fill_type, width,
		     pitch1, angle1, pitch2, angle2);

  o_object_recalc(w_current, object);

  o_redraw_single(w_current, object);


  w_current->page_current->CHANGED = 1;
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);

  gtk_grab_remove(w_current->ftwindow);
  gtk_widget_destroy(w_current->ftwindow);
  w_current->ftwindow = NULL;
}


#line 1616 "../noweb/x_dialog.nw"
void fill_type_dialog_cancel(GtkWidget * w, TOPLEVEL * w_current)
{
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);
  gtk_grab_remove(w_current->ftwindow);
  gtk_widget_destroy(w_current->ftwindow);
  w_current->ftwindow = NULL;
}


#line 1636 "../noweb/x_dialog.nw"
void fill_type_dialog(TOPLEVEL * w_current, OBJECT * object)
{
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttoncancel = NULL;
  GtkWidget *vbox, *action_area;
  GtkWidget *optionmenu = NULL;
  GtkWidget *fill_type_menu = NULL;
  GtkWidget *width_entry = NULL;
  GtkWidget *angle1_entry = NULL;
  GtkWidget *pitch1_entry = NULL;
  GtkWidget *angle2_entry = NULL;
  GtkWidget *pitch2_entry = NULL;
  char *string;
  int len;

  if (!w_current->ftwindow) {
    w_current->ftwindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->ftwindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->ftwindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->ftwindow);

    gtk_signal_connect(GTK_OBJECT(w_current->ftwindow),
		       "key_press_event",
		       (GtkSignalFunc) fill_type_dialog_keypress,
		       w_current);

    gtk_window_set_title(GTK_WINDOW(w_current->ftwindow),
			 _("Edit Fill Type"));
    gtk_container_border_width(GTK_CONTAINER(w_current->ftwindow), 10);

    gtk_object_set_data(GTK_OBJECT(w_current->ftwindow), "object",
			(gpointer) object);

    label = gtk_label_new(_("Fill Type"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    optionmenu = gtk_option_menu_new();
    fill_type_menu = create_menu_filltype(w_current);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), fill_type_menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu),
				object->fill_type);
    w_current->fill_type = object->fill_type;
    gtk_box_pack_start(GTK_BOX(vbox), optionmenu, TRUE, TRUE, 0);
    gtk_widget_grab_focus(optionmenu);
    gtk_widget_show(optionmenu);

    label = gtk_label_new(_("Line Width"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    width_entry = gtk_entry_new();
    gtk_editable_select_region(GTK_EDITABLE(width_entry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), width_entry, TRUE, TRUE, 10);

    gtk_signal_connect(GTK_OBJECT(width_entry), "activate",
		       GTK_SIGNAL_FUNC(fill_type_dialog_ok), w_current);
    gtk_widget_show(width_entry);
    gtk_object_set_data(GTK_OBJECT(w_current->ftwindow),
			"width_entry", (gpointer) width_entry);


    label = gtk_label_new(_("Angle1"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    angle1_entry = gtk_entry_new();
    gtk_editable_select_region(GTK_EDITABLE(angle1_entry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), angle1_entry, TRUE, TRUE, 10);

    gtk_signal_connect(GTK_OBJECT(angle1_entry), "activate",
		       GTK_SIGNAL_FUNC(fill_type_dialog_ok), w_current);
    gtk_widget_show(angle1_entry);
    gtk_object_set_data(GTK_OBJECT(w_current->ftwindow),
			"angle1_entry", (gpointer) angle1_entry);


    label = gtk_label_new(_("Pitch1"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    pitch1_entry = gtk_entry_new();
    gtk_editable_select_region(GTK_EDITABLE(pitch1_entry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), pitch1_entry, TRUE, TRUE, 10);

    gtk_signal_connect(GTK_OBJECT(pitch1_entry), "activate",
		       GTK_SIGNAL_FUNC(fill_type_dialog_ok), w_current);
    gtk_widget_show(pitch1_entry);
    gtk_object_set_data(GTK_OBJECT(w_current->ftwindow),
			"pitch1_entry", (gpointer) pitch1_entry);


    label = gtk_label_new(_("Angle2"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    angle2_entry = gtk_entry_new();
    gtk_editable_select_region(GTK_EDITABLE(angle2_entry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), angle2_entry, TRUE, TRUE, 10);

    gtk_signal_connect(GTK_OBJECT(angle2_entry), "activate",
		       GTK_SIGNAL_FUNC(fill_type_dialog_ok), w_current);
    gtk_widget_show(angle2_entry);
    gtk_object_set_data(GTK_OBJECT(w_current->ftwindow),
			"angle2_entry", (gpointer) angle2_entry);


    label = gtk_label_new(_("Pitch2"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    pitch2_entry = gtk_entry_new();
    gtk_editable_select_region(GTK_EDITABLE(pitch2_entry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), pitch2_entry, TRUE, TRUE, 10);

    gtk_signal_connect(GTK_OBJECT(pitch2_entry), "activate",
		       GTK_SIGNAL_FUNC(fill_type_dialog_ok), w_current);
    gtk_widget_show(pitch2_entry);
    gtk_object_set_data(GTK_OBJECT(w_current->ftwindow),
			"pitch2_entry", (gpointer) pitch2_entry);


    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(fill_type_dialog_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);

    buttoncancel = gtk_button_new_with_label(_("Cancel"));
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttoncancel, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(fill_type_dialog_cancel),
		       w_current);
    gtk_widget_show(buttoncancel);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->ftwindow)) {
    gtk_widget_show(w_current->ftwindow);

    string = g_strdup_printf("%d", object->fill_width);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(width_entry), string);
    gtk_entry_select_region(GTK_ENTRY(width_entry), 0, len);
    free(string);

    string = g_strdup_printf("%d", object->fill_angle1);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(angle1_entry), string);
    gtk_entry_select_region(GTK_ENTRY(angle1_entry), 0, len);
    free(string);

    string = g_strdup_printf("%d", object->fill_pitch1);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(pitch1_entry), string);
    gtk_entry_select_region(GTK_ENTRY(pitch1_entry), 0, len);
    free(string);

    string = g_strdup_printf("%d", object->fill_angle2);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(angle2_entry), string);
    gtk_entry_select_region(GTK_ENTRY(angle2_entry), 0, len);
    free(string);

    string = g_strdup_printf("%d", object->fill_pitch2);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(pitch2_entry), string);
    gtk_entry_select_region(GTK_ENTRY(pitch2_entry), 0, len);
    free(string);

    gtk_widget_grab_focus(width_entry);
    gtk_grab_add(w_current->ftwindow);
  }
}


#line 50 "../noweb/x_dialog.nw"
/***************** End of Fill Type dialog box ***********************/

/***************** Start of Exit dialog box **************************/
#line 1876 "../noweb/x_dialog.nw"
int
exit_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
		     TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    exit_dialog_cancel(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 1896 "../noweb/x_dialog.nw"
void exit_dialog_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_grab_remove(w_current->exwindow);
  gtk_widget_destroy(w_current->exwindow);
  w_current->exwindow = NULL;

  /* go through and change ALL changed flags to 0 */
#if 0
  w_current->page_current->CHANGED = 0;
#endif
  s_page_clear_changed(w_current->page_head);
  i_callback_file_close(w_current, 0, NULL);
}


#line 1921 "../noweb/x_dialog.nw"
void exit_dialog_cancel(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_grab_remove(w_current->exwindow);
  gtk_widget_destroy(w_current->exwindow);
  w_current->exwindow = NULL;

  /* leave this one */
  w_current->event_state = SELECT;
}


#line 1942 "../noweb/x_dialog.nw"
void exit_dialog(TOPLEVEL * w_current)
{
  GtkWidget *exit_dialog;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *hseparator1;
  GtkWidget *hbuttonbox1;
  GtkWidget *button1;
  GtkWidget *button2;

  if (!w_current->exwindow) {

    exit_dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    w_current->exwindow = exit_dialog;
    gtk_window_set_title(GTK_WINDOW(exit_dialog), "Discard Changes?");
    gtk_window_set_position(GTK_WINDOW(exit_dialog), GTK_WIN_POS_MOUSE);
    gtk_window_set_modal(GTK_WINDOW(exit_dialog), TRUE);
    gtk_window_set_default_size(GTK_WINDOW(exit_dialog), 240, 160);
    gtk_widget_show(exit_dialog);

    gtk_signal_connect(GTK_OBJECT(w_current->exwindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->exwindow);

    gtk_signal_connect(GTK_OBJECT(w_current->exwindow),
		       "key_press_event",
		       (GtkSignalFunc) exit_dialog_keypress, w_current);

    vbox1 = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox1);
    gtk_container_add(GTK_CONTAINER(exit_dialog), vbox1);

    label1 = gtk_label_new(_("There are unsaved schematics!\n"
			     "\n"
			     "Are you sure?\n"
			     "OK will discard ALL changes!"));
    gtk_label_set_justify(GTK_LABEL(label1), GTK_JUSTIFY_CENTER);
    gtk_widget_show(label1);
    gtk_box_pack_start(GTK_BOX(vbox1), label1, TRUE, TRUE, 0);
    hseparator1 = gtk_hseparator_new();
    gtk_widget_show(hseparator1);
    gtk_box_pack_start(GTK_BOX(vbox1), hseparator1, FALSE, FALSE, 0);

    hbuttonbox1 = gtk_hbutton_box_new();
    gtk_widget_show(hbuttonbox1);
    gtk_box_pack_start(GTK_BOX(vbox1), hbuttonbox1, FALSE, FALSE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(hbuttonbox1), 10);

    button1 = gtk_button_new_with_label(_("OK"));
    gtk_widget_show(button1);
    gtk_container_add(GTK_CONTAINER(hbuttonbox1), button1);
    GTK_WIDGET_SET_FLAGS(button1, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(button1), "clicked",
		       GTK_SIGNAL_FUNC(exit_dialog_ok), w_current);

    button2 = gtk_button_new_with_label(_("Cancel"));
    gtk_widget_show(button2);
    gtk_container_add(GTK_CONTAINER(hbuttonbox1), button2);
    GTK_WIDGET_SET_FLAGS(button2, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(button2), "clicked",
		       GTK_SIGNAL_FUNC(exit_dialog_cancel), w_current);

    gtk_widget_grab_focus(button2);
    gtk_widget_grab_default(button2);
  }

  if (!GTK_WIDGET_VISIBLE(w_current->exwindow)) {
    gtk_widget_show(w_current->exwindow);
    gtk_grab_add(w_current->exwindow);
  }
}


#line 57 "../noweb/x_dialog.nw"
/***************** End of Exit dialog box ****************************/

/***************** Start of Arc dialog box ***************************/
#line 2029 "../noweb/x_dialog.nw"
int
arc_angles_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			   TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    arc_angles_dialog_cancel(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 2048 "../noweb/x_dialog.nw"
void arc_angles_dialog_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  char *string_start = NULL;
  char *string_sweep = NULL;

  string_start =
      (char *) gtk_entry_get_text(GTK_ENTRY(w_current->aaentry_start));
  string_sweep =
      (char *) gtk_entry_get_text(GTK_ENTRY(w_current->aaentry_sweep));

  if ((string_start[0] != '\0') && (string_sweep[0] != '\0')) {
    /* TODO: put error detection */
    /* pb20011125 - o_arc_end4 accepts the final angles as param */
    o_arc_end4(w_current, atoi(string_start), atoi(string_sweep));
  }

  gtk_grab_remove(w_current->aawindow);
  gtk_widget_destroy(w_current->aawindow);
  w_current->aawindow = NULL;
}


#line 2078 "../noweb/x_dialog.nw"
void arc_angles_dialog_cancel(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_grab_remove(w_current->aawindow);
  gtk_widget_destroy(w_current->aawindow);
  w_current->aawindow = NULL;

  w_current->event_state = DRAWARC;
}


#line 2098 "../noweb/x_dialog.nw"
void arc_angle_dialog(TOPLEVEL * w_current)
{
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttoncancel = NULL;
  GtkWidget *vbox, *action_area;

  if (!w_current->aawindow) {
    w_current->aawindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->aawindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->aawindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->aawindow);

    gtk_signal_connect(GTK_OBJECT(w_current->aawindow),
		       "key_press_event",
		       (GtkSignalFunc) arc_angles_dialog_keypress,
		       w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->aawindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->aawindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->aawindow), _("Arc Params"));
    gtk_container_border_width(GTK_CONTAINER(w_current->aawindow), 10);

    label = gtk_label_new(_("Start Angle"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->aaentry_start = gtk_entry_new_with_max_length(4);
    gtk_editable_select_region(GTK_EDITABLE(w_current->aaentry_start), 0,
			       -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->aaentry_start, FALSE,
		       FALSE, 5);
    gtk_widget_show(w_current->aaentry_start);
    gtk_widget_grab_focus(w_current->aaentry_start);

    label = gtk_label_new(_("Degrees of Sweep"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->aaentry_sweep = gtk_entry_new_with_max_length(4);
    gtk_editable_select_region(GTK_EDITABLE(w_current->aaentry_sweep), 0,
			       -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->aaentry_sweep, FALSE,
		       FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->aaentry_sweep), "activate",
		       GTK_SIGNAL_FUNC(arc_angles_dialog_ok), w_current);
    gtk_widget_show(w_current->aaentry_sweep);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(arc_angles_dialog_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);

    buttoncancel = gtk_button_new_with_label(_("Cancel"));
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttoncancel, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(arc_angles_dialog_cancel),
		       w_current);
    gtk_widget_show(buttoncancel);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->aawindow)) {
    gtk_widget_show(w_current->aawindow);
    gtk_grab_add(w_current->aawindow);
  }
}


#line 64 "../noweb/x_dialog.nw"
/***************** End of Arc dialog box *****************************/

/***************** Start of Translate dialog box *********************/
#line 2203 "../noweb/x_dialog.nw"
int
translate_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			  TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    translate_dialog_cancel(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 2223 "../noweb/x_dialog.nw"
void translate_dialog_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  char *string = NULL;

  string = (char *) gtk_entry_get_text(GTK_ENTRY(w_current->trentry));

  if ((string[0] != '\0')) {
    /* TODO: put error detection */
    /* zero offset has a special meaning... */
    o_complex_translate_all(w_current, atoi(string));
  }
#if 0
  gtk_grab_remove(w_current->trwindow);
#endif
  gtk_widget_destroy(w_current->trwindow);
  w_current->trwindow = NULL;
}


#line 2252 "../noweb/x_dialog.nw"
void translate_dialog_cancel(GtkWidget * w, TOPLEVEL * w_current)
{
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);
#if 0
  gtk_grab_remove(w_current->trwindow);
#endif
  gtk_widget_destroy(w_current->trwindow);
  w_current->trwindow = NULL;
}


#line 2274 "../noweb/x_dialog.nw"
void translate_dialog(TOPLEVEL * w_current)
{
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttoncancel = NULL;
  GtkWidget *vbox, *action_area;

  if (!w_current->trwindow) {
    w_current->trwindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->trwindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->trwindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->trwindow);

    gtk_signal_connect(GTK_OBJECT(w_current->trwindow),
		       "key_press_event",
		       (GtkSignalFunc) translate_dialog_keypress,
		       w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->trwindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->trwindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->trwindow), _("Translate"));
    gtk_container_border_width(GTK_CONTAINER(w_current->trwindow), 10);

    label = gtk_label_new(_("Offset to translate?\n(0 for origin)"));
    gtk_misc_set_padding(GTK_MISC(label), 10, 10);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->trentry = gtk_entry_new_with_max_length(10);
    gtk_editable_select_region(GTK_EDITABLE(w_current->trentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->trentry, FALSE, FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->trentry), "activate",
		       GTK_SIGNAL_FUNC(translate_dialog_ok), w_current);
    gtk_widget_show(w_current->trentry);
    gtk_widget_grab_focus(w_current->trentry);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(translate_dialog_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);

    buttoncancel = gtk_button_new_with_label(_("Cancel"));
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttoncancel, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(translate_dialog_cancel),
		       w_current);
    gtk_widget_show(buttoncancel);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->trwindow)) {
    gtk_widget_show(w_current->trwindow);
#if 0
    gtk_grab_add(w_current->trwindow);
#endif
  }
}


#line 71 "../noweb/x_dialog.nw"
/***************** End of Translate dialog box ***********************/

/***************** Start of Text size dialog box *********************/
#line 2367 "../noweb/x_dialog.nw"
int
text_size_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			  TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    text_size_dialog_cancel(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 2387 "../noweb/x_dialog.nw"
void text_size_dialog_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  char *string = NULL;
  int size;

  string = (char *) gtk_entry_get_text(GTK_ENTRY(w_current->tsentry));

  if ((string[0] != '\0')) {
    size = atoi(string);
    if (size) {
      w_current->text_size = size;
      w_current->page_current->CHANGED = 1;
      o_undo_savestate(w_current, UNDO_ALL);
    }
  }

  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}


#line 2419 "../noweb/x_dialog.nw"
void text_size_dialog_cancel(GtkWidget * w, TOPLEVEL * w_current)
{
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);
  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}


#line 2439 "../noweb/x_dialog.nw"
void text_size_dialog(TOPLEVEL * w_current)
{
  char *string;
  int len;
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttoncancel = NULL;
  GtkWidget *vbox, *action_area;

  if (!w_current->tswindow) {
    w_current->tswindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->tswindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "key_press_event",
		       (GtkSignalFunc) text_size_dialog_keypress,
		       w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->tswindow), _("Text Size"));
    gtk_container_border_width(GTK_CONTAINER(w_current->tswindow), 10);

    label = gtk_label_new(_("Enter new text size"));
    gtk_misc_set_padding(GTK_MISC(label), 10, 10);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->tsentry = gtk_entry_new_with_max_length(10);
    gtk_editable_select_region(GTK_EDITABLE(w_current->tsentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->tsentry, FALSE, FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->tsentry), "activate",
		       GTK_SIGNAL_FUNC(text_size_dialog_ok), w_current);
    gtk_widget_show(w_current->tsentry);
    gtk_widget_grab_focus(w_current->tsentry);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(text_size_dialog_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);

    buttoncancel = gtk_button_new_with_label(_("Cancel"));
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttoncancel, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(text_size_dialog_cancel),
		       w_current);
    gtk_widget_show(buttoncancel);
  }

  if (!GTK_WIDGET_VISIBLE(w_current->tswindow)) {
    string = g_strdup_printf("%d", w_current->text_size);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(w_current->tsentry), string);
    gtk_entry_select_region(GTK_ENTRY(w_current->tsentry), 0, len);
    gtk_widget_show(w_current->tswindow);
    gtk_grab_add(w_current->tswindow);
    free(string);
  }
}


#line 78 "../noweb/x_dialog.nw"
/***************** End of Text size dialog box ***********************/

/***************** Start of Snap size dialog box *********************/
#line 2537 "../noweb/x_dialog.nw"
int
snap_size_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			  TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    snap_size_dialog_cancel(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 2557 "../noweb/x_dialog.nw"
void snap_size_dialog_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  char *string = NULL;
  int size;

  string = (char *) gtk_entry_get_text(GTK_ENTRY(w_current->tsentry));

  if ((string[0] != '\0')) {
    size = atoi(string);
    if (size) {
      w_current->snap_size = size;
    }
  }

  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}


#line 2587 "../noweb/x_dialog.nw"
void snap_size_dialog_cancel(GtkWidget * w, TOPLEVEL * w_current)
{
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);
  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}


#line 2607 "../noweb/x_dialog.nw"
void snap_size_dialog(TOPLEVEL * w_current)
{
  char *string;
  int len;
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttoncancel = NULL;
  GtkWidget *vbox, *action_area;

  if (!w_current->tswindow) {
    w_current->tswindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->tswindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow), "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "key_press_event",
		       (GtkSignalFunc) snap_size_dialog_keypress,
		       w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->tswindow), _("Snap Grid"));
    gtk_container_border_width(GTK_CONTAINER(w_current->tswindow), 10);

    label = gtk_label_new(_("Enter new snap grid spacing"));
    gtk_misc_set_padding(GTK_MISC(label), 10, 10);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->tsentry = gtk_entry_new_with_max_length(10);
    gtk_editable_select_region(GTK_EDITABLE(w_current->tsentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->tsentry, FALSE, FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->tsentry), "activate",
		       GTK_SIGNAL_FUNC(snap_size_dialog_ok), w_current);
    gtk_widget_show(w_current->tsentry);
    gtk_widget_grab_focus(w_current->tsentry);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(snap_size_dialog_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);

    buttoncancel = gtk_button_new_with_label(_("Cancel"));
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttoncancel, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(snap_size_dialog_cancel),
		       w_current);
    gtk_widget_show(buttoncancel);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->tswindow)) {
    string = g_strdup_printf("%d", w_current->snap_size);
    len = strlen(string);
    gtk_entry_set_text(GTK_ENTRY(w_current->tsentry), string);
    gtk_entry_select_region(GTK_ENTRY(w_current->tsentry), 0, len);
    gtk_widget_show(w_current->tswindow);
    gtk_grab_add(w_current->tswindow);
    free(string);
  }
}


#line 85 "../noweb/x_dialog.nw"
/***************** End of Snap size dialog box ***********************/

/***************** Start of slot edit dialog box *********************/
#line 2705 "../noweb/x_dialog.nw"
int
slot_edit_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			  TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    slot_edit_dialog_cancel(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 2724 "../noweb/x_dialog.nw"
void slot_edit_dialog_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  int len;
  char *string = NULL;

  string = (char *) gtk_entry_get_text(GTK_ENTRY(w_current->seentry));

  if (string[0] != '\0') {
    len = strlen(string);

#if DEBUG
    printf("text was: _%s_ %d\n", string, len);
#endif

    if (len < 80) {
      o_slot_end(w_current, string, len);
    } else {
      /* TODO: you should NOT have limits */
      fprintf(stderr, _("String too long... hack!\n"));
    }
  }

  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);

  gtk_grab_remove(w_current->sewindow);
  gtk_widget_destroy(w_current->sewindow);
  w_current->sewindow = NULL;
}


#line 2765 "../noweb/x_dialog.nw"
void slot_edit_dialog_cancel(GtkWidget * w, TOPLEVEL * w_current)
{
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);
  gtk_grab_remove(w_current->sewindow);
  gtk_widget_destroy(w_current->sewindow);
  w_current->sewindow = NULL;
}


#line 2785 "../noweb/x_dialog.nw"
void slot_edit_dialog(TOPLEVEL * w_current, char *string)
{
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttoncancel = NULL;
  GtkWidget *vbox, *action_area;
  int len;

  if (!w_current->sewindow) {
    w_current->sewindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->sewindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->sewindow),
		       "destroy", GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->sewindow);

    gtk_signal_connect(GTK_OBJECT(w_current->sewindow),
		       "key_press_event",
		       (GtkSignalFunc) slot_edit_dialog_keypress,
		       w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->sewindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->sewindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->sewindow),
			 _("Edit slot number"));
    gtk_container_border_width(GTK_CONTAINER(w_current->sewindow), 10);

    label = gtk_label_new(_("Edit slot number"));
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->seentry = gtk_entry_new();
    gtk_editable_select_region(GTK_EDITABLE(w_current->seentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->seentry, TRUE, TRUE, 10);

    gtk_signal_connect(GTK_OBJECT(w_current->seentry), "activate",
		       GTK_SIGNAL_FUNC(slot_edit_dialog_ok), w_current);
    gtk_widget_show(w_current->seentry);
    gtk_widget_grab_focus(w_current->seentry);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(slot_edit_dialog_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);

    buttoncancel = gtk_button_new_with_label(_("Cancel"));
    GTK_WIDGET_SET_FLAGS(buttoncancel, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttoncancel, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttoncancel), "clicked",
		       GTK_SIGNAL_FUNC(slot_edit_dialog_cancel),
		       w_current);
    gtk_widget_show(buttoncancel);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->sewindow)) {
    gtk_widget_show(w_current->sewindow);

    if (string != NULL) {
      len = strlen(string);
      gtk_entry_set_text(GTK_ENTRY(w_current->seentry), string);
      gtk_entry_select_region(GTK_ENTRY(w_current->seentry),
			      strlen("slot="), len);
    }
    gtk_grab_add(w_current->sewindow);
  }
}


#line 92 "../noweb/x_dialog.nw"
/***************** End of Slot Edit dialog box ***********************/

/***************** Start of help/about dialog box ********************/
#line 2884 "../noweb/x_dialog.nw"
int
about_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
		      TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    about_dialog_close(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 2904 "../noweb/x_dialog.nw"
void about_dialog_close(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_widget_destroy(w_current->abwindow);
  w_current->abwindow = NULL;
}


#line 2921 "../noweb/x_dialog.nw"
void about_dialog(TOPLEVEL * w_current)
{
  GtkWidget *label = NULL;
  GtkWidget *buttonclose = NULL;
  GtkWidget *vbox, *action_area;
  char *string;

  if (!w_current->abwindow) {
    w_current->abwindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->abwindow),
			GTK_WIN_POS_MOUSE);

    gtk_window_set_title(GTK_WINDOW(w_current->abwindow), _("About..."));
    gtk_container_border_width(GTK_CONTAINER(w_current->abwindow), 5);

    gtk_signal_connect(GTK_OBJECT(w_current->abwindow),
		       "destroy", GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->abwindow);

    gtk_signal_connect(GTK_OBJECT(w_current->abwindow),
		       "key_press_event",
		       (GtkSignalFunc) about_dialog_keypress, w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->abwindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->abwindow);
#endif

    string = g_strdup_printf(_("gEDA : GPL Electronic Design Automation"));
    label = gtk_label_new(string);
    free(string);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);
    gtk_widget_show(label);

    string = g_strdup_printf(_("gschem version %s"), VERSION);
    label = gtk_label_new(string);
    free(string);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);
    gtk_widget_show(label);

    string =
	g_strdup_printf(_
			("Written by:\nAles V. Hvezda\nahvezda@geda.seul.org\nAnd many others (See AUTHORS file)"));
    label = gtk_label_new(string);
    free(string);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);
    gtk_widget_show(label);

    buttonclose = gtk_button_new_with_label(_("Close"));
    GTK_WIDGET_SET_FLAGS(buttonclose, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonclose, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonclose), "clicked",
		       GTK_SIGNAL_FUNC(about_dialog_close), w_current);
    gtk_widget_show(buttonclose);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->abwindow)) {
    gtk_widget_show(w_current->abwindow);
  }
}


#line 98 "../noweb/x_dialog.nw"
/***************** End of help/about dialog box *********************/

/***************** Start of coord dialog box ************************/
#line 3006 "../noweb/x_dialog.nw"
int
coord_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
		      TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    coord_dialog_close(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 3026 "../noweb/x_dialog.nw"
void coord_dialog_close(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_widget_destroy(w_current->cowindow);
  w_current->cowindow = NULL;
}


#line 3043 "../noweb/x_dialog.nw"
void coord_display_update(TOPLEVEL * w_current, int x, int y)
{
  char *string;
  int world_x, world_y;

  string = g_strdup_printf("(%d, %d)", x, y);
  gtk_label_set_text(GTK_LABEL(w_current->coord_screen), string);
  free(string);

  SCREENtoWORLD(w_current, x, y, &world_x, &world_y);

  string = g_strdup_printf("(%d, %d)", world_x, world_y);
  gtk_label_set_text(GTK_LABEL(w_current->coord_world), string);
  free(string);
}


#line 3070 "../noweb/x_dialog.nw"
void coord_dialog(TOPLEVEL * w_current, int x, int y)
{
  GtkWidget *buttonclose = NULL;
  GtkWidget *frame;
  GtkWidget *vbox2;

  if (!w_current->cowindow) {
    w_current->cowindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_position(GTK_WINDOW(w_current->cowindow),
			GTK_WIN_POS_MOUSE);

    gtk_window_set_title(GTK_WINDOW(w_current->cowindow), _("Coords"));
    gtk_container_border_width(GTK_CONTAINER(w_current->cowindow), 5);

    gtk_signal_connect(GTK_OBJECT(w_current->cowindow),
		       "destroy", GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->cowindow);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->cowindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->cowindow);
#endif

    gtk_signal_connect(GTK_OBJECT(w_current->cowindow),
		       "key_press_event",
		       (GtkSignalFunc) coord_dialog_keypress, w_current);


    vbox2 = gtk_vbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(w_current->cowindow), vbox2);
    gtk_widget_show(vbox2);

    frame = gtk_frame_new(_("Screen"));
    w_current->coord_screen = gtk_label_new("(########, ########)");
    gtk_label_set_justify(GTK_LABEL(w_current->coord_screen),
			  GTK_JUSTIFY_LEFT);
    gtk_misc_set_padding(GTK_MISC(w_current->coord_screen), 10, 10);
    gtk_container_add(GTK_CONTAINER(frame), w_current->coord_screen);
    gtk_box_pack_start(GTK_BOX(vbox2), frame, FALSE, FALSE, 0);
    gtk_widget_show(w_current->coord_screen);
    gtk_widget_show(frame);

    frame = gtk_frame_new(_("World"));
    w_current->coord_world = gtk_label_new("(########, ########)");
    gtk_misc_set_padding(GTK_MISC(w_current->coord_world), 10, 10);
    gtk_label_set_justify(GTK_LABEL(w_current->coord_world),
			  GTK_JUSTIFY_LEFT);
    gtk_container_add(GTK_CONTAINER(frame), w_current->coord_world);
    gtk_box_pack_start(GTK_BOX(vbox2), frame, FALSE, FALSE, 0);
    gtk_widget_show(w_current->coord_world);
    gtk_widget_show(frame);

    buttonclose = gtk_button_new_with_label(_("Close"));
    GTK_WIDGET_SET_FLAGS(buttonclose, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(vbox2), buttonclose, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonclose), "clicked",
		       GTK_SIGNAL_FUNC(coord_dialog_close), w_current);
    gtk_widget_show(buttonclose);
    gtk_widget_grab_default(buttonclose);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->cowindow)) {
    gtk_widget_show(w_current->cowindow);
    coord_display_update(w_current, x, y);
  } else {
    gdk_window_raise(w_current->cowindow->window);
  }
}


#line 105 "../noweb/x_dialog.nw"
/***************** End of coord dialog box **************************/

/***************** Start of color edit dialog box *******************/
#line 3162 "../noweb/x_dialog.nw"
gint color_set(GtkWidget * w, gpointer data)
{
  int index;

  index = (int) data;

  /* hate to use this here... but I have to... */
  global_window_current->edit_color = index;
  return (0);
}


#line 3184 "../noweb/x_dialog.nw"
/* be sure that the caller frees the returned string */
char *index2functionstring(int index)
{
  char *string;

  switch (index) {
  case (BACKGROUND_COLOR):
    string = u_basic_strdup("background");
    break;
  case (PIN_COLOR):
    string = u_basic_strdup("pin");
    break;
  case (NET_ENDPOINT_COLOR):
    string = u_basic_strdup("net endpoint");
    break;
  case (GRAPHIC_COLOR):
    string = u_basic_strdup("graphic");
    break;
  case (NET_COLOR):
    string = u_basic_strdup("net");
    break;
  case (ATTRIBUTE_COLOR):
    string = u_basic_strdup("attribute");
    break;
  case (LOGIC_BUBBLE_COLOR):
    string = u_basic_strdup("logic bubble");
    break;
  case (GRID_COLOR):
    string = u_basic_strdup("grid point");
    break;
  case (DETACHED_ATTRIBUTE_COLOR):
    string = u_basic_strdup("detached attribute");
    break;
  case (TEXT_COLOR):
    string = u_basic_strdup("text");
    break;
  case (BUS_COLOR):
    string = u_basic_strdup("bus");
    break;
  case (SELECT_COLOR):
    string = u_basic_strdup("select");
    break;
  case (BOUNDINGBOX_COLOR):
    string = u_basic_strdup("bounding box");
    break;
  case (ZOOM_BOX_COLOR):
    string = u_basic_strdup("zoom box");
    break;
  case (STROKE_COLOR):
    string = u_basic_strdup("stroke");
    break;
  case (LOCK_COLOR):
    string = u_basic_strdup("lock");
    break;
  case (OUTPUT_BACKGROUND_COLOR):
    string = u_basic_strdup("output background");
    break;
  default:
    string = u_basic_strdup("unknown");
    break;
  }
  return (string);
}


#line 3259 "../noweb/x_dialog.nw"
/* this is from gtktest.c */
static GtkWidget *create_color_menu(TOPLEVEL * w_current)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GSList *group;
  int index = 0;
  char buf[30];			/* should be be big enough hack */
  char *menu_string;
  char *temp = NULL;
  int found = 0;
  int set_first = 0;

  menu = gtk_menu_new();
  group = NULL;

  found = x_color_get_name(index, buf);
  while (found != FALSE) {

    if (found == TRUE) {

      /* set the default to the first entry */
      if (!set_first) {
	global_window_current->edit_color = index;
	set_first = 1;
      }

      temp = index2functionstring(index);
      menu_string = g_strdup_printf("%d | %s | %s", index, temp, buf);
      free(temp);

      menuitem = gtk_radio_menu_item_new_with_label(group, menu_string);
      free(menu_string);
      group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));

      gtk_menu_append(GTK_MENU(menu), menuitem);

      gtk_signal_connect(GTK_OBJECT(menuitem),
			 "activate",
			 (GtkSignalFunc) color_set, (int *) index);

      /* I have no idea if doing the above cast is valid, */
      /* since index isn't a pointer, it's just being */
      /* treated as one, it's then cast to an int in */
      /* color_set */

      gtk_widget_show(menuitem);
    }

    index++;
    found = x_color_get_name(index, buf);
  }


  return menu;
}


#line 3332 "../noweb/x_dialog.nw"
int
color_edit_dialog_keypress(GtkWidget * widget, GdkEventKey * event,
			   TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    color_edit_dialog_close(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 3352 "../noweb/x_dialog.nw"
void color_edit_dialog_close(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_widget_destroy(w_current->clwindow);
  w_current->clwindow = NULL;
}


#line 3369 "../noweb/x_dialog.nw"
void color_edit_dialog_apply(GtkWidget * w, TOPLEVEL * w_current)
{
  SELECTION *s_current = NULL;
  OBJECT *object = NULL;

  /* skip over head */
  s_current = w_current->page_current->selection2_head->next;

  while (s_current != NULL) {

    object = s_current->selected_object;
    if (object == NULL) {
      fprintf(stderr,
	      _("ERROR: NULL object in color_edit_dialog_apply!\n"));
      exit(-1);
    }

    switch (object->type) {
    case (OBJ_LINE):
    case (OBJ_BOX):
    case (OBJ_CIRCLE):
    case (OBJ_NET):
    case (OBJ_BUS):
    case (OBJ_PIN):
    case (OBJ_ARC):
      object->saved_color = w_current->edit_color;
      w_current->page_current->CHANGED = 1;
      break;

    case (OBJ_TEXT):
      object->saved_color = w_current->edit_color;
      o_complex_set_saved_color_only(object->text->prim_objs,
				     w_current->edit_color);
      w_current->page_current->CHANGED = 1;
      break;
    }

    s_current = s_current->next;
  }
  o_undo_savestate(w_current, UNDO_ALL);
}


#line 3422 "../noweb/x_dialog.nw"
void color_edit_dialog(TOPLEVEL * w_current)
{
  GtkWidget *buttonclose = NULL;
  GtkWidget *buttonapply = NULL;
  GtkWidget *optionmenu;
  GtkWidget *vbox, *action_area;

  if (!w_current->clwindow) {
    w_current->clwindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->clwindow),
			GTK_WIN_POS_MOUSE);

    gtk_window_set_title(GTK_WINDOW(w_current->clwindow), _("Color Edit"));
    gtk_container_border_width(GTK_CONTAINER(w_current->clwindow), 5);

    gtk_signal_connect(GTK_OBJECT(w_current->clwindow),
		       "destroy", GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->clwindow);

    gtk_signal_connect(GTK_OBJECT(w_current->clwindow),
		       "key_press_event",
		       (GtkSignalFunc) color_edit_dialog_keypress,
		       w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->clwindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->clwindow);
#endif

    optionmenu = gtk_option_menu_new();
    gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu),
			     create_color_menu(w_current));
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu), 0);
    gtk_box_pack_start(GTK_BOX(vbox), optionmenu, TRUE, TRUE, 0);
    gtk_widget_show(optionmenu);

    buttonapply = gtk_button_new_with_label(_("Apply"));
    GTK_WIDGET_SET_FLAGS(buttonapply, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonapply, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonapply), "clicked",
		       GTK_SIGNAL_FUNC(color_edit_dialog_apply),
		       w_current);
    gtk_widget_show(buttonapply);
    gtk_widget_grab_default(buttonapply);

    buttonclose = gtk_button_new_with_label(_("Close"));
    gtk_box_pack_start(GTK_BOX(action_area), buttonclose, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonclose), "clicked",
		       GTK_SIGNAL_FUNC(color_edit_dialog_close),
		       w_current);
    gtk_widget_show(buttonclose);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->clwindow)) {
    gtk_widget_show(w_current->clwindow);
  } else {
    gdk_window_raise(w_current->clwindow->window);
  }
}


#line 115 "../noweb/x_dialog.nw"
/***************** End of color edit dialog box *********************/

/***************** Start of help/keymapping dialog box **************/
#line 3499 "../noweb/x_dialog.nw"
/* limit this to 128 hotkeys */
static char *hotkey_strings[128];
static int hotkey_counter = 0;

#line 3512 "../noweb/x_dialog.nw"
int
x_dialog_hotkeys_keypress(GtkWidget * widget, GdkEventKey * event,
			  TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    x_dialog_hotkeys_close(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 3532 "../noweb/x_dialog.nw"
void x_dialog_hotkeys_close(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_widget_destroy(w_current->hkwindow);
  w_current->hkwindow = NULL;
}

#line 3548 "../noweb/x_dialog.nw"
void x_dialog_hotkeys_free_all(void)
{
  int i;

  for (i = 0; i < hotkey_counter; i++) {
    if (hotkey_strings[i]) {
      free(hotkey_strings[i]);
    }
  }
}


#line 3570 "../noweb/x_dialog.nw"
void x_dialog_hotkeys_fill(char *string)
{

  if (hotkey_counter > 127) {
    printf(_("Ran out of space in the hotkey buffer...\n"));
    return;
  }

  hotkey_strings[hotkey_counter] =
      (char *) malloc(sizeof(char) * (strlen(string) + 1));
  ;
  strcpy(hotkey_strings[hotkey_counter], string);
  hotkey_counter++;
}


#line 3596 "../noweb/x_dialog.nw"
void x_dialog_hotkeys(TOPLEVEL * w_current)
{
  GtkWidget *buttonclose = NULL;
  GtkWidget *vbox, *action_area, *scrolled_win, *list;
  GtkWidget *item;
  int i;

  if (!w_current->hkwindow) {


    w_current->hkwindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->hkwindow),
			GTK_WIN_POS_MOUSE);

    gtk_window_set_title(GTK_WINDOW(w_current->hkwindow), _("Hotkeys..."));
    gtk_container_border_width(GTK_CONTAINER(w_current->hkwindow), 5);

    gtk_widget_set_usize(w_current->hkwindow, 300, 300);

    gtk_signal_connect(GTK_OBJECT(w_current->hkwindow),
		       "destroy", GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->hkwindow);

    gtk_signal_connect(GTK_OBJECT(w_current->hkwindow),
		       "key_press_event",
		       (GtkSignalFunc) x_dialog_hotkeys_keypress,
		       w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->hkwindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->hkwindow);
#endif

    scrolled_win = gtk_scrolled_window_new(NULL, NULL);
    gtk_container_set_border_width(GTK_CONTAINER(scrolled_win), 5);
    gtk_widget_set_usize(scrolled_win, -1, 300);
    gtk_box_pack_start(GTK_BOX(vbox), scrolled_win, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win),
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);
    gtk_widget_show(scrolled_win);

    list = gtk_list_new();
    gtk_list_set_selection_mode(GTK_LIST(list), GTK_SELECTION_SINGLE);
    gtk_scrolled_window_add_with_viewport
	(GTK_SCROLLED_WINDOW(scrolled_win), list);
    gtk_container_set_focus_vadjustment
	(GTK_CONTAINER(list),
	 gtk_scrolled_window_get_vadjustment
	 (GTK_SCROLLED_WINDOW(scrolled_win)));
    gtk_container_set_focus_hadjustment
	(GTK_CONTAINER(list),
	 gtk_scrolled_window_get_hadjustment
	 (GTK_SCROLLED_WINDOW(scrolled_win)));
    gtk_widget_show(list);

    item = gtk_list_item_new_with_label(_("Function : keystroke(s)"));
    gtk_container_add(GTK_CONTAINER(list), item);
    gtk_widget_show(item);

    item = gtk_list_item_new_with_label(" ");
    gtk_container_add(GTK_CONTAINER(list), item);
    gtk_widget_show(item);

    for (i = 0; i < hotkey_counter; i++) {

      if (hotkey_strings[i]) {
	item = gtk_list_item_new_with_label(hotkey_strings[i]);
	gtk_container_add(GTK_CONTAINER(list), item);
	gtk_widget_show(item);
      }
    }

    buttonclose = gtk_button_new_with_label(_("Close"));
    GTK_WIDGET_SET_FLAGS(buttonclose, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonclose, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonclose), "clicked",
		       GTK_SIGNAL_FUNC(x_dialog_hotkeys_close), w_current);
    gtk_widget_show(buttonclose);

  }

  if (!GTK_WIDGET_VISIBLE(w_current->hkwindow)) {
    gtk_widget_show(w_current->hkwindow);
  } else {
    gdk_window_raise(w_current->hkwindow->window);
  }
}


#line 124 "../noweb/x_dialog.nw"
/***************** End of help/keymapping dialog box ****************/

/*********** Start of misc support functions for dialog boxes *******/
#line 3700 "../noweb/x_dialog.nw"
extern GtkWidget *stwindow;

#line 3711 "../noweb/x_dialog.nw"
void x_dialog_raise_all(TOPLEVEL * w_current)
{

#if 0				/* don't raise the log window */
  if (stwindow) {
    gdk_window_raise(stwindow->window);
  }
#endif

  if (w_current->fowindow) {
    gdk_window_raise(w_current->fowindow->window);
  }
  if (w_current->fswindow) {
    gdk_window_raise(w_current->fswindow->window);
  }
  if (w_current->sowindow) {
    gdk_window_raise(w_current->sowindow->window);
  }
  if (w_current->aswindow) {
    gdk_window_raise(w_current->aswindow->window);
  }
  if (w_current->cswindow) {
    gdk_window_raise(w_current->cswindow->window);
  }
#if 0				/* don't raise these windows ever */
  if (w_current->fileselect[FILESELECT].xfwindow) {
    gdk_window_raise(w_current->fileselect[FILESELECT].xfwindow->window);
  }
  if (w_current->fileselect[COMPSELECT].xfwindow) {
    gdk_window_raise(w_current->fileselect[COMPSELECT].xfwindow->window);
  }
#endif

  if (w_current->pwindow) {
    gdk_window_raise(w_current->pwindow->window);
  }
  if (w_current->iwindow) {
    gdk_window_raise(w_current->iwindow->window);
  }
#if 0				/* don't raise the page manager window */
  if (w_current->pswindow) {
    gdk_window_raise(w_current->pswindow->window);
  }
#endif

  if (w_current->tiwindow) {
    gdk_window_raise(w_current->tiwindow->window);
  }
  if (w_current->tewindow) {
    gdk_window_raise(w_current->tewindow->window);
  }
  if (w_current->sewindow) {
    gdk_window_raise(w_current->sewindow->window);
  }
  if (w_current->exwindow) {
    gdk_window_raise(w_current->exwindow->window);
  }
  if (w_current->aawindow) {
    gdk_window_raise(w_current->aawindow->window);
  }
  if (w_current->mawindow) {
    gdk_window_raise(w_current->mawindow->window);
  }
  if (w_current->aewindow) {
    gdk_window_raise(w_current->aewindow->window);
  }
  if (w_current->trwindow) {
    gdk_window_raise(w_current->trwindow->window);
  }
  if (w_current->tswindow) {
    gdk_window_raise(w_current->tswindow->window);
  }
  if (w_current->abwindow) {
    gdk_window_raise(w_current->abwindow->window);
  }
  if (w_current->hkwindow) {
    gdk_window_raise(w_current->hkwindow->window);
  }
  if (w_current->cowindow) {
    gdk_window_raise(w_current->cowindow->window);
  }
  if (w_current->clwindow) {
    gdk_window_raise(w_current->clwindow->window);
  }
  if (w_current->ltwindow) {
    gdk_window_raise(w_current->ltwindow->window);
  }
  if (w_current->ftwindow) {
    gdk_window_raise(w_current->ftwindow->window);
  }

}


#line 129 "../noweb/x_dialog.nw"
/*********** End of misc support functions for dialog boxes *******/

/*********** Start of generic text input dialog box *******/
#line 3817 "../noweb/x_dialog.nw"
char generic_textstring[256] = "refdes=R";

void generic_text_input_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  char *string = NULL;

  string = (char *) gtk_entry_get_text(GTK_ENTRY(w_current->tsentry));
  strncpy(generic_textstring, string, 256);

  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}

#line 3840 "../noweb/x_dialog.nw"
void generic_text_input_dialog(TOPLEVEL * w_current)
{
  int len;
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *vbox, *action_area;

  if (!w_current->tswindow) {
    w_current->tswindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->tswindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);


#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->tswindow),
			 _("Generic String"));
    gtk_container_border_width(GTK_CONTAINER(w_current->tswindow), 10);

    label = gtk_label_new(_("Enter new string."));
    gtk_misc_set_padding(GTK_MISC(label), 20, 20);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->tsentry = gtk_entry_new_with_max_length(20);
    gtk_editable_select_region(GTK_EDITABLE(w_current->tsentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->tsentry, FALSE, FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->tsentry), "activate",
		       GTK_SIGNAL_FUNC(generic_text_input_ok), w_current);
    gtk_widget_show(w_current->tsentry);
    gtk_widget_grab_focus(w_current->tsentry);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(generic_text_input_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);
  }

  if (!GTK_WIDGET_VISIBLE(w_current->tswindow)) {
    len = strlen(generic_textstring);
    gtk_entry_set_text(GTK_ENTRY(w_current->tsentry), generic_textstring);
    gtk_entry_select_region(GTK_ENTRY(w_current->tsentry), 0, len);
    gtk_widget_show(w_current->tswindow);
    gtk_grab_add(w_current->tswindow);
  }
}

#line 134 "../noweb/x_dialog.nw"
/*********** End of generic text input dialog box *******/

/*********** Start of find text dialog box *******/
#line 3910 "../noweb/x_dialog.nw"
int
find_text_keypress(GtkWidget * widget, GdkEventKey * event,
		   TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    find_text_done(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 3930 "../noweb/x_dialog.nw"
GtkWidget *checkdescend = NULL;
int start_find;
OBJECT *remember_page;
void find_text_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  char *string = NULL;
  int done;

  string = (char *) gtk_entry_get_text(GTK_ENTRY(w_current->tsentry));

  /* descend = gtk_object_get_data(GTK_OBJECT(w_current->tsentry),"descend"); */

  strncpy(generic_textstring, string, 256);

  while (remember_page != w_current->page_current->object_head) {
    s_hierarchy_up(w_current, w_current->page_current->up);
  }
  done =
      o_edit_find_text(w_current, remember_page, string,
		       gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
						    (checkdescend)),
		       !start_find);
  if (done) {
    o_redraw_all_fast(w_current);
    gtk_grab_remove(w_current->tswindow);
    gtk_widget_destroy(w_current->tswindow);
    w_current->tswindow = NULL;
  }
  start_find = 0;

}

#line 3971 "../noweb/x_dialog.nw"
void find_text_done(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}

#line 3986 "../noweb/x_dialog.nw"
void find_text_dialog(TOPLEVEL * w_current)
{
  int len;
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *buttondone = NULL;
  GtkWidget *vbox, *action_area;
  OBJECT *object = NULL;

  start_find = 1;
  remember_page = w_current->page_current->object_head;
  if ((object = o_select_return_first_object(w_current)) != NULL) {
    if (object->type == OBJ_TEXT) {
      strncpy(generic_textstring, object->text->string, 256);
    }
  }



  if (!w_current->tswindow) {
    w_current->tswindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->tswindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "key_press_event",
		       (GtkSignalFunc) find_text_keypress, w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->tswindow), _("Find text"));
    gtk_container_border_width(GTK_CONTAINER(w_current->tswindow), 10);

    label = gtk_label_new(_("Text to find:"));
    gtk_misc_set_padding(GTK_MISC(label), 20, 20);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->tsentry = gtk_entry_new_with_max_length(20);
    gtk_editable_select_region(GTK_EDITABLE(w_current->tsentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->tsentry, FALSE, FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->tsentry), "activate",
		       GTK_SIGNAL_FUNC(find_text_ok), w_current);
    gtk_widget_show(w_current->tsentry);
    gtk_widget_grab_focus(w_current->tsentry);

    buttonok = gtk_button_new_with_label(_("Find"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(find_text_ok), w_current);

    buttondone = gtk_button_new_with_label(_("Done"));
    GTK_WIDGET_SET_FLAGS(buttondone, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttondone, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttondone), "clicked",
		       GTK_SIGNAL_FUNC(find_text_done), w_current);


    checkdescend =
	gtk_check_button_new_with_label(_("descend into hierarchy"));
    /*          gtk_object_set_data (GTK_OBJECT (w_current->tswindow), "descend", w_current->preview_checkbox); */

    gtk_box_pack_start(GTK_BOX(action_area), checkdescend, TRUE, TRUE, 0);

    gtk_widget_show(buttonok);
    gtk_widget_show(buttondone);
    gtk_widget_show(checkdescend);
    gtk_widget_grab_default(buttonok);
  }

  if (!GTK_WIDGET_VISIBLE(w_current->tswindow)) {
    len = strlen(generic_textstring);
    gtk_entry_set_text(GTK_ENTRY(w_current->tsentry), generic_textstring);
    gtk_entry_select_region(GTK_ENTRY(w_current->tsentry), 0, len);
    gtk_widget_show(w_current->tswindow);
    gtk_grab_add(w_current->tswindow);
  }
}

#line 141 "../noweb/x_dialog.nw"
/*********** End of find text dialog box *******/

/*********** Start of hide text dialog box *******/
#line 4086 "../noweb/x_dialog.nw"
int
hide_text_keypress(GtkWidget * widget, GdkEventKey * event,
		   TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    hide_text_done(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 4106 "../noweb/x_dialog.nw"
void hide_text_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  char *string = NULL;

  string = (char *) gtk_entry_get_text(GTK_ENTRY(w_current->tsentry));
  strncpy(generic_textstring, string, 256);

  o_edit_hide_specific_text(w_current,
			    w_current->page_current->object_head, string);

  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}

#line 4125 "../noweb/x_dialog.nw"
void hide_text_done(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}

#line 4140 "../noweb/x_dialog.nw"
void hide_text_dialog(TOPLEVEL * w_current)
{
  int len;
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *vbox, *action_area;

  if (!w_current->tswindow) {
    w_current->tswindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->tswindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "key_press_event",
		       (GtkSignalFunc) hide_text_keypress, w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->tswindow), _("Hide text"));
    gtk_container_border_width(GTK_CONTAINER(w_current->tswindow), 10);

    label = gtk_label_new(_("Hide text starting with:"));
    gtk_misc_set_padding(GTK_MISC(label), 20, 20);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->tsentry = gtk_entry_new_with_max_length(20);
    gtk_editable_select_region(GTK_EDITABLE(w_current->tsentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->tsentry, FALSE, FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->tsentry), "activate",
		       GTK_SIGNAL_FUNC(hide_text_ok), w_current);
    gtk_widget_show(w_current->tsentry);
    gtk_widget_grab_focus(w_current->tsentry);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(hide_text_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);
  }

  if (!GTK_WIDGET_VISIBLE(w_current->tswindow)) {
    len = strlen(generic_textstring);
    gtk_entry_set_text(GTK_ENTRY(w_current->tsentry), generic_textstring);
    gtk_entry_select_region(GTK_ENTRY(w_current->tsentry), 0, len);
    gtk_widget_show(w_current->tswindow);
    gtk_grab_add(w_current->tswindow);
  }
}

#line 148 "../noweb/x_dialog.nw"
/*********** End of hide text dialog box *******/

/*********** Start of show text dialog box *******/
#line 4219 "../noweb/x_dialog.nw"
int
show_text_keypress(GtkWidget * widget, GdkEventKey * event,
		   TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    show_text_done(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 4234 "../noweb/x_dialog.nw"
void show_text_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  char *string = NULL;

  string = (char *) gtk_entry_get_text(GTK_ENTRY(w_current->tsentry));
  strncpy(generic_textstring, string, 256);

  o_edit_show_specific_text(w_current,
			    w_current->page_current->object_head, string);

  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}

#line 4252 "../noweb/x_dialog.nw"
void show_text_done(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}

#line 4267 "../noweb/x_dialog.nw"
void show_text_dialog(TOPLEVEL * w_current)
{
  int len;
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *vbox, *action_area;

  if (!w_current->tswindow) {
    w_current->tswindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->tswindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "key_press_event",
		       (GtkSignalFunc) show_text_keypress, w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->tswindow), _("Show text"));
    gtk_container_border_width(GTK_CONTAINER(w_current->tswindow), 10);

    label = gtk_label_new(_("Show text starting with:"));
    gtk_misc_set_padding(GTK_MISC(label), 20, 20);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->tsentry = gtk_entry_new_with_max_length(20);
    gtk_editable_select_region(GTK_EDITABLE(w_current->tsentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->tsentry, FALSE, FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->tsentry), "activate",
		       GTK_SIGNAL_FUNC(show_text_ok), w_current);
    gtk_widget_show(w_current->tsentry);
    gtk_widget_grab_focus(w_current->tsentry);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(show_text_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);
  }

  if (!GTK_WIDGET_VISIBLE(w_current->tswindow)) {
    len = strlen(generic_textstring);
    gtk_entry_set_text(GTK_ENTRY(w_current->tsentry), generic_textstring);
    gtk_entry_select_region(GTK_ENTRY(w_current->tsentry), 0, len);
    gtk_widget_show(w_current->tswindow);
    gtk_grab_add(w_current->tswindow);
  }
}

#line 155 "../noweb/x_dialog.nw"
/*********** End of show text dialog box *******/

/*********** Start of autonumber text dialog box *******/
#line 4338 "../noweb/x_dialog.nw"
int
autonumber_text_keypress(GtkWidget * widget, GdkEventKey * event,
			 TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    autonumber_text_done(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 4357 "../noweb/x_dialog.nw"
void autonumber_text_ok(GtkWidget * w, TOPLEVEL * w_current)
{
  char *string = NULL;

  string = (char *) gtk_entry_get_text(GTK_ENTRY(w_current->tsentry));
  strncpy(generic_textstring, string, 256);

  o_edit_autonumber_text(w_current, w_current->page_current->object_head,
			 string);

  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}

#line 4375 "../noweb/x_dialog.nw"
void autonumber_text_done(GtkWidget * w, TOPLEVEL * w_current)
{
  gtk_grab_remove(w_current->tswindow);
  gtk_widget_destroy(w_current->tswindow);
  w_current->tswindow = NULL;
}

#line 4390 "../noweb/x_dialog.nw"
void autonumber_text_dialog(TOPLEVEL * w_current)
{
  int len;
  GtkWidget *label = NULL;
  GtkWidget *buttonok = NULL;
  GtkWidget *vbox, *action_area;

  if (!w_current->tswindow) {
    w_current->tswindow = x_create_dialog_box(&vbox, &action_area);

    gtk_window_position(GTK_WINDOW(w_current->tswindow),
			GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "destroy",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);

    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "key_press_event",
		       (GtkSignalFunc) autonumber_text_keypress,
		       w_current);

#if 0				/* removed because it was causing the dialog box to not close */
    gtk_signal_connect(GTK_OBJECT(w_current->tswindow),
		       "delete_event",
		       GTK_SIGNAL_FUNC(destroy_window),
		       &w_current->tswindow);
#endif

    gtk_window_set_title(GTK_WINDOW(w_current->tswindow),
			 _("Autonumber text"));
    gtk_container_border_width(GTK_CONTAINER(w_current->tswindow), 10);

    label = gtk_label_new(_("Autonumber text starting with:"));
    gtk_misc_set_padding(GTK_MISC(label), 20, 20);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
    gtk_widget_show(label);

    w_current->tsentry = gtk_entry_new_with_max_length(20);
    gtk_editable_select_region(GTK_EDITABLE(w_current->tsentry), 0, -1);
    gtk_box_pack_start(GTK_BOX(vbox), w_current->tsentry, FALSE, FALSE, 5);
    gtk_signal_connect(GTK_OBJECT(w_current->tsentry), "activate",
		       GTK_SIGNAL_FUNC(autonumber_text_ok), w_current);
    gtk_widget_show(w_current->tsentry);
    gtk_widget_grab_focus(w_current->tsentry);

    buttonok = gtk_button_new_with_label(_("OK"));
    GTK_WIDGET_SET_FLAGS(buttonok, GTK_CAN_DEFAULT);
    gtk_box_pack_start(GTK_BOX(action_area), buttonok, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(buttonok), "clicked",
		       GTK_SIGNAL_FUNC(autonumber_text_ok), w_current);
    gtk_widget_show(buttonok);
    gtk_widget_grab_default(buttonok);
  }

  if (!GTK_WIDGET_VISIBLE(w_current->tswindow)) {
    len = strlen(generic_textstring);
    gtk_entry_set_text(GTK_ENTRY(w_current->tsentry), generic_textstring);
    gtk_entry_select_region(GTK_ENTRY(w_current->tsentry), 0, len);
    gtk_widget_show(w_current->tswindow);
    gtk_grab_add(w_current->tswindow);
  }
}

#line 162 "../noweb/x_dialog.nw"
/*********** End of autonumber text dialog box *******/

/*********** Start of some Gtk utils  *******/
#line 220 "../noweb/x_dialog.nw"
#if HAS_GTK22
void select_all_text_in_textview(GtkTextView * textview)
{
  GtkTextBuffer *textbuffer;
  GtkTextIter start, end;
  GtkTextMark *mark;

  textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
  gtk_text_buffer_get_bounds(textbuffer, &start, &end);
  gtk_text_buffer_place_cursor(textbuffer, &start);
  mark = gtk_text_buffer_get_selection_bound(textbuffer);
  gtk_text_buffer_move_mark(textbuffer, mark, &end);
}
#endif

#line 245 "../noweb/x_dialog.nw"
#if HAS_GTK22
int
text_view_calculate_real_tab_width(GtkTextView * textview, int tab_size)
{
  PangoLayout *layout;
  gchar *tab_string;
  gint counter = 0;
  gint tab_width = 0;

  if (tab_size == 0)
    return -1;

  tab_string = g_malloc(tab_size + 1);

  while (counter < tab_size) {
    tab_string[counter] = ' ';
    counter++;
  }

  tab_string[tab_size] = 0;

  layout = gtk_widget_create_pango_layout(GTK_WIDGET(textview),
					  tab_string);
  g_free(tab_string);

  if (layout != NULL) {
    pango_layout_get_pixel_size(layout, &tab_width, NULL);
    g_object_unref(G_OBJECT(layout));
  } else
    tab_width = -1;

  return tab_width;

}
#endif

#line 167 "../noweb/x_dialog.nw"
/*********** End of some Gtk utils *******/
