#line 33 "../noweb/x_multiattrib.nw"
/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/x_multiattrib.nw"
/* DO NOT read or edit this file ! Use ../noweb/x_multiattrib.nw instead */

#line 56 "../noweb/x_multiattrib.nw"
#include <config.h>

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/i_vars.h"
#include "../include/globals.h"
#include "../include/prototype.h"

#define NUM_COLUMNS 4

#line 15 "../noweb/x_multiattrib.nw"
/***************** Start of Multiple Attrib Edit dialog box ***********/
#line 81 "../noweb/x_multiattrib.nw"
int
multi_attrib_edit_keypress(GtkWidget * widget, GdkEventKey * event,
			   TOPLEVEL * w_current)
{
  if (strcmp(gdk_keyval_name(event->keyval), "Escape") == 0) {
    multi_attrib_edit_close(NULL, w_current);
    return TRUE;
  }

  return FALSE;
}

#line 101 "../noweb/x_multiattrib.nw"
char *multi_attrib_edit_parser(GtkWidget * w, char **text, int *vis,
			       int *show)
{
  GtkWidget *window;
  GtkWidget *name;
  GtkWidget *value;
  GtkWidget *visbutton;
  GtkWidget *show_options;
  int option_index;
  char *newtext;
#ifdef HAS_GTK22
  GtkTextBuffer *textbuffer;
  GtkTextIter start, end;
#endif

  text[2] = malloc(sizeof(char) * 8);	/* this needs to be freed somewhere? */
  text[3] = malloc(sizeof(char) * 8);	/* this needs to be freed somewhere? */

  window = gtk_object_get_data(GTK_OBJECT(w), "mawindow");
  name = gtk_object_get_data(GTK_OBJECT(window), "attrib_combo_entry");
  value = gtk_object_get_data(GTK_OBJECT(window), "value_entry");
  show_options = gtk_object_get_data(GTK_OBJECT(window), "show_options");
  visbutton = gtk_object_get_data(GTK_OBJECT(window), "visbutton");

  text[0] = (char *) gtk_entry_get_text(GTK_ENTRY(name));

#ifdef HAS_GTK22
  textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(value));
  gtk_text_buffer_get_bounds(textbuffer, &start, &end);
  text[1] = gtk_text_iter_get_text(&start, &end);
#else
  text[1] = (char *) gtk_entry_get_text(GTK_ENTRY(value));
#endif

  newtext = u_basic_strdup_multiple(text[0], "=", text[1], NULL);

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(visbutton))) {
    *vis = VISIBLE;
    strcpy(text[2], _("Yes"));
  } else {
    *vis = INVISIBLE;
    strcpy(text[2], _("No"));
  }

  option_index = option_menu_get_history(GTK_OPTION_MENU(show_options));
  switch (option_index) {
  case (0):
    *show = SHOW_VALUE;
    strcpy(text[3], _("V"));
    break;

  case (1):
    *show = SHOW_NAME;
    strcpy(text[3], _("N"));
    break;

  case (2):
    *show = SHOW_NAME_VALUE;
    strcpy(text[3], _("NV"));
    break;

  default:
    fprintf(stderr,
	    _("Got invalid show option; defaulting to show both\n"));
    *show = SHOW_NAME_VALUE;
    break;
  }

  return newtext;
}

#line 180 "../noweb/x_multiattrib.nw"
void multi_attrib_edit_set_values(GtkWindow * window, OBJECT * attrib)
{
  GtkWidget *name_entry;
  GtkWidget *value_entry;
  GtkWidget *visbutton;
  GtkWidget *show_options;

  char *name = NULL;
  char *value = NULL;
  int len;

#ifdef HAS_GTK22
  GtkTextBuffer *textbuffer;
#endif

  name_entry =
      gtk_object_get_data(GTK_OBJECT(window), "attrib_combo_entry");
  value_entry = gtk_object_get_data(GTK_OBJECT(window), "value_entry");
  show_options = gtk_object_get_data(GTK_OBJECT(window), "show_options");
  visbutton = gtk_object_get_data(GTK_OBJECT(window), "visbutton");

  if (!attrib) {
    gtk_entry_set_text(GTK_ENTRY(name_entry), "");
#ifdef HAS_GTK22
    textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(value_entry));
    gtk_text_buffer_set_text(GTK_TEXT_BUFFER(textbuffer), "", -1);
#else
    gtk_entry_set_text(GTK_ENTRY(value_entry), "");
#endif
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(visbutton), TRUE);
    gtk_option_menu_set_history(GTK_OPTION_MENU(show_options), 0);
  } else {
    if (attrib->visibility == VISIBLE)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(visbutton), TRUE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(visbutton), FALSE);

    if (attrib->show_name_value == SHOW_VALUE) {
      gtk_option_menu_set_history(GTK_OPTION_MENU(show_options), 0);
    } else if (attrib->show_name_value == SHOW_NAME) {
      gtk_option_menu_set_history(GTK_OPTION_MENU(show_options), 1);
    } else {
      gtk_option_menu_set_history(GTK_OPTION_MENU(show_options), 2);
    }

    o_attrib_get_name_value(attrib->text->string, &name, &value);
    if (name) {
      gtk_entry_set_text(GTK_ENTRY(name_entry), name);
    }

    if (value) {
#ifdef HAS_GTK22
      textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(value_entry));
      gtk_text_buffer_set_text(GTK_TEXT_BUFFER(textbuffer), value, -1);
#else
      gtk_entry_set_text(GTK_ENTRY(value_entry), value);
#endif

      gtk_widget_grab_focus(value_entry);
      len = strlen(value);
      if (len) {
#ifdef HAS_GTK22
	select_all_text_in_textview(GTK_TEXT_VIEW(value_entry));
#else
	gtk_entry_select_region(GTK_ENTRY(value_entry), 0, len);
#endif
      }
    }
    if (name)
      free(name);
    if (value)
      free(value);
  }
}


#line 402 "../noweb/x_multiattrib.nw"
void multi_attrib_edit_clear(GtkWidget * w, GtkWindow * window)
{
  multi_attrib_edit_set_values(window, NULL);
}


#line 266 "../noweb/x_multiattrib.nw"
void multi_attrib_parse_attribute(GtkWidget * w, GtkWidget * w_current)
{
  GtkWidget *top_window;
  GtkWidget *combo_entry;
  GtkWidget *add_button;
  GtkWidget *change_button;
  GtkWidget *value_entry;
  GtkWidget *clist;
  char *attrib_name;
  char *value;
  int row, attrib_def_row;
  char attrib_defined;
  char *row_attrib_name;
  GSList *special_attrib_list = NULL;
  int special_attrib_found;
  GSList *tmp;

#ifdef HAS_GTK22
  GtkTextBuffer *textbuffer;
  GtkTextIter start, end;
#endif

#ifdef HAS_GTK22
  top_window =
      gtk_widget_get_ancestor(GTK_WIDGET(w_current), GTK_TYPE_WINDOW);
#else
  top_window = gtk_widget_get_ancestor(w, GTK_TYPE_WINDOW);
#endif


  /* Get combo with attribute name */
  combo_entry =
      gtk_object_get_data(GTK_OBJECT(top_window), "attrib_combo_entry");

  attrib_name = (char *) gtk_entry_get_text(GTK_ENTRY(combo_entry));

  /* Get entry with value of the attribute */
  value_entry = gtk_object_get_data(GTK_OBJECT(top_window), "value_entry");
#ifdef HAS_GTK22
  textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(value_entry));
  gtk_text_buffer_get_bounds(textbuffer, &start, &end);
  value = gtk_text_iter_get_text(&start, &end);
#else
  value = gtk_entry_get_text(GTK_ENTRY(value_entry));
#endif

  /* Get clist with the attribute list */
  clist = gtk_object_get_data(GTK_OBJECT(top_window), "clist");

  /* Check if the attribute is already defined */
  attrib_defined = FALSE;
  attrib_def_row = -1;
  row = 0;
  while (gtk_clist_get_text(GTK_CLIST(clist), row, 0, &row_attrib_name) ==
	 1) {
    if (strcmp(row_attrib_name, attrib_name) == 0) {
      attrib_defined = TRUE;
      attrib_def_row = row;
    }
    row++;
  }

  /* Create a list with the attributes which can be attached multiple times */
  special_attrib_list = g_slist_append(special_attrib_list, "comment");
  special_attrib_list = g_slist_append(special_attrib_list, "source");
  special_attrib_list = g_slist_append(special_attrib_list, "net");

  add_button = gtk_object_get_data(GTK_OBJECT(top_window), "addbutton");
  change_button =
      gtk_object_get_data(GTK_OBJECT(top_window), "changebutton");


  /* Search the attrib_name in the special list.  */
  special_attrib_found = FALSE;
  tmp = special_attrib_list;
  while (tmp != NULL) {
    if (strcmp(attrib_name, tmp->data) == 0)
      special_attrib_found = TRUE;
    tmp = g_slist_next(tmp);
  }


  /* Select the attribute's row if it's not selected and it can be attached 
     only once. */
  if ((attrib_defined == TRUE) && (!special_attrib_found)) {

    /* Get the selected row */
    GList *list;
    gint row = -1;
    for (list = GTK_CLIST(clist)->selection; list; list = list->next) {
      row = GPOINTER_TO_INT(list->data);
    }
    /* Select the attribute's row if it's not selected */
    if (row != attrib_def_row) {
      gtk_clist_select_row(GTK_CLIST(clist), attrib_def_row, -1);
    }
  }

  /* Unselect all if the attribute is not defined */
  if (!attrib_defined) {
    gtk_clist_unselect_all(GTK_CLIST(clist));
  }

  /* Enable/Disable Add and Change buttons */
  if ((strlen(attrib_name) == 0) || (strlen(value) == 0)) {
    /* Disable buttons when there is no name or value */
    gtk_widget_set_sensitive(add_button, FALSE);
    gtk_widget_set_sensitive(change_button, FALSE);
  } else {
    if (!attrib_defined) {
      /* If the attribute is not defined, then only Add button is enabled. */
      gtk_widget_set_sensitive(add_button, TRUE);
      gtk_widget_set_sensitive(change_button, FALSE);
    } else {
      /* If it's defined, then the Change button is enabled. */
      gtk_widget_set_sensitive(change_button, TRUE);

      /* If it's in the list, then the Add button should be enabled.  */
      if (!special_attrib_found) {
	gtk_widget_set_sensitive(add_button, FALSE);
      } else
	gtk_widget_set_sensitive(add_button, TRUE);
    }
  }
  g_slist_free(special_attrib_list);
}

#line 418 "../noweb/x_multiattrib.nw"
void
multi_attrib_edit_select_row(GtkCList * clist, gint row, gint col,
			     GdkEventButton * event, TOPLEVEL * w_current)
{
  GtkWidget *window;
  OBJECT *attrib;

  window = w_current->mawindow;
  clist = gtk_object_get_data(GTK_OBJECT(window), "clist");

  gtk_object_set_data(GTK_OBJECT(clist), "selected", (gpointer) row);
  attrib = gtk_clist_get_row_data(clist, row);
  multi_attrib_edit_set_values(GTK_WINDOW(window), attrib);
}


#line 443 "../noweb/x_multiattrib.nw"
void multi_attrib_edit_add(GtkWidget * w, TOPLEVEL * w_current)
{
  int vis, show;
  char *newtext;
  gint row;
  OBJECT *attrib;
  OBJECT *object;
  char **text;
  GtkWidget *clist;
  char *tmpstr;

  clist = gtk_object_get_data(GTK_OBJECT(w_current->mawindow), "clist");

  text = malloc(NUM_COLUMNS * sizeof(char *));

  newtext = multi_attrib_edit_parser(w, text, &vis, &show);

  if (text[0][0] == '\0' || text[0][0] == ' ')
    return;

  row = gtk_clist_append(GTK_CLIST(clist), text);

  object = o_select_return_first_object(w_current);
  attrib = o_attrib_add_attrib(w_current, newtext, vis, show, object);

  /* handle slot= attribute, it's a special case */
  if ((!strcmp(text[0], "slot")) & (strlen(text[1]) < 3)) {
    tmpstr = g_strdup_printf("%s=%i", text[0], atoi(text[1]));
    o_slot_end(w_current, tmpstr, strlen(tmpstr));
    free(tmpstr);
  }

  w_current->page_current->CHANGED = 1;
  o_undo_savestate(w_current, UNDO_ALL);

  if (attrib != NULL) {
    gtk_clist_set_row_data(GTK_CLIST(clist), row, attrib);
    multi_attrib_edit_clear(NULL, GTK_WINDOW(w_current->mawindow));
  }

  free(newtext);
  free(text);			/* is this correct?  I think so */
}


#line 497 "../noweb/x_multiattrib.nw"
void multi_attrib_edit_change(GtkWidget * w, TOPLEVEL * w_current)
{
  int vis, show;
  char *newtext;
  gint row;
  OBJECT *attrib;
  char **text;
  GtkWidget *clist;
  GtkWidget *value_entry;
  char *tmpstr;
  int len;

  clist = gtk_object_get_data(GTK_OBJECT(w_current->mawindow), "clist");
  value_entry = gtk_object_get_data(GTK_OBJECT(w_current->mawindow),
				    "value_entry");

  text = malloc(NUM_COLUMNS * sizeof(char *));
  newtext = multi_attrib_edit_parser(w, text, &vis, &show);

  if (text && text[0] && text[0][0] != '\0' && text[0][0] != ' ') {
    row = (int) gtk_object_get_data(GTK_OBJECT(clist), "selected");
    if (row != -1) {
      attrib = gtk_clist_get_row_data(GTK_CLIST(clist), row);
      o_text_change(w_current, attrib, newtext, vis, show);
      o_undo_savestate(w_current, UNDO_ALL);
      /*                        multi_attrib_edit_clear(NULL,GTK_WINDOW(w_current->mawindow)); */
      gtk_clist_set_text(GTK_CLIST(clist), row, 0, text[0]);
      gtk_clist_set_text(GTK_CLIST(clist), row, 1, text[1]);
      gtk_clist_set_text(GTK_CLIST(clist), row, 2, text[2]);
      gtk_clist_set_text(GTK_CLIST(clist), row, 3, text[3]);
    }
  }

  if ((!strcmp(text[0], "slot")) & (strlen(text[1]) < 3)) {
    tmpstr = g_strdup_printf("%s=%i", text[0], atoi(text[1]));
    o_slot_end(w_current, tmpstr, strlen(tmpstr));
    free(tmpstr);
  }

  /* highlight the value text */
  if (text[1]) {
    len = strlen(text[1]);
    if (len) {

      gtk_widget_grab_focus(value_entry);
#ifdef HAS_GTK22
      select_all_text_in_textview(GTK_TEXT_VIEW(value_entry));
#else
      gtk_entry_select_region(GTK_ENTRY(value_entry), 0, len);
#endif
    }
  }

  free(newtext);
  free(text);			/* is this correct?  I think so. */

  if (gtk_object_get_data(GTK_OBJECT(w), "close")) {
    multi_attrib_edit_close(w, w_current);
  }
}


#line 572 "../noweb/x_multiattrib.nw"
void multi_attrib_edit_delete(GtkWidget * w, TOPLEVEL * w_current)
{
  OBJECT *attrib;
  GtkCList *clist;
  gint selected;

  /* if you delete the slot= attribute, the symbol is not updated. HACK */
  /* not sure if there is an easy way to fix this, since deleting the slot */
  /* attribute is not a very nice thing todo */

  clist = gtk_object_get_data(GTK_OBJECT(w_current->mawindow), "clist");

  selected = (gint) gtk_object_get_data(GTK_OBJECT(clist), "selected");
  if (selected == -1)
    return;

  attrib = gtk_clist_get_row_data(clist, selected);
  gtk_clist_remove(clist, selected);
  gtk_object_set_data(GTK_OBJECT(clist), "selected", (gpointer) - 1);

  o_selection_remove(w_current->page_current->selection2_head, attrib);
  o_delete_text(w_current, attrib);
  w_current->page_current->CHANGED = 1;
  o_undo_savestate(w_current, UNDO_ALL);

  multi_attrib_edit_clear(NULL, GTK_WINDOW(w_current->mawindow));
  /* Tell System about change! */
}


#line 611 "../noweb/x_multiattrib.nw"
void multi_attrib_edit_close(GtkWidget * w, TOPLEVEL * w_current)
{
  i_set_state(w_current, SELECT);
  i_update_toolbar(w_current);
  /* gtk_grab_remove(w_current->mawindow); not needed ? */
  gtk_widget_destroy(w_current->mawindow);
  w_current->mawindow = NULL;
}


#line 631 "../noweb/x_multiattrib.nw"
void multi_attrib_edit(TOPLEVEL * w_current, SELECTION * list)
{
  GtkWidget *mawindow;
  GtkWidget *vbox1;
  GtkWidget *frame1;
  GtkWidget *scrolledwindow1;
  GtkWidget *clist;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *label3a;
  GtkWidget *label3b;
  GtkWidget *frame3;
  GtkWidget *table1;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *visbutton;
  GtkWidget *combo1;
  GtkWidget *attrib_combo_entry;
  GtkWidget *value_entry;
  GtkWidget *show_options;
  GtkWidget *show_options_menu;
  GtkWidget *glade_menuitem;
  GtkWidget *vbox2;
  GtkWidget *hbuttonbox1;
  GtkWidget *changebutton;
  GtkWidget *addbutton;
  GtkWidget *deletebutton;
  GtkWidget *hbuttonbox2;
  GtkWidget *clearbutton;
  GtkWidget *closebutton;
#ifdef HAS_GTK22
  GtkWidget *viewport1;
  GtkTextBuffer *value_textbuffer;
#endif

  /* gschem specific variables */
  GList *combo1_items = NULL;
  char *text[NUM_COLUMNS];
  char *string;
  int i, j;
  int row;
  OBJECT **attriblist = NULL;
  OBJECT *object = NULL;

  /* Do basic checks first, gschem specific */
  if (!w_current)
    return;
  if (!w_current->page_current)
    return;
  if (!w_current->page_current->object_head)
    return;
  object = list->selected_object;
  if (!object)
    return;

  /* get attribute list, gschem specific */
  attriblist =
      o_attrib_return_attribs(w_current->page_current->object_head,
			      object);

#ifdef HAS_GTK22
  mawindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
#else
  mawindow = gtk_window_new(GTK_WINDOW_DIALOG);
#endif
  w_current->mawindow = mawindow;	/* gschem specific */
  gtk_object_set_data(GTK_OBJECT(mawindow), "mawindow", mawindow);
  gtk_window_set_title(GTK_WINDOW(mawindow), _("Edit Attributes"));
  gtk_window_set_position(GTK_WINDOW(mawindow), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal(GTK_WINDOW(mawindow), TRUE);
#ifdef HAS_GTK22
  gtk_window_set_default_size(GTK_WINDOW(mawindow), 320, 370);
#else
  gtk_window_set_default_size(GTK_WINDOW(mawindow), 320, 350);
#endif
  gtk_window_set_policy(GTK_WINDOW(mawindow), FALSE, TRUE, TRUE);

  vbox1 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox1);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "vbox1", vbox1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox1);
  gtk_container_add(GTK_CONTAINER(mawindow), vbox1);
  gtk_container_set_border_width(GTK_CONTAINER(vbox1), 5);

  frame1 = gtk_frame_new(_("Attributes"));
  gtk_widget_ref(frame1);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "frame1", frame1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(frame1);
  gtk_box_pack_start(GTK_BOX(vbox1), frame1, TRUE, TRUE, 1);

  scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_ref(scrolledwindow1);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "scrolledwindow1",
			   scrolledwindow1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(scrolledwindow1);
  gtk_container_add(GTK_CONTAINER(frame1), scrolledwindow1);
  gtk_container_set_border_width(GTK_CONTAINER(scrolledwindow1), 3);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow1),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);

  clist = gtk_clist_new(NUM_COLUMNS);
  gtk_widget_ref(clist);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "clist", clist,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(clist);
  gtk_container_add(GTK_CONTAINER(scrolledwindow1), clist);
  gtk_clist_set_column_width(GTK_CLIST(clist), 0, 80);	/* "documentation" should fit */
  gtk_clist_set_column_width(GTK_CLIST(clist), 1, 140);
  gtk_clist_set_column_width(GTK_CLIST(clist), 2, 25);
  gtk_clist_set_column_width(GTK_CLIST(clist), 3, 10);
  gtk_clist_column_titles_show(GTK_CLIST(clist));
  /* gschem specific */
  gtk_object_set_data(GTK_OBJECT(clist), "selected", (gpointer) - 1);

  label1 = gtk_label_new(_("Name"));
  gtk_widget_ref(label1);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "label1", label1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(label1);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 0, label1);

  label2 = gtk_label_new(_("Value"));
  gtk_widget_ref(label2);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "label2", label2,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(label2);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 1, label2);

  label3a = gtk_label_new(_("Vis?"));
  gtk_widget_ref(label3a);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "label3", label3a,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(label3a);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 2, label3a);

  label3b = gtk_label_new(_("SN"));
  gtk_widget_ref(label3b);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "label3", label3b,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(label3b);
  gtk_clist_set_column_widget(GTK_CLIST(clist), 3, label3b);


  frame3 = gtk_frame_new(_("Add/Edit"));
  gtk_widget_ref(frame3);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "frame3", frame3,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(frame3);
  gtk_box_pack_start(GTK_BOX(vbox1), frame3, FALSE, TRUE, 4);

  table1 = gtk_table_new(3, 2, FALSE);
  gtk_widget_ref(table1);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "table1", table1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(table1);
  gtk_container_add(GTK_CONTAINER(frame3), table1);
  gtk_container_set_border_width(GTK_CONTAINER(table1), 4);

  label4 = gtk_label_new(_("Name:"));
  gtk_widget_ref(label4);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "label4", label4,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(label4);
  gtk_table_attach(GTK_TABLE(table1), label4, 0, 1, 0, 1,
		   (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment(GTK_MISC(label4), 0, 0.5);

  label5 = gtk_label_new(_("Value:"));
  gtk_widget_ref(label5);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "label5", label5,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(label5);
  gtk_table_attach(GTK_TABLE(table1), label5, 0, 1, 1, 2,
		   (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment(GTK_MISC(label5), 0, 0.5);

  visbutton = gtk_check_button_new_with_label(_("Visible"));
  gtk_widget_ref(visbutton);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "visbutton", visbutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(visbutton);
  gtk_table_attach(GTK_TABLE(table1), visbutton, 0, 1, 2, 3,
		   (GtkAttachOptions) (GTK_FILL),
		   (GtkAttachOptions) (0), 3, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(visbutton), TRUE);
  /* gschem specific */
  gtk_object_set_data(GTK_OBJECT(mawindow), "visbutton", visbutton);

  combo1 = gtk_combo_new();
  gtk_widget_ref(combo1);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "combo1", combo1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(combo1);
  gtk_table_attach(GTK_TABLE(table1), combo1, 1, 2, 0, 1,
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		   (GtkAttachOptions) (0), 6, 3);

  attrib_combo_entry = GTK_COMBO(combo1)->entry;
  gtk_widget_ref(attrib_combo_entry);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "attrib_combo_entry",
			   attrib_combo_entry,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(attrib_combo_entry);

#ifdef HAS_GTK22
  value_entry = gtk_text_view_new();
#else
  value_entry = gtk_entry_new();
#endif
  gtk_widget_ref(value_entry);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "value_entry",
			   value_entry,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(value_entry);

#ifdef HAS_GTK22
  viewport1 = gtk_viewport_new(NULL, NULL);
  gtk_widget_show(viewport1);
  gtk_container_add(GTK_CONTAINER(viewport1), value_entry);
  gtk_table_attach(GTK_TABLE(table1), viewport1, 1, 2, 1, 2,
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		   (GtkAttachOptions) (0), 6, 3);
#else
  gtk_table_attach(GTK_TABLE(table1), value_entry, 1, 2, 1, 2,
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		   (GtkAttachOptions) (0), 6, 3);
#endif
  /* gschem specific */
  gtk_object_set_data(GTK_OBJECT(value_entry), "mawindow", mawindow);
  gtk_object_set_data(GTK_OBJECT(value_entry), "close", (void *) 1);

  show_options = gtk_option_menu_new();
  gtk_widget_ref(show_options);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "show_options",
			   show_options,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(show_options);
  gtk_table_attach(GTK_TABLE(table1), show_options, 1, 2, 2, 3,
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		   (GtkAttachOptions) (0), 6, 3);
  show_options_menu = gtk_menu_new();
  glade_menuitem = gtk_menu_item_new_with_label(_("Show Value only"));
  gtk_widget_show(glade_menuitem);
  gtk_menu_append(GTK_MENU(show_options_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label(_("Show Name only"));
  gtk_widget_show(glade_menuitem);
  gtk_menu_append(GTK_MENU(show_options_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label(_("Show Name & Value"));
  gtk_widget_show(glade_menuitem);
  gtk_menu_append(GTK_MENU(show_options_menu), glade_menuitem);
  gtk_option_menu_set_menu(GTK_OPTION_MENU(show_options),
			   show_options_menu);

  vbox2 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox2);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "vbox2", vbox2,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox2);
  gtk_box_pack_start(GTK_BOX(vbox1), vbox2, FALSE, TRUE, 3);

  hbuttonbox1 = gtk_hbutton_box_new();
  gtk_widget_ref(hbuttonbox1);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "hbuttonbox1",
			   hbuttonbox1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbuttonbox1);
#ifdef HAS_GTK22
  gtk_box_pack_start(GTK_BOX(vbox2), hbuttonbox1, TRUE, TRUE, 3);
  gtk_box_set_spacing(GTK_BOX(hbuttonbox1), 6);
#else
  gtk_box_pack_start(GTK_BOX(vbox2), hbuttonbox1, TRUE, TRUE, 0);
#endif
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox1),
			    GTK_BUTTONBOX_END);

  changebutton = gtk_button_new_with_label(_("Change"));
  gtk_widget_ref(changebutton);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "changebutton",
			   changebutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(changebutton);
  gtk_container_add(GTK_CONTAINER(hbuttonbox1), changebutton);
  GTK_WIDGET_SET_FLAGS(changebutton, GTK_CAN_DEFAULT);
  /* gschem specific */
  gtk_object_set_data(GTK_OBJECT(changebutton), "mawindow", mawindow);

  addbutton = gtk_button_new_with_label(_("Add"));
  gtk_widget_ref(addbutton);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "addbutton", addbutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(addbutton);
  gtk_container_add(GTK_CONTAINER(hbuttonbox1), addbutton);
  GTK_WIDGET_SET_FLAGS(addbutton, GTK_CAN_DEFAULT);
  /* gschem specific */
  gtk_object_set_data(GTK_OBJECT(addbutton), "mawindow", mawindow);

  deletebutton = gtk_button_new_with_label(_("Delete"));
  gtk_widget_ref(deletebutton);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "deletebutton",
			   deletebutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(deletebutton);
  gtk_container_add(GTK_CONTAINER(hbuttonbox1), deletebutton);
  GTK_WIDGET_SET_FLAGS(deletebutton, GTK_CAN_DEFAULT);

  hbuttonbox2 = gtk_hbutton_box_new();
  gtk_widget_ref(hbuttonbox2);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "hbuttonbox2",
			   hbuttonbox2,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbuttonbox2);
#ifdef HAS_GTK22
  gtk_box_pack_start(GTK_BOX(vbox2), hbuttonbox2, TRUE, TRUE, 3);
  gtk_box_set_spacing(GTK_BOX(hbuttonbox2), 6);
#else
  gtk_box_pack_start(GTK_BOX(vbox2), hbuttonbox2, TRUE, TRUE, 0);
#endif
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox2),
			    GTK_BUTTONBOX_END);

  clearbutton = gtk_button_new_with_label(_("Clear"));
  gtk_widget_ref(clearbutton);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "clearbutton",
			   clearbutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(clearbutton);
  gtk_container_add(GTK_CONTAINER(hbuttonbox2), clearbutton);
  GTK_WIDGET_SET_FLAGS(clearbutton, GTK_CAN_DEFAULT);

  closebutton = gtk_button_new_with_label(_("Close"));
  gtk_widget_ref(closebutton);
  gtk_object_set_data_full(GTK_OBJECT(mawindow), "closebutton",
			   closebutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(closebutton);
  gtk_container_add(GTK_CONTAINER(hbuttonbox2), closebutton);
  GTK_WIDGET_SET_FLAGS(closebutton, GTK_CAN_DEFAULT);

  /* connect signals, gschem specific */
  gtk_signal_connect(GTK_OBJECT(w_current->mawindow), "destroy",
		     GTK_SIGNAL_FUNC(destroy_window),
		     &w_current->mawindow);
  gtk_signal_connect(GTK_OBJECT(w_current->mawindow), "key_press_event",
		     (GtkSignalFunc) multi_attrib_edit_keypress,
		     w_current);
#ifdef HAS_GTK12
  gtk_signal_connect(GTK_OBJECT(value_entry), "activate",
		     GTK_SIGNAL_FUNC(multi_attrib_edit_change), w_current);
#endif
  gtk_signal_connect(GTK_OBJECT(addbutton), "clicked",
		     GTK_SIGNAL_FUNC(multi_attrib_edit_add), w_current);
  gtk_signal_connect(GTK_OBJECT(changebutton), "clicked",
		     GTK_SIGNAL_FUNC(multi_attrib_edit_change), w_current);
  gtk_signal_connect(GTK_OBJECT(clearbutton), "clicked",
		     GTK_SIGNAL_FUNC(multi_attrib_edit_clear), mawindow);
  gtk_signal_connect(GTK_OBJECT(deletebutton), "clicked",
		     GTK_SIGNAL_FUNC(multi_attrib_edit_delete), w_current);
  gtk_signal_connect(GTK_OBJECT(closebutton), "clicked",
		     GTK_SIGNAL_FUNC(multi_attrib_edit_close), w_current);
  gtk_signal_connect(GTK_OBJECT(clist), "select-row",
		     GTK_SIGNAL_FUNC(multi_attrib_edit_select_row),
		     w_current);
  gtk_signal_connect(GTK_OBJECT(closebutton), "clicked",
		     GTK_SIGNAL_FUNC(multi_attrib_edit_close), w_current);
#ifdef HAS_GTK22
  value_textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(value_entry));
  gtk_signal_connect(GTK_OBJECT(attrib_combo_entry), "changed",
		     GTK_SIGNAL_FUNC(multi_attrib_parse_attribute),
		     attrib_combo_entry);
  g_signal_connect(value_textbuffer, "changed",
		   GTK_SIGNAL_FUNC(multi_attrib_parse_attribute),
		   value_entry);
#else
  gtk_signal_connect(GTK_OBJECT(attrib_combo_entry), "changed",
		     GTK_SIGNAL_FUNC(multi_attrib_parse_attribute),
		     w_current);
  gtk_signal_connect(GTK_OBJECT(value_entry), "changed",
		     GTK_SIGNAL_FUNC(multi_attrib_parse_attribute),
		     w_current);
#endif

  /* fill clist, gschem specific */
  i = 0;
  if (attriblist) {
    while (attriblist[i] != NULL) {
      o_attrib_get_name_value(attriblist[i]->text->string,
			      &(text[0]), &(text[1]));
      if (attriblist[i]->visibility == VISIBLE) {
	text[2] = g_strdup(_("Yes"));
      } else {
	text[2] = g_strdup(_("No"));
      }

      if (attriblist[i]->show_name_value == SHOW_NAME) {
	text[3] = g_strdup(_("N"));
      } else if (attriblist[i]->show_name_value == SHOW_VALUE) {
	text[3] = g_strdup(_("V"));
      } else {
	text[3] = g_strdup(_("NV"));
      }
      row = gtk_clist_append(GTK_CLIST(clist), text);
      gtk_clist_set_row_data(GTK_CLIST(clist), row, attriblist[i]);
      i++;

      /* Now free the text array, don't try to do this later as some */
      /* components do not have attributes and the free will core dump. */
      /* You have to free here, since you will be filling up text with */
      /* another row. */
      for (j = 0; j < NUM_COLUMNS; j++) {
	if (text[j]) {
	  free(text[j]);
	}
      }
    }
  }

  /* center justify the last two columns, gschem specific */
  gtk_clist_set_column_justification(GTK_CLIST(clist), 2,
				     GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_justification(GTK_CLIST(clist), 3,
				     GTK_JUSTIFY_CENTER);

  /* set name combo items, gschem specific */
  i = 0;
  string = (char *) s_attrib_get(i);
  while (string != NULL) {
    combo1_items = g_list_append(combo1_items, string);
    i++;
    string = (char *) s_attrib_get(i);
  }
  combo1_items = g_list_prepend(combo1_items, NULL);
  gtk_combo_set_popdown_strings(GTK_COMBO(combo1), combo1_items);
  g_list_free(combo1_items);

  /* show window, gschem specific */
  gtk_widget_show(mawindow);

  /* gschem specific */
  o_attrib_free_returned(attriblist);
  multi_attrib_edit_clear(NULL, GTK_WINDOW(mawindow));

}


#line 27 "../noweb/x_multiattrib.nw"
/***************** End of Multiple Attrib Edit dialog box *************/
