static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2011 Robert Sasu <sasu.robert@gmail.com>                         \n"
" *                                                                            \n"
" * Based on \"Cubism\" GIMP plugin                                            \n"
" * Copyright (C) 1996 Spencer Kimball, Tracy Scott                            \n"
" * You can contact the original GIMP authors at gimp@xcf.berkeley.edu         \n"
" * Speedups by Elliot Lee                                                     \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (tile_size, _(\"Tile size\"), 10.0)                           \n"
"    description (_(\"Average diameter of each tile (in pixels)\"))            \n"
"    value_range (0.0, 256.0)                                                  \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"                                                                              \n"
"property_double (tile_saturation, _(\"Tile saturation\"), 2.5)                \n"
"    description (_(\"Expand tiles by this amount\"))                          \n"
"    value_range (0.0, 10.0)                                                   \n"
"                                                                              \n"
"property_color  (bg_color, _(\"Background color\"), \"rgba(0.0, 0.0, 0.0, 0.0)\")\n"
"    description ((\"The tiles' background color\"))                           \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     cubism                                               \n"
"#define GEGL_OP_C_SOURCE cubism.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"#define SCALE_WIDTH     125                                                   \n"
"#define BLACK             0                                                   \n"
"#define BG                1                                                   \n"
"#define SUPERSAMPLE       4                                                   \n"
"#define MAX_POINTS        4                                                   \n"
"#define RANDOMNESS        5                                                   \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gint x, y;                                                                  \n"
"} Vector2;                                                                    \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gint    npts;                                                               \n"
"  Vector2 pts[MAX_POINTS];                                                    \n"
"} Polygon;                                                                    \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties              *o       = GEGL_PROPERTIES (operation);         \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"                                                                              \n"
"  gint tmp;                                                                   \n"
"  /*                                                                          \n"
"   * Calculate the needed extension for the ROI                               \n"
"   *      MAX (o->tile_size +                                                 \n"
"   *           g_rand_double_range (gr, 0, o->tile_size / 4.0) -              \n"
"   *           o->tile_size / 8.0) * o->tile_saturation)                      \n"
"   */                                                                         \n"
"                                                                              \n"
"  tmp = ceil ((9 * o->tile_size / 8.0) * o->tile_saturation);                 \n"
"                                                                              \n"
"  op_area->left = op_area->right = op_area->top = op_area->bottom = tmp;      \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static inline gdouble                                                         \n"
"calc_alpha_blend (gdouble *vec,                                               \n"
"                  gdouble  one_over_dist,                                     \n"
"                  gdouble  x,                                                 \n"
"                  gdouble  y)                                                 \n"
"{                                                                             \n"
"  gdouble r;                                                                  \n"
"                                                                              \n"
"  if (! one_over_dist)                                                        \n"
"    return 1.0;                                                               \n"
"                                                                              \n"
"  r = (vec[0] * x + vec[1] * y) * one_over_dist;                              \n"
"                                                                              \n"
"  return CLAMP (r, 0.2, 1.0);                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"convert_segment (gint  x1,                                                    \n"
"                 gint  y1,                                                    \n"
"                 gint  x2,                                                    \n"
"                 gint  y2,                                                    \n"
"                 gint  offset,                                                \n"
"                 gint *min,                                                   \n"
"                 gint *max)                                                   \n"
"{                                                                             \n"
"  gint    ydiff, y, tmp;                                                      \n"
"  gdouble xinc, xstart;                                                       \n"
"                                                                              \n"
"                                                                              \n"
"  if (y1 > y2)                                                                \n"
"    {                                                                         \n"
"      tmp = y2; y2 = y1; y1 = tmp;                                            \n"
"      tmp = x2; x2 = x1; x1 = tmp;                                            \n"
"    }                                                                         \n"
"  ydiff = (y2 - y1);                                                          \n"
"                                                                              \n"
"  if (ydiff)                                                                  \n"
"    {                                                                         \n"
"      xinc = (gdouble) (x2 - x1) / (gdouble) ydiff;                           \n"
"      xstart = x1 + 0.5 * xinc;                                               \n"
"      for (y = y1 ; y < y2; y++)                                              \n"
"        {                                                                     \n"
"          if (xstart < min[y - offset])                                       \n"
"            min[y-offset] = xstart;                                           \n"
"          if (xstart > max[y - offset])                                       \n"
"            max[y-offset] = xstart;                                           \n"
"                                                                              \n"
"          xstart += xinc;                                                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"randomize_indices (gint   count,                                              \n"
"                   gint  *indices,                                            \n"
"                   GRand *gr)                                                 \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"  gint index1, index2;                                                        \n"
"  gint tmp;                                                                   \n"
"                                                                              \n"
"  for (i = 0; i < count * RANDOMNESS; i++)                                    \n"
"    {                                                                         \n"
"      index1 = g_rand_int_range (gr, 0, count);                               \n"
"      index2 = g_rand_int_range (gr, 0, count);                               \n"
"      tmp = indices[index1];                                                  \n"
"      indices[index1] = indices[index2];                                      \n"
"      indices[index2] = tmp;                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"polygon_add_point (Polygon *poly,                                             \n"
"                   gdouble  x,                                                \n"
"                   gdouble  y)                                                \n"
"{                                                                             \n"
"  if (poly->npts < MAX_POINTS)                                                \n"
"    {                                                                         \n"
"      poly->pts[poly->npts].x = x;                                            \n"
"      poly->pts[poly->npts].y = y;                                            \n"
"      poly->npts++;                                                           \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    g_print (\"Unable to add additional point.\\n\");                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"polygon_rotate (Polygon *poly,                                                \n"
"                gdouble  theta)                                               \n"
"{                                                                             \n"
"  gint    i;                                                                  \n"
"  gdouble ct, st;                                                             \n"
"  gdouble ox, oy;                                                             \n"
"                                                                              \n"
"  ct = cos (theta);                                                           \n"
"  st = sin (theta);                                                           \n"
"                                                                              \n"
"  for (i = 0; i < poly->npts; i++)                                            \n"
"    {                                                                         \n"
"      ox = poly->pts[i].x;                                                    \n"
"      oy = poly->pts[i].y;                                                    \n"
"      poly->pts[i].x = ct * ox - st * oy;                                     \n"
"      poly->pts[i].y = st * ox + ct * oy;                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"polygon_extents (Polygon *poly,                                               \n"
"                 gdouble *x1,                                                 \n"
"                 gdouble *y1,                                                 \n"
"                 gdouble *x2,                                                 \n"
"                 gdouble *y2)                                                 \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"                                                                              \n"
"  if (!poly->npts)                                                            \n"
"    return 0;                                                                 \n"
"                                                                              \n"
"  *x1 = *x2 = poly->pts[0].x;                                                 \n"
"  *y1 = *y2 = poly->pts[0].y;                                                 \n"
"                                                                              \n"
"  for (i = 1; i < poly->npts; i++)                                            \n"
"    {                                                                         \n"
"      if (poly->pts[i].x < *x1)                                               \n"
"        *x1 = poly->pts[i].x;                                                 \n"
"      if (poly->pts[i].x > *x2)                                               \n"
"        *x2 = poly->pts[i].x;                                                 \n"
"      if (poly->pts[i].y < *y1)                                               \n"
"        *y1 = poly->pts[i].y;                                                 \n"
"      if (poly->pts[i].y > *y2)                                               \n"
"        *y2 = poly->pts[i].y;                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  return 1;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"polygon_translate (Polygon *poly,                                             \n"
"                   gdouble  tx,                                               \n"
"                   gdouble  ty)                                               \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"                                                                              \n"
"  for (i = 0; i < poly->npts; i++)                                            \n"
"    {                                                                         \n"
"      poly->pts[i].x += tx;                                                   \n"
"      poly->pts[i].y += ty;                                                   \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"polygon_reset (Polygon *poly)                                                 \n"
"{                                                                             \n"
"  poly->npts = 0;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"fill_poly_color (Polygon             *poly,                                   \n"
"                 const GeglRectangle *extended,                               \n"
"                 const GeglRectangle *boundary,                               \n"
"                 gfloat              *dst_buf,                                \n"
"                 gfloat              *color)                                  \n"
"{                                                                             \n"
"  gdouble       dmin_x = 0.0;                                                 \n"
"  gdouble       dmin_y = 0.0;                                                 \n"
"  gdouble       dmax_x = 0.0;                                                 \n"
"  gdouble       dmax_y = 0.0;                                                 \n"
"  gint          xs, ys;                                                       \n"
"  gint          xe, ye;                                                       \n"
"  gint          min_x, min_y;                                                 \n"
"  gint          max_x, max_y;                                                 \n"
"  gint          size_x, size_y;                                               \n"
"  gint         *max_scanlines, *max_scanlines_iter;                           \n"
"  gint         *min_scanlines, *min_scanlines_iter;                           \n"
"  gdouble       val;                                                          \n"
"  gfloat        alpha;                                                        \n"
"  gfloat        buf[4];                                                       \n"
"  gint          i, j, x, y;                                                   \n"
"  gdouble       sx, sy;                                                       \n"
"  gdouble       ex, ey;                                                       \n"
"  gdouble       xx, yy;                                                       \n"
"  gdouble       vec[2];                                                       \n"
"  gdouble       dist, one_over_dist;                                          \n"
"  gint          x1, y1, x2, y2;                                               \n"
"  gint         *vals, *vals_iter, *vals_end;                                  \n"
"  gint          b;                                                            \n"
"                                                                              \n"
"  sx = poly->pts[0].x;                                                        \n"
"  sy = poly->pts[0].y;                                                        \n"
"  ex = poly->pts[1].x;                                                        \n"
"  ey = poly->pts[1].y;                                                        \n"
"                                                                              \n"
"  dist = sqrt (pow((ex - sx),2) + pow((ey - sy),2));                          \n"
"                                                                              \n"
"  if (dist > 0.0)                                                             \n"
"    {                                                                         \n"
"      one_over_dist = 1.0 / dist;                                             \n"
"      vec[0] = (ex - sx) * one_over_dist;                                     \n"
"      vec[1] = (ey - sy) * one_over_dist;                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      one_over_dist = 0.0;                                                    \n"
"      vec[0] = 0.0;                                                           \n"
"      vec[1] = 0.0;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  x1 = boundary->x;                                                           \n"
"  y1 = boundary->y;                                                           \n"
"  x2 = boundary->x + boundary->width;                                         \n"
"  y2 = boundary->y + boundary->height;                                        \n"
"                                                                              \n"
"  polygon_extents (poly, &dmin_x, &dmin_y, &dmax_x, &dmax_y);                 \n"
"  min_x = (gint) dmin_x;                                                      \n"
"  min_y = (gint) dmin_y;                                                      \n"
"  max_x = (gint) dmax_x;                                                      \n"
"  max_y = (gint) dmax_y;                                                      \n"
"                                                                              \n"
"  size_y = (max_y - min_y) * SUPERSAMPLE;                                     \n"
"  size_x = (max_x - min_x) * SUPERSAMPLE;                                     \n"
"                                                                              \n"
"  min_scanlines = min_scanlines_iter = g_new0 (gint, size_y);                 \n"
"  max_scanlines = max_scanlines_iter = g_new0 (gint, size_y);                 \n"
"                                                                              \n"
"  for (i = 0; i < size_y; i++)                                                \n"
"    {                                                                         \n"
"      min_scanlines[i] = max_x * SUPERSAMPLE;                                 \n"
"      max_scanlines[i] = min_x * SUPERSAMPLE;                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (poly->npts)                                                             \n"
"    {                                                                         \n"
"      Vector2 *curptr;                                                        \n"
"      gint     poly_npts = poly->npts;                                        \n"
"                                                                              \n"
"      xs = (gint) (poly->pts[poly_npts-1].x);                                 \n"
"      ys = (gint) (poly->pts[poly_npts-1].y);                                 \n"
"      xe = (gint) poly->pts[0].x;                                             \n"
"      ye = (gint) poly->pts[0].y;                                             \n"
"                                                                              \n"
"      xs *= SUPERSAMPLE;                                                      \n"
"      ys *= SUPERSAMPLE;                                                      \n"
"      xe *= SUPERSAMPLE;                                                      \n"
"      ye *= SUPERSAMPLE;                                                      \n"
"                                                                              \n"
"      convert_segment (xs, ys, xe, ye, min_y * SUPERSAMPLE,                   \n"
"                       min_scanlines, max_scanlines);                         \n"
"                                                                              \n"
"      for (i = 1, curptr = &poly->pts[0]; i < poly_npts; i++)                 \n"
"        {                                                                     \n"
"          xs = (gint) curptr->x;                                              \n"
"          ys = (gint) curptr->y;                                              \n"
"          curptr++;                                                           \n"
"          xe = (gint) curptr->x;                                              \n"
"          ye = (gint) curptr->y;                                              \n"
"                                                                              \n"
"          xs *= SUPERSAMPLE;                                                  \n"
"          ys *= SUPERSAMPLE;                                                  \n"
"          xe *= SUPERSAMPLE;                                                  \n"
"          ye *= SUPERSAMPLE;                                                  \n"
"                                                                              \n"
"          convert_segment (xs, ys, xe, ye, min_y * SUPERSAMPLE,               \n"
"                           min_scanlines, max_scanlines);                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  vals = g_new0 (gint, size_x);                                               \n"
"                                                                              \n"
"  for (i = 0; i < size_y; i++, min_scanlines_iter++, max_scanlines_iter++)    \n"
"    {                                                                         \n"
"      if (! (i % SUPERSAMPLE))                                                \n"
"        {                                                                     \n"
"          memset (vals, 0, sizeof (gint) * size_x);                           \n"
"        }                                                                     \n"
"                                                                              \n"
"      yy = (gdouble)i / (gdouble)SUPERSAMPLE + min_y;                         \n"
"                                                                              \n"
"      for (j = *min_scanlines_iter; j < *max_scanlines_iter; j++)             \n"
"        {                                                                     \n"
"          x = j - min_x * SUPERSAMPLE;                                        \n"
"          vals[x] += 1;                                                       \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (! ((i + 1) % SUPERSAMPLE))                                          \n"
"        {                                                                     \n"
"          y = (i / SUPERSAMPLE) + min_y;                                      \n"
"                                                                              \n"
"          if (y >= y1 && y < y2)                                              \n"
"            {                                                                 \n"
"              for (j = 0; j < size_x; j += SUPERSAMPLE)                       \n"
"                {                                                             \n"
"                  x = (j / SUPERSAMPLE) + min_x;                              \n"
"                                                                              \n"
"                  if (x >= x1 && x < x2)                                      \n"
"                    {                                                         \n"
"                      for (val = 0, vals_iter = &vals[j],                     \n"
"                             vals_end = &vals_iter[SUPERSAMPLE];              \n"
"                           vals_iter < vals_end;                              \n"
"                           vals_iter++)                                       \n"
"                        val += *vals_iter;                                    \n"
"                                                                              \n"
"                      val /= pow((SUPERSAMPLE),2);                            \n"
"                                                                              \n"
"                      if (val > 0)                                            \n"
"                        {                                                     \n"
"                          xx = (gdouble) j / (gdouble) SUPERSAMPLE + min_x;   \n"
"                          alpha = (gfloat) (val * calc_alpha_blend (vec,      \n"
"                                                                    one_over_dist,\n"
"                                                                    xx - sx,  \n"
"                                                                    yy - sy));\n"
"                                                                              \n"
"                          for (b = 0; b < 4; b++)                             \n"
"                            buf[b] = dst_buf[( (y-extended->y) * extended->width\n"
"                                               + (x-extended->x)) * 4 + b];   \n"
"                                                                              \n"
"                          for (b = 0; b < 4; b++)                             \n"
"                            buf[b] = (color[b] * alpha) + (buf[b] * (1 - alpha));\n"
"                                                                              \n"
"                          for (b = 0; b < 4; b++)                             \n"
"                            dst_buf[((y-extended->y) * extended->width +      \n"
"                                     (x - extended->x)) * 4 + b] = buf[b];    \n"
"                                                                              \n"
"                        }                                                     \n"
"                    }                                                         \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (vals);                                                              \n"
"  g_free (min_scanlines);                                                     \n"
"  g_free (max_scanlines);                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_effective_area (GeglOperation *operation)                                 \n"
"{                                                                             \n"
"  GeglRectangle  result  = { 0, 0, 0, 0 };                                    \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  gegl_rectangle_copy (&result, in_rect);                                     \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties          *o         = GEGL_PROPERTIES (operation);           \n"
"  GeglOperationAreaFilter *op_area   = GEGL_OPERATION_AREA_FILTER (operation);\n"
"  GeglRectangle            boundary  = get_effective_area (operation);        \n"
"  GeglRectangle            extended;                                          \n"
"  const Babl              *format    = babl_format (\"RGBA float\");          \n"
"                                                                              \n"
"  GRand  *gr = g_rand_new_with_seed (o->seed);                                \n"
"  gfloat  color[4];                                                           \n"
"  gint    cols, rows, num_tiles, count;                                       \n"
"  gint   *random_indices;                                                     \n"
"  gfloat *dst_buf;                                                            \n"
"  gfloat *buf;                                                                \n"
"                                                                              \n"
"  Polygon poly;                                                               \n"
"  gint    i;                                                                  \n"
"                                                                              \n"
"  extended.x      = CLAMP (result->x - op_area->left, boundary.x, boundary.x +\n"
"                           boundary.width);                                   \n"
"  extended.width  = CLAMP (result->width + op_area->left + op_area->right, 0, \n"
"                           boundary.width);                                   \n"
"  extended.y      = CLAMP (result->y - op_area->top, boundary.y, boundary.y + \n"
"                           boundary.width);                                   \n"
"  extended.height = CLAMP (result->height + op_area->top + op_area->bottom, 0,\n"
"                           boundary.height);                                  \n"
"                                                                              \n"
"  dst_buf = g_new0 (gfloat, extended.width * extended.height * 4);            \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->bg_color, format, color);                          \n"
"                                                                              \n"
"  i   = extended.width * extended.height;                                     \n"
"  buf = dst_buf;                                                              \n"
"                                                                              \n"
"  while (i--)                                                                 \n"
"    {                                                                         \n"
"      buf[0] = color[0];                                                      \n"
"      buf[1] = color[1];                                                      \n"
"      buf[2] = color[2];                                                      \n"
"      buf[3] = color[3];                                                      \n"
"                                                                              \n"
"      buf += 4;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  cols = (result->width + o->tile_size - 1) / o->tile_size;                   \n"
"  rows = (result->height + o->tile_size - 1) / o->tile_size;                  \n"
"                                                                              \n"
"  num_tiles = (rows + 1) * (cols + 1);                                        \n"
"                                                                              \n"
"  random_indices = g_new0 (gint, num_tiles);                                  \n"
"                                                                              \n"
"  for (i = 0; i < num_tiles; i++)                                             \n"
"    random_indices[i] = i;                                                    \n"
"                                                                              \n"
"  randomize_indices (num_tiles, random_indices, gr);                          \n"
"                                                                              \n"
"  for (count = 0; count < num_tiles; count++)                                 \n"
"    {                                                                         \n"
"      gint i, j, ix, iy;                                                      \n"
"      gdouble x, y, width, height, theta;                                     \n"
"                                                                              \n"
"      i = random_indices[count] / (cols + 1);                                 \n"
"      j = random_indices[count] % (cols + 1);                                 \n"
"                                                                              \n"
"      x = j * o->tile_size + (o->tile_size / 4.0)                             \n"
"        - g_rand_double_range (gr, 0, (o->tile_size /2.0)) + result->x;       \n"
"                                                                              \n"
"      y = i * o->tile_size + (o->tile_size / 4.0)                             \n"
"        - g_rand_double_range (gr, 0, (o->tile_size /2.0)) + result->y;       \n"
"                                                                              \n"
"      width  = (o->tile_size +                                                \n"
"                g_rand_double_range (gr, -o->tile_size / 8.0, o->tile_size / 8.0))\n"
"        * o->tile_saturation;                                                 \n"
"                                                                              \n"
"      height = (o->tile_size +                                                \n"
"                g_rand_double_range (gr, -o->tile_size / 8.0, o->tile_size / 8.0))\n"
"        * o->tile_saturation;                                                 \n"
"                                                                              \n"
"      theta = g_rand_double_range (gr, 0, 2 * G_PI);                          \n"
"                                                                              \n"
"      polygon_reset (&poly);                                                  \n"
"      polygon_add_point (&poly, -width / 2.0, -height / 2.0);                 \n"
"      polygon_add_point (&poly,  width / 2.0,  -height / 2.0);                \n"
"      polygon_add_point (&poly,  width / 2.0,   height / 2.0);                \n"
"      polygon_add_point (&poly, -width / 2.0,  height / 2.0);                 \n"
"      polygon_rotate (&poly, theta);                                          \n"
"      polygon_translate (&poly, x, y);                                        \n"
"                                                                              \n"
"      ix = CLAMP (x, boundary.x, boundary.x + boundary.width - 1);            \n"
"      iy = CLAMP (y, boundary.y, boundary.y + boundary.height - 1);           \n"
"                                                                              \n"
"      gegl_buffer_sample_at_level (input, ix, iy, NULL, color, format, level, \n"
"                          GEGL_SAMPLER_NEAREST, GEGL_ABYSS_NONE);             \n"
"                                                                              \n"
"      fill_poly_color (&poly, &extended, &boundary, dst_buf, color);          \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, &extended, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);\n"
"                                                                              \n"
"  g_free (dst_buf);                                                           \n"
"  g_free (random_indices);                                                    \n"
"  g_free (gr);                                                                \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"                                                                              \n"
"  gegl_rectangle_copy (&result, in_rect);                                     \n"
"                                                                              \n"
"#ifdef TRACE                                                                  \n"
"  g_warning (\"< get_bounding_box result = %dx%d+%d+%d\", result.width, result.height, result.x, result.y);\n"
"#endif                                                                        \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"/* Compute the input rectangle required to compute the specified              \n"
" * region of interest (roi).                                                  \n"
" */                                                                           \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle  result = get_effective_area (operation);                     \n"
"                                                                              \n"
"#ifdef TRACE                                                                  \n"
"  g_warning (\"> get_required_for_output src=%dx%d+%d+%d\", result.width, result.height, result.x, result.y);\n"
"  if (roi)                                                                    \n"
"    g_warning (\"  ROI == %dx%d+%d+%d\", roi->width, roi->height, roi->x, roi->y);\n"
"#endif                                                                        \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return *gegl_operation_source_get_bounding_box (operation, \"input\");      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->threaded                = FALSE;                           \n"
"  operation_class->get_bounding_box        = get_bounding_box;                \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"title\",       _(\"Cubism\"),                                           \n"
"    \"name\",        \"gegl:cubism\",                                         \n"
"    \"categories\",  \"artistic:scramble\",                                   \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Convert the image into randomly rotated square blobs, somehow resembling a cubist painting style\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
