#!/bin/bash

# Input:
# $TAG - the SVN tag to export
# $VERSION - the upstream version of the generated tarball

DESTDIR="../tarballs/geogebra-$VERSION"
DESTTGZ="../tarballs/geogebra_$VERSION.orig.tar.gz"
TEMPDIR="$(mktemp -d)"

# Downloads code from SVN repository
test -d ../tarballs/. || mkdir -p ../tarballs
svn export "http://geogebra.uni.lu/svn/tags/$TAG/geogebra/" "$DESTDIR"

# Removes all upstream JARs
find "$DESTDIR" -name '*.jar' | xargs rm -vf

# Removes code with problematic license
rm -vfr "$DESTDIR/installer"
rm -vfr "$DESTDIR/geogebra/kernel/complex/Complex.java"
rm -vfr "$DESTDIR/geogebra/kernel/complex/ComplexPoly.java"
rm -vf "$DESTDIR/geogebra/kernel/roots/RealRoot.java"
rm -vf "$DESTDIR/geogebra/kernel/roots/RealRootFunction.java"
rm -vf "$DESTDIR/geogebra/kernel/integration/GaussQuadIntegration.java"

# Removes embedded copies of other software
rm -vfr "$DESTDIR/org"
mv -v "$DESTDIR/geogebra/kernel/jama/GgbMat.java" "$TEMPDIR"
rm -vfr "$DESTDIR/geogebra/kernel/jama/"*
mv -v "$TEMPDIR/GgbMat.java" "$DESTDIR/geogebra/kernel/jama"

# Builds tarball
tar czfv "$DESTTGZ" -C `dirname "$DESTDIR"` `basename "$DESTDIR"`

# Deletes snapshot and temporary dir
rm -fr "$DESTDIR"
rm -fr "$TEMPDIR"

