/*
 * Decompiled with CFR 0.152.
 */
package geotrans.jni;

import geotrans.jni.GeotransError;
import geotrans.jni.JNIException;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class JNIStrtoval {
    private String title = "Geographic Translator V2.4.2";
    public static final double PI = Math.PI;
    private String[] errorMsg = new String[22];
    private boolean engineError = false;
    private boolean jniError = false;
    private int numErrors = 0;

    public JNIStrtoval() {
        this.initialize();
    }

    public native String JNIErrorPrefix(int var1, int var2);

    public native String JNILatitudeToString(double var1, boolean var3, boolean var4, boolean var5) throws GeotransError, JNIException;

    public native String JNILongitudeToString(double var1, boolean var3, boolean var4, boolean var5) throws GeotransError, JNIException;

    public native String JNIMeterToString(double var1) throws GeotransError, JNIException;

    public native void JNISetSeparator(char var1);

    public native void JNISetLongRange(int var1);

    public native void JNISetLatLongPrecision(long var1);

    public native void JNIShowLeadingZeros(boolean var1);

    public native double JNIStringToDouble(String var1) throws GeotransError, JNIException;

    public native double JNIStringToLatitude(String var1) throws GeotransError, JNIException;

    public native long JNIStringToLong(String var1) throws GeotransError, JNIException;

    public native double JNIStringToLongitude(String var1) throws GeotransError, JNIException;

    public double stringToLatitude(String str, String msg) {
        double lat = 0.0;
        try {
            if (str.equals("")) {
                throw new GeotransError(msg);
            }
            lat = this.JNIStringToLatitude(str) * Math.PI / 180.0;
        }
        catch (GeotransError e) {
            this.errorMsg[this.numErrors] = msg;
            ++this.numErrors;
            this.engineError = true;
        }
        catch (JNIException e) {
            this.errorMsg[this.numErrors] = e.getMessage();
            ++this.numErrors;
            this.jniError = true;
        }
        return lat;
    }

    public double stringToLongitude(String str, String msg) {
        double lon = 0.0;
        try {
            if (str.equals("")) {
                throw new GeotransError(msg);
            }
            lon = this.JNIStringToLongitude(str) * Math.PI / 180.0;
        }
        catch (GeotransError e) {
            this.errorMsg[this.numErrors] = msg;
            ++this.numErrors;
            this.engineError = true;
        }
        catch (JNIException e) {
            this.errorMsg[this.numErrors] = e.getMessage();
            ++this.numErrors;
            this.jniError = true;
        }
        return lon;
    }

    public double stringToDouble(String str, String msg) {
        double num = 0.0;
        try {
            if (str.equals("")) {
                throw new GeotransError(msg);
            }
            num = this.JNIStringToDouble(str);
        }
        catch (GeotransError e) {
            this.errorMsg[this.numErrors] = msg;
            ++this.numErrors;
            this.engineError = true;
        }
        catch (JNIException e) {
            this.errorMsg[this.numErrors] = e.getMessage();
            ++this.numErrors;
            this.jniError = true;
        }
        return num;
    }

    public long stringToLong(String str, String msg) {
        long num = 0L;
        try {
            if (str.equals("")) {
                throw new GeotransError(msg);
            }
            num = this.JNIStringToLong(str);
        }
        catch (GeotransError e) {
            this.errorMsg[this.numErrors] = msg;
            ++this.numErrors;
            this.engineError = true;
        }
        catch (JNIException e) {
            this.errorMsg[this.numErrors] = e.getMessage();
            ++this.numErrors;
            this.jniError = true;
        }
        return num;
    }

    public void displayErrorMsg(Component parent) {
        JOptionPane.showMessageDialog(parent, this.errorMsg, this.title, 0);
        this.initialize();
    }

    public void displayErrorMsg(Component parent, String msg) {
        JOptionPane.showMessageDialog(parent, "Error: \n" + msg, this.title, 0);
    }

    public void displayErrorMsg(Component parent, int dir, int projType) {
        this.errorMsg[0] = "Error: \n" + this.JNIErrorPrefix(dir, projType);
        this.errorMsg[1] = " ";
        JOptionPane.showMessageDialog(parent, this.errorMsg, this.title, 0);
        this.initialize();
    }

    public void displayWarningMsg(Component parent, String msg) {
        JOptionPane.showMessageDialog(parent, "Warning: \n" + msg, this.title, 2);
    }

    public boolean getEngineError() {
        return this.engineError;
    }

    public void setEngineError(boolean error, String msg) {
        this.engineError = error;
        this.errorMsg[this.numErrors] = msg;
        ++this.numErrors;
    }

    public boolean getJNIError() {
        return this.jniError;
    }

    public String getTitle() {
        return this.title;
    }

    public void setJNIError(boolean error, String msg) {
        this.jniError = error;
        this.errorMsg[this.numErrors] = msg;
        ++this.numErrors;
    }

    private void initialize() {
        this.engineError = false;
        this.jniError = false;
        this.numErrors = 2;
        for (int i = 0; i < 10; ++i) {
            this.errorMsg[i] = "";
        }
    }

    public void setNumberFormat(JTextField textField, double num, int digits) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(digits);
        nf.setMinimumFractionDigits(digits);
        textField.setText(nf.format(num));
    }
}

