% FUNCTION MIM = gf_mesh_im(...)
% 
%   General constructor for @tmim object (integration methods on a mesh).
% 
%   * gf_mesh_im(mesh m[{integ im|int im_degree}])
% 
%   Return a getfem handle to the newly created @tmim object. For
%   convenience, optional arguments ('im' or 'im_degree') can be provided,
%   in that case a call to gf_mesh_im_set(mim, 'integ', ..) is issued with
%   these arguments.
% 
%   * gf_mesh_im('load', string fname[, Mesh m])
%   Load a MeshIm from a file.  If the mesh `m` is not supplied (this kind of file
%   does not store the mesh), then it is read from the file and its descriptor is
%   returned as the second output argument.
% 
%   * gf_mesh_im('from_string', string s[, mesh M])
%   Create a MeshIm object from its string description.  See also
%   gf_mesh_im_get(MIM,'char')
% 
%   * gf_mesh_im('clone', MeshIm mim2)
%   Create a copy of a MeshIm.
% 
%   * gf_mesh_im('levelset', LevelSet ls, string where, Integ im[, Integ im_tip])
%   Build an integration method conformal to a partition defined implicitely by a
%   levelset.  The `where` argument define the domain of integration with respect
%   to the levelset, it has to be chosen among 'ALL', 'INSIDE', 'OUTSIDE' and
%   'BOUNDARY'.
% 
% 
%   $Id: gf_mesh_im.cc 2869 2009-01-08 01:12:35Z lsaavedr $
function [varargout]=gf_mesh_im(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_im',varargin{:});
  else
    gf_matlab('mesh_im',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
