/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  error.inl - G::Error inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GFC::G::Error::operator GError* () const
{
	return this ? error_ : 0;
}

inline GFC::G::Error::operator GError** ()
{
	return this && !error_ ? &error_ : 0;
}

inline bool
GFC::G::Error::get() const
{
	return error_ != 0;
}

inline bool
GFC::G::Error::matches(GQuark domain, int code) const
{
	return g_error_matches(error_, domain, code);
}

inline int
GFC::G::Error::code() const
{
	return error_->code;
}

inline const char*
GFC::G::Error::message() const
{
	return error_->message;
}

inline void
GFC::G::Error::clear()
{
	g_clear_error(&error_);
}

