/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  selection.cc - AtkSelection C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "selection.hh"
#include "selectionsignals.hh"
#include "private/selectioniface.hh"
#include <gfc/glib/object.hh>
#include <gfc/glib/objectsignals.hh>

using namespace GFC;

/*  Atk::SelectionSignals
 */

Atk::SelectionSignals::SelectionSignals(Selection *selection)
{
	Atk::SelectionIface::init(ATK_SELECTION_GET_IFACE(selection->atk_selection()));
}
	
Atk::SelectionSignals::~SelectionSignals()
{
}
	
void
Atk::SelectionSignals::on_selection_changed()
{
	AtkSelectionIface *g_iface = SelectionIface::get_parent_iface(instance_);
	if (g_iface->selection_changed)
		g_iface->selection_changed((AtkSelection*)instance_);
}

/*  Atk::SelectionIface
 */

void
Atk::SelectionIface::init(AtkSelectionIface *g_iface)
{
	g_iface->selection_changed = &selection_changed_proxy;
}

AtkSelectionIface*
Atk::SelectionIface::get_parent_iface(void *instance)
{
	void *ptr = g_type_interface_peek_parent(ATK_SELECTION_GET_IFACE(instance));
	return static_cast<AtkSelectionIface*>(ptr);
}

void
Atk::SelectionIface::selection_changed_proxy(AtkSelection *selection)
{
	void *ptr = g_object_get_qdata((GObject*)selection, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<SelectionSignals*>(object)->on_selection_changed();
	}
	else
	{
		AtkSelectionIface *g_iface = SelectionIface::get_parent_iface(selection);
		if (g_iface->selection_changed)
			g_iface->selection_changed(selection);
	}
}

