/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  events.inl - Gdk::Event inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  Gdk::get_show_events
 */

inline bool
GFC::Gdk::get_show_events()
{
	return gdk_get_show_events();
}

/*  Gdk::events_pending
 */

inline bool
GFC::Gdk::events_pending()
{
	return gdk_events_pending();
}

/*  Gdk::set_show_events
 */

inline void
GFC::Gdk::set_show_events(bool show_events)
{
	gdk_set_show_events(show_events);
}

/*  Gdk::Event
 */

inline GdkEvent*
GFC::Gdk::Event::gdk_event() const
{
	return reinterpret_cast<GdkEvent*>(boxed_);
}

inline GFC::Gdk::Event::operator GdkEvent* () const
{
	return this ? gdk_event() : 0;
}

inline GFC::Gdk::EventType
GFC::Gdk::Event::type() const
{
	return (EventType)gdk_event()->type;
}

inline unsigned int
GFC::Gdk::Event::get_time() const
{
	return gdk_event_get_time(gdk_event());
}

inline bool
GFC::Gdk::Event::get_state(ModifierTypeField *state) const
{
	return gdk_event_get_state(gdk_event(), (GdkModifierType*)state);
}

inline bool
GFC::Gdk::Event::get_axis(AxisUse axis_use, double *value) const
{
	return gdk_event_get_axis(gdk_event(), (GdkAxisUse)axis_use, value);
}

inline bool
GFC::Gdk::Event::get_coords(double *x_win, double *y_win) const
{
	return gdk_event_get_coords(gdk_event(), x_win, y_win);
}

inline bool
GFC::Gdk::Event::get_root_coords(double *x_root, double *y_root) const
{
	return gdk_event_get_root_coords(gdk_event(), x_root, y_root);
}

inline void
GFC::Gdk::Event::put()
{
	gdk_event_put(gdk_event());
}

/*  Gdk::EventAny
 */

inline GdkEventAny*
GFC::Gdk::EventAny::gdk_event_any() const
{
	return reinterpret_cast<GdkEventAny*>(boxed_);
}

inline bool
GFC::Gdk::EventAny::send_event() const
{
	return gdk_event_any()->send_event;
}

/*  Gdk::EventExpose
 */

inline GdkEventExpose*
GFC::Gdk::EventExpose::gdk_event_expose() const
{
	return reinterpret_cast<GdkEventExpose*>(boxed_);
}

inline int
GFC::Gdk::EventExpose::count() const
{
	return gdk_event_expose()->count;
}

/*  Gdk::EventVisibilty
 */

inline GdkEventVisibility*
GFC::Gdk::EventVisibility::gdk_event_visibility() const
{
	return reinterpret_cast<GdkEventVisibility*>(boxed_);
}

inline GFC::Gdk::VisibilityState
GFC::Gdk::EventVisibility::state() const
{
	return (VisibilityState)gdk_event_visibility()->state;
}

/*  Gdk::EventMotion
 */

inline GdkEventMotion*
GFC::Gdk::EventMotion::gdk_event_motion() const
{
	return reinterpret_cast<GdkEventMotion*>(boxed_);
}

inline unsigned int
GFC::Gdk::EventMotion::time() const
{
	return gdk_event_motion()->time;
}

inline double
GFC::Gdk::EventMotion::x() const
{
	return gdk_event_motion()->x;
}

inline double
GFC::Gdk::EventMotion::y() const
{
	return gdk_event_motion()->y;
}

inline int
GFC::Gdk::EventMotion::x_int() const
{
	return (int)gdk_event_motion()->x;
}

inline int
GFC::Gdk::EventMotion::y_int() const
{
	return (int)gdk_event_motion()->y;
}

inline double*
GFC::Gdk::EventMotion::axes() const
{
	return gdk_event_motion()->axes;
}

inline GFC::Gdk::ModifierTypeField
GFC::Gdk::EventMotion::state() const
{
	return gdk_event_motion()->state;
}

inline bool
GFC::Gdk::EventMotion::is_hint() const
{
	return gdk_event_motion()->is_hint != 0;
}

inline double
GFC::Gdk::EventMotion::x_root() const
{
	return gdk_event_motion()->x_root;
}

inline double
GFC::Gdk::EventMotion::y_root() const
{
	return gdk_event_motion()->y_root;
}

/*  Gdk::EventButton
 */

inline GdkEventButton*
GFC::Gdk::EventButton::gdk_event_button() const
{
	return reinterpret_cast<GdkEventButton*>(boxed_);
}

inline unsigned int
GFC::Gdk::EventButton::time() const
{
	return gdk_event_button()->time;
}

inline double
GFC::Gdk::EventButton::x() const
{
	return gdk_event_button()->x;
}

inline double
GFC::Gdk::EventButton::y() const
{
	return gdk_event_button()->y;
}

inline int
GFC::Gdk::EventButton::x_int() const
{
	return (int)gdk_event_button()->x;
}

inline int
GFC::Gdk::EventButton::y_int() const
{
	return (int)gdk_event_button()->y;
}

inline double*
GFC::Gdk::EventButton::axes() const
{
	return gdk_event_button()->axes;
}

inline GFC::Gdk::ModifierTypeField
GFC::Gdk::EventButton::state() const
{
	return gdk_event_button()->state;
}

inline unsigned int
GFC::Gdk::EventButton::button() const
{
	return gdk_event_button()->button;
}

inline double
GFC::Gdk::EventButton::x_root() const
{
	return gdk_event_button()->x_root;
}

inline double
GFC::Gdk::EventButton::y_root() const
{
	return gdk_event_button()->y_root;
}

/*  Gdk::EventScroll
 */

inline GdkEventScroll*
GFC::Gdk::EventScroll::gdk_event_scroll() const
{
	return reinterpret_cast<GdkEventScroll*>(boxed_);
}

inline unsigned int
GFC::Gdk::EventScroll::time() const
{
	return gdk_event_scroll()->time;
}

inline double
GFC::Gdk::EventScroll::x() const
{
	return gdk_event_scroll()->x;
}

inline double
GFC::Gdk::EventScroll::y() const
{
	return gdk_event_scroll()->y;
}

inline int
GFC::Gdk::EventScroll::x_int() const
{
	return (int)gdk_event_scroll()->x;
}

inline int
GFC::Gdk::EventScroll::y_int() const
{
	return (int)gdk_event_scroll()->y;
}

inline GFC::Gdk::ModifierTypeField
GFC::Gdk::EventScroll::state() const
{
	return gdk_event_scroll()->state;
}

inline GFC::Gdk::ScrollDirection
GFC::Gdk::EventScroll::direction() const
{
	return (ScrollDirection)gdk_event_scroll()->direction;
}

inline double
GFC::Gdk::EventScroll::x_root() const
{
	return gdk_event_scroll()->x_root;
}

inline double
GFC::Gdk::EventScroll::y_root() const
{
	return gdk_event_scroll()->y_root;
}

/*  Gdk::EventKey
 */

inline GdkEventKey*
GFC::Gdk::EventKey::gdk_event_key() const
{
	return reinterpret_cast<GdkEventKey*>(boxed_);
}

inline unsigned int
GFC::Gdk::EventKey::time() const
{
	return gdk_event_key()->time;
}

inline GFC::Gdk::ModifierTypeField
GFC::Gdk::EventKey::state() const
{
	return gdk_event_key()->state;
}

inline unsigned short
GFC::Gdk::EventKey::hardware_keycode() const
{
	return gdk_event_key()->hardware_keycode;
}

inline unsigned char
GFC::Gdk::EventKey::group() const
{
	return gdk_event_key()->group;
}

/*  Gdk::EventCrossing
 */

inline GdkEventCrossing*
GFC::Gdk::EventCrossing::gdk_event_crossing() const
{
	return reinterpret_cast<GdkEventCrossing*>(boxed_);
}

inline unsigned int
GFC::Gdk::EventCrossing::time() const
{
	return gdk_event_crossing()->time;
}

inline double
GFC::Gdk::EventCrossing::x() const
{
	return gdk_event_crossing()->x;
}

inline double
GFC::Gdk::EventCrossing::y() const
{
	return gdk_event_crossing()->y;
}

inline int
GFC::Gdk::EventCrossing::x_int() const
{
	return (int)gdk_event_crossing()->x;
}

inline int
GFC::Gdk::EventCrossing::y_int() const
{
	return (int)gdk_event_crossing()->y;
}

inline double
GFC::Gdk::EventCrossing::x_root() const
{
	return gdk_event_crossing()->x_root;
}

inline double
GFC::Gdk::EventCrossing::y_root() const
{
	return gdk_event_crossing()->y_root;
}

inline int
GFC::Gdk::EventCrossing::x_root_int() const
{
	return (int)gdk_event_crossing()->x_root;
}

inline int
GFC::Gdk::EventCrossing::y_root_int() const
{
	return (int)gdk_event_crossing()->y_root;
}

inline GFC::Gdk::CrossingMode
GFC::Gdk::EventCrossing::mode() const
{
	return (CrossingMode)gdk_event_crossing()->mode;
}

inline GFC::Gdk::NotifyType
GFC::Gdk::EventCrossing::detail() const
{
	return (NotifyType)gdk_event_crossing()->detail;
}

inline bool
GFC::Gdk::EventCrossing::focus() const
{
	return gdk_event_crossing()->focus != 0;
}

inline GFC::Gdk::ModifierTypeField
GFC::Gdk::EventCrossing::state() const
{
	return gdk_event_crossing()->state;
}

/*  Gdk::EventFocus
 */

inline GdkEventFocus*
GFC::Gdk::EventFocus::gdk_event_focus() const
{
	return reinterpret_cast<GdkEventFocus*>(boxed_);
}

inline bool
GFC::Gdk::EventFocus::in() const
{
	return gdk_event_focus()->in != 0;
}

inline bool
GFC::Gdk::EventFocus::out() const
{
	return gdk_event_focus()->in == 0;
}

/*  Gdk::EventConfigure
 */

inline GdkEventConfigure*
GFC::Gdk::EventConfigure::gdk_event_configure() const
{
	return reinterpret_cast<GdkEventConfigure*>(boxed_);
}

inline int
GFC::Gdk::EventConfigure::x() const
{
	return gdk_event_configure()->x;
}

inline int
GFC::Gdk::EventConfigure::y() const
{
	return gdk_event_configure()->y;
}

inline int
GFC::Gdk::EventConfigure::width() const
{
	return gdk_event_configure()->width;
}

inline int
GFC::Gdk::EventConfigure::height() const
{
	return gdk_event_configure()->height;
}

/*  Gdk::EventProperty
 */

inline GdkEventProperty*
GFC::Gdk::EventProperty::gdk_event_property() const
{
	return reinterpret_cast<GdkEventProperty*>(boxed_);
}

inline GFC::Gdk::Atom
GFC::Gdk::EventProperty::atom() const
{
	return gdk_event_property()->atom;
}

inline unsigned int
GFC::Gdk::EventProperty::time() const
{
	return gdk_event_property()->time;
}

inline GFC::Gdk::PropertyState
GFC::Gdk::EventProperty::state() const
{
	return (PropertyState)gdk_event_property()->state;
}

/*  Gdk::EventSelection
 */

inline GdkEventSelection*
GFC::Gdk::EventSelection::gdk_event_selection() const
{
	return reinterpret_cast<GdkEventSelection*>(boxed_);
}

inline GFC::Gdk::Atom
GFC::Gdk::EventSelection::selection() const
{
	return gdk_event_selection()->selection;
}

inline GFC::Gdk::Atom
GFC::Gdk::EventSelection::target() const
{
	return gdk_event_selection()->target;
}

inline GFC::Gdk::Atom
GFC::Gdk::EventSelection::property() const
{
	return gdk_event_selection()->property;
}

inline unsigned int
GFC::Gdk::EventSelection::time() const
{
	return gdk_event_selection()->time;
}

inline GdkNativeWindow
GFC::Gdk::EventSelection::requestor() const
{
	return gdk_event_selection()->requestor;
}

/*  Gdk::EventProximity
 */

inline GdkEventProximity*
GFC::Gdk::EventProximity::gdk_event_proximity() const
{
	return reinterpret_cast<GdkEventProximity*>(boxed_);
}

inline unsigned int
GFC::Gdk::EventProximity::time() const
{
	return gdk_event_proximity()->time;
}

/*  Gdk::EventClient
 */

inline GdkEventClient*
GFC::Gdk::EventClient::gdk_event_client() const
{
	return reinterpret_cast<GdkEventClient*>(boxed_);
}

inline GFC::Gdk::Atom
GFC::Gdk::EventClient::message_type() const
{
	return gdk_event_client()->message_type;
}

inline unsigned short
GFC::Gdk::EventClient::data_format() const
{
	return gdk_event_client()->data_format;
}

inline const char*
GFC::Gdk::EventClient::char_data() const
{
	return gdk_event_client()->data.b;
}

inline const short*
GFC::Gdk::EventClient::short_data() const
{
	return gdk_event_client()->data.s;
}

inline const long*
GFC::Gdk::EventClient::long_data() const
{
	return gdk_event_client()->data.l;
}

/*  Gdk::EventSetting
 */

inline GdkEventSetting*
GFC::Gdk::EventSetting::gdk_event_setting() const
{
	return reinterpret_cast<GdkEventSetting*>(boxed_);
}

inline GFC::Gdk::SettingAction
GFC::Gdk::EventSetting::action() const
{
	return (SettingAction)gdk_event_setting()->action;
}

/*  Gdk::EventWindowState
 */

inline GdkEventWindowState*
GFC::Gdk::EventWindowState::gdk_event_window_state() const
{
	return reinterpret_cast<GdkEventWindowState*>(boxed_);
}

inline GFC::Gdk::WindowStateField
GFC::Gdk::EventWindowState::changed_mask() const
{
	return (WindowStateField)gdk_event_window_state()->changed_mask;
}

inline GFC::Gdk::WindowStateField
GFC::Gdk::EventWindowState::new_window_state() const
{
	return (WindowStateField)gdk_event_window_state()->new_window_state;
}

/*  Gdk::EventDND
 */

inline GdkEventDND*
GFC::Gdk::EventDND::gdk_event_dnd() const
{
	return reinterpret_cast<GdkEventDND*>(boxed_);
}

inline unsigned int
GFC::Gdk::EventDND::time() const
{
	return gdk_event_dnd()->time;
}

inline short
GFC::Gdk::EventDND::x_root() const
{
	return gdk_event_dnd()->x_root;
}

inline short
GFC::Gdk::EventDND::y_root() const
{
	return gdk_event_dnd()->y_root;
}

