/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  entrysignals.cc - Gtk::Entry virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "entry.hh"
#include "entrysignals.hh"
#include "menu.hh"
#include "private/entryclass.hh"
#include "private/editableclass.hh"
#include "private/celleditableiface.hh"

using namespace GFC;

/*  Gtk::EntrySignals
 */

Gtk::EntrySignals::EntrySignals(Entry *entry) 
: WidgetSignals(entry),
  EditableSignals(entry),
  CellEditableSignals(entry)
{
	Gtk::EntryClass::init(GTK_ENTRY_GET_CLASS(entry->gtk_entry()));
}

Gtk::EntrySignals::~EntrySignals()
{
}

void
Gtk::EntrySignals::on_populate_popup(Menu& menu)
{
	GtkEntryClass *g_class = EntryClass::get_parent_class(instance_);
	if (g_class->populate_popup)
		g_class->populate_popup((GtkEntry*)instance_, menu.gtk_menu());
}

void
Gtk::EntrySignals::on_activate()
{
	GtkEntryClass *g_class = EntryClass::get_parent_class(instance_);
	if (g_class->activate)
		g_class->activate((GtkEntry*)instance_);
}

void
Gtk::EntrySignals::on_insert_at_cursor(const String& text)
{
	GtkEntryClass *g_class = EntryClass::get_parent_class(instance_);
	if (g_class->insert_at_cursor)
		g_class->insert_at_cursor((GtkEntry*)instance_, text.c_str());
}

/*  Gtk::EntryClass
 */

void
Gtk::EntryClass::init(GtkEntryClass *g_class)
{
	g_class->populate_popup = &populate_popup_proxy;
	g_class->activate = &activate_proxy;
	g_class->insert_at_cursor = &insert_at_cursor_proxy;
}

GtkEntryClass*
Gtk::EntryClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_ENTRY_GET_CLASS(instance));
	return static_cast<GtkEntryClass*>(ptr);
}

GType
Gtk::EntryClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ENTRY);
		G::TypeInstance::add_interface(type, GTK_TYPE_EDITABLE);
		G::TypeInstance::add_interface(type, GTK_TYPE_CELL_EDITABLE);
	}
	return type;
}

void*
Gtk::EntryClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::EntryClass::populate_popup_proxy(GtkEntry *entry, GtkMenu *menu)
{
	void *ptr = g_object_get_qdata((GObject*)entry, G::ObjectSignals::quark());
	if (ptr)
		static_cast<EntrySignals*>(ptr)->on_populate_popup(*G::Object::wrap<Gtk::Menu>(menu));
	else
	{
		GtkEntryClass *g_class = EntryClass::get_parent_class(entry);
		if (g_class->populate_popup)
			g_class->populate_popup(entry, menu);
	}
}

void
Gtk::EntryClass::activate_proxy(GtkEntry *entry)
{
	void *ptr = g_object_get_qdata((GObject*)entry, G::ObjectSignals::quark());
	if (ptr)
		static_cast<EntrySignals*>(ptr)->on_activate();
	else
	{
		GtkEntryClass *g_class = EntryClass::get_parent_class(entry);
		if (g_class->activate)
			g_class->activate(entry);
	}
}

void
Gtk::EntryClass::insert_at_cursor_proxy(GtkEntry *entry, const gchar *str)
{
	void *ptr = g_object_get_qdata((GObject*)entry, G::ObjectSignals::quark());
	if (ptr)
	{
		std::string tmp_str(str);
		static_cast<EntrySignals*>(ptr)->on_insert_at_cursor(tmp_str);
	}
	else
	{
		GtkEntryClass *g_class = EntryClass::get_parent_class(entry);
		if (g_class->insert_at_cursor)
			g_class->insert_at_cursor(entry, str);
	}
}

