/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/menubar.hh
/// @brief A GtkMenuBar C++ wrapper interface.
///
/// Provides MenuBar, a widget subclass of MenuShell which contains one to many MenuItem.
/// The result is a standard menu bar which can hold many menu items.

#ifndef GFC_GTK_MENU_BAR_HH
#define GFC_GTK_MENU_BAR_HH

#ifndef GFC_GTK_MENU_SHELL_HH
#include <gfc/gtk/menushell.hh>
#endif

#ifndef __GTK_MENU_BAR_H__
#include <gtk/gtkmenubar.h>
#endif

namespace GFC {

namespace Gtk {

/// @class MenuBar menubar.hh gfc/gtk/menubar.hh
/// @brief A GtkMenuBar C++ wrapper class.
///
/// The MenuBar is a subclass of MenuShell which contains one or more MenuItem.
/// The result is a standard menu bar which can hold many menu items. MenuBar
/// allows for a shadow type to be set for aesthetic purposes.

class MenuBar : public MenuShell
{
	friend class G::Object;

	MenuBar(const MenuBar&);
	MenuBar& operator=(const MenuBar&);
	
protected:
/// @name Constructors
/// @{

	explicit MenuBar(GtkMenuBar *menu_bar, bool owns_reference = false);
	///< Construct a new MenuBar from an existing GtkMenuBar.
	///< @param menu_bar A pointer to a GtkMenuBar.
	///< @param owns_reference Set false if the initial reference count is floating, set true if it's not.
	///<
	///< <BR>The <EM>menu_bar</EM> can be a newly created GtkMenuBar or an existing
	///< GtkMenuBar (see G::Object::Object).

/// @}

public:
/// @name Constructors
/// @{

	MenuBar();
	///< Construct a new MenuBar.

	virtual ~MenuBar();
	///< Destructor.
	
/// @}
/// @name Accessors

	GtkMenuBar* gtk_menu_bar() const;
	///< Get a pointer to the GtkMenuBar structure.

	operator GtkMenuBar* () const;
	///< Conversion operator; safely converts a MenuBar to a GtkMenuBar pointer.

/// @}
};

} // namespace Gtk

} // namespace GFC

#include <gfc/gtk/inline/menubar.inl>

#endif // GFC_GTK_MENU_BAR_HH

