/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  object.cc - GtkObject C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "object.hh"
#include "private/objectclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::Object
 */

Gtk::Object::Object(GtkObject *object, bool owns_reference)
: G::Object((GObject*)object, owns_reference)
{
}

Gtk::Object::~Object()
{
}

void
Gtk::Object::ref()
{
	G::Object::ref();
	if (gtk_object()->flags & GTK_FLOATING)
	{
		sink();
		set_owns_reference(true);
	}
}

void
Gtk::Object::dispose()
{
	if (!(gtk_object()->flags & GTK_IN_DESTRUCTION))
		G::Object::dispose();
}

/*  Gtk::Object  signals
 */

const Gtk::Object::DestroySignalType Gtk::Object::destroy_signal("destroy", (GCallback)&G::Marshal::void_callback);

