/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/radiobuttonsignals.hh
/// @brief Gtk::RadioButton virtual signal handlers.
///
/// Provides Gtk::RadioButtonSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::RadioButton objects.

#ifndef GFC_GTK_RADIO_BUTTON_SIGNALS_HH
#define GFC_GTK_RADIO_BUTTON_SIGNALS_HH

#ifndef GFC_GTK_TOGGLE_BUTTON_SIGNALS_HH
#include <gfc/gtk/togglebuttonsignals.hh>
#endif

namespace GFC {

namespace Gtk {

/// @class RadioButtonSignals radiobuttonsignals.hh gfc/gtk/radiobuttonsignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::RadioButton.

class RadioButtonSignals : public ToggleButtonSignals
{
protected:
/// @name Constructors
/// @{

	RadioButtonSignals(RadioButton *radio_button);
	///< Constructs a new RadioButtonSignals object.
	///< @param radio_button A RadioButton object inheriting the RadioButtonSignals implementation.

	virtual ~RadioButtonSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{

	virtual void on_group_changed();
	///< Called when the group of radio buttons that a radio button belongs to changes. 
	///< This handler is called when a radio button switches from being alone to being
	///< part of a group of 2 or more buttons, or vice-versa, and when a buttton is 
	///< moved from one group of 2 or more buttons to a different one, but not when the
	///< composition of the group that a button belongs to changes.

/// @}
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_RADIO_BUTTON_SIGNALS_HH

