/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  toggletoolbuttonsignals.cc - Gtk::ToggleToolButton virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "toggletoolbutton.hh"
#include "toggletoolbuttonsignals.hh"
#include "private/toggletoolbuttonclass.hh"

using namespace GFC;

/*  Gtk::ToggleToolButtonSignals
 */

Gtk::ToggleToolButtonSignals::ToggleToolButtonSignals(ToggleToolButton *button)
: ToolButtonSignals(button)
{
	Gtk::ToggleToolButtonClass::init(GTK_TOGGLE_TOOL_BUTTON_GET_CLASS(button->gtk_toggle_tool_button()));
}

Gtk::ToggleToolButtonSignals::~ToggleToolButtonSignals()
{
}

void
Gtk::ToggleToolButtonSignals::on_toggled()
{
	GtkToggleToolButtonClass *g_class = ToggleToolButtonClass::get_parent_class(instance_);
	if (g_class->toggled)
		g_class->toggled((GtkToggleToolButton*)instance_);
}

/*  Gtk::ToggleToolButtonClass
 */

void
Gtk::ToggleToolButtonClass::init(GtkToggleToolButtonClass *g_class)
{
	g_class->toggled = &toggled_proxy;
}

GtkToggleToolButtonClass*
Gtk::ToggleToolButtonClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TOGGLE_TOOL_BUTTON_GET_CLASS(instance));
	return static_cast<GtkToggleToolButtonClass*>(ptr);
}

GType
Gtk::ToggleToolButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TOGGLE_TOOL_BUTTON);
	}
	return type;
}

void*
Gtk::ToggleToolButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ToggleToolButtonClass::toggled_proxy(GtkToggleToolButton *button)
{
	void *ptr = g_object_get_qdata((GObject*)button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ToggleToolButtonSignals*>(ptr)->on_toggled();
	else
	{
		GtkToggleToolButtonClass *g_class = ToggleToolButtonClass::get_parent_class(button);
		if (g_class->toggled)
			g_class->toggled(button);
	}
}

