/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  viewport.cc - GtkViewport C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "viewport.hh"
#include "private/viewportclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::Viewport
 */

Gtk::Viewport::Viewport(GtkViewport *viewport, bool owns_reference)
: Bin((GtkBin*)viewport, owns_reference)
{
}

Gtk::Viewport::Viewport() 
: Bin((GtkBin*)ViewportClass::create())
{
}

Gtk::Viewport::Viewport(Adjustment *hadjustment, Adjustment *vadjustment)
: Bin((GtkBin*)ViewportClass::create())
{
	if (hadjustment)
		set_hadjustment(hadjustment);
	if (vadjustment)
		set_vadjustment(vadjustment);
}

Gtk::Viewport::~Viewport()
{
}

Gtk::Adjustment*
Gtk::Viewport::get_hadjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_viewport_get_hadjustment(gtk_viewport()));
}

Gtk::Adjustment*
Gtk::Viewport::get_vadjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_viewport_get_vadjustment(gtk_viewport()));
}

Gtk::ShadowType
Gtk::Viewport::get_shadow_type() const
{
	return (ShadowType)gtk_viewport_get_shadow_type(gtk_viewport());
}

void 
Gtk::Viewport::set_hadjustment(Adjustment *adjustment)
{
	gtk_viewport_set_hadjustment(gtk_viewport(), *adjustment);
}
	
void 
Gtk::Viewport::set_vadjustment(Adjustment *adjustment)
{
	gtk_viewport_set_vadjustment(gtk_viewport(), *adjustment);
}

/*  Gtk::Viewport signals
 */

const Gtk::Viewport::SetScrollAdjustmentsSignalType Gtk::Viewport::set_scroll_adjustments_signal("set_scroll_adjustments", (GCallback)&Marshal::void_adjustment_adjustment_callback);
