/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  windowsignals.cc - Gtk::Window virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "window.hh"
#include "windowsignals.hh"
#include "private/windowclass.hh"
#include "private/widgetclass.hh"

using namespace GFC;

/*  Gtk::WindowSignals
 */

Gtk::WindowSignals::WindowSignals(Window *window)
: ContainerSignals(window)
{
	Gtk::WindowClass::init(GTK_WINDOW_GET_CLASS(window->gtk_window()));
}

Gtk::WindowSignals::~WindowSignals()
{
}

void
Gtk::WindowSignals::on_set_focus(Widget *focus)
{
	GtkWindowClass *g_class = WindowClass::get_parent_class(instance_);
	if (g_class->set_focus)
		g_class->set_focus((GtkWindow*)instance_, *focus);
}

bool
Gtk::WindowSignals::on_frame_event(const Gdk::Event& event)
{
	bool result = false;
	GtkWindowClass *g_class = WindowClass::get_parent_class(instance_);
	if (g_class->frame_event)
		result = g_class->frame_event((GtkWindow*)instance_, event.gdk_event());
	return result;
}

void
Gtk::WindowSignals::on_keys_changed()
{
	GtkWindowClass *g_class = WindowClass::get_parent_class(instance_);
	if (g_class->keys_changed)
		g_class->keys_changed((GtkWindow*)instance_);
}

/*  Gtk::WindowClass
 */

void
Gtk::WindowClass::init(GtkWindowClass *g_class)
{
	g_class->set_focus = &set_focus_proxy;
	g_class->frame_event = &frame_event_proxy;
	g_class->keys_changed = &keys_changed_proxy;
}

GtkWindowClass*
Gtk::WindowClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_WINDOW_GET_CLASS(instance));
	return static_cast<GtkWindowClass*>(ptr);
}

GType
Gtk::WindowClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_WINDOW);
	}
	return type;
}

void*
Gtk::WindowClass::create(GtkWindowType type)
{
	return g_object_new(get_type(), "type", type, 0);
}

void
Gtk::WindowClass::set_focus_proxy(GtkWindow *window, GtkWidget *focus)
{
	void *ptr = g_object_get_qdata((GObject*)window, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WindowSignals*>(ptr)->on_set_focus(G::Object::wrap<Gtk::Widget>(focus));
	else
	{
		GtkWindowClass *g_class = WindowClass::get_parent_class(window);
		if (g_class->set_focus)
			g_class->set_focus(window, focus);
	}
}

gboolean
Gtk::WindowClass::frame_event_proxy(GtkWindow *window, GdkEvent *event)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)window, G::ObjectSignals::quark());
	if (ptr)
	{
		Gdk::Event tmp_event(event);
		result = static_cast<WindowSignals*>(ptr)->on_frame_event(tmp_event);
	}
	else
	{
		GtkWindowClass *g_class = WindowClass::get_parent_class(window);
		if (g_class->frame_event)
			result = g_class->frame_event(window, event);
	}
	return result;
}

void
Gtk::WindowClass::keys_changed_proxy(GtkWindow *window)
{
	void *ptr = g_object_get_qdata((GObject*)window, G::ObjectSignals::quark());
	if (ptr)
		static_cast<WindowSignals*>(ptr)->on_keys_changed();
	else
	{
		GtkWindowClass *g_class = WindowClass::get_parent_class(window);
		if (g_class->keys_changed)
			g_class->keys_changed(window);
	}
}

