
/* -*- mode:C++ -*- */


#ifndef _GFONT_H
#define _GFONT_H


#ifdef USE_GNOME
# include <gnome.h>
#else

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(String) gettext(String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif       
#else /* NLS is disabled */
# define _(String) (String)
# define N_(String) (String)
# define textdomain(String) (String)
# define gettext(String) (String)
# define dgettext(Domain,String) (String)
# define dcgettext(Domain,String,Type) (String)
# define bindtextdomain(Domain,Directory)  
#endif /* if enable_nls */

#endif /* if gnome */

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include <t1lib.h>
#include <freetype.h>
#include <ftxerr18.h>
#include <ftxkern.h>
#include <ftxpost.h>
#include <locale.h>



typedef void (Callback) (GtkWidget*, gpointer);
typedef gint (EventCallback) (GtkWidget*, GdkEvent*, gpointer);


enum FontType {T1FONT, TTFONT};

struct T1Data {
  int fontID;
  char **encoding;
};


struct TTData {
  TT_Face face; 
  TT_Face_Properties properties;
  TT_Kerning kerndir;
  guint kernpairs, kerntable;
  bool PSloaded;
};


/* 
   Each row of the font selection list has a FontData structure associated to it
   A window which needs access to the structure after being created 
   (like the fonttables) has to increase the refcount when
   created and decrease it when destroyed. If the FontData is not visible, 
   the structure shall be destroyed when destroying the window (calling destroyfont)
*/
struct FontData {
  FontType fontType;
  union {
    struct T1Data t1data;
    struct TTData ttdata;
  };
  int num_glyphs;
  char *fontName;
  char *fontFile;
  char *fontFamily;
  int refcount;    // How oft the font is used by windows that will access it
  bool visible;    // Whether the font is being displayed in the actual font list
};



struct EntryDialog {
  GtkWidget *hbox, *label, *entry;
};


#ifdef USE_GNOME
#define STATUSBAR_PUSH(bar, msg) gnome_appbar_push(GNOME_APPBAR(bar), (msg))
#define STATUSBAR_POP(bar) gnome_appbar_pop(GNOME_APPBAR(bar))
#else
#define STATUSBAR_PUSH(bar, msg) gtk_statusbar_push(GTK_STATUSBAR((bar)), 1, (msg));
#define STATUSBAR_POP(bar) gtk_statusbar_pop(GTK_STATUSBAR((bar)), 1); 
#endif


// ********************* Prototypes

// T1 functions
const char* GetT1error(int err);
bool is_t1font(gchar *pathname, FontData *fd);
void t1_fonttable(FontData* fd, double size);
bool t1_downloadfont(FILE* fp, FontData *fd);
void t1_showproperties(FontData *fd, GtkWidget *window);
GdkImage* t1_makechar(FontData* fd, char index, double size, 
		      bool antialiasing);
GdkImage* t1_makestring(FontData* fd, const char* string, double size, 
			bool kerning, bool antialiasing);

// TT funtions
void fill_ttfontdata(FontData* fd);
const char* getfontname(FontData* fd, int idx);
bool is_ttfont(gchar *pathname, FontData *fd);
bool is_ttfontcollection(gchar *pathname, FontData *fd);
void tt_fonttable(FontData* fd, double size);
bool tt_downloadfont(FILE* fp, FontData *fd, GArray *codes);
bool tt_download_as_t42(FILE* fp, FontData *fd, GArray *codes);
void tt_showproperties(FontData *fd, GtkWidget *window);
GdkImage* tt_makechar(FontData* fd, TT_UShort index, double size, 
		      bool antialiasing);
GdkImage* tt_makestring(FontData* fd, const char* string, double size, 
			bool kerning, bool antialiasing);
TT_Error tt_findcharmap(FontData* fd, TT_CharMap* charmap);
TT_Error tt_findtextcharmap(FontData* fd, TT_CharMap* charmap);
bool tt_lookup(FontData *fd, const char *name, TT_UShort *index);


// Others
void select_fontlist(GtkWidget* list, gint row, gint column, GdkEventButton *event);
void unselect_fontlist(GtkWidget* list, gint row, gint column, GdkEventButton *event);

EventCallback fontlist_event;
Callback delete_pixmap, delete_image, delete_stringsw;
Callback show_message_window, makeabout, printfonts, 
  show_properties, save_names, show_char_or_string;

void out_of_memory(int value, const char* file, int line);
void make_message_window(void);
void add_error(FontData* fd, const char* msg, ...);
void errormsg(GtkWidget *parent, const char* msg, ...);
GtkWidget* makeicon(GtkWidget* toplevel, char** pixmap);
void destroyfont(FontData *fd);
bool ask_yes_no(GtkWidget *parent, const char* msg, ...);
GtkWidget* save_asgif(GdkImage *image);
GtkWidget *make_imagepopupmenu(GtkWidget *window);
void set_window_busy(GtkWidget *window, bool state);
GtkWidget* show_font_properties(FontData *fd);
void drawsample(GtkWidget *list, int row);
void array_insert(GArray *array, TT_UShort v);
struct EntryDialog*
make_entry_dialog(const char* labeltext, const char* entrytext);
void combo_drag_data_received(GtkWidget *entry, GdkDragContext *context,
			      gint x, gint y, GtkSelectionData *data,
			      guint info, guint time);
#endif _GFONT_H
