/* $Id: dock.c,v 1.12 2002/11/13 09:33:23 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under terms of GPL license.
 * (C) Copyright 2001-2002 Igor Truszkowski.
 * (C) Copyright 2001-2002 Micha Nowikowski.
 *
 *    Zawiera kod zapoyczony z wmgpi autorstwa:
 *    	Jason Slanga <jason@nearest-exit.org>     
 *    	Aaron Pendergrass <aaron@nearest-exit.org> 
 *
 * - applet panelu GNOME
 * - dockapp Window Makera
 * - docklet dla KDE/GNOME i by moe innych
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "gg.h"
#include "gg-types.h"
#include "support.h"
#include <X11/Xatom.h>

#include "callbacks.h"
#include "userstatus.h"

#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP


extern GtkWidget *window;
extern GList *msg_spool;
extern GGStatus status;

gboolean show_hide_main(GtkWidget * widget, gpointer data)
{
	GtkWidget *target;
	
	if (msg_spool) {
	    gg_new_msg_animate_off();
	    target = msg_spool->data;
	    gtk_widget_show(target);
	    msg_spool = g_list_remove(msg_spool, (gpointer) target);
	    
	    if (!msg_spool) 
		set_status_img_status(status.state);
	    return TRUE;
	}
	
	if (!GTK_WIDGET_VISIBLE(window)) {
		gtk_widget_show(window);
	} else {
		gtk_widget_hide(window);
	}
	return TRUE;
}

static
void applet_menu_change_status(GtkWidget * widget, gint * status)
{
    set_optionmenu_menu (*status);
    
    switch (*status) {
	case GG_STATUS_ONLINE:
		on_available_activate(NULL, NULL);
		break;
	case GG_STATUS_AWAY:
		on_away_activate(NULL, NULL);
		break;
	case GG_STATUS_INVISIBLE:
		on_invisible_activate(NULL, NULL);
		break;
	case GG_STATUS_OFFLINE:
		on_not_available_activate(NULL, NULL);
		break;
	case GG_STATUS_ONLINE_DESCR:
		on_status_description_activate(NULL, NULL);
		break;
    }
}

#endif

#ifdef USE_APPLET

#include <gnome.h>
#include <applet-widget.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include "interface.h"

extern GGConfig config;
extern GtkWidget *applet;

static
void applet_clicked_cb(GtkWidget * widget, GdkEventButton * ev,
		       gpointer data)
{

	if (ev == NULL)
		return;
	if (ev->button != 1 || ev->type != GDK_BUTTON_PRESS)
		return;
	show_hide_main(widget, NULL);

}
static
gint applet_save_session(GtkWidget * widget,
			 const gchar * privcfgpath,
			 const gchar * globcfgpath)
{
	write_config();
	write_contacts();

	g_print("applet_save_session(): session saved.\n");

	return FALSE;
}

#ifdef HAVE_PANEL_PIXEL_SIZE
static
void applet_update_sap(GtkWidget * applet, gint sap, gpointer data)
{
	GtkWidget *vbox;
	gint orient;
	gint size;

	size = applet_widget_get_panel_pixel_size(APPLET_WIDGET(applet));
	orient = applet_widget_get_panel_orient(APPLET_WIDGET(applet));

	vbox = lookup_widget(applet, "applet_vbox");
	g_return_if_fail(vbox != NULL);

	switch (orient) {

	case ORIENT_UP:
	case ORIENT_DOWN:
		gtk_widget_set_usize(GTK_WIDGET(vbox),
				     24, size - 5);
		break;

	case ORIENT_LEFT:
	case ORIENT_RIGHT:
		gtk_widget_set_usize(GTK_WIDGET(vbox),
				     size - 5, 24);
		break;
	}

}
#endif


void applet_change_status_pixmap(gchar *filename)
{
    GtkWidget *pixmap_applet;
    GdkPixmap *pixmap;
    GdkBitmap *mask;  
    GdkColormap *colormap;
    gchar *fullpath;
        
    pixmap_applet = lookup_widget(applet, "pixmap_applet");
    g_return_if_fail(pixmap_applet != NULL);

    colormap = gtk_widget_get_colormap(applet);
    fullpath = GPP(filename);
    pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, colormap, &mask,
						     NULL,
						     fullpath);
    g_free(fullpath);
    if (pixmap != NULL)
	change_pixmap(pixmap_applet, pixmap, mask);
        
}

GtkWidget *create_applet(void)
{
	GtkWidget *vbox;
	GtkWidget *eventbox;
	GtkWidget *applet;
	GtkWidget *pixmap_applet;

	static gint menus[] = { GG_STATUS_ONLINE, GG_STATUS_AWAY, 
				GG_STATUS_INVISIBLE, GG_STATUS_OFFLINE, 
				GG_STATUS_ONLINE_DESCR };

	applet = applet_widget_new("gg");

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_object_set_data(GTK_OBJECT(applet), "applet_vbox",
			    vbox);

	pixmap_applet = create_pixmap(applet, OFFLINE_IMG);
	gtk_object_set_data(GTK_OBJECT(applet), "pixmap_applet",
			    pixmap_applet);
	gtk_widget_realize(applet);
	gtk_box_pack_start(GTK_BOX(vbox), pixmap_applet, TRUE, TRUE, 0);

	eventbox = gtk_event_box_new();

	gtk_container_add(GTK_CONTAINER(eventbox), vbox);
	gtk_widget_show(eventbox);
	applet_widget_add(APPLET_WIDGET(applet), eventbox);

	gtk_widget_show(pixmap_applet);
	gtk_widget_show(vbox);

	applet_widget_register_stock_callback_dir(APPLET_WIDGET(applet),
						  "status",
						  GNOME_STOCK_MENU_REFRESH,
						  _("Zmie stan"));

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					      "status/online",
					      GNOME_STOCK_MENU_BLANK,
					      _("Dostpny"),
					      (AppletCallbackFunc)
					      applet_menu_change_status,
					      &menus[MENU_ONLINE_IDX]);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					      "status/away",
					      GNOME_STOCK_MENU_BLANK,
					      _("Zaraz wracam"),
					      (AppletCallbackFunc)
					      applet_menu_change_status,
					      &menus[MENU_AWAY_IDX]);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					      "status/invisible",
					      GNOME_STOCK_MENU_BLANK,
					      _("Niewidoczny"),
					      (AppletCallbackFunc)
					      applet_menu_change_status,
					      &menus[MENU_INVISIBLE_IDX]);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					      "status/offline",
					      GNOME_STOCK_MENU_BLANK,
					      _("Niedostpny"),
					      (AppletCallbackFunc)
					      applet_menu_change_status,
					      &menus[MENU_OFFLINE_IDX]);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					      "status/offline",
					      GNOME_STOCK_MENU_BLANK,
					      _("Z opisem..."),
					      (AppletCallbackFunc)
					      applet_menu_change_status,
					      &menus[MENU_DESCR_IDX]);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					      "preferences",
					      GNOME_STOCK_MENU_PREF,
					      _("Preferencje"),
					      (AppletCallbackFunc)
					      on_konfiguracja_activate,
					      NULL);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					      "show_hide",
					      GNOME_STOCK_MENU_CONVERT,
					      _
					      ("Ukryj/Wywietl gwne okno"),
					      (AppletCallbackFunc)
					      show_hide_main, NULL);

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					      "about",
					      GNOME_STOCK_MENU_ABOUT,
					      _("About..."), about, NULL);
	gtk_signal_connect(GTK_OBJECT(applet), "button_press_event",
			   GTK_SIGNAL_FUNC(applet_clicked_cb), NULL);

	gtk_signal_connect(GTK_OBJECT(applet), "save_session",
			   GTK_SIGNAL_FUNC(applet_save_session), NULL);

	gtk_signal_connect(GTK_OBJECT(applet), "delete_event",
			   GTK_SIGNAL_FUNC(applet_save_session), NULL);

#ifdef HAVE_PANEL_PIXEL_SIZE
	gtk_signal_connect(GTK_OBJECT(applet), "change_pixel_size",
			   GTK_SIGNAL_FUNC(applet_update_sap), NULL);

	gtk_signal_connect(GTK_OBJECT(applet), "change_orient",
			   GTK_SIGNAL_FUNC(applet_update_sap), NULL);
#endif

	return applet;
}

#endif				/* USE_APPLET */


#ifdef USE_DOCKAPP

extern GGConfig config;
extern GList *msg_spool;
extern GGStatus status;

static GtkWidget *wnd_main;
static int visible;

GtkWidget *wnd_dock, *icon_win;
GdkGC *dock_gc;
GdkFont *font;
GdkPixmap *launch_pixmap;
GdkPixmap *launch_mask;  
GdkColormap *cmap;
GdkColor white, black, /*col[7],*/ somecol;
GdkColor col2 = {65000, 65000, 30000};

static GdkColor clBgUp    = {0, 65000, 65000, 30000};    // tlo
static GdkColor clBg      = {0, 65000, 65000, 30000};    // tlo
static GdkColor clX1      = {0, 30000, 50000, 65535};
static GdkColor clX2      = {0,  3000, 30000, 65535};
static GdkColor clOffline = {0, 60000,  3000, 35535};     // offline
static GdkColor clOnline  = {0,  3000,  3000, 65535};      // online
static GdkColor clAway    = {0, 30000, 30000, 65535};    // away
static GdkColor clUnk     = {0,  3000, 30000,  3000};      // unknown


GdkRectangle btn_exit = {45, 7, 12, 12};
GdkRectangle btn_show_hide = {5, 5, 16, 16};
GdkRectangle btn_new_msg = {26, 6, 20, 20};

// Funkcje zdefiniowane sa nizej
void wmgg_change_status_pixmap(gchar *filename);
void wmgg_new_msg(gboolean show);

int btn_clicked(GdkRectangle *btn, int x, int y)
{
	return (x >= btn->x && x <= btn->x+btn->width &&
		y >= btn->y && y <= btn->y+btn->height);
} 

gint redraw_wnd_dock(GtkWidget *widget)
{
	gdk_draw_pixmap(icon_win->window, dock_gc, launch_pixmap,
			0, 0, 0, 0, 64, 64);
	return 0;
}      

gint on_click(GtkWidget *widget, GdkEventButton *ev, gpointer data )
{ 

//	printf("x:%f y:%f\n", ev->x, ev->y);

	if (ev->button != 1) 
		return 1;
	
	if (btn_clicked(&btn_show_hide, ev->x, ev->y))
	{
		if (visible)
			gtk_widget_hide(wnd_main);
		else
			gtk_widget_show(wnd_main);
		
		visible = 1-visible;
	}
	if (btn_clicked(&btn_new_msg, ev->x, ev->y))
	{
    		GtkWidget *target;
	
		if (msg_spool) {
		    gg_new_msg_animate_off();
		    target = msg_spool->data;
		    gtk_widget_show(target);
		    msg_spool = g_list_remove(msg_spool, (gpointer) target);
	    
		    if (!msg_spool) {
			set_status_img_status(status.state);
			wmgg_new_msg(FALSE);
		    }
		}
	}
	if (btn_clicked(&btn_exit, ev->x, ev->y))
		shutdown_gg();

	return 0;
}

int wmgg_start(GtkWidget *wnd)
{
	GdkWindow *leader;
	XWMHints hints;
	GdkGC *mask_gc;  
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	gchar *fullpath;
//	int i;
  
	wnd_main = wnd;
	visible  = config.main_on_start;
	
	cmap = gdk_colormap_get_system ();
  
	white.red=65535;
	white.green=65535;
	white.blue=65535;
	black.red=0;
	black.green=0;
	black.blue=0;
  
	gdk_color_alloc(cmap, &white);
	gdk_color_alloc(cmap, &black);
	gdk_color_alloc(cmap, &clBg);
	gdk_color_alloc(cmap, &clX1);
	gdk_color_alloc(cmap, &clX2);
	gdk_color_alloc(cmap, &clOffline);
	gdk_color_alloc(cmap, &clOnline);
	gdk_color_alloc(cmap, &clAway);
	gdk_color_alloc(cmap, &clUnk);
	
	font=gdk_font_load("-misc-fixed-medium-r-normal-*-*-110-*-*-c-*-iso8859-2");
	
	/*create wnd_dock (I don't really know what purpose it serves)*/
	wnd_dock = gtk_window_new(GTK_WINDOW_DIALOG);
//  if (has_geometry)
//  gtk_widget_set_uposition(wnd_dock, 100, 100);
	gtk_widget_set_usize(wnd_dock, 64, 64);
	gtk_widget_set_app_paintable(wnd_dock, TRUE);

	/*set WMhints for wnd_dock and realize it*/
	gtk_widget_realize(wnd_dock);
	hints.initial_state = WithdrawnState;
	hints.flags = StateHint;
	XSetWMHints(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(wnd_dock->window), &hints);
  
	/*create the icon wnd_dock*/
	icon_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_widget_set_app_paintable(icon_win, TRUE);
	gtk_widget_set_uposition(icon_win, 0, 0);
	gtk_widget_set_usize(icon_win, 64, 64);
	
	/*connect signals and realize icon_win*/
	gtk_widget_set_events(icon_win, GDK_BUTTON_PRESS_MASK |
			      GDK_EXPOSURE_MASK);
	gtk_signal_connect(GTK_OBJECT(icon_win), "expose_event", 
			   GTK_SIGNAL_FUNC(redraw_wnd_dock), NULL);
	gtk_signal_connect(GTK_OBJECT(icon_win), "button_press_event",
			   GTK_SIGNAL_FUNC(on_click), NULL);
	gtk_widget_realize(icon_win);
	
	/*clear icon_win*/
	gdk_window_set_background(icon_win->window, &somecol);
	gdk_window_clear(icon_win->window);
	gdk_window_set_background(wnd_dock->window, &somecol);
	gdk_window_clear(wnd_dock->window);

	/*create the pixmap and the mask*/
	launch_mask = gdk_pixmap_new(icon_win->window, 64, 64, 1);
	launch_pixmap = gdk_pixmap_new(icon_win->window, 64, 64, -1);

	/*create some graphic contexts*/
	dock_gc = gdk_gc_new(icon_win->window);
	mask_gc = gdk_gc_new(launch_mask);
	
	/*draw the icon mask*/
	gdk_gc_set_foreground(mask_gc, &black);
	gdk_draw_rectangle(launch_mask, mask_gc, TRUE,0,0,-1,-1);
	gdk_gc_set_foreground(mask_gc, &white);
	gdk_draw_rectangle(launch_mask, mask_gc, TRUE, 4, 4, 56, 56);

	/*draw a rectangle and a friendly greeting to the pixmap*/
	gdk_gc_set_foreground(dock_gc, &clBg);
	gdk_draw_rectangle(launch_pixmap, dock_gc, TRUE, 4, 4, 56, 56);
	gdk_gc_set_foreground(dock_gc, &clBg);
	gdk_draw_rectangle(launch_pixmap, dock_gc, FALSE, btn_show_hide.x, btn_show_hide.y, 
		     btn_show_hide.width, btn_show_hide.height);

//	gdk_gc_set_foreground(dock_gc, &black);
//	gdk_draw_line(launch_pixmap, dock_gc, 2, 25, 58, 25);
	
//	gdk_draw_rectangle(launch_pixmap, dock_gc, TRUE, btn_exit.x, btn_exit.y, 
//			   btn_exit.width, btn_exit.height);
	fullpath = GPP("wmexit.xpm");
	pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, cmap, &mask,
						     &clBg, fullpath);
	g_free(fullpath);
	gdk_draw_pixmap(launch_pixmap, dock_gc, pixmap, 0, 0, btn_exit.x, btn_exit.y, 
			btn_exit.width, btn_exit.height);
	wmgg_change_status_pixmap(OFFLINE_IMG);

//	gdk_gc_set_foreground(dock_gc, &col[2]);
//	gdk_draw_text(launch_pixmap, font, dock_gc, 8, 35, "GnuGadu", 7);
	
	/*apply the mask and draw the pixmap to both wnd_docks*/
	gtk_widget_shape_combine_mask(wnd_dock, launch_mask, 0, 0);  
	gtk_widget_shape_combine_mask(icon_win, launch_mask, 0, 0);  
	redraw_wnd_dock(NULL);
	
	/*grab the leader wnd_dock (I don't really understand this bit) 
	  and set it's icon to icon_win->wnd_dock */
	leader=gdk_window_foreign_new(gdk_leader_window);
	gdk_window_set_icon(leader, icon_win->window, NULL, NULL);
	gdk_window_reparent(icon_win->window, wnd_dock->window, 0, 0);
	/*unreference stuff and show the wnd_docks*/
	gdk_gc_unref(mask_gc);
	gdk_window_unref(leader); 
	gtk_widget_show(icon_win);
	gtk_widget_show(wnd_dock);

        font=gdk_font_load("-misc-fixed-medium-r-normal-*-*-100-*-*-c-*-iso8859-2");  

	return 0;
} 

// -show	- TRUE wyswietl / FALSE ukryj ikone nowej wiadomosci
void wmgg_new_msg(gboolean show)
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	gchar *fullpath;
	
	if (show) {
	    fullpath = GPP("wmmsg.xpm");
	    pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, cmap, &mask,
							 &clBg, fullpath);
	    g_free(fullpath);
	    gdk_draw_pixmap(launch_pixmap, dock_gc, pixmap, 0, 0, btn_new_msg.x, btn_new_msg.y, 
					btn_new_msg.width, btn_new_msg.height);				
	} else {
	    gdk_gc_set_foreground(dock_gc, &clBg);
	    gdk_draw_rectangle(launch_pixmap, dock_gc, TRUE, btn_new_msg.x, btn_new_msg.y, 
		    			btn_new_msg.width, btn_new_msg.height);
	}
	
	gtk_widget_shape_combine_mask(wnd_dock, launch_mask, 0, 0);
	gtk_widget_shape_combine_mask(icon_win, launch_mask, 0, 0);
	redraw_wnd_dock(NULL);
}

void wmgg_change_status_pixmap(gchar *filename)
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	gchar *fullpath;
//	printf("wm_change_state\n");
	fullpath = GPP(filename);
	pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, cmap, &mask,
						     &clBg, fullpath);
	g_free(fullpath);
	gdk_draw_pixmap(launch_pixmap, dock_gc, pixmap, 0, 0, 6, 6, 20, 20);

	gtk_widget_shape_combine_mask(wnd_dock, launch_mask, 0, 0);  
	gtk_widget_shape_combine_mask(icon_win, launch_mask, 0, 0);  
	redraw_wnd_dock(NULL);
}

#define NNICK 3
void wmgg_contact_change_status(gchar *nick, guint status, guint prev_status)
{
	int i;
	static guchar prev_nick[NNICK-1][9] = {"\0\0\0\0\0\0\0\0\0","\0\0\0\0\0\0\0\0\0"}; 
	static guint prev_nick_status[NNICK-1] = {GG_STATUS_OFFLINE, GG_STATUS_OFFLINE};
	
	gdk_gc_set_foreground(dock_gc, &clBg);
	gdk_draw_rectangle(launch_pixmap, dock_gc, TRUE, 8, 28, 53, 31);
	
	for (i=0; i<NNICK-1; i++) {
		switch (prev_nick_status[i])	{
		case GG_STATUS_OFFLINE:
		case GG_STATUS_OFFLINE_DESCR:
			gdk_gc_set_foreground(dock_gc, &clOffline); break;
		case GG_STATUS_ONLINE:
		case GG_STATUS_ONLINE_DESCR:
			gdk_gc_set_foreground(dock_gc, &clOnline); break;
		case GG_STATUS_AWAY:
		case GG_STATUS_AWAY_DESCR:
			gdk_gc_set_foreground(dock_gc, &clAway); break;
		default:
			gdk_gc_set_foreground(dock_gc, &clUnk); break;
		}
		gdk_draw_text(launch_pixmap, font, dock_gc, 8, 36 +i*10, prev_nick[i], 
		      strlen(prev_nick[i]));
//		printf("%d. %s %d\n", i, prev_nick[i], prev_nick_status[i]);
	}

	switch (status)	{
	case GG_STATUS_OFFLINE:
	case GG_STATUS_OFFLINE_DESCR:
		gdk_gc_set_foreground(dock_gc, &clOffline); break;
	case GG_STATUS_ONLINE:
	case GG_STATUS_ONLINE_DESCR:
		gdk_gc_set_foreground(dock_gc, &clOnline); break;
	case GG_STATUS_AWAY:
	case GG_STATUS_AWAY_DESCR:
		gdk_gc_set_foreground(dock_gc, &clAway); break;
	default:
		gdk_gc_set_foreground(dock_gc, &clUnk); break;
	}

	for (i=0; i<NNICK-2; i++) {
	    prev_nick_status[i] = prev_nick_status[i+1];
	    strncpy(prev_nick[i], prev_nick[i+1], 8);
	}

	prev_nick_status[NNICK-2] = status;
	strncpy(prev_nick[NNICK-2], nick, 8);
	gdk_draw_text(launch_pixmap, font, dock_gc, 8, 56, prev_nick[NNICK-2], 
		      strlen(prev_nick[NNICK-2]));
//	printf("%d. %s %d\n", NNICK-2, prev_nick[NNICK-2], prev_nick_status[NNICK-2]);

	/*apply the mask and draw the pixmap to both wnd_docks*/
	gtk_widget_shape_combine_mask(wnd_dock, launch_mask, 0, 0);  
	gtk_widget_shape_combine_mask(icon_win, launch_mask, 0, 0);  
	redraw_wnd_dock(NULL);
}

#endif /* USE_DOCKAPP */

#ifdef USE_DOCKLET

extern GtkWidget *docklet;

void docklet_change_status_pixmap(gchar *filename)
{
	GtkWidget *pixmap_docklet;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GdkColormap *colormap;
	gchar *fullpath;
	
	pixmap_docklet = lookup_widget(docklet, "pixmap_docklet");
	g_return_if_fail(pixmap_docklet != NULL);
	colormap = gtk_widget_get_colormap(docklet);
	fullpath = GPP(filename);
	pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, colormap, &mask,
						     NULL,
						     fullpath);
	g_free(fullpath);
	if (pixmap != NULL) 
	    change_pixmap(pixmap_docklet, pixmap, mask);
}

GtkWidget *create_docklet_menu() 
{
    GtkWidget *menu;
    GtkWidget *submenu;
    GtkWidget *menuitem;
    static gint menus[] = { GG_STATUS_ONLINE, GG_STATUS_AWAY, 
			    GG_STATUS_INVISIBLE, GG_STATUS_OFFLINE, 
			    GG_STATUS_ONLINE_DESCR };

    menu = gtk_menu_new();

    submenu = gtk_menu_new();
    gtk_widget_show(submenu);

    menuitem = gtk_menu_item_new_with_label(_("Dostpny"));
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(submenu), menuitem);

    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(applet_menu_change_status),
			   &menus[MENU_ONLINE_IDX]);


    menuitem = gtk_menu_item_new_with_label(_("Zaraz wracam"));
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(submenu), menuitem);

    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
    			   GTK_SIGNAL_FUNC(applet_menu_change_status),
			   &menus[MENU_AWAY_IDX]);
    
    menuitem = gtk_menu_item_new_with_label(_("Niewidoczny"));
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(submenu), menuitem);

    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
    			   GTK_SIGNAL_FUNC(applet_menu_change_status),
			   &menus[MENU_INVISIBLE_IDX]);


    menuitem = gtk_menu_item_new_with_label(_("Niedostpny"));
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(submenu), menuitem);

    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
    			   GTK_SIGNAL_FUNC(applet_menu_change_status),
			   &menus[MENU_OFFLINE_IDX]);

    menuitem = gtk_menu_item_new_with_label(_("Z opisem..."));
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(submenu), menuitem);

    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
    			   GTK_SIGNAL_FUNC(applet_menu_change_status),
			   &menus[MENU_DESCR_IDX]);

    menuitem = gtk_menu_item_new_with_label(_("Zmie status"));
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(menu), menuitem);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu);
    
    menuitem = gtk_menu_item_new();
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(menu), menuitem);

    menuitem = gtk_menu_item_new_with_label(_("Preferencje"));
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(menu), menuitem);

    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_konfiguracja_activate), NULL);

    menuitem = gtk_menu_item_new_with_label(_("Zakocz"));
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(menu), menuitem);

    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_wyjscie_activate), NULL);

    
    menuitem = gtk_menu_item_new_with_label(_("Informacje o..."));
    gtk_widget_show(menuitem);
    gtk_menu_append(GTK_MENU(menu), menuitem);

    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_informacje_o_activate), NULL);
    
    
    
    return menu;
}

static
void docklet_clicked_cb(GtkWidget * widget, GdkEventButton * ev,
		       gpointer data)
{

	GtkWidget *menu;
	
	if (ev == NULL)
		return;
	if (ev->type == GDK_BUTTON_PRESS) {
	    switch (ev->button) {
		case 1:
			show_hide_main(widget, NULL);
			break;
		default:
			menu = create_docklet_menu();
			gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
			ev->button, ev->time);
	    }
	}	
}

GtkWidget *create_docklet() 
{
        GtkWidget *docklet;
	GtkWidget *vbox;
	GtkWidget *eventbox;
	GtkWidget *pixmap;
	glong data[1];
	GdkAtom kwm_dockwindow_atom;
	GdkAtom kde_net_system_tray_window_for_atom;

	docklet = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(docklet), "gg_status_plugin");
	gtk_window_set_wmclass(GTK_WINDOW(docklet), "GM_StatusDocklet", "gg");
	gtk_widget_set_usize(GTK_WIDGET(docklet), 22, 22);
	gtk_widget_realize(GTK_WIDGET(docklet));

	eventbox = gtk_event_box_new();
	gtk_widget_show(eventbox);
	gtk_container_add(GTK_CONTAINER(docklet), eventbox);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(eventbox), vbox);

	pixmap = create_pixmap(docklet, OFFLINE_IMG);
	gtk_object_set_data(GTK_OBJECT(docklet), "pixmap_docklet",
			    pixmap);
	gtk_box_pack_start(GTK_BOX(vbox), pixmap, TRUE, TRUE, 0);

	gtk_widget_show(pixmap);

	gtk_signal_connect(GTK_OBJECT(docklet), "button_press_event",
			   GTK_SIGNAL_FUNC(docklet_clicked_cb), NULL);
	kwm_dockwindow_atom = gdk_atom_intern("KWM_DOCKWINDOW", FALSE);
	kde_net_system_tray_window_for_atom = gdk_atom_intern("_KDE_NET_WM_SYSTEM_TRAY_WINDOW_FOR", FALSE);
	data[0] = TRUE;
	gdk_property_change(GTK_WIDGET(docklet)->window, kwm_dockwindow_atom,
			    kwm_dockwindow_atom, 32,
			    GDK_PROP_MODE_REPLACE, (guchar *)&data, 1);
	data[0] = 0;
	gdk_property_change(GTK_WIDGET(docklet)->window, kde_net_system_tray_window_for_atom,
			    XA_WINDOW, 32,
			    GDK_PROP_MODE_REPLACE, (guchar *)&data, 1);
	gtk_widget_show(docklet);
	return docklet;
}

#endif
