/* $Id: main.c,v 1.22 2002/12/01 21:17:22 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik <thrull@slackware.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "common.h"
#ifdef USE_GNOME
#include <gnome.h>
#endif
#if USE_APPLET
#include <applet-widget.h>
#endif

#if USE_APPLET || USE_DOCKAPP || USE_DOCKLET
#include "dock.h"
#endif

#include <sys/stat.h>
#include <string.h>
#include <signal.h>
#if defined(__NetBSD__) || defined(__OpenBSD__) || defined(__FreeBSD__)
#include <sys/wait.h>
#else
#include <wait.h>
#endif

#include "gg-types.h"
#include "gg.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "userstatus.h"


GGConfig config;
GGStatus status;

GtkWidget *window = NULL;

#ifdef USE_APPLET
GtkWidget *applet;
#endif

#ifdef USE_DOCKLET
GtkWidget *docklet;
#endif

GtkWidget *ignore_window = NULL;
GtkWidget *wyniki_szukaj = NULL;

GtkTooltips *tooltips = NULL;

GList *kontakty = NULL;
GList *sessions = NULL;
GList *ignore = NULL;
GList *msg_spool = NULL;
GList *children = NULL;
GList *unknown = NULL;

#define MAX_CHUNK_SIZE 1024

int write_contacts()
{
	gchar *path;
	FILE *fp;
	GList *tmplist;

	path = g_strconcat(config.homedir, "/userlist", NULL);

	fp = fopen(path, "w");

	if (!fp) {
		g_print
		    ("write_contacts(): Nie mog utworzy pliku z kontaktami!");
		exit(0);
	}

	chmod(path, S_IRUSR | S_IWUSR);

	tmplist = kontakty;

	while (tmplist) {
		GGContact *k;

		k = ((GGContact *) (tmplist->data));
		fprintf(fp, "%s;%s;%s;%s;%s;%s;",
			(k->first_name) ? k->first_name : k->display,
			(k->last_name) ? k->last_name : "",
			(k->nick) ? k->nick : k->display,
			(k->display) ? k->display : "",
			(k->mobile) ? k->mobile : "",
			(k->group) ? k->group : "");
		if (k->uin)
			fprintf(fp, "%d", k->uin);
		fprintf(fp, "\n");

		tmplist = tmplist->next;
	}
	fclose(fp);
	return 1;
}

void load_contacts()
{
	GtkWidget *lista;
	gchar *path;
	FILE *fp;
	GGContact *kontakt = NULL;
	gchar *line;
	GList *tmplist;

	lista = lookup_widget(window, "lista");
	if (lista == NULL) {
		g_error("lista not found\n");
		exit(-1);
	}
	gtk_clist_clear(GTK_CLIST(lista));

	path = g_strconcat(config.homedir, "/userlist", NULL);

	fp = fopen(path, "r");

	if (!fp) {
		g_free(path);
		path = g_strconcat(getenv("HOME"), "/.gg/userlist", NULL);
		g_warning("Prbuje odczyta z domylnej cieki %s\n", path);

		fp = fopen(path, "r");

		if (!fp) {
		    g_warning
			("Nie mog odczyta pliku z kontaktami. Tworz nowy.");
		
		    if (!write_contacts()) {
			g_error("Zbyt wiele bdw. Kocz program!");
	    		exit(-1);
		    }
		    return;
		}
	}
	
	g_free(path);
	
	g_list_free(kontakty);
	line = g_malloc0(MAX_CHUNK_SIZE);

	while (fgets(line, MAX_CHUNK_SIZE - 1, fp)) {
		gchar *buf = line;
		gchar **l, **tmp;
		gchar *first_name, *last_name, *nick, *display, *mobile,
		    *group, *uin;

		if (line[0] == '#' || strcmp(g_strstrip(line), "") == 0)
			continue;
		
		l = g_strsplit(buf, ";", 7);
		tmp = l;
		
		first_name = *l;
		l++;
		last_name = *l;
		l++;
		nick = *l;
		l++;
		display = *l;
		l++;
		mobile = *l;
		l++;
		group = *l;
		l++;
		uin = *l;

#ifdef DEBUG
		g_print("KONTAKT %s %s\n", uin, mobile);
#endif
		if ((!uin || !*uin) && (!mobile || !*mobile)) {
			continue;
		}

		// mobile mona zrobi null, bo g_strdup sobie z tym poradzi

		if (!strlen(mobile))
			mobile = NULL;

		kontakt = g_new0(GGContact, 1);
		if (uin != NULL)
		kontakt->uin = strtol(uin, NULL, 0);
		kontakt->first_name = g_strdup(first_name);
		kontakt->last_name = g_strdup(last_name);
		kontakt->nick = g_strdup(nick);
		kontakt->display = g_strdup(display);
		kontakt->mobile = g_strdup(mobile);
		kontakt->group = g_strdup(group);
		kontakt->status = GG_STATUS_OFFLINE;
		g_strfreev(tmp);
		if (kontakt->uin != 0
		    && gg_get_contact_by_uin(kontakt->uin) != NULL) {
			g_warning("Kontakt z uin=%d istnieje. Ignoruje.",
				  kontakt->uin);
		} else {
			kontakty = g_list_append(kontakty, kontakt);
		}

	}
	tmplist = kontakty;
	while (tmplist) {
		kontakt = ((GGContact *) (tmplist->data));
		add_kontakt_to_list(kontakt);
		tmplist = tmplist->next;
	}
	fclose(fp);
	g_free(line);
}

void read_config()
{
	FILE *fp;
	gchar *path;
	char line[MAX_CHUNK_SIZE];

	config.uin = 0;
	config.password = NULL;
	config.email = NULL;
	config.bold_font = g_strdup(FONT);
	config.auto_away = 600;
	config.auto_reconnect = 10;
	config.beep = 1;
	config.beep_msg = 1;
	config.beep_chat = 1;
	config.beep_notify = 1;
	config.display_color = 1;
	config.log = 0;
#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	config.main_on_start = 0;
#endif
	config.sms_send_app = NULL;
	config.sms_away = 0;
	config.sms_max_length = 100;
	config.send_on_enter = 0;
	config.private = 0;
	config.use_proxy = 0;
	config.proxy_port = 8080;
	config.connect_on_start = 1;
	config.last_sysmsg = 0;
	config.width = GG_MIN_WIDTH;
	config.height = GG_MIN_HEIGHT;
#if HAVE_ESD || HAVE_ARTS
 	config.user_sound = 1;
 	config.login_sound = 1;
	config.msg_sound = 1;
 	config.user_sound_path = g_strdup("usr.wav");
 	config.login_sound_path = g_strdup("yahoo.wav");
	config.msg_sound_path = g_strdup("msg.wav");
#endif	
 	config.away_msg = g_strdup(_("Zaraz wracam"));
 	config.away_msg_send = 1;
 	config.away_msg_ask = 1;
 	config.save_config_on_exit = 1;
 	config.save_contacts_on_exit = 1;
//	config.server = g_strdup_printf("%s:%d", GG_DEFAULT_HOST);
	config.popup_msg_windows = 0;
			
	path = g_strconcat(config.homedir, "/config", NULL);

	g_list_free(ignore);

	fp = fopen(path, "r");
	if (!fp) {
		g_free(path);
		path = g_strconcat(getenv("HOME"), "/.gg/config", NULL);
		g_warning("Trying to read default path %s\n", path);
		fp = fopen(path, "r");
		if (!fp) {
		    g_warning("Cannot read config file. Using defaults.");
		    write_config();
		    return;
		}
	}
	g_free(path);

	while (fgets(line, MAX_CHUNK_SIZE - 1, fp)) {
		if (g_strncasecmp(line, "uin ", 4) == 0) {
			config.uin = atoi(line + 4);
		} else
		if (g_strncasecmp(line, "password ", 9) == 0) {
			char *tmp;

			config.password = g_strdup(g_strstrip(line + 9));
			
			if (*config.password == 1) {
			    tmp = config.password;
			    config.password++;
			    config.password = base64_decode(config.password);
			    free(tmp);
			}
		} else
		
		if (g_strncasecmp(line, "email ", 6) == 0) {
			config.email = g_strdup(g_strstrip(line + 6));
		} else
		if (g_strncasecmp(line, "bold_font ", 10) == 0) {
			config.bold_font = g_strdup(g_strstrip(line + 10));
		} else

		if (g_strncasecmp(line, "auto_away ", 10) == 0) {
			config.auto_away = atoi(line + 10);
		} else
		if (g_strncasecmp(line, "auto_reconnect ", 15) == 0) {
			config.auto_reconnect = atoi(line + 15);
		} else
		if (g_strncasecmp(line, "beep ", 5) == 0) {
			config.beep = atoi(line + 5);
		} else
		if (g_strncasecmp(line, "beep_msg ", 9) == 0) {
			config.beep_msg = atoi(line + 9);
		} else
		if (g_strncasecmp(line, "beep_chat ", 10) == 0) {
			config.beep_chat = atoi(line + 10);
		} else
		if (g_strncasecmp(line, "beep_notify ", 12) == 0) {
			config.beep_chat = atoi(line + 12);
		} else
		if (g_strncasecmp(line, "display_color ", 14) == 0) {
			config.display_color = atoi(line + 14);
		} else
		if (g_strncasecmp(line, "log ", 4) == 0) {
			config.log = atoi(line + 4);
		} else
#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
		if (g_strncasecmp(line, "main_on_start ", 14) == 0) {
			config.main_on_start = atoi(line + 14);
		} else
#endif
		if (g_strncasecmp(line, "sms_away ", 9) == 0) {
			config.sms_away = atoi(line + 9);
		} else
		if (g_strncasecmp(line, "sms_max_length ", 15) == 0) {
			config.sms_max_length = atoi(line + 15);
		} else
		if (g_strncasecmp(line, "ignore ", 7) == 0) {
			guint *ignore_uin;
			ignore_uin = g_new0(guint, 1);

			*ignore_uin = atoi(line + 7);

			ignore = g_list_append(ignore, ignore_uin);
		} else
		if (g_strncasecmp(line, "send_on_enter ", 14) == 0) {
			config.send_on_enter = atoi(line + 14);
		} else
		if (g_strncasecmp(line, "private ", 8) == 0) {
			config.private = atoi(line + 8);
		} else
		if (g_strncasecmp(line, "use_proxy ", 10) == 0) {
			config.use_proxy = atoi(line + 10);
		} else
		if (g_strncasecmp(line, "proxy_port ", 11) == 0) {
			config.proxy_port = atoi(line + 11);
		} else
		if (g_strncasecmp(line, "proxy_host ", 11) == 0) {
			config.proxy_host =
			    g_strdup(g_strstrip(line + 11));
		} else
		if (g_strncasecmp(line, "sms_send_app ", 13) == 0) {
			config.sms_send_app =
			    g_strdup(g_strstrip(line + 13));
		} else
		if (g_strncasecmp(line, "connect_on_start ", 17) == 0) {
			config.connect_on_start = atoi(line + 17);
		} else
		if (g_strncasecmp(line, "last_sysmsg ", 12) == 0) {
			config.last_sysmsg = atoi(line + 12);
		} else
		if (g_strncasecmp(line, "width ", 6) == 0) {
			config.width = atoi(line + 6);
		} else
		if (g_strncasecmp(line, "height ", 7) == 0) {
			config.height = atoi(line + 7);
		} else
#if HAVE_ESD || HAVE_ARTS
		if (g_strncasecmp(line, "user_sound ", 11) == 0) {
			config.user_sound = atoi(line + 11);
		} else
		if (g_strncasecmp(line, "login_sound ", 12) == 0) {
			config.login_sound = atoi(line + 12);
		} else
		if (g_strncasecmp(line, "msg_sound ", 10) == 0) {
			config.msg_sound = atoi(line + 10);
		} else

		if (g_strncasecmp(line, "user_sound_path ", 16) == 0) {
			config.user_sound_path = g_strdup(g_strstrip(line + 16));
		} else
		if (g_strncasecmp(line, "login_sound_path ", 17) == 0) {
			config.login_sound_path = g_strdup(g_strstrip(line + 17));
		} else
		if (g_strncasecmp(line, "msg_sound_path ", 15) == 0) {
			config.msg_sound_path = g_strdup(g_strstrip(line + 15));
		} else
		if (g_strncasecmp(line, "sound_app_file ", 15) == 0) {
			config.login_sound_path = g_strdup(g_strstrip(line + 15));
		} else
		if (g_strncasecmp(line, "sound_msg_file ", 15) == 0) {
			config.msg_sound_path = g_strdup(g_strstrip(line + 15));
		} else
#endif /* HAVE_ESD */
		if (g_strncasecmp(line, "save_config_on_exit ", 20) == 0) {
			config.save_config_on_exit = atoi(line + 20);
		} else
		if (g_strncasecmp(line, "save_contacts_on_exit ", 22) == 0) {
			config.save_contacts_on_exit = atoi(line + 22);
		} else
		if (g_strncasecmp(line, "away_msg ", 9) == 0) {
			gchar *p;
			config.away_msg = g_strdup(g_strstrip(line + 9));
			p = config.away_msg;
			while(*p++)
				if(*p == '|')
					*p = '\n';
		} else
		if (g_strncasecmp(line, "away_msg_send ", 14) == 0) {
			config.away_msg_send = atoi(line + 14);
		} else
		if (g_strncasecmp(line, "away_msg_ask ", 13) == 0) {
			config.away_msg_ask = atoi(line + 13);
		} else
		if (g_strncasecmp(line, "server ", 7) == 0) {
			config.server = g_strdup(g_strstrip(line + 7));
		} else
		if (g_strncasecmp(line, "popup_msg_windows ", 18) == 0) {
			config.popup_msg_windows = atoi(line + 18);
		} else
		if (g_strncasecmp(line, "status ", 7) == 0) {
			config.status = atoi(line + 7);
		} else
		if (g_strncasecmp(line, "reason ", 7) == 0) {
			config.reason = g_strdup(g_strstrip(line + 7));
		} else {
		    unknown = g_list_append(unknown, g_strdup(g_strstrip(line)));
		    g_print("UNKOWN variable%s\n", g_strstrip(line));
		}

	}
#ifdef DEBUG
	g_print("read_config(): config: %d ********\n", config.uin);
#endif
	fclose(fp);
}

void write_config()
{
	FILE *fp;
	gchar *path;
	GList *tmp_list;
	gchar *tmp;
	
	if (window != NULL) {
	    config.width=window->allocation.width;
	    config.height=window->allocation.height;
	}
	path = g_strconcat(config.homedir, "/config", NULL);

	fp = fopen(path, "w");

	if (fp == NULL) {
		g_warning
		    ("write_config(): Cannot write config file. Giving up.");
		return;
	}

	chmod(path, S_IRUSR | S_IWUSR);

	fprintf(fp, "uin %d\n", config.uin);
	
	if (config.password != NULL)
	{
	tmp = base64_encode(config.password);
	fprintf(fp, "password \1%s\n", tmp);
	free(tmp);
	}
		
	if (config.email != NULL)
		fprintf(fp, "email %s\n", config.email);
	fprintf(fp, "auto_away %d\n", config.auto_away);
	fprintf(fp, "auto_reconnect %d\n", config.auto_reconnect);
	fprintf(fp, "beep %d\n", config.beep);
	fprintf(fp, "beep_msg %d\n", config.beep_msg);
	fprintf(fp, "beep_chat %d\n", config.beep_chat);
	fprintf(fp, "beep_notify %d\n", config.beep_notify);
	fprintf(fp, "display_color %d\n", config.display_color);
	fprintf(fp, "log %d\n", config.log);
#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	fprintf(fp, "main_on_start %d\n", config.main_on_start);
#endif
	if (config.sms_send_app != NULL)
		fprintf(fp, "sms_send_app %s\n", config.sms_send_app);
	fprintf(fp, "sms_away %d\n", config.sms_away);
	fprintf(fp, "sms_max_length %d\n", config.sms_max_length);
	fprintf(fp, "bold_font %s\n", config.bold_font);
	fprintf(fp, "send_on_enter %d\n", config.send_on_enter);
	fprintf(fp, "private %d\n", config.private);
	fprintf(fp, "use_proxy %d\n", config.use_proxy);
	fprintf(fp, "proxy_port %d\n", config.proxy_port);
	if (config.proxy_host != NULL)
		fprintf(fp, "proxy_host %s\n", config.proxy_host);

	fprintf(fp, "connect_on_start %d\n", config.connect_on_start);
	fprintf(fp, "last_sysmsg %d\n", config.last_sysmsg);
	fprintf(fp, "width %d\n", config.width);
	fprintf(fp, "height %d\n", config.height);
#if HAVE_ESD || HAVE_ARTS
	fprintf(fp, "user_sound %d\n", config.user_sound);
 	fprintf(fp, "login_sound %d\n", config.login_sound);
 	fprintf(fp, "msg_sound %d\n", config.msg_sound);
	fprintf(fp, "user_sound_path %s\n", config.user_sound_path);
 	fprintf(fp, "sound_app_file %s\n", config.login_sound_path);
 	fprintf(fp, "sound_msg_file %s\n", config.msg_sound_path);

#endif
 	if(config.away_msg != NULL) {
 		gchar *p, *s;
 		p = s = g_strdup(config.away_msg);
		while(*p++)
 			if(*p == '\n')
 				*p = '|';
 		fprintf(fp, "away_msg %s\n", s);
 		g_free(s);
 	}
 	fprintf(fp, "away_msg_send %d\n", config.away_msg_send);
	fprintf(fp, "away_msg_ask %d\n", config.away_msg_ask);
 	fprintf(fp, "save_config_on_exit %d\n", config.save_config_on_exit);
	fprintf(fp, "save_contacts_on_exit %d\n", config.save_contacts_on_exit);
	fprintf(fp, "server %s\n", config.server);
	fprintf(fp, "popup_msg_windows %d\n", config.popup_msg_windows);
	fprintf(fp, "status %d\n", status.state);
	fprintf(fp, "reason %s\n", config.reason ? config.reason : "");

	tmp_list = unknown;
	while (tmp_list) {
		fprintf(fp, "%s\n", (gchar *) tmp_list->data);
		tmp_list = tmp_list->next;
	}

	tmp_list = ignore;
	while (tmp_list) {
		fprintf(fp, "ignore %d\n", *(guint *) tmp_list->data);
		tmp_list = tmp_list->next;
	}
	fclose(fp);
	free(path);
}

/* na razie mao przdatne ;-) */
int check_config()
{
	if (config.uin == 0) {
		return 0;
	}
	return 1;
}

static gint gg_init(gpointer data)
{
	status.retry = config.auto_reconnect;

	if (!check_config())
		config_dialog();

	load_contacts();

	if (config.uin != 0 && config.password != NULL && config.connect_on_start)
		gg_connect_to_server();
	
	return TRUE;
}

void shutdown_gg()
{
	if (config.save_config_on_exit) {
	    write_config();
	}
	if (config.save_contacts_on_exit) {
	    write_contacts();
	}
	
#ifdef USE_APPLET
	applet_widget_remove(APPLET_WIDGET(applet));
	applet_widget_gtk_main_quit();
#else
	gtk_main_quit();
#endif				/* USE_APPLET */
}

void sigchld(int sig)
{
	int pid, status;
	GGSession *sesja;

	while ((pid = wait(&status)) != -1) {
	    waitpid(pid, NULL, 0);
	    if ((status != 0) && (sesja = gg_find_session_by_sms_pid(pid)) != NULL)
		show_error_dialog("SMS nie zosta wysany poprawnie!");
	}
}

void my_g_print(char *msg)
{

#ifdef DEBUG
    fprintf(stderr, msg);
#endif

}
int main(int argc, char **argv)
{
#ifdef USE_APPLET
	gchar applet_name[] = "gg";
#endif
	config.homedir = NULL;

	g_set_print_handler((GPrintFunc) my_g_print);

	if (getenv("CONFIG_DIR"))
	    config.homedir = g_strconcat(getenv("HOME"),"/", 
		getenv("CONFIG_DIR"), "/gg", NULL);
	else
	    config.homedir = g_strconcat(getenv("HOME"), "/.gg", NULL);

	g_print("Creating config dir? %s\n", config.homedir);
	mkdir(config.homedir, 0700);
	
	read_config();

		
	signal(SIGPIPE, SIG_IGN);
	signal(SIGCHLD, sigchld);
	
	memset(&status, 0, sizeof(GGStatus));
	status.state = GG_STATUS_OFFLINE;

	
#ifdef ENABLE_NLS
	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);
#endif

#ifdef USE_GNOME

#ifdef USE_APPLET
	applet_widget_init(applet_name, VERSION, argc, argv, NULL,
			   0, NULL);
#else
	gnome_init("gnu_gadu", VERSION, argc, argv);
#endif				/* USE_APPLET */

#else
	gtk_set_locale();
	gtk_init(&argc, &argv);
#endif				/* USE_GNOME */

	add_pixmap_directory(PACKAGE_SOURCE_DIR "/pixmaps");
	add_pixmap_directory(PACKAGE_DATA_DIR "/pixmaps");

	add_sound_directory(PACKAGE_SOURCE_DIR "/sounds");
	add_sound_directory(PACKAGE_DATA_DIR "/sounds");
	window = create_main_window();

#ifdef USE_DOCKLET
	docklet = create_docklet();
#endif

#ifdef USE_DOCKAPP
        wmgg_start(window);
#endif

#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	if (config.main_on_start == 0)
		gtk_widget_realize(window);
	else
		gtk_widget_show(window);
#else
	gtk_widget_show(window);
#endif
				/* USE_APPLET || USE_DOCKLET */

#ifdef USE_APPLET
	applet = create_applet();
	if (!applet) {
	    g_warning("Nie mog stworzyc appletu!!!");
	} else {
	    gtk_widget_show(applet);
	}
#endif
	gtk_init_add(gg_init, NULL);
	
	tooltips = gtk_tooltips_new();
	gtk_tooltips_enable(tooltips);
	gtk_tooltips_set_delay(tooltips, 1);
	
#ifdef USE_APPLET
	applet_widget_gtk_main();
#else
	gtk_main();
#endif

	g_free(config.homedir);
	
	return 0;
}
