/* $Id: userstatus.c,v 1.16 2003/01/31 09:39:08 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik <thrull@slackware.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "common.h"
#ifdef USE_GNOME
#include <gnome.h>
#endif

#if USE_APPLET || USE_DOCKAPP || USE_DOCKLET
#include "dock.h"
#endif

#include "gg-types.h"
#include "gg.h"
#include "support.h"
#include "userstatus.h"

extern GGConfig config;
extern GGStatus status;

extern GtkWidget *window;

#ifdef USE_APPLET
extern GtkWidget *applet;
#endif

extern GList *kontakty;
extern GList *sessions;
extern GList *ignore;
extern GList *msg_spool;

#define MAX_CHUNK_SIZE 1024

void set_status_img_status(guint status)
{
	GtkWidget *widget = NULL;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GdkColormap *colormap;
	gchar *filename = NULL;
	gchar *filename_applet = NULL;
	gchar *widget_name = NULL;
	gchar *fullpath;
	
	switch (status) {
	case GG_STATUS_OFFLINE:
		widget_name = "online_pixmap";
		filename = ONLINE_CON_IMG;
		filename_applet = OFFLINE_IMG;
		break;

	case GG_STATUS_OFFLINE_DESCR:
		widget_name = "online_pixmap";
		filename = ONLINE_CON_IMG;
		filename_applet = OFFLINE_DESCR_IMG;
		break;

	case GG_STATUS_ONLINE:
		widget_name = "online_pixmap";
		filename = ONLINE_IMG;
		filename_applet = ONLINE_IMG;
		break;

	case GG_STATUS_ONLINE_DESCR:
		set_status_img_status(GG_STATUS_ONLINE);
		widget_name = "descr_pixmap";
		filename = ONLINE_DESCR_IMG;
		filename_applet = ONLINE_DESCR_IMG;
		break;
	case GG_STATUS_AWAY:
		widget_name = "online_pixmap";
		filename = ONLINE_IMG;
		filename_applet = AWAY_IMG;
		break;
		
	case GG_STATUS_AWAY_DESCR:
		set_status_img_status(GG_STATUS_ONLINE);
		widget_name = "descr_pixmap";
		filename = AWAY_DESCR_IMG;
		filename_applet = AWAY_DESCR_IMG;
		break;

	case GG_STATUS_INVISIBLE:
		widget_name = "online_pixmap";
		filename = ONLINE_IMG;
		filename_applet = INVISIBLE_IMG;
		break;

	case GG_STATUS_INVISIBLE_DESCR:
		set_status_img_status(GG_STATUS_ONLINE);
		widget_name = "descr_pixmap";
		filename = INVISIBLE_DESCR_IMG;
		filename_applet = INVISIBLE_DESCR_IMG;
		break;
	default:
		break;
	}
	
	if (widget_name) {
	    widget = lookup_widget(window, widget_name);
    	    g_return_if_fail(widget != NULL);
	}
	if (!msg_spool) {
	
#ifdef USE_APPLET
	    applet_change_status_pixmap(filename_applet);
#endif

#ifdef USE_DOCKAPP
	    wmgg_change_status_pixmap(filename_applet);
#endif

#ifdef USE_DOCKLET
	    docklet_change_status_pixmap(filename_applet);
#endif
	}
	
	colormap = gtk_widget_get_colormap(window);
	fullpath = GPP(filename);
	pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, colormap, &mask,
						     NULL,
						     fullpath);
	g_free(fullpath);
	if (pixmap != NULL)
	    change_pixmap(widget, pixmap, mask);
}

void set_dock_icon(guint icon_id) 
{
    gchar *filename_applet;
    
    switch (icon_id) {
	case GG_STATUS_OFFLINE:
		filename_applet = OFFLINE_IMG;
		break;

	case GG_STATUS_OFFLINE_DESCR:
		filename_applet = OFFLINE_DESCR_IMG;
		break;

	case GG_STATUS_ONLINE:
		filename_applet = ONLINE_IMG;
		break;

	case GG_STATUS_ONLINE_DESCR:
		filename_applet = ONLINE_DESCR_IMG;
		break;
	case GG_STATUS_AWAY:
		filename_applet = AWAY_IMG;
		break;
		
	case GG_STATUS_AWAY_DESCR:
		filename_applet = AWAY_DESCR_IMG;
		break;

	case GG_STATUS_INVISIBLE:
		filename_applet = INVISIBLE_IMG;
		break;
	case GG_STATUS_INVISIBLE_DESCR:
		filename_applet = INVISIBLE_DESCR_IMG;
		break;
	case GG_EMPTY:
	    filename_applet = GG_EMPTY_IMG;
	    break;
	case GG_STATUS_NEW_MSG:
	default:
	    filename_applet = GG_NEW_MSG_IMG;
	    break;
    }

#ifdef USE_APPLET
	applet_change_status_pixmap(filename_applet);
#endif

#ifdef USE_DOCKAPP
	wmgg_change_status_pixmap(filename_applet);
#endif

#ifdef USE_DOCKLET
	docklet_change_status_pixmap(filename_applet);
#endif

}
/* zmiana statusu i obrazka statusu jednego z naszych kontaktw */
void change_kontakt_status(GGContact * kontakt, guint prev_status)
{
	gint row;
	GtkWidget *lista;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GdkColormap *colormap;
	GGSession *sesja;
	gchar *picname;
	gchar *title=NULL;
	gchar *fullpath;

	g_return_if_fail(kontakt != NULL);

/*	if (kontakt->status == GG_STATUS_OFFLINE) {
	    remove_kontakt_from_list(kontakt);
	} else {
	    add_kontakt_to_list(kontakt);
	}
*/
	lista = lookup_widget(window, "lista");

	g_return_if_fail(lista != NULL);


	row = gtk_clist_find_row_from_data(GTK_CLIST(lista), kontakt);

	g_return_if_fail(row != -1);

	g_print("KONTAKT status=%d mobile=%s uin=%d\n", kontakt->status,
		kontakt->mobile, kontakt->uin);

	switch (kontakt->status) {
	case GG_STATUS_OFFLINE:
		picname = kontakt->mobile ? OFFLINE_MOBILE_IMG : OFFLINE_IMG;
		break;
	case GG_STATUS_OFFLINE_DESCR:
		picname = kontakt->mobile ? OFFLINE_MOBILE_DESCR_IMG : OFFLINE_DESCR_IMG;
		break;
	case GG_STATUS_ONLINE:
		picname = kontakt->mobile ? ONLINE_MOBILE_IMG : ONLINE_IMG;
		break;

	case GG_STATUS_ONLINE_DESCR:
		picname = kontakt->mobile ? ONLINE_MOBILE_DESCR_IMG : ONLINE_DESCR_IMG;
		break;
	case GG_STATUS_AWAY_DESCR:
		picname = kontakt->mobile ? AWAY_MOBILE_DESCR_IMG : AWAY_DESCR_IMG;
		break;
	case GG_STATUS_AWAY:
		picname = kontakt->mobile ? AWAY_MOBILE_IMG : AWAY_IMG;
		break;
	case GG_STATUS_MOBILE_ONLY:
		picname = MOBILE_IMG;
		break;

	default:
		picname = kontakt->mobile ? OFFLINE_MOBILE_IMG : OFFLINE_IMG;
		break;
	}

	colormap = gtk_widget_get_colormap(lista);
	fullpath = GPP(picname);
	pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, colormap, &mask,
						     NULL,
						     fullpath);
	g_free(fullpath);


	if (pixmap != NULL) {
		GdkPixmap *old_pixmap;
		GdkBitmap *old_mask;
		guint8 spacing;
		gchar *text;
				
		gtk_clist_get_pixtext(GTK_CLIST(lista), row, 0, &text, &spacing, &old_pixmap, &old_mask);
		gtk_clist_set_pixtext(GTK_CLIST(lista), row, 0, text, 3,
				      pixmap, mask);
		if (old_pixmap && old_mask) {
		    gdk_pixmap_unref(old_pixmap);
		    gdk_bitmap_unref(old_mask);
		}
	}

	gtk_clist_sort(GTK_CLIST(lista));

	if((sesja=gg_find_session(kontakt->uin)))
	{
		if(sesja->chat_window)
		{
			title=g_strdup_printf("Rozmowa z %s (%d) - %s",
					kontakt->nick, kontakt->uin,
					gg_get_status_as_string(kontakt->uin));

			gtk_window_set_title(GTK_WINDOW(sesja->chat_window), title);

			g_free(title);
		}
	}

#ifdef USE_DOCKAPP
	wmgg_contact_change_status(kontakt->nick, kontakt->status, prev_status);
#endif 
}

void add_kontakt_to_list(GGContact * kontakt)
{
	gint row;
	gchar *nick;
	GtkWidget *lista;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GdkColormap *colormap;
	gchar *fullpath;
	
	if (gg_is_ignored(kontakt->uin))
		return;

	lista = lookup_widget(window, "lista");
	g_return_if_fail (lista != NULL);    
	
	if (!kontakt->nick || !*kontakt->nick)
	    if (!kontakt->first_name || !*kontakt->first_name)
		nick = g_strdup_printf("%d", kontakt->uin);
	    else 
		nick = kontakt->first_name;
	else 
	    nick = kontakt->nick;

	row = gtk_clist_append(GTK_CLIST(lista), &nick);
	gtk_clist_set_row_data(GTK_CLIST(lista), row, kontakt);
	colormap = gtk_widget_get_colormap(lista);
	fullpath = GPP((kontakt->uin ? (kontakt->mobile ? OFFLINE_MOBILE_IMG : OFFLINE_IMG) : MOBILE_IMG));

	pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, colormap, &mask,
						     NULL,
						     fullpath);
	g_free(fullpath);

	if (pixmap != NULL) {
		gtk_clist_set_pixtext(GTK_CLIST(lista), row, 0, nick, 3,
				      pixmap, mask);
	}
	gtk_clist_sort(GTK_CLIST(lista));
}

void remove_kontakt_from_list(GGContact * kontakt)
{
	gint row;
	GtkWidget *lista;

	lista = lookup_widget(window, "lista");
	g_return_if_fail (lista != NULL);    
	row = gtk_clist_find_row_from_data(GTK_CLIST(lista), kontakt);
	
	gtk_clist_remove(GTK_CLIST(lista), row);
}
