# generate pdf version of the doc

import docutils.writers
import docutils
import parser
import docutils.core
import os
import sys

from reportlab.platypus import Spacer, SimpleDocTemplate, Table, TableStyle
from reportlab.pdfgen.canvas import Canvas
from reportlab.lib.pagesizes import A4
from reportlab.lib import colors
from reportlab.platypus.paragraph import Paragraph
from reportlab.platypus.xpreformatted import XPreformatted
from reportlab.lib.styles import getSampleStyleSheet, ParagraphStyle
from reportlab.platypus.flowables import Image, Spacer, PageBreak
from reportlab.lib.enums import TA_LEFT, TA_RIGHT, TA_CENTER, TA_JUSTIFY


#######################################################################
# pdf formatter
#######################################################################
class Formater(SimpleDocTemplate):
    pass


class Style:
    def __init__(self):
        print 'style?'
        self.title2Style = ParagraphStyle('title2', fontSize=14, leading=20,
                                          spaceBefore=10, spaceAfter=10,
                                          backColor=colors.lightcoral)
        self.title3Style = ParagraphStyle('title3', fontSize=12, leading=16,
                                          spaceBefore=10, spaceAfter=10,
                                          backColor=colors.lightcyan)
        self.paragraphStyle = ParagraphStyle('para',
                                             alignement = TA_JUSTIFY,
                                             spaceAfter=5,
                                             fontSize = 10)
        self.literalBlockStyle = ParagraphStyle('literalBlock',
                                                fontSize = 10,
                                                fontName='Courier')
        
        self.emphasisStyle = '<i>%s</i>'
        self.strongStyle   = '<b>%s</b>'
        self.literalStyle  = '<font name="Courier">%s</font>'
        print 'done style'
        
#######################################################################
# Custom writers
#######################################################################

def toxml(s):
    return s.replace('&','&amp;').replace('<','&lt;').replace('>','&gt;')

class Translator(docutils.nodes.NodeVisitor):
    def __init__(self, d, style = None):
        docutils.nodes.NodeVisitor.__init__(self,d)
        self.style = style
        self.flow = []
        self.section = 0
        self.current = ''
        
        self.enum = []
        self.depth = 0

    def visit_section(self, node):
        self.section += 1

    def depart_section(self, node):
        self.section -= 1

    def visit_title(self, node):
        if self.section == 2:
            self.flow.append(Paragraph(' '+str(node[0]), self.style.title2Style))
        elif self.section == 3:
            self.flow.append(Paragraph(' '+str(node[0]), self.style.title3Style))
        raise docutils.nodes.SkipNode
        
    def visit_Text(self, node):
        self.current += toxml(str(node))

    def visit_system_message(self, node):
        raise docutils.nodes.SkipNode
        print '<system_message>'

    def visit_paragraph(self, node):
        self.current = ''
    
    def depart_paragraph(self, node):
        self.flow.append(Paragraph(self.current, self.style.paragraphStyle))
    
    def visit_literal(self, node):
        self.current += self.style.literalStyle%toxml(str(node[0]))
        raise docutils.nodes.SkipNode

    def visit_literal_block(self, node):
        self.current = ''

    def depart_literal_block(self, node):
        self.flow.append(XPreformatted(self.current, self.style.literalBlockStyle))
    
    def visit_definition_list(self, node):
        raise docutils.nodes.SkipNode
        if self.depth > 0:
            self.file.write('.RS\n')
        self.depth += 1

    def depart_definition_list(self, node):
        raise docutils.nodes.SkipNode
        self.depth -= 1

    def visit_definition_list_item(self, node):
        raise docutils.nodes.SkipNode
        self.file.write('.TP\n')

    def depart_definition_list_item(self, node):
        raise docutils.nodes.SkipNode
        self.file.write('.PP\n')

    def visit_term(self, node):
        pass

    def visit_definition(self, node):
        raise docutils.nodes.SkipNode
        self.file.write('\n')

    def depart_definition(self, node):
        pass

    def visit_emphasis(self, node):
        self.current += self.style.emphasisStyle%str(node[0])
        raise docutils.nodes.SkipNode
    
    def visit_strong(self, node):
        self.current += self.style.strongStyle%str(node[0])
        raise docutils.nodes.SkipNode
    
    def visit_block_quote(self, node):
        print '<block-quote>'
        raise docutils.nodes.SkipNode

    def depart_block_quote(self, node):
        raise docutils.nodes.SkipNode

    def visit_enumerated_list(self, node):
        raise docutils.nodes.SkipNode
        self.enum.append(0)
        self.stack()
        
    def depart_enumerated_list(self, node):
        raise docutils.nodes.SkipNode
        del self.enum[-1]
        self.unstack()

    def visit_bullet_list(self, node):
        raise docutils.nodes.SkipNode
        self.enum.append('\\(bu')
        self.stack()

    def depart_bullet_list(self, node):
        raise docutils.nodes.SkipNode
        del self.enum[-1]
        self.unstack()

    def visit_list_item(self, node):
        raise docutils.nodes.SkipNode
        if self.enum[-1].__class__ == int:
            self.enum[-1] += 1
        self.file.write('.IP %s 4\n'%str(self.enum[-1]))

    def visit_reference(self, node):
        raise docutils.nodes.SkipNode
        print '<reference>', node

    def visit_target(self, node):
        raise docutils.nodes.SkipNode
        print '<target>', node

    def visit_tip(self, node):
        raise docutils.nodes.SkipNode
        self.stack()
        self.file.write('\fBTip:\fR\n')

    def visit_important(self, node):
        raise docutils.nodes.SkipNode
        self.stack()
        self.file.write('\fBImprotant:\fR\n')

    def visit_note(self, node):
        raise docutils.nodes.SkipNode
        self.stack()
        self.file.write('\fBNote:\fR\n')

    def depart_tip(self, node):
        raise docutils.nodes.SkipNode
        self.unstack()

    def depart_note(self, node):
        raise docutils.nodes.SkipNode
        self.unstack()
        
    def depart_important(self, node):
        raise docutils.nodes.SkipNode
        self.unstack()

    def unknown_departure(self, node):
        pass


class Writer(docutils.writers.Writer):
    def __init__(self, filename):
        docutils.writers.Writer.__init__(self)
        self.filename = filename
        self.output = ''
        
    def translate(self):
        style = Style()
        t = Translator(self.document, style)
        print 'translate'
        for e in [ self.document.manpages_entries[i] for i in self.document.manpages ]:
            #for l in e['links']:
            #    fn = os.path.join(self.path,l+'.'+e['volume'])
            #    print "linking %s -> %s(%s) ..."%(fn, e['page'], e['volume'])
            #    f = open(fn,'w')
            #    f.write(".so man%s/%s.%s\n"%(e['volume'], e['page'], e['volume']))
            #    f.close()
            #fn = os.path.join(self.path,e['page']+'.'+e['volume'])
            #print "writing %s ..."%fn
            #f = open(fn,'w')
            #f.write('.TH "%s" %s GGI\n'%(e['page'], e['volume']))
            #d = Translator(self.document, f)
            #e['node'].walkabout(d)
            #f.close()
            e['node'].walkabout(t)
            t.flow.append(PageBreak())
        print 'build'
        SimpleDocTemplate(self.filename, pagesize = A4).build(t.flow)
        
if __name__ == '__main__':
    docutils.core.publish_file(source = open(sys.argv[1]),
                               destination = open('/dev/null','w'),
                               writer = Writer(sys.argv[2]),
                               parser = parser.Parser())
