# generated automatically by aclocal 1.7.4 -*- Autoconf -*-

# Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002
# Free Software Foundation, Inc.
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

dnl ======================================
dnl GGZ Gaming Zone - Configuration Macros
dnl ======================================
dnl
dnl Copyright (C) 2001, 2002 Josef Spillner, dr_maux@users.sourceforge.net
dnl This file has heavily been inspired by KDE's acinclude :)
dnl It is published under the conditions of the GNU General Public License.
dnl
dnl ======================================
dnl
dnl This file is common to most GGZ modules, and should be kept in sync
dnl between them all.  Currently the following modules use it:
dnl kde-games, kde-client, gtk-games, gtk-client, utils, grubby,
dnl ggz-client-libs, ggzd, gnome-client, txt-client.
dnl See /docs/ggz-project/buildsystem for documentation.
dnl
dnl ======================================
dnl
dnl History:
dnl 2001-05-??: first version to find easysock and ggzcore
dnl 2001-09-09: include libggz[d]mod support, and rename ac_find_file
dnl 2001-11-05: backport from copenhagen, and more macros
dnl 2001-12-16: updated for new ggzmod, imported to gtk-games and gtk-client
dnl 2002-01-12: include libggz support; imported to ggz-client-libs and ggzd
dnl 2002-01-18: remove easysock functions; look in prefix dirs for
dnl             includes and libs
dnl 2002-08-20: change -I<directory> to -isystem<directory> to avoid
dnl             warnings in gcc3
dnl 2002-09-25: added AC_GGZ_ERROR, AC_GGZ_REMOVEDUPS, AC_GGZ_INIT, allowing
dnl             for more control over what is going to happen
dnl 2002-10-12: added action-if-found and action-if-not-found parameters to
dnl             all primary macros

dnl ------------------------------------------------------------------------
dnl Content of this file:
dnl ------------------------------------------------------------------------
dnl AC_GGZ_LIBGGZ - find the libggz headers and libraries
dnl AC_GGZ_GGZCORE - find the ggzcore headers and libraries
dnl AC_GGZ_CONFIG - find the ggz-config tool and set up configuration
dnl AC_GGZ_GGZMOD - find the ggzmod library
dnl AC_GGZ_GGZDMOD - find the ggzdmod library
dnl AC_GGZ_SERVER - set up game and room path for ggzd game servers
dnl AC_GGZ_INTL - ensure proper i18n tools installation
dnl
dnl Each macro takes two arguments:
dnl   1.  Action-if-found (or empty for no action).
dnl   2.  Action-if-not-found (or empty for error, or "ignore" to ignore).
dnl ------------------------------------------------------------------------
dnl Internal functions:
dnl ------------------------------------------------------------------------
dnl AC_GGZ_INIT - initialization
dnl AC_GGZ_ERROR - user-friendly error messages
dnl AC_GGZ_FIND_FILE - macro for convenience (thanks kde)
dnl AC_GGZ_REMOVEDUPS - eliminate duplicate list elements
dnl

dnl ------------------------------------------------------------------------
dnl Find a directory containing a single file
dnl Synopsis: AC_GGZ_FIND_FILE(file, directorylist, <returnvar>)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    echo "configure: __oline__: $i/$j" >&AC_FD_CC
    if test -r "$i/$j"; then
      echo "taking that" >&AC_FD_CC
      $3=$i
      break 2
    fi
  done
done
])

dnl ------------------------------------------------------------------------
dnl Remove duplicate entries in a list, and remove all NO's
dnl Synopsis: AC_GGZ_REMOVEDUPS(list, <returnlist>)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_REMOVEDUPS,
[
ret=""
for i in $1; do
  add=yes
  for j in $ret; do
    if test "x$i" = "x$j"; then
      add=no
    fi
  done
  if test "x$i" = "xNO"; then
    add=no
  fi
  if test "x$add" = "xyes"; then
  ret="$ret $i"
  fi
done
$2=$ret
])

dnl ------------------------------------------------------------------------
dnl User-friendly error messages
dnl Synopsis: AC_GGZ_ERROR(libraryname, headerdirlist, libdirlist)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_ERROR,
[
  AC_MSG_WARN([no
  The library '$1' does not seem to be installed correctly.
  Headers searched in: $2
  Libraries searched in: $3
  Please read QuickStart.GGZ in order to fix this.
  ])
  exit 1
])

dnl ------------------------------------------------------------------------
dnl Initialization, common values and such
dnl Synopsis: AC_GGZ_INIT([export], [defaults])
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_INIT,
[
if test "x${prefix}" = "xNONE"; then
   ac_ggz_prefix_incdir="${ac_default_prefix}/include"
   ac_ggz_prefix_libdir="${ac_default_prefix}/lib"
   ac_ggz_prefix_bindir="${ac_default_prefix}/bin"
   ac_ggz_prefix_etcdir="${ac_default_prefix}/etc"
else
   ac_ggz_prefix_incdir="${prefix}/include"
   ac_ggz_prefix_libdir="${prefix}/lib"
   ac_ggz_prefix_bindir="${prefix}/bin"
   ac_ggz_prefix_etcdir="${prefix}/etc"
fi
ac_ggz_stdinc="$ac_ggz_prefix_incdir"
ac_ggz_stdlib="$ac_ggz_prefix_libdir"
ac_ggz_stdbin="$ac_ggz_prefix_bindir"
ac_ggz_stdetc="$ac_ggz_prefix_etcdir"
if test "x$1" = "xdefaults" || test "x$2" = "xdefaults"; then
  ac_ggz_stdinc="$ac_ggz_stdinc /usr/local/include /usr/include"
  ac_ggz_stdlib="$ac_ggz_stdlib /usr/local/lib /usr/lib"
  ac_ggz_stdbin="$ac_ggz_stdbin /usr/local/bin /usr/bin"
  ac_ggz_stdetc="$ac_ggz_stdetc/ggzd /usr/local/etc/ggzd /etc/ggzd"
fi
if test "x$1" = "xexport" || test "x$2" = "xexport"; then
  CPPFLAGS="$CPPFLAGS -isystem${ac_ggz_prefix_incdir}"
  LDFLAGS="$LDFLAGS -L${ac_ggz_prefix_libdir}"
fi

save_cflags=$CFLAGS
save_cxxflags=$CXXFLAGS
CFLAGS="-Wall -Werror"
AC_COMPILE_IFELSE([AC_LANG_PROGRAM(
	[[void signedness(void){char c;if(c==-1)c=0;}]])],
	[],
	[save_cflags="$save_cflags -fsigned-char"
	 save_cxxflags="$save_cxxflags -fsigned-char"])
CFLAGS=$save_cflags
CXXFLAGS=$save_cxxflags
])

dnl ------------------------------------------------------------------------
dnl Try to find the libggz headers and libraries.
dnl $(LIBGGZ_LDFLAGS) will be -L ... (if needed)
dnl and $(LIBGGZ_INCLUDES) will be -I ... (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_LIBGGZ,
[
AC_MSG_CHECKING([for GGZ library: libggz])

ac_libggz_includes=NO ac_libggz_libraries=NO
libggz_libraries=""
libggz_includes=""

AC_ARG_WITH(libggz-dir,
    [  --with-libggz-dir=DIR       libggz installation prefix ],
    [  ac_libggz_includes="$withval"/include
       ac_libggz_libraries="$withval"/lib
    ])
AC_ARG_WITH(libggz-includes,
    [  --with-libggz-includes=DIR  where the libggz includes are. ],
    [  ac_libggz_includes="$withval"
    ])
AC_ARG_WITH(libggz-libraries,
    [  --with-libggz-libraries=DIR where the libggz libs are. ],
    [  ac_libggz_libraries="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_libggz,
[
libggz_incdirs="$ac_libggz_includes $ac_ggz_stdinc"
AC_GGZ_REMOVEDUPS($libggz_incdirs, libggz_incdirs)
libggz_header=ggz.h

AC_GGZ_FIND_FILE($libggz_header, $libggz_incdirs, libggz_incdir)
ac_libggz_includes="$libggz_incdir"

libggz_libdirs="$ac_libggz_libraries $ac_ggz_stdlib"
AC_GGZ_REMOVEDUPS($libggz_libdirs, libggz_libdirs)

test=NONE
libggz_libdir=NONE
for dir in $libggz_libdirs; do
  try="ls -1 $dir/libggz.so"
  if test -n "`$try 2> /dev/null`"; then libggz_libdir=$dir; break; else echo "tried $dir" >&AC_FD_CC ; fi
done

ac_libggz_libraries="$libggz_libdir"

if test "$ac_libggz_includes" = NO || test "$ac_libggz_libraries" = NO; then
  ac_cv_have_libggz="have_libggz=no"
  ac_libggz_notfound=""
else
  have_libggz="yes"
fi
])

eval "$ac_cv_have_libggz"

if test "$have_libggz" != yes; then
  if test "x$2" = "xignore"; then
    AC_MSG_RESULT([$have_libggz (ignored)])
  else
    AC_MSG_RESULT([$have_libggz])
    if test "x$2" = "x"; then
      AC_GGZ_ERROR(libggz, $libggz_incdirs, $libggz_libdirs)
    fi

    # perform actions given by argument 2.
    $2
  fi
else
  ac_cv_have_libggz="have_libggz=yes \
    ac_libggz_includes=$ac_libggz_includes ac_libggz_libraries=$ac_libggz_libraries"
  AC_MSG_RESULT([$have_libggz (libraries $ac_libggz_libraries, headers $ac_libggz_includes)])

  libggz_libraries="$ac_libggz_libraries"
  libggz_includes="$ac_libggz_includes"

  AC_SUBST(libggz_libraries)
  AC_SUBST(libggz_includes)

  LIBGGZ_INCLUDES="-isystem $libggz_includes"
  LIBGGZ_LDFLAGS="-L$libggz_libraries"

  AC_SUBST(LIBGGZ_INCLUDES)
  AC_SUBST(LIBGGZ_LDFLAGS)

  LIB_GGZ='-lggz'
  AC_SUBST(LIB_GGZ)

  # perform actions given by argument 1.
  $1
fi

])


dnl ------------------------------------------------------------------------
dnl Try to find the ggzcore headers and libraries.
dnl $(GGZCORE_LDFLAGS) will be -L ... (if needed)
dnl and $(GGZCORE_INCLUDES) will be -I ... (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_GGZCORE,
[
AC_MSG_CHECKING([for GGZ library: ggzcore])

ac_ggzcore_includes=NO ac_ggzcore_libraries=NO
ggzcore_libraries=""
ggzcore_includes=""

AC_ARG_WITH(ggzcore-dir,
    [  --with-ggzcore-dir=DIR       ggzcore installation prefix ],
    [  ac_ggzcore_includes="$withval"/include
       ac_ggzcore_libraries="$withval"/lib
    ])
AC_ARG_WITH(ggzcore-includes,
    [  --with-ggzcore-includes=DIR  where the ggzcore includes are. ],
    [  ac_ggzcore_includes="$withval"
    ])
AC_ARG_WITH(ggzcore-libraries,
    [  --with-ggzcore-libraries=DIR where the ggzcore libs are. ],
    [  ac_ggzcore_libraries="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_ggzcore,
[
ggzcore_incdirs="$ac_ggzcore_includes $ac_ggz_stdinc"
AC_GGZ_REMOVEDUPS($ggzcore_incdirs, ggzcore_incdirs)
ggzcore_header=ggzcore.h

AC_GGZ_FIND_FILE($ggzcore_header, $ggzcore_incdirs, ggzcore_incdir)
ac_ggzcore_includes="$ggzcore_incdir"

ggzcore_libdirs="$ac_ggzcore_libraries $ac_ggz_stdlib"
AC_GGZ_REMOVEDUPS($ggzcore_libdirs, ggzcore_libdirs)

test=NONE
ggzcore_libdir=NONE
for dir in $ggzcore_libdirs; do
  try="ls -1 $dir/libggzcore.so"
  if test -n "`$try 2> /dev/null`"; then ggzcore_libdir=$dir; break; else echo "tried $dir" >&AC_FD_CC ; fi
done

ac_ggzcore_libraries="$ggzcore_libdir"

if test "$ac_ggzcore_includes" = NO || test "$ac_ggzcore_libraries" = NO; then
  ac_cv_have_ggzcore="have_ggzcore=no"
  ac_ggzcore_notfound=""
else
  have_ggzcore="yes"
fi
])

eval "$ac_cv_have_ggzcore"

if test "$have_ggzcore" != yes; then
  if test "x$2" = "xignore"; then
    AC_MSG_RESULT([$have_ggzcore (intentionally ignored)])
  else
    AC_MSG_RESULT([$have_ggzcore])
    if test "x$2" = "x"; then
      AC_GGZ_ERROR(ggzcore, $ggzcore_incdirs, $ggzcore_libdirs)
    fi

    # Perform actions given by argument 2.
    $2
  fi
else
  ac_cv_have_ggzcore="have_ggzcore=yes \
    ac_ggzcore_includes=$ac_ggzcore_includes ac_ggzcore_libraries=$ac_ggzcore_libraries"
  AC_MSG_RESULT([$have_ggzcore (libraries $ac_ggzcore_libraries, headers $ac_ggzcore_includes)])

  ggzcore_libraries="$ac_ggzcore_libraries"
  ggzcore_includes="$ac_ggzcore_includes"

  AC_SUBST(ggzcore_libraries)
  AC_SUBST(ggzcore_includes)

  GGZCORE_INCLUDES="-isystem $ggzcore_includes"
  GGZCORE_LDFLAGS="-L$ggzcore_libraries"

  AC_SUBST(GGZCORE_INCLUDES)
  AC_SUBST(GGZCORE_LDFLAGS)

  LIB_GGZCORE='-lggzcore'
  AC_SUBST(LIB_GGZCORE)

  # Perform actions given by argument 1.
  $1
fi

])

dnl ------------------------------------------------------------------------
dnl Try to find the ggz-config binary.
dnl Sets GGZ_CONFIG to the path/name of the program.
dnl Sets also: ggz_gamedir, ggz_datadir etc.
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_CONFIG,
[
AC_MSG_CHECKING([for GGZ configuration tool: ggz-config])

ac_ggz_config=NO
ggz_config=""

AC_ARG_WITH(ggzconfig,
    [  --with-ggzconfig=DIR          path to ggz-config ],
    [  ac_ggz_config="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_ggzconfig,
[
ggz_config_dirs="$ac_ggz_config $ac_ggz_stdbin"

AC_GGZ_FIND_FILE(ggz-config, $ggz_config_dirs, ggz_config_dir)
ac_ggz_config="$ggz_config_dir"

if test "$ac_ggz_config" = NO; then
  ac_cv_have_ggzcore="have_ggz_config=no"
  ac_ggz_config_notfound=""
  have_ggz_config="no"
else
  have_ggz_config="yes"
fi
])

eval "$ac_cv_have_ggz_config"

if test "$have_ggz_config" != yes; then
  if test "x$2" = "xignore"; then
    AC_MSG_RESULT([$have_ggz_config (intentionally ignored)])
  else
    AC_MSG_RESULT([$have_ggz_config])
    if test "x$2" = "x"; then
      AC_MSG_ERROR([ggz-config not found. Please check your installation! ])
    fi

    # Perform actions given by argument 2.
    $2
  fi
else
  ac_cv_have_ggz_config="have_ggz_config=yes \
    ac_ggz_config=$ac_ggz_config"
  AC_MSG_RESULT([$ac_ggz_config/ggz-config])

  ggz_config="$ac_ggz_config"

  AC_SUBST(ggz_config)

  GGZ_CONFIG="${ggz_config}/ggz-config"
  AC_SUBST(GGZ_CONFIG)

  ggzmoduleconfdir=`$GGZ_CONFIG --configdir`
  AC_DEFINE_UNQUOTED(GGZMODULECONFDIR, "${ggzmoduleconfdir}", [Path where the game registry is located])
  ggzexecmoddir=`$GGZ_CONFIG --gamedir`
  AC_DEFINE_UNQUOTED(GAMEDIR, "${ggzexecmoddir}", [Path where to install the games])
  ggzdatadir=`$GGZ_CONFIG --datadir`
  AC_DEFINE_UNQUOTED(GGZDATADIR, "${ggzdatadir}", [Path where the games should look for their data files])
  packagesrcdir=`cd $srcdir && pwd`
  AC_DEFINE_UNQUOTED(PACKAGE_SOURCE_DIR, "${packagesrcdir}", [Path where the source is located])

  AC_SUBST(ggzmoduleconfdir)
  AC_SUBST(ggzexecmoddir)
  AC_SUBST(ggzdatadir)
  AC_SUBST(packagesrcdir)

  # Perform actions given by argument 1.
  $1
fi

])

dnl ------------------------------------------------------------------------
dnl Try to find the ggzmod headers and libraries.
dnl $(GGZMOD_LDFLAGS) will be -L ... (if needed)
dnl and $(GGZMOD_INCLUDES) will be -I ... (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_GGZMOD,
[
AC_MSG_CHECKING([for GGZ library: ggzmod])

ac_ggzmod_includes=NO ac_ggzmod_libraries=NO
ggzmod_libraries=""
ggzmod_includes=""

AC_ARG_WITH(ggzmod-dir,
    [  --with-ggzmod-dir=DIR        ggzmod installation prefix ],
    [  ac_ggzmod_includes="$withval"/include
       ac_ggzmod_libraries="$withval"/lib
    ])
AC_ARG_WITH(ggzmod-includes,
    [  --with-ggzmod-includes=DIR   where the ggzmod includes are. ],
    [  ac_ggzmod_includes="$withval"
    ])
AC_ARG_WITH(ggzmod-libraries,
    [  --with-ggzmod-libraries=DIR  where the ggzmod libs are. ],
    [  ac_ggzmod_libraries="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_ggzmod,
[
ggzmod_incdirs="$ac_ggzmod_includes $ac_ggz_stdinc"
AC_GGZ_REMOVEDUPS($ggzmod_incdirs, ggzmod_incdirs)
ggzmod_header=ggzmod.h

AC_GGZ_FIND_FILE($ggzmod_header, $ggzmod_incdirs, ggzmod_incdir)
ac_ggzmod_includes="$ggzmod_incdir"

ggzmod_libdirs="$ac_ggzmod_libraries $ac_ggz_stdlib"
AC_GGZ_REMOVEDUPS($ggzmod_libdirs, ggzmod_libdirs)

test=NONE
ggzmod_libdir=NONE
for dir in $ggzmod_libdirs; do
  try="ls -1 $dir/libggzmod.so"
  if test -n "`$try 2> /dev/null`"; then ggzmod_libdir=$dir; break; else echo "tried $dir" >&AC_FD_CC ; fi
done

ac_ggzmod_libraries="$ggzmod_libdir"

if test "$ac_ggzmod_includes" = NO || test "$ac_ggzmod_libraries" = NO; then
  ac_cv_have_ggzmod="have_ggzmod=no"
  ac_ggzmod_notfound=""
else
  have_ggzmod="yes"
fi
])

eval "$ac_cv_have_ggzmod"

if test "$have_ggzmod" != yes; then
  if test "x$2" = "xignore"; then
    AC_MSG_RESULT([$have_ggzmod (intentionally ignored)])
  else
    AC_MSG_RESULT([$have_ggzmod])
    if test "x$2" = "x"; then
      AC_GGZ_ERROR(ggzmod, $ggzmod_incdirs, $ggzmod_libdirs)
    fi

    # Perform actions given by argument 2.
    $2
  fi
else
  ac_cv_have_ggzmod="have_ggzmod=yes \
    ac_ggzmod_includes=$ac_ggzmod_includes ac_ggzmod_libraries=$ac_ggzmod_libraries"
  AC_MSG_RESULT([$have_ggzmod (libraries $ac_ggzmod_libraries, headers $ac_ggzmod_includes)])

  ggzmod_libraries="$ac_ggzmod_libraries"
  ggzmod_includes="$ac_ggzmod_includes"

  AC_SUBST(ggzmod_libraries)
  AC_SUBST(ggzmod_includes)

  GGZMOD_INCLUDES="-isystem $ggzmod_includes"
  GGZMOD_LDFLAGS="-L$ggzmod_libraries"

  AC_SUBST(GGZMOD_INCLUDES)
  AC_SUBST(GGZMOD_LDFLAGS)

  LIB_GGZMOD='-lggzmod'
  AC_SUBST(LIB_GGZMOD)

  # Perform actions given by argument 1.
  $1
fi

])

dnl ------------------------------------------------------------------------
dnl Try to find the ggzdmod headers and libraries.
dnl $(GGZDMOD_LDFLAGS) will be -L ... (if needed)
dnl and $(GGZDMOD_INCLUDES) will be -I ... (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_GGZDMOD,
[
AC_MSG_CHECKING([for GGZ library: ggzdmod])

ac_ggzdmod_includes=NO ac_ggzdmod_libraries=NO
ggzdmod_libraries=""
ggzdmod_includes=""

AC_ARG_WITH(ggzdmod-dir,
    [  --with-ggzdmod-dir=DIR        ggzdmod installation prefix ],
    [  ac_ggzdmod_includes="$withval"/include
       ac_ggzdmod_libraries="$withval"/lib
    ])
AC_ARG_WITH(ggzdmod-includes,
    [  --with-ggzdmod-includes=DIR   where the ggzdmod includes are. ],
    [  ac_ggzdmod_includes="$withval"
    ])
AC_ARG_WITH(ggzdmod-libraries,
    [  --with-ggzdmod-libraries=DIR  where the ggzdmod libs are. ],
    [  ac_ggzdmod_libraries="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_ggzdmod,
[
ggzdmod_incdirs="$ac_ggzdmod_includes $ac_ggz_stdinc"
AC_GGZ_REMOVEDUPS($ggzdmod_incdirs, ggzdmod_incdirs)
ggzdmod_header=ggzdmod.h

AC_GGZ_FIND_FILE($ggzdmod_header, $ggzdmod_incdirs, ggzdmod_incdir)
ac_ggzdmod_includes="$ggzdmod_incdir"

ggzdmod_libdirs="$ac_ggzdmod_libraries $ac_ggz_stdlib"
AC_GGZ_REMOVEDUPS($ggzdmod_libdirs, ggzdmod_libdirs)

test=NONE
ggzdmod_libdir=NONE
for dir in $ggzdmod_libdirs; do
  try="ls -1 $dir/libggzdmod.so"
  if test -n "`$try 2> /dev/null`"; then ggzdmod_libdir=$dir; break; else echo "tried $dir" >&AC_FD_CC ; fi
done

ac_ggzdmod_libraries="$ggzdmod_libdir"

if test "$ac_ggzdmod_includes" = NO || test "$ac_ggzdmod_libraries" = NO; then
  ac_cv_have_ggzdmod="have_ggzdmod=no"
  ac_ggzdmod_notfound=""
else
  have_ggzdmod="yes"
fi
])

eval "$ac_cv_have_ggzdmod"

if test "$have_ggzdmod" != yes; then
  if test "x$2" = "xignore"; then
    AC_MSG_RESULT([$have_ggzdmod (intentionally ignored)])
  else
    AC_MSG_RESULT([$have_ggzdmod])
    if test "x$2" = "x"; then
      AC_GGZ_ERROR(ggzdmod, $ggzdmod_incdirs, $ggzdmod_libdirs)
    fi

    # Perform actions given by argument 2.
    $2
  fi
else
  ac_cv_have_ggzdmod="have_ggzdmod=yes \
    ac_ggzdmod_includes=$ac_ggzdmod_includes ac_ggzdmod_libraries=$ac_ggzdmod_libraries"
  AC_MSG_RESULT([$have_ggzdmod (libraries $ac_ggzdmod_libraries, headers $ac_ggzdmod_includes)])

  ggzdmod_libraries="$ac_ggzdmod_libraries"
  ggzdmod_includes="$ac_ggzdmod_includes"

  AC_SUBST(ggzdmod_libraries)
  AC_SUBST(ggzdmod_includes)

  GGZDMOD_INCLUDES="-isystem $ggzdmod_includes"
  GGZDMOD_LDFLAGS="-L$ggzdmod_libraries"

  AC_SUBST(GGZDMOD_INCLUDES)
  AC_SUBST(GGZDMOD_LDFLAGS)

  LIB_GGZDMOD='-lggzdmod'
  AC_SUBST(LIB_GGZDMOD)

  # Perform actions given by argument 1.
  $1
fi

])

dnl ------------------------------------------------------------------------
dnl Setup the game server configuration.
dnl Sets ggzdconfdir (ggzd configuration).
dnl Sets ggzddatadir (for game server data).
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_SERVER,
[
AC_MSG_CHECKING([for GGZ server: ggzd])
AC_ARG_WITH(ggzd-confdir,
[  --with-ggzd-confdir=DIR       directory for room/game data],
[ ac_ggzd_confdir="$withval"
])

AC_CACHE_VAL(ac_cv_have_ggzdconf,
[
	if test "x$1" = "xforce"; then
		if test "x$ac_ggzd_confdir" = "x"; then
			ggzdconfdirs="$ac_ggz_stdetc"
		else
			ggzdconfdirs="$ac_ggzd_confdir"
		fi
	else
		ggzdconfdirs="$ac_ggzd_confdir $ac_ggz_stdetc"
	fi

	ggzdconfdir=NONE
	for dir in $ggzdconfdirs; do
		if test -n "`ls -d $dir/rooms 2> /dev/null`"; then
			if test -n "`ls -d $dir/rooms 2> /dev/null`"; then
				ggzdconfdir=$dir; break;
			else
				echo "tried $dir" >&AC_FD_CC;
			fi
		else
			echo "tried $dir" >&AC_FD_CC;
		fi
	done

	if test "x$ggzdconfdir" = "xNONE"; then
		have_ggzdconf="no"
	else
		have_ggzdconf="yes"
	fi
])

eval "$ac_cv_have_ggzdconf"

if test "$have_ggzdconf" != yes; then
	if test "x$2" = "xignore"; then
	  AC_MSG_RESULT([$have_ggzdconf (intentionally ignored)])
	elif test "x$2" = "xforce"; then
	  if test "x$ac_ggzd_confdir" = "x"; then
	    ggzdconfdir="\${prefix}/etc/ggzd"
	  else
	    ggzdconfdir=$ac_ggzd_confdir
	  fi
	  AC_MSG_RESULT([$have_ggzdconf (but forced to ${ggzdconfdir})])
	else
	  AC_MSG_RESULT([$have_ggzdconf])
      if test "x$2" = "x"; then
	    AC_MSG_ERROR([GGZ server configuration not found. Please check your installation! ])
      fi

	  # Perform actions given by argument 2.
	  $2
	fi
else
	prefixed=0
	if test "x${prefix}" != "xNONE" && test "x${prefix}" != "x${ac_default_prefix}"; then
		prefixed=1
	fi
	if test "x$ggzconfdir" != "x${prefix}/etc/ggzd" && test "x$prefixed" = "x1"; then
		AC_MSG_RESULT([$have_ggzdconf ($ggzdconfdir, but using ${prefix}/etc/ggzd nevertheless)])
		ggzdconfdir="\${prefix}/etc/ggzd"
	else
		AC_MSG_RESULT([$have_ggzdconf ($ggzdconfdir)])
	fi
fi

if test "$have_ggzdconf" = yes || test "x$2" = "xforce"; then
	AC_SUBST(ggzdconfdir)

	ggzddatadir=${prefix}/share/${PACKAGE}
	AC_DEFINE_UNQUOTED(GGZDDATADIR, "${ggzddatadir}", [Game server data directory])
	AC_SUBST(ggzddatadir)

	if test "x${libdir}" = 'x${exec_prefix}/lib'; then
	  if test "x${exec_prefix}" = "xNONE"; then
	    if test "x${prefix}" = "xNONE"; then
	      ggzdexecmoddir="\${ac_default_prefix}/lib/ggzd"
		  ggzdexecmodpath="${ac_default_prefix}/lib/ggzd"
	    else
	      ggzdexecmoddir="\${prefix}/lib/ggzd"
		  ggzdexecmodpath="${prefix}/lib/ggzd"
	    fi
	  else
	    ggzdexecmoddir="\${exec_prefix}/lib/ggzd"
		ggzdexecmodpath="${exec_prefix}/lib/ggzd"
	  fi
	else
	  ggzdexecmoddir="\${libdir}/ggzd"
	  ggzdexecmodpath="${libdir}/ggzd"
	fi
	AC_SUBST(ggzdexecmoddir)
	AC_SUBST(ggzdexecmodpath)

	# Perform actions given by argument 1.
	$1
fi

])

dnl ------------------------------------------------------------------------
dnl Find internationalization tools
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_GGZ_INTL,
[
AC_PATH_PROG(GETTEXT, xgettext)
AC_PATH_PROG(MSGFMT, msgfmt)
AC_PATH_PROG(MSGMERGE, msgmerge)

intl=1
if test "x$GETTEXT" = "x"; then intl=0; fi
if test "x$MSGFMT" = "x"; then intl=0; fi
if test "x$MSGMERGE" = "x"; then intl=0; fi
if test "$intl" = 0; then
  if test "x$2" = "xignore"; then
    AC_MSG_WARN([Internationalization tools missing. (ignored)])
  else
    AC_MSG_RESULT([Internationalization tools missing.])
    if test "x$2" = "x"; then
      AC_MSG_ERROR([Internationalization tools missing.])
    fi

    # Perform actions given by argument 2.
    $2
  fi
else
  AC_MSG_RESULT([Internationalization tools found.])

  XGETTEXT=$GETTEXT
  GMSGFMT=$MSGFMT

  AC_SUBST(XGETTEXT)
  AC_SUBST(GETTEXT)
  AC_SUBST(GMSGFMT)
  AC_SUBST(MSGFMT)
  AC_SUBST(MSGMERGE)

  # Perform actions given by argument 1.
  $1
fi

])

# Do all the work for Automake.                            -*- Autoconf -*-

# This macro actually does too much some checks are only needed if
# your package does certain things.  But this isn't really a big deal.

# Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003
# Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 10

AC_PREREQ([2.54])

# Autoconf 2.50 wants to disallow AM_ names.  We explicitly allow
# the ones we care about.
m4_pattern_allow([^AM_[A-Z]+FLAGS$])dnl

# AM_INIT_AUTOMAKE(PACKAGE, VERSION, [NO-DEFINE])
# AM_INIT_AUTOMAKE([OPTIONS])
# -----------------------------------------------
# The call with PACKAGE and VERSION arguments is the old style
# call (pre autoconf-2.50), which is being phased out.  PACKAGE
# and VERSION should now be passed to AC_INIT and removed from
# the call to AM_INIT_AUTOMAKE.
# We support both call styles for the transition.  After
# the next Automake release, Autoconf can make the AC_INIT
# arguments mandatory, and then we can depend on a new Autoconf
# release and drop the old call support.
AC_DEFUN([AM_INIT_AUTOMAKE],
[AC_REQUIRE([AM_SET_CURRENT_AUTOMAKE_VERSION])dnl
 AC_REQUIRE([AC_PROG_INSTALL])dnl
# test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" &&
   test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi

# test whether we have cygpath
if test -z "$CYGPATH_W"; then
  if (cygpath --version) >/dev/null 2>/dev/null; then
    CYGPATH_W='cygpath -w'
  else
    CYGPATH_W=echo
  fi
fi
AC_SUBST([CYGPATH_W])

# Define the identity of the package.
dnl Distinguish between old-style and new-style calls.
m4_ifval([$2],
[m4_ifval([$3], [_AM_SET_OPTION([no-define])])dnl
 AC_SUBST([PACKAGE], [$1])dnl
 AC_SUBST([VERSION], [$2])],
[_AM_SET_OPTIONS([$1])dnl
 AC_SUBST([PACKAGE], ['AC_PACKAGE_TARNAME'])dnl
 AC_SUBST([VERSION], ['AC_PACKAGE_VERSION'])])dnl

_AM_IF_OPTION([no-define],,
[AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
 AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package])])dnl

# Some tools Automake needs.
AC_REQUIRE([AM_SANITY_CHECK])dnl
AC_REQUIRE([AC_ARG_PROGRAM])dnl
AM_MISSING_PROG(ACLOCAL, aclocal-${am__api_version})
AM_MISSING_PROG(AUTOCONF, autoconf)
AM_MISSING_PROG(AUTOMAKE, automake-${am__api_version})
AM_MISSING_PROG(AUTOHEADER, autoheader)
AM_MISSING_PROG(MAKEINFO, makeinfo)
AM_MISSING_PROG(AMTAR, tar)
AM_PROG_INSTALL_SH
AM_PROG_INSTALL_STRIP
# We need awk for the "check" target.  The system "awk" is bad on
# some platforms.
AC_REQUIRE([AC_PROG_AWK])dnl
AC_REQUIRE([AC_PROG_MAKE_SET])dnl
AC_REQUIRE([AM_SET_LEADING_DOT])dnl

_AM_IF_OPTION([no-dependencies],,
[AC_PROVIDE_IFELSE([AC_PROG_CC],
                  [_AM_DEPENDENCIES(CC)],
                  [define([AC_PROG_CC],
                          defn([AC_PROG_CC])[_AM_DEPENDENCIES(CC)])])dnl
AC_PROVIDE_IFELSE([AC_PROG_CXX],
                  [_AM_DEPENDENCIES(CXX)],
                  [define([AC_PROG_CXX],
                          defn([AC_PROG_CXX])[_AM_DEPENDENCIES(CXX)])])dnl
])
])


# When config.status generates a header, we must update the stamp-h file.
# This file resides in the same directory as the config header
# that is generated.  The stamp files are numbered to have different names.

# Autoconf calls _AC_AM_CONFIG_HEADER_HOOK (when defined) in the
# loop where config.status creates the headers, so we can generate
# our stamp files there.
AC_DEFUN([_AC_AM_CONFIG_HEADER_HOOK],
[# Compute $1's index in $config_headers.
_am_stamp_count=1
for _am_header in $config_headers :; do
  case $_am_header in
    $1 | $1:* )
      break ;;
    * )
      _am_stamp_count=`expr $_am_stamp_count + 1` ;;
  esac
done
echo "timestamp for $1" >`AS_DIRNAME([$1])`/stamp-h[]$_am_stamp_count])

# Copyright 2002  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA

# AM_AUTOMAKE_VERSION(VERSION)
# ----------------------------
# Automake X.Y traces this macro to ensure aclocal.m4 has been
# generated from the m4 files accompanying Automake X.Y.
AC_DEFUN([AM_AUTOMAKE_VERSION],[am__api_version="1.7"])

# AM_SET_CURRENT_AUTOMAKE_VERSION
# -------------------------------
# Call AM_AUTOMAKE_VERSION so it can be traced.
# This function is AC_REQUIREd by AC_INIT_AUTOMAKE.
AC_DEFUN([AM_SET_CURRENT_AUTOMAKE_VERSION],
	 [AM_AUTOMAKE_VERSION([1.7.4])])

# Helper functions for option handling.                    -*- Autoconf -*-

# Copyright 2001, 2002  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 2

# _AM_MANGLE_OPTION(NAME)
# -----------------------
AC_DEFUN([_AM_MANGLE_OPTION],
[[_AM_OPTION_]m4_bpatsubst($1, [[^a-zA-Z0-9_]], [_])])

# _AM_SET_OPTION(NAME)
# ------------------------------
# Set option NAME.  Presently that only means defining a flag for this option.
AC_DEFUN([_AM_SET_OPTION],
[m4_define(_AM_MANGLE_OPTION([$1]), 1)])

# _AM_SET_OPTIONS(OPTIONS)
# ----------------------------------
# OPTIONS is a space-separated list of Automake options.
AC_DEFUN([_AM_SET_OPTIONS],
[AC_FOREACH([_AM_Option], [$1], [_AM_SET_OPTION(_AM_Option)])])

# _AM_IF_OPTION(OPTION, IF-SET, [IF-NOT-SET])
# -------------------------------------------
# Execute IF-SET if OPTION is set, IF-NOT-SET otherwise.
AC_DEFUN([_AM_IF_OPTION],
[m4_ifset(_AM_MANGLE_OPTION([$1]), [$2], [$3])])

#
# Check to make sure that the build environment is sane.
#

# Copyright 1996, 1997, 2000, 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 3

# AM_SANITY_CHECK
# ---------------
AC_DEFUN([AM_SANITY_CHECK],
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftest.file
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftest.file 2> /dev/null`
   if test "$[*]" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftest.file`
   fi
   rm -f conftest.file
   if test "$[*]" != "X $srcdir/configure conftest.file" \
      && test "$[*]" != "X conftest.file $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "$[2]" = conftest.file
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
AC_MSG_RESULT(yes)])

#  -*- Autoconf -*-


# Copyright 1997, 1999, 2000, 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 3

# AM_MISSING_PROG(NAME, PROGRAM)
# ------------------------------
AC_DEFUN([AM_MISSING_PROG],
[AC_REQUIRE([AM_MISSING_HAS_RUN])
$1=${$1-"${am_missing_run}$2"}
AC_SUBST($1)])


# AM_MISSING_HAS_RUN
# ------------------
# Define MISSING if not defined so far and test if it supports --run.
# If it does, set am_missing_run to use it, otherwise, to nothing.
AC_DEFUN([AM_MISSING_HAS_RUN],
[AC_REQUIRE([AM_AUX_DIR_EXPAND])dnl
test x"${MISSING+set}" = xset || MISSING="\${SHELL} $am_aux_dir/missing"
# Use eval to expand $SHELL
if eval "$MISSING --run true"; then
  am_missing_run="$MISSING --run "
else
  am_missing_run=
  AC_MSG_WARN([`missing' script is too old or missing])
fi
])

# AM_AUX_DIR_EXPAND

# Copyright 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# For projects using AC_CONFIG_AUX_DIR([foo]), Autoconf sets
# $ac_aux_dir to `$srcdir/foo'.  In other projects, it is set to
# `$srcdir', `$srcdir/..', or `$srcdir/../..'.
#
# Of course, Automake must honor this variable whenever it calls a
# tool from the auxiliary directory.  The problem is that $srcdir (and
# therefore $ac_aux_dir as well) can be either absolute or relative,
# depending on how configure is run.  This is pretty annoying, since
# it makes $ac_aux_dir quite unusable in subdirectories: in the top
# source directory, any form will work fine, but in subdirectories a
# relative path needs to be adjusted first.
#
# $ac_aux_dir/missing
#    fails when called from a subdirectory if $ac_aux_dir is relative
# $top_srcdir/$ac_aux_dir/missing
#    fails if $ac_aux_dir is absolute,
#    fails when called from a subdirectory in a VPATH build with
#          a relative $ac_aux_dir
#
# The reason of the latter failure is that $top_srcdir and $ac_aux_dir
# are both prefixed by $srcdir.  In an in-source build this is usually
# harmless because $srcdir is `.', but things will broke when you
# start a VPATH build or use an absolute $srcdir.
#
# So we could use something similar to $top_srcdir/$ac_aux_dir/missing,
# iff we strip the leading $srcdir from $ac_aux_dir.  That would be:
#   am_aux_dir='\$(top_srcdir)/'`expr "$ac_aux_dir" : "$srcdir//*\(.*\)"`
# and then we would define $MISSING as
#   MISSING="\${SHELL} $am_aux_dir/missing"
# This will work as long as MISSING is not called from configure, because
# unfortunately $(top_srcdir) has no meaning in configure.
# However there are other variables, like CC, which are often used in
# configure, and could therefore not use this "fixed" $ac_aux_dir.
#
# Another solution, used here, is to always expand $ac_aux_dir to an
# absolute PATH.  The drawback is that using absolute paths prevent a
# configured tree to be moved without reconfiguration.

# Rely on autoconf to set up CDPATH properly.
AC_PREREQ([2.50])

AC_DEFUN([AM_AUX_DIR_EXPAND], [
# expand $ac_aux_dir to an absolute path
am_aux_dir=`cd $ac_aux_dir && pwd`
])

# AM_PROG_INSTALL_SH
# ------------------
# Define $install_sh.

# Copyright 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

AC_DEFUN([AM_PROG_INSTALL_SH],
[AC_REQUIRE([AM_AUX_DIR_EXPAND])dnl
install_sh=${install_sh-"$am_aux_dir/install-sh"}
AC_SUBST(install_sh)])

# AM_PROG_INSTALL_STRIP

# Copyright 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# One issue with vendor `install' (even GNU) is that you can't
# specify the program used to strip binaries.  This is especially
# annoying in cross-compiling environments, where the build's strip
# is unlikely to handle the host's binaries.
# Fortunately install-sh will honor a STRIPPROG variable, so we
# always use install-sh in `make install-strip', and initialize
# STRIPPROG with the value of the STRIP variable (set by the user).
AC_DEFUN([AM_PROG_INSTALL_STRIP],
[AC_REQUIRE([AM_PROG_INSTALL_SH])dnl
# Installed binaries are usually stripped using `strip' when the user
# run `make install-strip'.  However `strip' might not be the right
# tool to use in cross-compilation environments, therefore Automake
# will honor the `STRIP' environment variable to overrule this program.
dnl Don't test for $cross_compiling = yes, because it might be `maybe'.
if test "$cross_compiling" != no; then
  AC_CHECK_TOOL([STRIP], [strip], :)
fi
INSTALL_STRIP_PROGRAM="\${SHELL} \$(install_sh) -c -s"
AC_SUBST([INSTALL_STRIP_PROGRAM])])

#                                                          -*- Autoconf -*-
# Copyright (C) 2003  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 1

# Check whether the underlying file-system supports filenames
# with a leading dot.  For instance MS-DOS doesn't.
AC_DEFUN([AM_SET_LEADING_DOT],
[rm -rf .tst 2>/dev/null
mkdir .tst 2>/dev/null
if test -d .tst; then
  am__leading_dot=.
else
  am__leading_dot=_
fi
rmdir .tst 2>/dev/null
AC_SUBST([am__leading_dot])])

# serial 5						-*- Autoconf -*-

# Copyright (C) 1999, 2000, 2001, 2002, 2003  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.


# There are a few dirty hacks below to avoid letting `AC_PROG_CC' be
# written in clear, in which case automake, when reading aclocal.m4,
# will think it sees a *use*, and therefore will trigger all it's
# C support machinery.  Also note that it means that autoscan, seeing
# CC etc. in the Makefile, will ask for an AC_PROG_CC use...



# _AM_DEPENDENCIES(NAME)
# ----------------------
# See how the compiler implements dependency checking.
# NAME is "CC", "CXX", "GCJ", or "OBJC".
# We try a few techniques and use that to set a single cache variable.
#
# We don't AC_REQUIRE the corresponding AC_PROG_CC since the latter was
# modified to invoke _AM_DEPENDENCIES(CC); we would have a circular
# dependency, and given that the user is not expected to run this macro,
# just rely on AC_PROG_CC.
AC_DEFUN([_AM_DEPENDENCIES],
[AC_REQUIRE([AM_SET_DEPDIR])dnl
AC_REQUIRE([AM_OUTPUT_DEPENDENCY_COMMANDS])dnl
AC_REQUIRE([AM_MAKE_INCLUDE])dnl
AC_REQUIRE([AM_DEP_TRACK])dnl

ifelse([$1], CC,   [depcc="$CC"   am_compiler_list=],
       [$1], CXX,  [depcc="$CXX"  am_compiler_list=],
       [$1], OBJC, [depcc="$OBJC" am_compiler_list='gcc3 gcc'],
       [$1], GCJ,  [depcc="$GCJ"  am_compiler_list='gcc3 gcc'],
                   [depcc="$$1"   am_compiler_list=])

AC_CACHE_CHECK([dependency style of $depcc],
               [am_cv_$1_dependencies_compiler_type],
[if test -z "$AMDEP_TRUE" && test -f "$am_depcomp"; then
  # We make a subdir and do the tests there.  Otherwise we can end up
  # making bogus files that we don't know about and never remove.  For
  # instance it was reported that on HP-UX the gcc test will end up
  # making a dummy file named `D' -- because `-MD' means `put the output
  # in D'.
  mkdir conftest.dir
  # Copy depcomp to subdir because otherwise we won't find it if we're
  # using a relative directory.
  cp "$am_depcomp" conftest.dir
  cd conftest.dir

  am_cv_$1_dependencies_compiler_type=none
  if test "$am_compiler_list" = ""; then
     am_compiler_list=`sed -n ['s/^#*\([a-zA-Z0-9]*\))$/\1/p'] < ./depcomp`
  fi
  for depmode in $am_compiler_list; do
    # We need to recreate these files for each test, as the compiler may
    # overwrite some of them when testing with obscure command lines.
    # This happens at least with the AIX C compiler.
    echo '#include "conftest.h"' > conftest.c
    echo 'int i;' > conftest.h
    echo "${am__include} ${am__quote}conftest.Po${am__quote}" > confmf

    case $depmode in
    nosideeffect)
      # after this tag, mechanisms are not by side-effect, so they'll
      # only be used when explicitly requested
      if test "x$enable_dependency_tracking" = xyes; then
	continue
      else
	break
      fi
      ;;
    none) break ;;
    esac
    # We check with `-c' and `-o' for the sake of the "dashmstdout"
    # mode.  It turns out that the SunPro C++ compiler does not properly
    # handle `-M -o', and we need to detect this.
    if depmode=$depmode \
       source=conftest.c object=conftest.o \
       depfile=conftest.Po tmpdepfile=conftest.TPo \
       $SHELL ./depcomp $depcc -c -o conftest.o conftest.c \
         >/dev/null 2>conftest.err &&
       grep conftest.h conftest.Po > /dev/null 2>&1 &&
       ${MAKE-make} -s -f confmf > /dev/null 2>&1; then
      # icc doesn't choke on unknown options, it will just issue warnings
      # (even with -Werror).  So we grep stderr for any message
      # that says an option was ignored.
      if grep 'ignoring option' conftest.err >/dev/null 2>&1; then :; else
        am_cv_$1_dependencies_compiler_type=$depmode
        break
      fi
    fi
  done

  cd ..
  rm -rf conftest.dir
else
  am_cv_$1_dependencies_compiler_type=none
fi
])
AC_SUBST([$1DEPMODE], [depmode=$am_cv_$1_dependencies_compiler_type])
AM_CONDITIONAL([am__fastdep$1], [
  test "x$enable_dependency_tracking" != xno \
  && test "$am_cv_$1_dependencies_compiler_type" = gcc3])
])


# AM_SET_DEPDIR
# -------------
# Choose a directory name for dependency files.
# This macro is AC_REQUIREd in _AM_DEPENDENCIES
AC_DEFUN([AM_SET_DEPDIR],
[AC_REQUIRE([AM_SET_LEADING_DOT])dnl
AC_SUBST([DEPDIR], ["${am__leading_dot}deps"])dnl
])


# AM_DEP_TRACK
# ------------
AC_DEFUN([AM_DEP_TRACK],
[AC_ARG_ENABLE(dependency-tracking,
[  --disable-dependency-tracking Speeds up one-time builds
  --enable-dependency-tracking  Do not reject slow dependency extractors])
if test "x$enable_dependency_tracking" != xno; then
  am_depcomp="$ac_aux_dir/depcomp"
  AMDEPBACKSLASH='\'
fi
AM_CONDITIONAL([AMDEP], [test "x$enable_dependency_tracking" != xno])
AC_SUBST([AMDEPBACKSLASH])
])

# Generate code to set up dependency tracking.   -*- Autoconf -*-

# Copyright 1999, 2000, 2001, 2002 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

#serial 2

# _AM_OUTPUT_DEPENDENCY_COMMANDS
# ------------------------------
AC_DEFUN([_AM_OUTPUT_DEPENDENCY_COMMANDS],
[for mf in $CONFIG_FILES; do
  # Strip MF so we end up with the name of the file.
  mf=`echo "$mf" | sed -e 's/:.*$//'`
  # Check whether this is an Automake generated Makefile or not.
  # We used to match only the files named `Makefile.in', but
  # some people rename them; so instead we look at the file content.
  # Grep'ing the first line is not enough: some people post-process
  # each Makefile.in and add a new line on top of each file to say so.
  # So let's grep whole file.
  if grep '^#.*generated by automake' $mf > /dev/null 2>&1; then
    dirpart=`AS_DIRNAME("$mf")`
  else
    continue
  fi
  grep '^DEP_FILES *= *[[^ @%:@]]' < "$mf" > /dev/null || continue
  # Extract the definition of DEP_FILES from the Makefile without
  # running `make'.
  DEPDIR=`sed -n -e '/^DEPDIR = / s///p' < "$mf"`
  test -z "$DEPDIR" && continue
  # When using ansi2knr, U may be empty or an underscore; expand it
  U=`sed -n -e '/^U = / s///p' < "$mf"`
  test -d "$dirpart/$DEPDIR" || mkdir "$dirpart/$DEPDIR"
  # We invoke sed twice because it is the simplest approach to
  # changing $(DEPDIR) to its actual value in the expansion.
  for file in `sed -n -e '
    /^DEP_FILES = .*\\\\$/ {
      s/^DEP_FILES = //
      :loop
	s/\\\\$//
	p
	n
	/\\\\$/ b loop
      p
    }
    /^DEP_FILES = / s/^DEP_FILES = //p' < "$mf" | \
       sed -e 's/\$(DEPDIR)/'"$DEPDIR"'/g' -e 's/\$U/'"$U"'/g'`; do
    # Make sure the directory exists.
    test -f "$dirpart/$file" && continue
    fdir=`AS_DIRNAME(["$file"])`
    AS_MKDIR_P([$dirpart/$fdir])
    # echo "creating $dirpart/$file"
    echo '# dummy' > "$dirpart/$file"
  done
done
])# _AM_OUTPUT_DEPENDENCY_COMMANDS


# AM_OUTPUT_DEPENDENCY_COMMANDS
# -----------------------------
# This macro should only be invoked once -- use via AC_REQUIRE.
#
# This code is only required when automatic dependency tracking
# is enabled.  FIXME.  This creates each `.P' file that we will
# need in order to bootstrap the dependency handling code.
AC_DEFUN([AM_OUTPUT_DEPENDENCY_COMMANDS],
[AC_CONFIG_COMMANDS([depfiles],
     [test x"$AMDEP_TRUE" != x"" || _AM_OUTPUT_DEPENDENCY_COMMANDS],
     [AMDEP_TRUE="$AMDEP_TRUE" ac_aux_dir="$ac_aux_dir"])
])

# Check to see how 'make' treats includes.	-*- Autoconf -*-

# Copyright (C) 2001, 2002 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 2

# AM_MAKE_INCLUDE()
# -----------------
# Check to see how make treats includes.
AC_DEFUN([AM_MAKE_INCLUDE],
[am_make=${MAKE-make}
cat > confinc << 'END'
doit:
	@echo done
END
# If we don't find an include directive, just comment out the code.
AC_MSG_CHECKING([for style of include used by $am_make])
am__include="#"
am__quote=
_am_result=none
# First try GNU make style include.
echo "include confinc" > confmf
# We grep out `Entering directory' and `Leaving directory'
# messages which can occur if `w' ends up in MAKEFLAGS.
# In particular we don't look at `^make:' because GNU make might
# be invoked under some other name (usually "gmake"), in which
# case it prints its new name instead of `make'.
if test "`$am_make -s -f confmf 2> /dev/null | grep -v 'ing directory'`" = "done"; then
   am__include=include
   am__quote=
   _am_result=GNU
fi
# Now try BSD make style include.
if test "$am__include" = "#"; then
   echo '.include "confinc"' > confmf
   if test "`$am_make -s -f confmf 2> /dev/null`" = "done"; then
      am__include=.include
      am__quote="\""
      _am_result=BSD
   fi
fi
AC_SUBST(am__include)
AC_SUBST(am__quote)
AC_MSG_RESULT($_am_result)
rm -f confinc confmf
])

# AM_CONDITIONAL                                              -*- Autoconf -*-

# Copyright 1997, 2000, 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 5

AC_PREREQ(2.52)

# AM_CONDITIONAL(NAME, SHELL-CONDITION)
# -------------------------------------
# Define a conditional.
AC_DEFUN([AM_CONDITIONAL],
[ifelse([$1], [TRUE],  [AC_FATAL([$0: invalid condition: $1])],
        [$1], [FALSE], [AC_FATAL([$0: invalid condition: $1])])dnl
AC_SUBST([$1_TRUE])
AC_SUBST([$1_FALSE])
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi
AC_CONFIG_COMMANDS_PRE(
[if test -z "${$1_TRUE}" && test -z "${$1_FALSE}"; then
  AC_MSG_ERROR([conditional "$1" was never defined.
Usually this means the macro was only invoked conditionally.])
fi])])

# Add --enable-maintainer-mode option to configure.
# From Jim Meyering

# Copyright 1996, 1998, 2000, 2001, 2002  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 2

AC_DEFUN([AM_MAINTAINER_MODE],
[AC_MSG_CHECKING([whether to enable maintainer-specific portions of Makefiles])
  dnl maintainer-mode is disabled by default
  AC_ARG_ENABLE(maintainer-mode,
[  --enable-maintainer-mode enable make rules and dependencies not useful
                          (and sometimes confusing) to the casual installer],
      USE_MAINTAINER_MODE=$enableval,
      USE_MAINTAINER_MODE=no)
  AC_MSG_RESULT([$USE_MAINTAINER_MODE])
  AM_CONDITIONAL(MAINTAINER_MODE, [test $USE_MAINTAINER_MODE = yes])
  MAINT=$MAINTAINER_MODE_TRUE
  AC_SUBST(MAINT)dnl
]
)

AU_DEFUN([jm_MAINTAINER_MODE], [AM_MAINTAINER_MODE])

# isc-posix.m4 serial 2 (gettext-0.11.2)
dnl Copyright (C) 1995-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

# This file is not needed with autoconf-2.53 and newer.  Remove it in 2005.

# This test replaces the one in autoconf.
# Currently this macro should have the same name as the autoconf macro
# because gettext's gettext.m4 (distributed in the automake package)
# still uses it.  Otherwise, the use in gettext.m4 makes autoheader
# give these diagnostics:
#   configure.in:556: AC_TRY_COMPILE was called before AC_ISC_POSIX
#   configure.in:556: AC_TRY_RUN was called before AC_ISC_POSIX

undefine([AC_ISC_POSIX])

AC_DEFUN([AC_ISC_POSIX],
  [
    dnl This test replaces the obsolescent AC_ISC_POSIX kludge.
    AC_CHECK_LIB(cposix, strerror, [LIBS="$LIBS -lcposix"])
  ]
)


# Copyright 1996, 1997, 1999, 2000, 2001, 2002  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 2

# @defmac AC_PROG_CC_STDC
# @maindex PROG_CC_STDC
# @ovindex CC
# If the C compiler in not in ANSI C mode by default, try to add an option
# to output variable @code{CC} to make it so.  This macro tries various
# options that select ANSI C on some system or another.  It considers the
# compiler to be in ANSI C mode if it handles function prototypes correctly.
#
# If you use this macro, you should check after calling it whether the C
# compiler has been set to accept ANSI C; if not, the shell variable
# @code{am_cv_prog_cc_stdc} is set to @samp{no}.  If you wrote your source
# code in ANSI C, you can make an un-ANSIfied copy of it by using the
# program @code{ansi2knr}, which comes with Ghostscript.
# @end defmac

AC_DEFUN([AM_PROG_CC_STDC],
[AC_REQUIRE([AC_PROG_CC])
AC_BEFORE([$0], [AC_C_INLINE])
AC_BEFORE([$0], [AC_C_CONST])
dnl Force this before AC_PROG_CPP.  Some cpp's, eg on HPUX, require
dnl a magic option to avoid problems with ANSI preprocessor commands
dnl like #elif.
dnl FIXME: can't do this because then AC_AIX won't work due to a
dnl circular dependency.
dnl AC_BEFORE([$0], [AC_PROG_CPP])
AC_MSG_CHECKING([for ${CC-cc} option to accept ANSI C])
AC_CACHE_VAL(am_cv_prog_cc_stdc,
[am_cv_prog_cc_stdc=no
ac_save_CC="$CC"
# Don't try gcc -ansi; that turns off useful extensions and
# breaks some systems' header files.
# AIX			-qlanglvl=ansi
# Ultrix and OSF/1	-std1
# HP-UX 10.20 and later	-Ae
# HP-UX older versions	-Aa -D_HPUX_SOURCE
# SVR4			-Xc -D__EXTENSIONS__
for ac_arg in "" -qlanglvl=ansi -std1 -Ae "-Aa -D_HPUX_SOURCE" "-Xc -D__EXTENSIONS__"
do
  CC="$ac_save_CC $ac_arg"
  AC_TRY_COMPILE(
[#include <stdarg.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
/* Most of the following tests are stolen from RCS 5.7's src/conf.sh.  */
struct buf { int x; };
FILE * (*rcsopen) (struct buf *, struct stat *, int);
static char *e (p, i)
     char **p;
     int i;
{
  return p[i];
}
static char *f (char * (*g) (char **, int), char **p, ...)
{
  char *s;
  va_list v;
  va_start (v,p);
  s = g (p, va_arg (v,int));
  va_end (v);
  return s;
}
int test (int i, double x);
struct s1 {int (*f) (int a);};
struct s2 {int (*f) (double a);};
int pairnames (int, char **, FILE *(*)(struct buf *, struct stat *, int), int, int);
int argc;
char **argv;
], [
return f (e, argv, 0) != argv[0]  ||  f (e, argv, 1) != argv[1];
],
[am_cv_prog_cc_stdc="$ac_arg"; break])
done
CC="$ac_save_CC"
])
if test -z "$am_cv_prog_cc_stdc"; then
  AC_MSG_RESULT([none needed])
else
  AC_MSG_RESULT([$am_cv_prog_cc_stdc])
fi
case "x$am_cv_prog_cc_stdc" in
  x|xno) ;;
  *) CC="$CC $am_cv_prog_cc_stdc" ;;
esac
])

AU_DEFUN([fp_PROG_CC_STDC], [AM_PROG_CC_STDC])

